
#nullable enable

namespace AI21
{
    /// <summary>
    /// 
    /// </summary>
    public sealed partial class FileResponse
    {
        /// <summary>
        /// The unique identifier of the file, generated by AI21.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("fileId")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required global::System.Guid FileId { get; set; }

        /// <summary>
        /// The name of the file. This is the local file name from when the file was<br/>
        /// uploaded. It cannot be modified.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("name")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required string Name { get; set; }

        /// <summary>
        /// An arbitrary file-path-like string to indicate the content of a file. This has<br/>
        /// nothing to do with the location of the file in storage or on disk, and is only<br/>
        /// another label that you can assign to the file in path-like format to help you<br/>
        /// organize the contents of the file or filter queries against your files. Example<br/>
        /// paths might be `pets/fish` or `pets/dogs`. Then, when searching your library,<br/>
        /// you can filter files by the full path or path prefix. So to search only files<br/>
        /// in the "dog folder", filter by the path `/pets/dogs`. To search all files in<br/>
        /// the "pet folder", filter your search by the path `pets/` when searching by path.<br/>
        /// There isn't a restriction on whether a path must start or end with a / mark, but<br/>
        /// be consistent in your usage, and all matches are prefix matching, not substring<br/>
        /// matching. So filtering by `dog/` matches `dog/` and `dog/setter` but not `pets/dog/`.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("path")]
        public string? Path { get; set; }

        /// <summary>
        /// The file type. See the file upload method to learn what file types are supported.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("fileType")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required string FileType { get; set; }

        /// <summary>
        /// The size of the file, in bytes.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("sizeBytes")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required int SizeBytes { get; set; }

        /// <summary>
        /// Any string labels you have associated with the file. You can apply arbitrary<br/>
        /// string labels to your files and limit queries to files with one or more labels.<br/>
        /// Similar to paths, but labels do not prefix match. Labels are case-sensitive.<br/>
        /// There can be a maximum of 20 unique labels per account.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("labels")]
        public global::System.Collections.Generic.IList<string>? Labels { get; set; }

        /// <summary>
        /// The public URL of the file, if any. This URL is not validated by<br/>
        /// AI21 or used in any way. It is strictly a piece of metadata that you can<br/>
        /// optionally attach to a file.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("publicUrl")]
        public string? PublicUrl { get; set; }

        /// <summary>
        /// An internal identifier of the user who uploaded the file.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("createdBy")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required global::System.Guid CreatedBy { get; set; }

        /// <summary>
        /// The date when the file was uploaded.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("creationDate")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required global::System.DateTime CreationDate { get; set; }

        /// <summary>
        /// When the file data or metadata was last changed.
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("lastUpdated")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required global::System.DateTime LastUpdated { get; set; }

        /// <summary>
        /// File status. One of the following values: "DB_RECORD_CREATED",<br/>
        /// "UPLOADED", "UPLOAD_FAILED", "PROCESSED", "PROCESSING_FAILED"
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("status")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required string Status { get; set; }

        /// <summary>
        /// Additional properties that are not explicitly defined in the schema
        /// </summary>
        [global::System.Text.Json.Serialization.JsonExtensionData]
        public global::System.Collections.Generic.IDictionary<string, object> AdditionalProperties { get; set; } = new global::System.Collections.Generic.Dictionary<string, object>();

        /// <summary>
        /// Initializes a new instance of the <see cref="FileResponse" /> class.
        /// </summary>
        /// <param name="fileId">
        /// The unique identifier of the file, generated by AI21.
        /// </param>
        /// <param name="name">
        /// The name of the file. This is the local file name from when the file was<br/>
        /// uploaded. It cannot be modified.
        /// </param>
        /// <param name="path">
        /// An arbitrary file-path-like string to indicate the content of a file. This has<br/>
        /// nothing to do with the location of the file in storage or on disk, and is only<br/>
        /// another label that you can assign to the file in path-like format to help you<br/>
        /// organize the contents of the file or filter queries against your files. Example<br/>
        /// paths might be `pets/fish` or `pets/dogs`. Then, when searching your library,<br/>
        /// you can filter files by the full path or path prefix. So to search only files<br/>
        /// in the "dog folder", filter by the path `/pets/dogs`. To search all files in<br/>
        /// the "pet folder", filter your search by the path `pets/` when searching by path.<br/>
        /// There isn't a restriction on whether a path must start or end with a / mark, but<br/>
        /// be consistent in your usage, and all matches are prefix matching, not substring<br/>
        /// matching. So filtering by `dog/` matches `dog/` and `dog/setter` but not `pets/dog/`.
        /// </param>
        /// <param name="fileType">
        /// The file type. See the file upload method to learn what file types are supported.
        /// </param>
        /// <param name="sizeBytes">
        /// The size of the file, in bytes.
        /// </param>
        /// <param name="labels">
        /// Any string labels you have associated with the file. You can apply arbitrary<br/>
        /// string labels to your files and limit queries to files with one or more labels.<br/>
        /// Similar to paths, but labels do not prefix match. Labels are case-sensitive.<br/>
        /// There can be a maximum of 20 unique labels per account.
        /// </param>
        /// <param name="publicUrl">
        /// The public URL of the file, if any. This URL is not validated by<br/>
        /// AI21 or used in any way. It is strictly a piece of metadata that you can<br/>
        /// optionally attach to a file.
        /// </param>
        /// <param name="createdBy">
        /// An internal identifier of the user who uploaded the file.
        /// </param>
        /// <param name="creationDate">
        /// The date when the file was uploaded.
        /// </param>
        /// <param name="lastUpdated">
        /// When the file data or metadata was last changed.
        /// </param>
        /// <param name="status">
        /// File status. One of the following values: "DB_RECORD_CREATED",<br/>
        /// "UPLOADED", "UPLOAD_FAILED", "PROCESSED", "PROCESSING_FAILED"
        /// </param>
        [global::System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
        public FileResponse(
            global::System.Guid fileId,
            string name,
            string fileType,
            int sizeBytes,
            global::System.Guid createdBy,
            global::System.DateTime creationDate,
            global::System.DateTime lastUpdated,
            string status,
            string? path,
            global::System.Collections.Generic.IList<string>? labels,
            string? publicUrl)
        {
            this.FileId = fileId;
            this.Name = name ?? throw new global::System.ArgumentNullException(nameof(name));
            this.FileType = fileType ?? throw new global::System.ArgumentNullException(nameof(fileType));
            this.SizeBytes = sizeBytes;
            this.CreatedBy = createdBy;
            this.CreationDate = creationDate;
            this.LastUpdated = lastUpdated;
            this.Status = status ?? throw new global::System.ArgumentNullException(nameof(status));
            this.Path = path;
            this.Labels = labels;
            this.PublicUrl = publicUrl;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FileResponse" /> class.
        /// </summary>
        public FileResponse()
        {
        }
    }
}