#nullable enable

namespace AI21
{
    public partial interface ILibraryManagementClient
    {
        /// <summary>
        /// Get File By Id<br/>
        /// Retrieve a list of documents in the user's library. Optionally specify a<br/>
        /// filter to find only files with matching labels or paths. This method<br/>
        /// returns only metadata about files; to download a file, call<br/>
        /// `GET .../files/{file_id}/download`<br/>
        /// When specifying qualifiers with your request, only files that match<br/>
        /// _all_ qualifiers will be returns. So, for example, if you specify<br/>
        /// `label='financial'` and `status='UPLOADED'`, only files with the label<br/>
        /// "financial" AND status UPLOADED will be returned.
        /// </summary>
        /// <param name="fileId"></param>
        /// <param name="requestStartTime">
        /// Default Value: 1730898900272
        /// </param>
        /// <param name="cancellationToken">The token to cancel the operation with</param>
        /// <exception cref="global::AI21.ApiException"></exception>
        global::System.Threading.Tasks.Task<global::AI21.FileResponse> V1LibraryManagement2Async(
            global::System.Guid fileId,
            int? requestStartTime = default,
            global::System.Threading.CancellationToken cancellationToken = default);
    }
}