<div align="center">
  <h1>Trongate PHP Framework</h1>
  <img src="https://trongate.io/trongate_logo/trongate_logo_dark_blue_bg.png" alt="logo" width="600" height="auto" />
  <h1>Break the rules use Trongate</h1>
  
  <h3>
   GitHub stars are the metric by which the success of frameworks gets measured. We need 1,200 GitHub stars to make Trongate a top ten PHP framework. If Trongate becomes a top ten PHP framework it will be one of the most electrifying events in the history of PHP! 
  </h3>

<!-- Badges -->
<p>
  <a href="https://www.php.net/">
    <img src="https://img.shields.io/badge/PHP-8%2B-777BB4"
    alt="PHP8+ required" />
  </a>
  <a href="https://github.com/trongate/trongate-framework/graphs/contributors">
    <img src="https://img.shields.io/github/contributors/trongate/trongate-framework" alt="contributors" />
  </a>
  <a href="">
    <img src="https://img.shields.io/github/last-commit/trongate/trongate-framework" alt="last update" />
  </a>
  <a href="https://github.com/trongate/trongate-framework/network/members">
    <img src="https://img.shields.io/github/forks/trongate/trongate-framework" alt="forks" />
  </a>
  <a href="https://github.com/trongate/trongate-framework/stargazers">
    <img src="https://img.shields.io/github/stars/trongate/trongate-framework" alt="stars" />
  </a>
  <a href="https://github.com/trongate/trongate-framework/issues/">
    <img src="https://img.shields.io/github/issues/trongate/trongate-framework" alt="open issues" />
  </a>
</p>
   
<h4>
    <a href="https://trongate.io">Website</a>
  <span> · </span>
    <a href="https://trongate.io/docs_m/contents">Documentation</a>
  <span> · </span>
    <a href="https://trongate.io/learning-zone">Learning Zone</a>
  <span> · </span>
    <a href="https://trongate.io/help_bar">Need some help</a>
  <span> · </span>
    <a href="https://trongate.io/your_messages/compose">Request a Feature</a>
  </h4>
</div>

<br />

<!-- Table of Contents -->

# :notebook_with_decorative_cover: Table of Contents

- [About the Project](#star2-about-the-project)
  - [Features](#dart-features)
- [Getting Started](#toolbox-getting-started)
  - [Prerequisites](#bangbang-prerequisites)
  - [Installation](#gear-installation)
- [Usage](#eyes-usage)
- [Contributing](#wave-contributing)
- [License](#warning-license)
- [Contact](#handshake-contact)

<!-- About the Project -->

## :star2: About the Project

<div align="left"> 
  <p>Trongate was built with a love of pure PHP and a belief that PHP is best when it's easy, stable and fast. Trongate uses PHP the way that PHP was originally intended to be used, i.e., as a templating engine. Trongate is the only PHP framework that actively rejects; PSR-4 auto-loading, Composer, Packagist, rewrite culture, certification and all forms of bureaucracy.</p>
  <p>
Trongate is also the first PHP framework that has been built with a determination to remain v1 forever. Finally, PHP developers have framework that has been built with stability as a priority.</p>

  <p>The Trongate framework will never contain features that developers don't need. Trongate will never offer certification - paid or unpaid. Instead, Trongate will continue to boldly tackle real problems that face real developers every day.</p>

  <p>The Trongate framework is free. The Trongate desktop app is also free. These things will always be free. That's a promise!</p>
  <h1>Is this fast enough for you?</h1>
  <p>Trongate favours pure PHP over things like PSR-4 autoloading. The result? A brave new PHP framework that demolishes the competition based on every metric that counts. Pure PHP is back!</p>
   <img src="https://trongate.io/images/trongate_benchmarks.png" />
</div>

<!-- Features -->

### :dart: Features

<details>
  <summary>Automatic Installer</summary>
  <p>
    No command line. No Git. No 'Composer dot phar'. No Yaml. No Packagist. Trongate installs itself. Simply download the free Trongate desktop app and set up entire database driven apps in seconds!
  </p>
</details>
<details>
  <summary>API Manager</summary>
  <p>
    Trongate's best in class API Manager sets a new standard for rapid API development. Mobile developers and JavaScript developers - you're in for a treat!
  </p>
</details>
<details>
  <summary>Advanced File Uploaders</summary>
  <p>
    Trongate sets a new standard for PHP by letting developers build highly performant features in record time. This includes some of the fastest file uploaders in the industry.
  </p>
</details>
<details>
  <summary>Graphical Query Builder</summary>
  <p>
    Trongate is the only framework that comes with a free graphical SQL query builder. So, now you can build complex table joins easily and liberate yourself from costly db management software.
  </p>
</details>
<details>
  <summary>Updates Itself</summary>
  <p>
    Whenever new features come out you get an alert, asking if you want it. If you want it, you click 'yes'. Then it self-updates. Another industry first! By the way, Trongate is also the first PHP framework that aims to be v1 forever!
  </p>
</details>
<details>
  <summary>Automatic Code Generator</summary>
  <p>
   With Trongate, you get a revolutionary code generator to help take care of boring boilerplate code. Your productivity levels are about to go through the roof!
  </p>
</details>
<details>
  <summary>JavaScript Components</summary>
  <p>
   With Trongate you can build beautiful pop up calendars, time pickers, date-range pickers and even drag and drop file uploaders in seconds!
  </p>
</details>
<details>
  <summary>Custom Themes</summary>
  <p>
   Unlike some frameworks that tether users to a particular design, Trongate lets you choose from a potentially unlimited number of design themes for your admin panels.
  </p>
</details>
<details>
  <summary>Custom CSS Library</summary>
  <p>
   Frameworks should NOT depend upon third party libraries. That's why Trongate has its own CSS library. Yet another industry first!
  </p>
</details>
<details>
  <summary>Modular HAVC</summary>
  <p>
   Trongate uses Hierarchical Asset View Controller architecture. It's like HMVC on steroids! Finally, the PHP community have a "truly modular" PHP framework.
  </p>
</details>
<details>
  <summary>Module Import Wizard</summary>
  <p>
   Easily import entire modules, including SQL data. Drag 'n' drop web development, at last.
  </p>
</details>
<details>
  <summary>An App Store!</summary>
  <p>
   Trongate's Module Market is the PHP community's first legitimate challenge to the Composer / Packagist combo. Goodbye henhouse. Hello sunshine!
  </p>
</details>

<!-- Getting Started -->

## :toolbox: Getting Started

<!-- Prerequisites -->

### :bangbang: Prerequisites

- PHP 8+
  - gd module loaded in php.ini (for image uploader)
  - intl module loaded in php.ini (for url_title() method)
- MariaDB or MySQL

<!-- Installation -->

### :gear: Installation

The Trongate PHP framework is available from GitHub at the following URL:

https://github.com/trongate/trongate-framework.

However, the fastest and easiest way to get the Trongate PHP framework is by using the Trongate Desktop App. The Trongate Desktop App is 100% free of charge (it always will be!) and is available for Mac, Windows and Linux. The Trongate Desktop App can be downloaded from:

https://trongate.io/download

There are a wide variety of benefits from using the Trongate Desktop App. These include:

<ul>
  <li>Automatic framework downloads and setups</li>
  <li>Automatic updates whenever new features are added to Trongate</li>
  <li>Automatic code generation</li>
  <li>Automatic database management</li>
  <li>A graphical query builder</li>
 </ul>

<p>and much more... !</p>

<!-- Usage -->

## :eyes: Usage

<a href="http://www.youtube.com/watch?feature=player_embedded&v=2sAtjYcAD-4" target="_blank">
 <img src="http://img.youtube.com/vi/2sAtjYcAD-4/hqdefault.jpg" alt="Watch the video" />
</a>

<!-- Contributing -->

## :wave: Contributing

<a href="https://github.com/trongate/trongate-framework/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=trongate/trongate-framework" />
</a>

Contributions are always welcome!

<!-- License -->

## :warning: License

See LICENSE.txt for more information.

<!-- Contact -->

## :handshake: Contact

David Connelly - [@davidjconnelly](https://twitter.com/davidjconnelly) - [Get In Touch](https://trongate.io/your_messages/compose)
