# Non-QWERTY layouts and Tridactyl ("internationalisation")

Tridactyl's default keybinds are designed to be ergonomic on a QWERTY keyboard layout. On many other layouts - such as DVORAK or BÉPO - they are extremely unergonomic.

If you only use one keyboard layout, you could quite reasonably decide to rebind all of Tridactyl's binds manually to make it more ergonomic, or you could use `:keymap` to make your layout as seen to Tridactyl be more like QWERTY or whatever other layout you desire.

However, if you use multiple keyboard layouts, we recommend that you `:set keyboardlayoutforce true`. This setting intercepts all key presses and checks the keyboard layout-agnostic key codes and then translates those keycodes into the US ANSI QWERTY layout by default. This means that Tridactyl behaviour depends on the physical keys you press rather than the layout you are currently using, except in text fields. The major downside to this is that binding new commands becomes a bit mind bending since when you are writing the bind you must press the key that corresponds in your layout to the forced layout, rather than the physical key.

To counteract this, we have added a binding wizard/helper called `:bindwizard` which starts `gobble`, accepting physical key presses until Enter is pressed, at which point it prefills the command line with the key sequence which corresponds to your keys in the forced layout. Your binds will then be bound to the same keys no matter which software layout you use.

You can change the forced layout - see `:help keyboardlayoutbase` - if, for example, you would prefer the forced layout to be the UK QWERTY.

At the time of writing, it is not possible to use `:setmode` with `keyboardlayoutforce`, which means it also applies to hint mode and hint characters, which may be surprising.

The [next and final page](./9-help.md) of this tutorial is about getting help. <a href='./8-marks.md' rel="prev"></a>
