# Tridactyl news - Winter 2023

Hello,

Welcome to the ninth "quarterly" Tridactyl newsletter. Given that I've now missed five quarters in a row (how! how?) it is perhaps time to rebrand the newsletter but, as you may have noticed, the lack of newsletters has not meant a lack of progress on Tridactyl.

## Highlighted new features

2022 has been a year in which Tridactyl has got some long awaited and very cool features. We have completions for `:back` and `:forward` for navigating history within a tab. It cost us very little to make these tab history completions into a tree, which is something I personally have been wanting for a very long time. Pressing back no longer means that you lose pages - most of the time `:back` completions will have preserved them. I've added `:bind --mode=ex <C-o>t ex.execute_ex_on_completion_args tabopen -b` to my RC file so that I can open a page in the background from the history completions.

We also got the `:goto` command and completions that let you jump to specific headings on a page. It's really handy on well-structured pages like those of Wikipedia.

2022 also brought tab groups to Tridactyl for hiding and showing groups of tabs all at once. I know it is a feature that lots of people have missed since Firefox removed it. All the commands start with `:tgroup` - see `:help tgroupswitch` and `:help tgroupcreate` for tips on usage.

A feature that people have been missing from Vimperator that we finally got merged is local and global marks. You can add a mark with `m[a-zA-Z]` - local marks are added with lowercase letters are per page and are temporary; global marks are added with uppercase letters are permanent and can be used to access a specific part of a certain page from any other page, like a bookmark. Marks can be accessed with `\`[a-zA-Z]`.

Tridactyl has also gained some symbols on tab completions showing whether tabs are muted, playing audio or are discarded (which Firefox does to save RAM).

We've added a new feature a bit like `searchurls` called `jsurls` which instead of being a URL to which your search term is appeneded, are javascript functions which accept your search string and return a URL to navigate to. At the same time, `searchurls` now support basic splicing and indexing of search term arrays - see `:help searchurls` and `:help jsurls` for more details.

In the latest betas, `:set keyboardlayoutforce true` and e.g. `:set keyboardlayoutbase uk` to force Tridactyl to use a specific keyboard layout. This is useful if you use a keyboard layout that makes the default Tridactyl binds difficult to use, such as the Cyrillic or bepo, or if you regularly change keyboard layout but don't want Tridactyl binds to change. This feature can make making new binds complicated, so we have added a new command, `:bindwizard`, which accepts physical keypresses until you press `<Enter>` and translates them into the correct Tridactyl keysequence for the currently forced keyboard layout. For example, on a physical AZERTY layout with Tridactyl's `keyboardlayoutbase` set to QWERTY, using `:bindwizard` and pressing `a<Enter>` would bring up `:bind --mode=normal q`, since that is the key that Tridactyl would see when `a` was pressed on an AZERTY layout.

Finally, a feature that was added in the last few days is that `:set tabsort mru` now rewrites tab IDs for most commands. This means that `[count]gt` which takes you to the `[count]`th tab, will now take you to the `[count]`th most recently used tab. Repeatedly issuing this command (e.g. with `.`) will make you cycle through the `[count]+1`th most recently used tabs, which is a feature I personally find very useful.

## Neat bug fixes

Visual mode is much more reliable. The really annoying bug where Tridactyl would leave visual mode while you were extending the selection has been fixed. It is reliable enough for me now that I use it regularly for copying text. It may well be my favourite change in Tridactyl this year.

## Plans for next few months

2023 could end up being a difficult year for Tridactyl. Firefox is partially following Chrome in introducing Manifest V3, a new version of the browser extension API we use to interact with Firefox. One of the major changes is that `eval`, which we use for `:js`, `:jsb` and any user-specified callbacks, is going to lose access to the browser API. That will mean that lots of the more imaginative uses of those commands will stop working. We would like to support as many use-cases as possible but it is likely that we won't be able to find suitable workarounds for every situation. One alternative we are considering is to add a `contrib` folder to Tridactyl to which people would be encouraged to make PRs which would then be reviewed to lower standards than the rest of Tridactyl, so that it would be easier to add code to Tridactyl if you so wished. The API is still not totally set in stone so we can't yet fully know what restrictions it will or will not introduce.

Manifest V3 also removes the permanently live background page which Tridactyl uses heavily, and replaces it with short lived processes. That could necessitate a substantial rewrite of Tridactyl.

Finally, as a matter of some urgence, if you're currently donating to Tridactyl via GitHub sponsors using PayPal, please consider switching to another payment method. GitHub is dropping support for PayPal towards the end of February. The most efficient way to get money to me is via GitHub sponsors - I get very nearly 100% of the money you donate. You can also donate via wire transfer - contact me directly for details via oliver@blanthorn.com. If you would prefer not to do either of those, you can donate directly via PayPal to tridactyl.donations@gmail.com, but PayPal will take a 10-20% cut of the money you donate once exchange rates are taken into account. As a last resort, you can donate via Patreon, but I get a much smaller cut of the money you donate there - I think last time I did the maths, the fees in total added up to about 40% by the time it reached my bank account.

I'm a little bit worried about this as other open-source developers have said that about 30% of their income comes via GitHub sponsors using PayPal, which would be a fair chunk of income to lose overnight.

As always, thanks for your generous support,

bovine3dom and the rest of the Tridactyl developers
