# Tridactyl news - Spring 2021

Hello,

Welcome to the seventh quarterly Tridactyl newsletter. Somehow I missed the quarter and it's now summer ... sorry! We added a few neat features this quarter - I find myself using `:tabaudio` a lot - but most of the work went on changes to our build system which have made working on Tridactyl vastly more pleasurable.

## Highlighted new features

We have a couple of new features for tab/window management. The first relates to tabs playing audio: `:tabaudio`, bound to `ga` by default takes you to the tab currently playing audio in your current window; and a little speaker is shown next to tabs playing audio on `:tab` completions. The second is that you can now open windows in specific containers by using `:winopen -c [container]`.

Also on completions, you can now `:set completionfuzziness [0-1]` to control how fuzzy completion searching is for lots of completions. If you find that you get surprising results when you're filtering completions, consider turning this setting down to get more exact matches.

Our hint mode argument parser was totally rewritten, meaning that essentially all flags which could meaningfully be combined now can be combined. At the same time, `:hint -V` was added for hinting the entire page rather than just the visible area.

I gave themes a bit of TLC in Tridactyl; you can now load themes directly from a URL with `:colours --url`; `:colours` now has completions; `:colours` will fallback to loading from Tridactyl storage if a theme isn't found on disk; and finally it is much easier to get starting writing themes as you no longer require any magic classnames. These improvements were inspired by the "Tips and Tricks" newsletter I was writing at the time (the one available for 10 USD sponsors/patrons and up) ... so I was right that they'd have trickle-down effects!

I finally fixed something a bit daft: you've been able to `:source --url` for a while to load an RC file from a web page without using the native messenger, but there was no way to write an RC file without the native messenger. Now you can, with `:mkt --clipboard` which will store your current settings as in an RC format in your system clipboard for you to paste wherever is convenient.

And finally, just for fun, a pull request added `:drawing{start,stop}`. These commands allow you to temporarily scribble on web pages with your mouse or stylus if you have one.

## Neat bug fixes

We've added a workaround for a Firefox bug that always confused new users: `:viewconfig` used to just give you a huge JSON dump on a single line when you called it from Tridactyl pages such as the new tab page or the help page, but it would appear in a snazzy JSON-viewer on other pages. It now works from Tridactyl tabs ... most of the time. There's a bug where sometimes it now just doesn't work at all, on any tab, if your system is overloaded. If that happens to you, close some tabs until we get around to fixing it.

We rewrote completions a little so that we update the DOM a bit less, which could improve performance, but it's hard to tell. I personally feel like `<S-Del>` on completions has sped up a bit but I've been wrong before.

## Stuff only Tridactyl developers care about

This newsletter is a bit shorter than previous ones - we've made fewer user-facing changes to Tridactyl this quarter. Instead, the bulk of my time on Tridactyl went on changing our build system from one centred on `webpack` to one centred on `esbuild`. Our development builds - how long it takes from making a change in Tridactyl to being able to test it - went from about 40 seconds to 1 second. It's made developing Tridactyl much less frustrating; it has made me very happy indeed. With luck this should mean that we can add features and fix bugs in Tridactyl more quickly.

At the same time, I rationalised the amount of stuff needed to reproduce a Tridactyl build - mostly because I felt sorry for Mozilla reviewers. Because our builds come with `:credits` containing an automatically generated list of contributors and `:version` which contains in some builds a git hash, you previously needed our entire git history to reproduce a build. Now we simply write those details to some small files when creating a build, so that a much smaller amount of code (5MB vs 100MB) is required. On a related note, `Tridactyl: Beta` builds got held up in the Mozilla review process for about 6 weeks, meaning no new releases were made in that time. It doesn't look like anyone other than me noticed. For now, our `Beta` releases will be semi-manual as Mozilla has started enforcing its "you must manually upload source code alongside your automated submissions" policy for non-listed extensions. This shouldn't make much difference to users but it has added a few minutes of drudgery to my week so I thought I would complain about it here...

## Plans for next few months

In the last newsletter I wrote that I thought I would probably spend a while fixing bugs in the native messenger, which came true (albeit with a lot of help from contributors). There are still a few - particularly, we broke `:set yankto selection`, which I keep meaning to look at.

Financially, donations are down a little this quarter, something along the lines of 20%, which I'll need to keep an eye on. I've been very slow with the newsletters - I'm not sure if that is a factor or if is just natural "leakage" as people rationalise their subscriptions. Anyway, I'll try to make sure the summer newsletter actually comes out in summer ... and as a gentle reminder, I get about 30% more of your money if you donate via GitHub Sponsors rather than Patreon.

You may also be aware that Mozilla is taking some steps towards implementing "Manifest V3", a Google initiative to "make web extensions more secure" (and accidentally nerf ad-blockers at the same time). Most of the noise online about that is about how Mozilla won't follow Google in making ad-blockers much worse, but they are intending to tighten up "content security policy" and use of `eval()` which _probably_ means that `:js`, `:jsb` and `:hint -F` callbacks will stop working [^1]. We could mitigate that by making `:composite` more powerful, but at some point if we make `:composite` too useful we will be violating the spirit of the rules. Switching to "Manifest V3" is planned to be compulsory some time in 2023, but as far as I understand it, Mozilla are talking about bringing some of these changes down to "Manifest V2" which we currently use, so we could see some features disappearing sooner. I'll keep you all up to date.

As always, thanks for your generous support,

bovine3dom and the rest of the Tridactyl developers

[^1]: a tiny angry footnote here: this is also going to stop in-browser language translation from working, which while already against Mozilla policies (no remote code execution) is currently possible. It infuriates me that Mozilla, while claiming to be a champion of minorities, doesn't see "allowing minorities to read the internet in their own language" as an absolute priority. Yes, Mozilla has their own offline language translation system in development but this is a bit like seeing a hungry person eating, slapping the food out of their hands because you think it is unhealthy and then planting a potato for them and expecting them to be grateful. `>:(`
