# Tridactyl news - Winter 2021

Hello,

Welcome to the sixth quarterly Tridactyl newsletter. As a gentle reminder, the second (and first paywalled) Tridactyl top-tips newsletter will be going out in the next few days. If you'd like to receive it, simply up your monthly pledge to 10 USD or more on GitHub sponsors (preferred, as I get ~30%+ more of your money after taxes and transaction fees) or Patreon. I really appreciate every penny you send - it directly affects how long I can afford to work on Tridactyl. This next tips newsletter will be on making custom themes.

If you don't feel like you can afford the extra newsletter, don't worry about it too much. I find that when I start documenting how crazy parts of Tridactyl it is often easier to re-write how it works in Tridactyl rather than suffer the embarrassment of communicating it; so writing the tips newsletters benefits everyone. I'd also like to turn the newsletters into public wiki pages - I'll probably do that about 3 months after each one goes out.

## Highlighted new features

### Native messenger a bit quicker

The big change this quarter is that we've rewritten the native messenger - the little programme that lets Tridactyl interact with your computer, for example to read your files from your filesystem or restart Firefox - in Nim, a small compiled language previously called Nimrod. Compared to the previous Python version, Nim starts up much faster leading to around speed-ups of 2-100x depending on the command and your system. Windows users who were using the cross-compiled Python executables should notice a particularly large speedup; it is very obvious when using the editor on `<C-i>` in a text-box if you haven't manually set `:editorcmd`. At the time of writing this newsletter, the native messenger wasn't quite ready for release on OSX (a lack of testing) or Windows (reimplementing `:restart` is non-trivial). On Linux the messenger should update automatically in the latest betas if you already have native installed - just run `:native` to check. `0.2.0` is the first Nim version of the messenger. Use `:nativeupdate` to update it if it hasn't updated itself.

### Other stuff

Quite a few minor things have been added to Tridactyl, too. As always, I'll detail a few highlights here.

`:tabclose` now accepts `window_number.tab_number` arguments, meaning that Shift-Delete works to close tabs even in other windows on `:taball` completions. The selected completion on `:taball` doesn't currently move to the next option as you would expect. I'm hoping I'll get round to implementing that soon.

Three new hint modes were added: `;x` and `;X` "emergency" hint modes added if you have the native messenger and `xdotool` installed: these actually move the mouse and click on the element you select, so no amount of JS-shenanigans will break it. `;K` reversible element-"kill" hint mode added with `:elementunhide` to resurrect elements. `;Y` image-to-clipboard hint mode added.

Just for fun, `g!` jumbles all the text on the page, leaving the start and end of each word in the same place. Give your brain some exercise.

As a small quality-of-life improvement, we've changed how the clipboard commands (`yy`, etc) work under-the-bonnet to use a newer clipboard API. They're quite a bit quicker than they were and throw fewer errors now.

We've added a few treats for advanced users, too: a `UriChange` event added for `:autocmd` for use as a last resort on modern single-page application (SPA) sites where `DocLoad` events don't fire. Unfortunately it uses a little bit of extra power, so don't turn it on unless you need it. Additionally, `:js` accepts a flag `-d` and an EOF character, which will then give you `JS_ARGS` array to use of space-separated arguments, making it easier to make more complex ex-commands.

## Neat bug fixes

### Fewer race conditions on user input in the command line

In the command line, we now wait for completions to load before processing any commands that interact with the completions. In practice this means that if you have a website that you regularly visit, you can build up muscle memory to quickly go to and select that site - say, for example, you visit `news.bbc.co.uk` a lot, you can access it by typing `tne<Tab><Enter>`.

There's a caveat here in that you have to wait for the command line to have loaded at least a bit before you continue to type, but once the input box has appeared you can type as quickly as you like.

With this fix, I'm personally much happier using Tridactyl than I was. For me, it is a big step towards being a reliable tool I enjoy using and away from being a janky thing that I simply put up with.

### Other stuff

Help and tutor pages now follow your theme. `:editor` is quicker on Windows (even without the new native messenger) as we no longer check for Linux terminals which are vanishingly unlikely to exist. And that's pretty much it ... I think we must have added and then fixed lots of bugs in the beta which aren't really worth mentioning in these newsletters.

## Plans for next few months

I'll keep making the tips & tricks newsletters and maybe try to advertise them a little more. We currently have 12 donors across all platforms that will receive them. In monetary terms that is getting towards the "worth it" line, I think. We'll see whether it becomes too exhausting writing them each month, especially if I start tidying them up for the wiki too.

I'm still toying with the idea of looking seriously into a paid-for Chrome port, but I think I've found more things that I want to fix in Tridactyl first. I'm going to take another look at rewriting the completions code - updating the all-window-tab completions because they missed something that the one-window-tab completions had was unpleasant because there was so much duplicated code.

Finally, I expect I'll spend much of the next quarter fixing bugs I didn't spot in the new native messenger : )

As always, thanks for your generous support,

bovine3dom and the rest of the Tridactyl developers
