# Tridactyl news - Autumn 2020

Hello,

Welcome to the fifth quarterly Tridactyl newsletter.

We've had another productive quarter. It hasn't been quite as transformative as the last quarter - the addition of browser-wide `<C-,>` and `<C-6>` was hard to beat (I've personally switched to using `<C-,>` instead of `<Esc>` and generally Tridactyl and I get along a lot better :)) - but we have added quite a few nice little things.

## Highlighted new features

### For everyone

A few new features relating to completions have been added: `<C-o>yy` copies the currently selected completion to the clipboard, `<S-Delete>` executes `:tabclose` on a selected completion's arguments and `<C-Enter>` executes the highlighted completion keeping the command line open - particularly useful for, e.g. `tabopen -b`. The commands relating to those binds are `ex.execute_ex_on_completion{,_args} [ex command]`; the "args" variant means that the ex-command that triggered the completion is omitted from the final executed command.

Next, a quality of life improvement for some of our users. The mode indicator can now be hidden in individual modes with `:set modeindicatormodes.[mode] true|false`. I hope this is useful for e.g. full screen applications and ignore mode; users often were frustrated by the appearance of the mode indicator on YouTube.

My favourite feature of the quarter, from a contributor, is `:jumble`, bound to `g!` by default, which shuffles the characters in all text on the page while persrvineg the frist and last letetr of each word. Just for fun.

### For power users

I added a callback hintmode with `:hint -F elem => [... do some stuff in JS ...]`. I don't know why we didn't add it earlier - it was easy to implement and allows you to do a lot of cool stuff. It just goes to show that Tridactyl still has some low-hanging fruit!

autocommands now support `WebRequest` events - see `:help autocmd` for more details. It's especially useful for redirecting sites, like old reddit to new reddit, but comes with lots of caveats - rather than an ex-command, it runs a JavaScript snippet which must return an object with a specific format. There's no substitute for reading the help page on this one, I'm afraid.

`:js` now accepts a flag, `-d`, to specify an EOF character which allows space-separated arguments to be given to it, stored in the array `JS_ARGS`, meaning that people really can write their own ex-commands - the only thing left, really, is custom completions : ).

`:autocmd` now provides magic variables for lots of events - see `:help autocmd` to see them all. It's useful for ensuring that an ex-command affects the right tab even if that tab is opened in the background.

## Highlighted bug fixes

Tridactyl _finally_ should display the right version number on the new tab page and everywhere else, which means pretty version numbers for stable users. Beta users keep the current ugly version numbers : ).

In a fairly big change - you probably noticed it because your config disappeared despite my best efforts - we have ditched automatic synchronisation with the Firefox Sync storage. It had always caused problems for a minority of our users, but the introduction of a strict storage quota by Mozilla meant it broke for almost everyone using a custom theme. We now just use the local storage; if you want to keep your settings in sync with another machine, just run `:firefoxsync{pull,push}` periodically. Currently, the settings do not merge and will just overwrite when you push/pull - if anyone really wants that feature they should ask me. I suspect most people will manage fine without it. I'm hoping that this change might have made our RC files more reliable, but so far I haven't heard any noises either way.

We also fixed a bug that was particularly frustrating to new users: the little pop-up telling you the address of a link you are hovering over is now hidden when the command line is opened. We do this by putting focus on a fake empty link and then quickly deleting it - a trick we found in [VVimpulation](https://github.com/amedama41/vvimpulation), a smaller vim-like browser project that actually has quite a few neat little features. Open source is nice sometimes.

As a workaround to make `<C-,>` compatible with Tree Style Tab, `:set escapehatchsidebarhack` stops us from closing the sidebar. Unfortunately, that means that we can't get focus back from the address bar, so pick your poison.

Finally, a bug that I personally found very distracting has been squashed: `yy` should no longer give spurious errors.

## Other stuff + the near future

You might be interested to learn that [I did an interview for a little tech newsletter](https://console.substack.com/p/console-21), which was fun. Everyone loves talking about themselves.

In the next quarter, GitHub will stop doubling donations via GitHub sponsors. They still won't charge any fees, so it's still a vastly better deal than PayPal or Patreon (if your donation is small, those platforms will eat about ~30% of it by the time it gets to our pockets). This leaves us with a slight conundrum as my state-of-the-art forecasts predict that I would still like to eat broadly the same amount of food even after GitHub stops doubling the donations. I think we have enough users (and certainly the potential to have enough users) that, together, they could afford to keep me fed and maybe even housed [1]. I have a few ideas for persuading them to do this:

-   porting to Chrome and charging a fairly high yearly licence fee for it + big updates to it (~tens of pounds); security updates and major bug/compatibility fixes we'd probably offer for free for as long as we could reasonably manage. Firefox would remain free and all our code would continue to be FOSS - people could just build Tridactyl for Chrome themselves if they wanted.

-   offering a paid-for weekly newsletter with Tridactyl tips and tricks (~a few pounds a month). Not sure how I'd manage the mechanics of it - would people who got this newsletter currently be fed up if one suddenly turned up once a month?

-   asking slightly more prominently in Tridactyl and explaining why we need donations in a little more detail. I'd probably add a setting to disable this ... I don't want to turn into Wikipedia (but Wikipedia is rolling in cash, so maybe I do?). We'd need the setting for the Chrome port, anyway, so that we weren't nagging people who had already paid.

In terms of features that are coming your way - I think I have finally been frustrated enough by our completion code that I am going to rewrite it to rely more heavily on configuration at runtime; I hope that will allow for more natural code re-use than the "you only have one parent" inheritance we currently use. It would also naturally allow users to write their own completions. I am optimistic that I will be able to merge the key-up binding PR in the next few months too - there's just one minor bug (that I know of) left to squash. The key-up bindings would allow for layers (e.g. hold \ to make j and k scroll farther) and "videogame style" smooth scrolling where the scrolling happens only while the key is held.

Thanks as ever for your support,

bovine3dom and the rest of the Tridactyl developers

[1]: NB - I am not in danger of starving or becoming homeless any time soon. However, there is a real risk that I would seek gainful employment if I was having to draw from my savings every month, which would mean less time spent on Tridactyl.
