#!/usr/bin/env python
from __future__ import print_function

handlers = [
    "hard_fault_handler",
    "mem_manage_handler",
    "bus_fault_handler",
    "usage_fault_handler",
    "nvic_wwdg_isr",
    "pvd_isr",
    "tamp_stamp_isr",
    "rtc_wkup_isr",
    "flash_isr",
    "rcc_isr",
    "exti0_isr",
    "exti1_isr",
    "exti2_isr",
    "exti3_isr",
    "exti4_isr",
    "dma1_stream0_isr",
    "dma1_stream1_isr",
    "dma1_stream2_isr",
    "dma1_stream3_isr",
    "dma1_stream4_isr",
    "dma1_stream5_isr",
    "dma1_stream6_isr",
    "adc_isr",
    "can1_tx_isr",
    "can1_rx0_isr",
    "can1_rx1_isr",
    "can1_sce_isr",
    "exti9_5_isr",
    "tim1_brk_tim9_isr",
    "tim1_up_tim10_isr",
    "tim1_trg_com_tim11_isr",
    "tim1_cc_isr",
    "tim2_isr",
    "tim3_isr",
    "tim4_isr",
    "i2c1_ev_isr",
    "i2c1_er_isr",
    "i2c2_ev_isr",
    "i2c2_er_isr",
    "spi1_isr",
    "spi2_isr",
    "usart1_isr",
    "usart2_isr",
    "usart3_isr",
    "exti15_10_isr",
    "rtc_alarm_isr",
    "usb_fs_wkup_isr",
    "tim8_brk_tim12_isr",
    "tim8_up_tim13_isr",
    "tim8_trg_com_tim14_isr",
    "tim8_cc_isr",
    "dma1_stream7_isr",
    "fsmc_isr",
    "sdio_isr",
    "tim5_isr",
    "spi3_isr",
    "uart4_isr",
    "uart5_isr",
    "tim6_dac_isr",
    "tim7_isr",
    "dma2_stream0_isr",
    "dma2_stream1_isr",
    "dma2_stream2_isr",
    "dma2_stream3_isr",
    "dma2_stream4_isr",
    "eth_isr",
    "eth_wkup_isr",
    "can2_tx_isr",
    "can2_rx0_isr",
    "can2_rx1_isr",
    "can2_sce_isr",
    "otg_fs_isr",
    "dma2_stream5_isr",
    "dma2_stream6_isr",
    "dma2_stream7_isr",
    "usart6_isr",
    "i2c3_ev_isr",
    "i2c3_er_isr",
    "otg_hs_ep1_out_isr",
    "otg_hs_ep1_in_isr",
    "otg_hs_wkup_isr",
    "otg_hs_isr",
    "dcmi_isr",
    "cryp_isr",
    "hash_rng_isr",
]

with open("handlers.c", "wt") as f:
    f.write('#include "layout.h"\n')
    f.write('#include "oled.h"\n\n')
    for i in handlers:
        f.write(f"void __attribute__((noreturn)) {i}(void)\n")
        f.write("{\n")
        f.write(
            f'\tlayoutDialog(DIALOG_ICON_ERROR, NULL, NULL, NULL, "Encountered", NULL, "{i.upper()}", NULL, "Please restart", "the device.");\n'
        )
        f.write("\tfor (;;) {} // loop forever\n")
        f.write("}\n\n")
