<%
ATTRIBUTES_REQUIRED = (
	("namespace", c_str),
	("mosaic", c_str),
)

ATTRIBUTES_OPTIONAL = (
	("name", c_str),
	("ticker", lambda s: c_str(" " + s) if s else "NULL"),
	("divisibility", int),
	("levy", lambda s: "NEMMosaicLevy_" + s),
	("fee", int),
	("levy_namespace", c_str),
	("levy_mosaic", c_str),
)
%>\
// This file is automatically generated from nem_mosaics.c.mako
// DO NOT EDIT

#include "nem_mosaics.h"

const NEMMosaicDefinition NEM_MOSAIC_DEFINITIONS[NEM_MOSAIC_DEFINITIONS_COUNT] = {
% for m in supported_on("T1B1", nem):
{
	% for attr, func in ATTRIBUTES_REQUIRED:
		% if attr in m:
	.${attr} = ${func(m[attr])},
		% endif
	% endfor
	.description = "",
	% for attr, func in ATTRIBUTES_OPTIONAL:
		% if attr in m:
	.has_${attr} = true,
	.${attr} = ${func(m[attr])},
		% endif
	% endfor
	% if "networks" in m:
	.networks_count = ${len(m["networks"])},
	.networks = { ${", ".join(map(str, m["networks"]))} },
	% endif
},
% endfor
};

const NEMMosaicDefinition *NEM_MOSAIC_DEFINITION_XEM = NEM_MOSAIC_DEFINITIONS;
