<% networks = list(supported_on("T1B1", eth)) %>\
// This file is automatically generated from ethereum_networks.c.mako
// DO NOT EDIT

#include "ethereum.h"
#include "ethereum_networks.h"

#define NETWORKS_COUNT ${len(networks)}

static const EthereumNetworkInfo networks[NETWORKS_COUNT] = {
% for n in networks:
  {
    .chain_id = ${n.chain_id},
    .slip44 = ${n.slip44},
    .symbol = ${c_str(n.shortcut)},  /* ${n.name} */
    .name = "",
  },
% endfor
};

const EthereumNetworkInfo UNKNOWN_NETWORK = {
  .chain_id = CHAIN_ID_UNKNOWN,
  .slip44 = SLIP44_UNKNOWN,
  .symbol = "UNKN",
  .name = "",
};

const EthereumNetworkInfo *ethereum_get_network_by_chain_id(uint64_t chain_id) {
  for (size_t i = 0; i < NETWORKS_COUNT; i++) {
    if (networks[i].chain_id == chain_id) {
      return &networks[i];
    }
  }
  return &UNKNOWN_NETWORK;
}

const EthereumNetworkInfo *ethereum_get_network_by_slip44(uint32_t slip44) {
  for (size_t i = 0; i < NETWORKS_COUNT; i++) {
    if (networks[i].slip44 == slip44) {
      return &networks[i];
    }
  }
  return &UNKNOWN_NETWORK;
}

bool is_unknown_network(const EthereumNetworkInfo *network) {
  return network->chain_id == CHAIN_ID_UNKNOWN;
}
