<%
def signed_message_header(s):
	return r'"\x{:02x}" {}'.format(len(s), c_str(s))

def c_bool(b):
	return "true" if b else "false"

def c_int(i):
	return int(i or 0)

def defined(s):
	return c_bool(s is not None)

def hex(x):
	return "0x{:08x}".format(c_int(x))
%>\
// This file is automatically generated from coin_info.c.mako
// DO NOT EDIT

#include "coins.h"

#include "curves.h"
#include "secp256k1.h"

const CoinInfo coins[COINS_COUNT] = {
% for c in supported_on("T1B1", bitcoin):
{
	.coin_name = ${c_str(c.coin_name)},
	.coin_shortcut = ${c_str(c.coin_shortcut)},
	.maxfee_kb = ${c_int(c.maxfee_kb)},
	.signed_message_header = ${signed_message_header(c.signed_message_header)},
	.has_segwit = ${c_bool(c.segwit)},
	.has_taproot = ${c_bool(c.taproot)},
	.has_fork_id = ${defined(c.fork_id)},
	.force_bip143 = ${c_bool(c.force_bip143)},
	.decred = ${c_bool(c.decred)},
	.decimals = ${c.decimals},
	.address_type = ${c.address_type},
	.address_type_p2sh = ${c.address_type_p2sh},
	.xpub_magic = ${hex(c.xpub_magic)},
	.xpub_magic_segwit_p2sh = ${hex(c.xpub_magic_segwit_p2sh)},
	.xpub_magic_segwit_native = ${hex(c.xpub_magic_segwit_native)},
	.xpub_magic_multisig_segwit_p2sh = ${hex(c.xpub_magic_multisig_segwit_p2sh)},
	.xpub_magic_multisig_segwit_native = ${hex(c.xpub_magic_multisig_segwit_native)},
	.fork_id = ${c_int(c.fork_id)},
	.bech32_prefix = ${c_str(c.bech32_prefix)},
	.cashaddr_prefix = ${c_str(c.cashaddr_prefix)},
	.coin_type = (${c_int(c.slip44)} | 0x80000000),
	.negative_fee = ${c_bool(c.negative_fee)},
	.curve_name = ${c.curve_name.upper()}_NAME,
	.curve = &${c.curve_name}_info,
	.extra_data = ${c_bool(c.extra_data)},
	.timestamp = ${c_bool(c.timestamp)},
	.overwintered = ${c_bool(c.overwintered)},
},
% endfor
};
