# Debugging T1 signatures

## Signing with the "SignMessage" (v3) method
1. T1 firmware+bootloader must be built with `DEBUG_T1_SIGNATURES=1` to be able to debug them
1. Load signing device or emulator (must have `PYOPT=0` for core or `DEBUG_LINK=1`
   for T1 legacy) with:
   `trezorctl device load -m "table table table table table table table table table table table advance"`
1. **FW header hash is different from whole FW hash in the one output by cibuild**
1. Run the emulator or device (make sure not to confuse which are you using for signing)
1. Run `firmware_hash_sign_trezor.py ../firmware/trezor.bin ../firmware/trezor.bin.signed`
1. Accept 2 signature requests on signing device
1. This will show you a list of 2 signatures for 3 keys
1. It will output `../firmware.trezor.bin.signed`

By default the scripts uses the `[1, 2]` sigindices, you can modify `sig_indices`
inside to have different order or different keys (1 <= index <= 3 )

Update FW on T1 either via `trezorctl device firmware-update` or
`make flash_firmware_jlink`.

## Signing with the v2 method (called "new" for confusing historical reasons)

This method is currently (Oct 2022) used for signing official T1 firmwares.
To debug it, you also need `DEBUG_T1_SIGNATURES=1` build (bootloader and FW)

Use this to sign FW:

    sign_firmware_v2_signature.py ../firmware/trezor.bin ../firmware/trezor.bin.signed.v2

## Notes on signatures patching

`fill_t1_fw_signatures.py` script will allow you to paste wrong signatures
because that is also needed for testing. For example you may repeat
sigindex or use wrong signature (as long as it's some 64 bytes)

Using e.g. this signatures generated by `firmware_hash_sign_trezor`
1. Copy three of the signatures and their indices into `trezor.bin.signatures` file, e.g.
```
1 bc8ed893fedc088ea4b45f775ea62ef84d8113a6c0f2d88d0fb6b8f4c26549eb02e88dffa3c06517729ce5b41da3678d88ac4a7ce3b0ad05a1ee0507f7165dd3
2 58f89a229b1d47011bd7771395c20bdce461bde2f150331e26a4cfc58456bdb0456e886f1d558b47f80982ec80dff941028fb4b1ef05e79fa32b6298dbf0bc5f
4 2a5ca0d3f7cad6b440a417779942158d70442e2ccd48875131d83a1644ae00022c531590a605d2ad415d778afda8b8118b47e4c47442014be64e90fa09b3a4ab
```

Finally use this file to patch signatures into the unsigned `trezor.bin`:

    fill_t1_fw_signatures.py firmware/trezor.bin trezor.bin.signatures

Example output for this hash:

```
Loaded FW image with header hash 9e82a06e05a73b6fc5236508c3d1f3cdd15868523191783cfa2bda78d6e349c6
Parsing sig line 1 - 1 bc8ed893fedc088ea4b45f775ea62ef84d8113a6c0f2d88d0fb6b8f4c26549eb02e88dffa3c06517729ce5b41da3678d88ac4a7ce3b0ad05a1ee0507f7165dd3

Parsing sig line 2 - 2 58f89a229b1d47011bd7771395c20bdce461bde2f150331e26a4cfc58456bdb0456e886f1d558b47f80982ec80dff941028fb4b1ef05e79fa32b6298dbf0bc5f

Parsing sig line 3 - 4 2a5ca0d3f7cad6b440a417779942158d70442e2ccd48875131d83a1644ae00022c531590a605d2ad415d778afda8b8118b47e4c47442014be64e90fa09b3a4ab

Patching sigindex 1 at offset 736
Patching signature bc8ed893fedc088ea4b45f775ea62ef84d8113a6c0f2d88d0fb6b8f4c26549eb02e88dffa3c06517729ce5b41da3678d88ac4a7ce3b0ad05a1ee0507f7165dd3 at offset 544
Patching sigindex 2 at offset 737
Patching signature 58f89a229b1d47011bd7771395c20bdce461bde2f150331e26a4cfc58456bdb0456e886f1d558b47f80982ec80dff941028fb4b1ef05e79fa32b6298dbf0bc5f at offset 608
Patching sigindex 4 at offset 738
Patching signature 2a5ca0d3f7cad6b440a417779942158d70442e2ccd48875131d83a1644ae00022c531590a605d2ad415d778afda8b8118b47e4c47442014be64e90fa09b3a4ab at offset 672
Writing output signed FW file firmware/trezor.bin.signed
```

## Manually verifying signature

Use `firmware_hash_verify.py`:

* arg 1 - hex digest of firmware header with zeroed sigslots
* arg 2 - public key (compressed or uncompressed)
* arg 3 - signature 64 bytes in hex

```
./firmware_hash_verify.py 0029608e2c879b6f6f636faba08d3434319e4694f6e0cdd626e4216640c403a1 02e62488c7a4aee638457f8b6afdb6dc41993971b5175dd4b941e14441c2df22b2 1ce267b37d712776f856ace87c8633413699b7212c63577fcac654c91ae9d35347f208fc7fb6d2315514a111c3d951a2c6451cc2a6178bdf12dc0c76406a6c08
```
