/*
 * This file is part of the Trezor project, https://trezor.io/
 *
 * Copyright (c) SatoshiLabs
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TREZORHAL_COMMON_H__
#define __TREZORHAL_COMMON_H__

#include <stddef.h>
#include <stdint.h>
#include "secbool.h"

#define HW_ENTROPY_LEN (12 + 32)
extern uint8_t HW_ENTROPY_DATA[HW_ENTROPY_LEN];

void __attribute__((noreturn))
__fatal_error(const char *msg, const char *file, int line);
void __attribute__((noreturn))
error_shutdown(const char *line1, const char *line2, const char *line3,
               const char *line4);
void show_wipe_code_screen(void);
void show_pin_too_many_screen(void);

#define ensure(expr, msg) \
  (((expr) == sectrue) ? (void)0 : __fatal_error(msg, __FILE__, __LINE__))

void hal_delay(uint32_t ms);
uint32_t hal_ticks_ms(void);

void drbg_init(void);
void drbg_reseed(const uint8_t *entropy, size_t len);
void drbg_generate(uint8_t *buf, size_t len);
uint32_t drbg_random32(void);

#endif
