# Generated files

Certain files in the repository are auto-generated from other sources, but the generated
content is stored in Git. The command `make gen_check`, run from CI, ensures that the
generated content matches its sources. The command `make gen` regenerates all relevant
files.

In general, generated files are not compatible between branches. After rebasing or
merging a different branch, you should immediately run `make gen` and make sure the
result is committed.

**Do not fix merge conflicts in generated files**. Instead, run `make gen` and commit
the result.

The following is a (possibly incomplete) list of files regenerated by `make gen`:

* `core/mocks/generated`: mock Python stubs for C modules (`modtrezor*`). Generated from
  special comments in `embed/upymod/modtrezor*`.
* `networks.py`, `tokens.py`, `coininfo.py` and `nem_mosaics.py` in their respective
  subdirectories of `core/src/apps`. In general, any file matching `*.py.mako` has a
  corresponding `*.py` file generated from the Mako template. These files are based on
  coin data from `common/defs`.
* Protobuf class definitions in `core/src/trezor/messages` and
  `python/src/trezorlib/messages`. Generated from `common/protob/*.proto`.
