# Summary

- [Introduction](index.md)
- [Core](core/index.md)
  - [Build](core/build/index.md)
    - [Embedded](core/build/embedded.md)
    - [Emulator](core/build/emulator.md)
  - [Emulator](core/emulator/index.md)
    - [Valgrind profiling](core/emulator/valgrind.md)
  - [Event Loop](core/src/event-loop.md)
  - [Apps](core/src/apps.md)
  - [Tests](core/tests/index.md)
  - [Debugging on hardware](core/embed_debug/index.md)
  - [SystemView instrumentation](core/systemview/index.md)
  - [Miscellaneous](core/misc/index.md)
    - [Boot stages](core/misc/boot.md)
    - [Code style](core/misc/codestyle.md)
    - [DISC1](core/misc/disc1.md)
    - [Exceptions usage](core/misc/exceptions.md)
    - [Memory fragmentation management](core/misc/fragmentation.md)
    - [Memory layout](core/misc/memory.md)
    - [SLIP-39](core/misc/slip0039.md)
    - [Translation data format](core/misc/translations.md)
    - [UI Layout lifecycle](core/misc/layout-lifecycle.md)
- [Legacy](legacy/index.md)
    - [Firmware format](legacy/firmware-format.md)
- [Python](python/index.md)
  - [trezorlib](python/trezorlib.md)
- [Common](common/index.md)
  - [Communication](common/communication/index.md)
    - [Sessions](common/communication/sessions.md)
    - [Passphrase](common/communication/passphrase.md)
      - [Migration](common/communication/passphrase-redesign-migration.md)
    - [Bitcoin signing](common/communication/bitcoin-signing.md)
  - [Reproducible builds](common/reproducible-build.md)
  - [Message Workflows](common/message-workflows.md)
  - [Ethereum definitions](common/ethereum-definitions.md)
- [Storage](storage/index.md)
- [Tests](tests/index.md)
  - [Device Tests](tests/device-tests.md)
  - [Upgrade Tests](tests/upgrade-tests.md)
  - [UI Tests](tests/ui-tests.md)
  - [Click Tests](tests/click-tests.md)
- [CI](ci/index.md)
  - [GitLab CI Jobs](ci/jobs.md)
- [Miscellaneous](misc/index.md)
  - [Affected third-parties](misc/third-parties.md)
  - [Changelog](misc/changelog.md)
  - [Coins' BIP-44 Paths](misc/coins-bip44-paths.md)
  - [Contributing](misc/contributing.md)
  - [FW update and device wipe](misc/update-wipes.md)
  - [Generated Files](misc/generated-files.md)
  - [Git Hooks](misc/git-hooks.md)
  - [Monorepo Notes](misc/monorepo.md)
  - [Review Process](misc/review.md)
  - [TOIF Image Format](misc/toif.md)
- [Developers guide](developers/index.md)
  - [Libraries](developers/libraries.md)
  - [Hello World in Core](developers/hello_world_feature_TT.md)
