# flake8: noqa: F403,F405
from common import *  # isort:skip

from trezor import utils


class TestUtils(unittest.TestCase):
    def test_chunks(self):
        c = list(utils.chunks(range(100), 7))
        for i in range(15):
            # need to check start, stop, step attrs until https://github.com/micropython/micropython/issues/2600 is resolved
            self.assertEqual(c[i].start, i * 7)
            self.assertEqual(c[i].stop, 100 if (i == 14) else (i + 1) * 7)
            self.assertEqual(c[i].step, 1)

    def test_truncate_utf8(self):
        self.assertEqual(utils.truncate_utf8("", 3), "")
        self.assertEqual(utils.truncate_utf8("a", 3), "a")
        self.assertEqual(utils.truncate_utf8("ab", 3), "ab")
        self.assertEqual(utils.truncate_utf8("abc", 3), "abc")
        self.assertEqual(utils.truncate_utf8("abcd", 3), "abc")
        self.assertEqual(utils.truncate_utf8("abcde", 3), "abc")
        self.assertEqual(utils.truncate_utf8("a\u0123", 3), "a\u0123")  # b'a\xc4\xa3'
        self.assertEqual(utils.truncate_utf8("a\u1234", 3), "a")  # b'a\xe1\x88\xb4'
        self.assertEqual(utils.truncate_utf8("ab\u0123", 3), "ab")  # b'ab\xc4\xa3'
        self.assertEqual(utils.truncate_utf8("ab\u1234", 3), "ab")  # b'ab\xe1\x88\xb4'
        self.assertEqual(utils.truncate_utf8("abc\u0123", 3), "abc")  # b'abc\xc4\xa3'
        self.assertEqual(
            utils.truncate_utf8("abc\u1234", 3), "abc"
        )  # b'abc\xe1\x88\xb4'
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 0), ""
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 1), ""
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 2), ""
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 3), "\u1234"
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 4), "\u1234"
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 5), "\u1234"
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 6), "\u1234\u5678"
        )  # b'\xe1\x88\xb4\xe5\x99\xb8
        self.assertEqual(
            utils.truncate_utf8("\u1234\u5678", 7), "\u1234\u5678"
        )  # b'\xe1\x88\xb4\xe5\x99\xb8

    def test_firmware_hash(self):
        if utils.INTERNAL_MODEL in (  # pylint: disable=internal-model-tuple-comparison
            "DISC2",
            "T3W1",
        ):
            self.assertEqual(
                utils.firmware_hash(),
                b"\xde\xce\xc5\xf6\xa4vgl5\x13l2\xa5\xf8F\xd8\xba\n$\x0b!x\x1fVM\x1e\xf3}@\xd9\xa8\xe9",
            )
            self.assertEqual(
                utils.firmware_hash(b"0123456789abcdef"),
                b"\xb9w\xa0\x02\xbb\xa5\xa3\x90%.\x13\x97\xf8\xf0\xa9\n\xd1\xe8\xdc\xc5\x120\x81\xd0\x13\x13P\x1d\x11\xf70Y",
            )
        else:
            self.assertEqual(
                utils.firmware_hash(),
                b"\xd2\xdb\x90\xa7jV6\xa7\x00N\xc3\xb4\x8eq\xa9U\xe0\xcb\xb2\xcbZo\xd7\xae\x9f\xbe\xf8F\xbc\x16l\x8c",
            )
            self.assertEqual(
                utils.firmware_hash(b"0123456789abcdef"),
                b"\xa0\x93@\x98\xa6\x80\xdb\x07m\xdf~\xe2'E\xf1\x19\xd8\xfd\xa4`\x10H\xf0_\xdbf\xa6N\xdd\xc0\xcf\xed",
            )


if __name__ == "__main__":
    unittest.main()
