# Automatically generated by pb2py
# fmt: off
# isort:skip_file

from trezor import protobuf

from typing import Any, TYPE_CHECKING


def __getattr__(name: str) -> Any:
    try:
        return protobuf.type_for_name(name)
    except ValueError:
        raise AttributeError(name)


if TYPE_CHECKING:
    from typing import TypeGuard
    from trezor.enums import AmountUnit  # noqa: F401
    from trezor.enums import BackupAvailability  # noqa: F401
    from trezor.enums import BackupType  # noqa: F401
    from trezor.enums import BinanceOrderSide  # noqa: F401
    from trezor.enums import BinanceOrderType  # noqa: F401
    from trezor.enums import BinanceTimeInForce  # noqa: F401
    from trezor.enums import BootCommand  # noqa: F401
    from trezor.enums import ButtonRequestType  # noqa: F401
    from trezor.enums import Capability  # noqa: F401
    from trezor.enums import CardanoAddressType  # noqa: F401
    from trezor.enums import CardanoCVoteRegistrationFormat  # noqa: F401
    from trezor.enums import CardanoCertificateType  # noqa: F401
    from trezor.enums import CardanoDRepType  # noqa: F401
    from trezor.enums import CardanoDerivationType  # noqa: F401
    from trezor.enums import CardanoNativeScriptHashDisplayFormat  # noqa: F401
    from trezor.enums import CardanoNativeScriptType  # noqa: F401
    from trezor.enums import CardanoPoolRelayType  # noqa: F401
    from trezor.enums import CardanoTxAuxiliaryDataSupplementType  # noqa: F401
    from trezor.enums import CardanoTxOutputSerializationFormat  # noqa: F401
    from trezor.enums import CardanoTxSigningMode  # noqa: F401
    from trezor.enums import CardanoTxWitnessType  # noqa: F401
    from trezor.enums import DebugButton  # noqa: F401
    from trezor.enums import DebugPhysicalButton  # noqa: F401
    from trezor.enums import DebugSwipeDirection  # noqa: F401
    from trezor.enums import DebugWaitType  # noqa: F401
    from trezor.enums import DecredStakingSpendType  # noqa: F401
    from trezor.enums import DisplayRotation  # noqa: F401
    from trezor.enums import EthereumDataType  # noqa: F401
    from trezor.enums import EthereumDefinitionType  # noqa: F401
    from trezor.enums import FailureType  # noqa: F401
    from trezor.enums import HomescreenFormat  # noqa: F401
    from trezor.enums import InputScriptType  # noqa: F401
    from trezor.enums import MessageType  # noqa: F401
    from trezor.enums import MoneroNetworkType  # noqa: F401
    from trezor.enums import MultisigPubkeysOrder  # noqa: F401
    from trezor.enums import NEMImportanceTransferMode  # noqa: F401
    from trezor.enums import NEMModificationType  # noqa: F401
    from trezor.enums import NEMMosaicLevy  # noqa: F401
    from trezor.enums import NEMSupplyChangeType  # noqa: F401
    from trezor.enums import OutputScriptType  # noqa: F401
    from trezor.enums import PinMatrixRequestType  # noqa: F401
    from trezor.enums import RecoveryDeviceInputMethod  # noqa: F401
    from trezor.enums import RecoveryStatus  # noqa: F401
    from trezor.enums import RecoveryType  # noqa: F401
    from trezor.enums import RequestType  # noqa: F401
    from trezor.enums import SafetyCheckLevel  # noqa: F401
    from trezor.enums import SdProtectOperationType  # noqa: F401
    from trezor.enums import StellarAssetType  # noqa: F401
    from trezor.enums import StellarMemoType  # noqa: F401
    from trezor.enums import StellarSignerType  # noqa: F401
    from trezor.enums import TezosBallotType  # noqa: F401
    from trezor.enums import TezosContractType  # noqa: F401
    from trezor.enums import WordRequestType  # noqa: F401

    class BenchmarkListNames(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BenchmarkListNames"]:
            return isinstance(msg, cls)

    class BenchmarkNames(protobuf.MessageType):
        names: "list[str]"

        def __init__(
            self,
            *,
            names: "list[str] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BenchmarkNames"]:
            return isinstance(msg, cls)

    class BenchmarkRun(protobuf.MessageType):
        name: "str | None"

        def __init__(
            self,
            *,
            name: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BenchmarkRun"]:
            return isinstance(msg, cls)

    class BenchmarkResult(protobuf.MessageType):
        value: "str | None"
        unit: "str | None"

        def __init__(
            self,
            *,
            value: "str | None" = None,
            unit: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BenchmarkResult"]:
            return isinstance(msg, cls)

    class BinanceGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceGetAddress"]:
            return isinstance(msg, cls)

    class BinanceAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceAddress"]:
            return isinstance(msg, cls)

    class BinanceGetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceGetPublicKey"]:
            return isinstance(msg, cls)

    class BinancePublicKey(protobuf.MessageType):
        public_key: "bytes"

        def __init__(
            self,
            *,
            public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinancePublicKey"]:
            return isinstance(msg, cls)

    class BinanceSignTx(protobuf.MessageType):
        address_n: "list[int]"
        msg_count: "int"
        account_number: "int"
        chain_id: "str | None"
        memo: "str | None"
        sequence: "int"
        source: "int"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            msg_count: "int",
            account_number: "int",
            sequence: "int",
            source: "int",
            address_n: "list[int] | None" = None,
            chain_id: "str | None" = None,
            memo: "str | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceSignTx"]:
            return isinstance(msg, cls)

    class BinanceTxRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceTxRequest"]:
            return isinstance(msg, cls)

    class BinanceTransferMsg(protobuf.MessageType):
        inputs: "list[BinanceInputOutput]"
        outputs: "list[BinanceInputOutput]"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            inputs: "list[BinanceInputOutput] | None" = None,
            outputs: "list[BinanceInputOutput] | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceTransferMsg"]:
            return isinstance(msg, cls)

    class BinanceOrderMsg(protobuf.MessageType):
        id: "str | None"
        ordertype: "BinanceOrderType"
        price: "int"
        quantity: "int"
        sender: "str | None"
        side: "BinanceOrderSide"
        symbol: "str | None"
        timeinforce: "BinanceTimeInForce"

        def __init__(
            self,
            *,
            ordertype: "BinanceOrderType",
            price: "int",
            quantity: "int",
            side: "BinanceOrderSide",
            timeinforce: "BinanceTimeInForce",
            id: "str | None" = None,
            sender: "str | None" = None,
            symbol: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceOrderMsg"]:
            return isinstance(msg, cls)

    class BinanceCancelMsg(protobuf.MessageType):
        refid: "str | None"
        sender: "str | None"
        symbol: "str | None"

        def __init__(
            self,
            *,
            refid: "str | None" = None,
            sender: "str | None" = None,
            symbol: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceCancelMsg"]:
            return isinstance(msg, cls)

    class BinanceSignedTx(protobuf.MessageType):
        signature: "bytes"
        public_key: "bytes"

        def __init__(
            self,
            *,
            signature: "bytes",
            public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceSignedTx"]:
            return isinstance(msg, cls)

    class BinanceInputOutput(protobuf.MessageType):
        address: "str"
        coins: "list[BinanceCoin]"

        def __init__(
            self,
            *,
            address: "str",
            coins: "list[BinanceCoin] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceInputOutput"]:
            return isinstance(msg, cls)

    class BinanceCoin(protobuf.MessageType):
        amount: "int"
        denom: "str"

        def __init__(
            self,
            *,
            amount: "int",
            denom: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BinanceCoin"]:
            return isinstance(msg, cls)

    class Success(protobuf.MessageType):
        message: "str"

        def __init__(
            self,
            *,
            message: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Success"]:
            return isinstance(msg, cls)

    class Failure(protobuf.MessageType):
        code: "FailureType | None"
        message: "str | None"

        def __init__(
            self,
            *,
            code: "FailureType | None" = None,
            message: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Failure"]:
            return isinstance(msg, cls)

    class ButtonRequest(protobuf.MessageType):
        code: "ButtonRequestType | None"
        pages: "int | None"
        name: "str | None"

        def __init__(
            self,
            *,
            code: "ButtonRequestType | None" = None,
            pages: "int | None" = None,
            name: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ButtonRequest"]:
            return isinstance(msg, cls)

    class ButtonAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ButtonAck"]:
            return isinstance(msg, cls)

    class PinMatrixRequest(protobuf.MessageType):
        type: "PinMatrixRequestType | None"

        def __init__(
            self,
            *,
            type: "PinMatrixRequestType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PinMatrixRequest"]:
            return isinstance(msg, cls)

    class PinMatrixAck(protobuf.MessageType):
        pin: "str"

        def __init__(
            self,
            *,
            pin: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PinMatrixAck"]:
            return isinstance(msg, cls)

    class PassphraseRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PassphraseRequest"]:
            return isinstance(msg, cls)

    class PassphraseAck(protobuf.MessageType):
        passphrase: "str | None"
        on_device: "bool | None"

        def __init__(
            self,
            *,
            passphrase: "str | None" = None,
            on_device: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PassphraseAck"]:
            return isinstance(msg, cls)

    class HDNodeType(protobuf.MessageType):
        depth: "int"
        fingerprint: "int"
        child_num: "int"
        chain_code: "bytes"
        private_key: "bytes | None"
        public_key: "bytes"

        def __init__(
            self,
            *,
            depth: "int",
            fingerprint: "int",
            child_num: "int",
            chain_code: "bytes",
            public_key: "bytes",
            private_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["HDNodeType"]:
            return isinstance(msg, cls)

    class MultisigRedeemScriptType(protobuf.MessageType):
        pubkeys: "list[HDNodePathType]"
        signatures: "list[bytes]"
        m: "int"
        nodes: "list[HDNodeType]"
        address_n: "list[int]"
        pubkeys_order: "MultisigPubkeysOrder"

        def __init__(
            self,
            *,
            m: "int",
            pubkeys: "list[HDNodePathType] | None" = None,
            signatures: "list[bytes] | None" = None,
            nodes: "list[HDNodeType] | None" = None,
            address_n: "list[int] | None" = None,
            pubkeys_order: "MultisigPubkeysOrder | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MultisigRedeemScriptType"]:
            return isinstance(msg, cls)

    class GetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        ecdsa_curve_name: "str | None"
        show_display: "bool | None"
        coin_name: "str"
        script_type: "InputScriptType"
        ignore_xpub_magic: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            ecdsa_curve_name: "str | None" = None,
            show_display: "bool | None" = None,
            coin_name: "str | None" = None,
            script_type: "InputScriptType | None" = None,
            ignore_xpub_magic: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetPublicKey"]:
            return isinstance(msg, cls)

    class PublicKey(protobuf.MessageType):
        node: "HDNodeType"
        xpub: "str"
        root_fingerprint: "int | None"
        descriptor: "str | None"

        def __init__(
            self,
            *,
            node: "HDNodeType",
            xpub: "str",
            root_fingerprint: "int | None" = None,
            descriptor: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PublicKey"]:
            return isinstance(msg, cls)

    class GetAddress(protobuf.MessageType):
        address_n: "list[int]"
        coin_name: "str"
        show_display: "bool | None"
        multisig: "MultisigRedeemScriptType | None"
        script_type: "InputScriptType"
        ignore_xpub_magic: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            coin_name: "str | None" = None,
            show_display: "bool | None" = None,
            multisig: "MultisigRedeemScriptType | None" = None,
            script_type: "InputScriptType | None" = None,
            ignore_xpub_magic: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetAddress"]:
            return isinstance(msg, cls)

    class Address(protobuf.MessageType):
        address: "str"
        mac: "bytes | None"

        def __init__(
            self,
            *,
            address: "str",
            mac: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Address"]:
            return isinstance(msg, cls)

    class GetOwnershipId(protobuf.MessageType):
        address_n: "list[int]"
        coin_name: "str"
        multisig: "MultisigRedeemScriptType | None"
        script_type: "InputScriptType"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            coin_name: "str | None" = None,
            multisig: "MultisigRedeemScriptType | None" = None,
            script_type: "InputScriptType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetOwnershipId"]:
            return isinstance(msg, cls)

    class OwnershipId(protobuf.MessageType):
        ownership_id: "bytes"

        def __init__(
            self,
            *,
            ownership_id: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["OwnershipId"]:
            return isinstance(msg, cls)

    class SignMessage(protobuf.MessageType):
        address_n: "list[int]"
        message: "bytes"
        coin_name: "str"
        script_type: "InputScriptType"
        no_script_type: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            message: "bytes",
            address_n: "list[int] | None" = None,
            coin_name: "str | None" = None,
            script_type: "InputScriptType | None" = None,
            no_script_type: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SignMessage"]:
            return isinstance(msg, cls)

    class MessageSignature(protobuf.MessageType):
        address: "str"
        signature: "bytes"

        def __init__(
            self,
            *,
            address: "str",
            signature: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MessageSignature"]:
            return isinstance(msg, cls)

    class VerifyMessage(protobuf.MessageType):
        address: "str"
        signature: "bytes"
        message: "bytes"
        coin_name: "str"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address: "str",
            signature: "bytes",
            message: "bytes",
            coin_name: "str | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["VerifyMessage"]:
            return isinstance(msg, cls)

    class SignTx(protobuf.MessageType):
        outputs_count: "int"
        inputs_count: "int"
        coin_name: "str"
        version: "int"
        lock_time: "int"
        expiry: "int | None"
        version_group_id: "int | None"
        timestamp: "int | None"
        branch_id: "int | None"
        amount_unit: "AmountUnit"
        decred_staking_ticket: "bool"
        serialize: "bool"
        coinjoin_request: "CoinJoinRequest | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            outputs_count: "int",
            inputs_count: "int",
            coin_name: "str | None" = None,
            version: "int | None" = None,
            lock_time: "int | None" = None,
            expiry: "int | None" = None,
            version_group_id: "int | None" = None,
            timestamp: "int | None" = None,
            branch_id: "int | None" = None,
            amount_unit: "AmountUnit | None" = None,
            decred_staking_ticket: "bool | None" = None,
            serialize: "bool | None" = None,
            coinjoin_request: "CoinJoinRequest | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SignTx"]:
            return isinstance(msg, cls)

    class TxRequest(protobuf.MessageType):
        request_type: "RequestType | None"
        details: "TxRequestDetailsType | None"
        serialized: "TxRequestSerializedType | None"

        def __init__(
            self,
            *,
            request_type: "RequestType | None" = None,
            details: "TxRequestDetailsType | None" = None,
            serialized: "TxRequestSerializedType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxRequest"]:
            return isinstance(msg, cls)

    class TxInput(protobuf.MessageType):
        address_n: "list[int]"
        prev_hash: "bytes"
        prev_index: "int"
        script_sig: "bytes | None"
        sequence: "int"
        script_type: "InputScriptType"
        multisig: "MultisigRedeemScriptType | None"
        amount: "int"
        decred_tree: "int | None"
        witness: "bytes | None"
        ownership_proof: "bytes | None"
        commitment_data: "bytes | None"
        orig_hash: "bytes | None"
        orig_index: "int | None"
        decred_staking_spend: "DecredStakingSpendType | None"
        script_pubkey: "bytes | None"
        coinjoin_flags: "int"

        def __init__(
            self,
            *,
            prev_hash: "bytes",
            prev_index: "int",
            amount: "int",
            address_n: "list[int] | None" = None,
            script_sig: "bytes | None" = None,
            sequence: "int | None" = None,
            script_type: "InputScriptType | None" = None,
            multisig: "MultisigRedeemScriptType | None" = None,
            decred_tree: "int | None" = None,
            witness: "bytes | None" = None,
            ownership_proof: "bytes | None" = None,
            commitment_data: "bytes | None" = None,
            orig_hash: "bytes | None" = None,
            orig_index: "int | None" = None,
            decred_staking_spend: "DecredStakingSpendType | None" = None,
            script_pubkey: "bytes | None" = None,
            coinjoin_flags: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxInput"]:
            return isinstance(msg, cls)

    class TxOutput(protobuf.MessageType):
        address: "str | None"
        address_n: "list[int]"
        amount: "int"
        script_type: "OutputScriptType"
        multisig: "MultisigRedeemScriptType | None"
        op_return_data: "bytes | None"
        orig_hash: "bytes | None"
        orig_index: "int | None"
        payment_req_index: "int | None"

        def __init__(
            self,
            *,
            amount: "int",
            address_n: "list[int] | None" = None,
            address: "str | None" = None,
            script_type: "OutputScriptType | None" = None,
            multisig: "MultisigRedeemScriptType | None" = None,
            op_return_data: "bytes | None" = None,
            orig_hash: "bytes | None" = None,
            orig_index: "int | None" = None,
            payment_req_index: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxOutput"]:
            return isinstance(msg, cls)

    class PrevTx(protobuf.MessageType):
        version: "int"
        lock_time: "int"
        inputs_count: "int"
        outputs_count: "int"
        extra_data_len: "int"
        expiry: "int | None"
        version_group_id: "int | None"
        timestamp: "int | None"
        branch_id: "int | None"

        def __init__(
            self,
            *,
            version: "int",
            lock_time: "int",
            inputs_count: "int",
            outputs_count: "int",
            extra_data_len: "int | None" = None,
            expiry: "int | None" = None,
            version_group_id: "int | None" = None,
            timestamp: "int | None" = None,
            branch_id: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PrevTx"]:
            return isinstance(msg, cls)

    class PrevInput(protobuf.MessageType):
        prev_hash: "bytes"
        prev_index: "int"
        script_sig: "bytes"
        sequence: "int"
        decred_tree: "int | None"

        def __init__(
            self,
            *,
            prev_hash: "bytes",
            prev_index: "int",
            script_sig: "bytes",
            sequence: "int",
            decred_tree: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PrevInput"]:
            return isinstance(msg, cls)

    class PrevOutput(protobuf.MessageType):
        amount: "int"
        script_pubkey: "bytes"
        decred_script_version: "int | None"

        def __init__(
            self,
            *,
            amount: "int",
            script_pubkey: "bytes",
            decred_script_version: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PrevOutput"]:
            return isinstance(msg, cls)

    class TxAckPaymentRequest(protobuf.MessageType):
        nonce: "bytes | None"
        recipient_name: "str"
        memos: "list[PaymentRequestMemo]"
        amount: "int | None"
        signature: "bytes"

        def __init__(
            self,
            *,
            recipient_name: "str",
            signature: "bytes",
            memos: "list[PaymentRequestMemo] | None" = None,
            nonce: "bytes | None" = None,
            amount: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPaymentRequest"]:
            return isinstance(msg, cls)

    class TxAckInput(protobuf.MessageType):
        tx: "TxAckInputWrapper"

        def __init__(
            self,
            *,
            tx: "TxAckInputWrapper",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckInput"]:
            return isinstance(msg, cls)

    class TxAckOutput(protobuf.MessageType):
        tx: "TxAckOutputWrapper"

        def __init__(
            self,
            *,
            tx: "TxAckOutputWrapper",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckOutput"]:
            return isinstance(msg, cls)

    class TxAckPrevMeta(protobuf.MessageType):
        tx: "PrevTx"

        def __init__(
            self,
            *,
            tx: "PrevTx",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevMeta"]:
            return isinstance(msg, cls)

    class TxAckPrevInput(protobuf.MessageType):
        tx: "TxAckPrevInputWrapper"

        def __init__(
            self,
            *,
            tx: "TxAckPrevInputWrapper",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevInput"]:
            return isinstance(msg, cls)

    class TxAckPrevOutput(protobuf.MessageType):
        tx: "TxAckPrevOutputWrapper"

        def __init__(
            self,
            *,
            tx: "TxAckPrevOutputWrapper",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevOutput"]:
            return isinstance(msg, cls)

    class TxAckPrevExtraData(protobuf.MessageType):
        tx: "TxAckPrevExtraDataWrapper"

        def __init__(
            self,
            *,
            tx: "TxAckPrevExtraDataWrapper",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevExtraData"]:
            return isinstance(msg, cls)

    class GetOwnershipProof(protobuf.MessageType):
        address_n: "list[int]"
        coin_name: "str"
        script_type: "InputScriptType"
        multisig: "MultisigRedeemScriptType | None"
        user_confirmation: "bool"
        ownership_ids: "list[bytes]"
        commitment_data: "bytes"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            ownership_ids: "list[bytes] | None" = None,
            coin_name: "str | None" = None,
            script_type: "InputScriptType | None" = None,
            multisig: "MultisigRedeemScriptType | None" = None,
            user_confirmation: "bool | None" = None,
            commitment_data: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetOwnershipProof"]:
            return isinstance(msg, cls)

    class OwnershipProof(protobuf.MessageType):
        ownership_proof: "bytes"
        signature: "bytes"

        def __init__(
            self,
            *,
            ownership_proof: "bytes",
            signature: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["OwnershipProof"]:
            return isinstance(msg, cls)

    class AuthorizeCoinJoin(protobuf.MessageType):
        coordinator: "str"
        max_rounds: "int"
        max_coordinator_fee_rate: "int"
        max_fee_per_kvbyte: "int"
        address_n: "list[int]"
        coin_name: "str"
        script_type: "InputScriptType"
        amount_unit: "AmountUnit"

        def __init__(
            self,
            *,
            coordinator: "str",
            max_rounds: "int",
            max_coordinator_fee_rate: "int",
            max_fee_per_kvbyte: "int",
            address_n: "list[int] | None" = None,
            coin_name: "str | None" = None,
            script_type: "InputScriptType | None" = None,
            amount_unit: "AmountUnit | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["AuthorizeCoinJoin"]:
            return isinstance(msg, cls)

    class HDNodePathType(protobuf.MessageType):
        node: "HDNodeType"
        address_n: "list[int]"

        def __init__(
            self,
            *,
            node: "HDNodeType",
            address_n: "list[int] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["HDNodePathType"]:
            return isinstance(msg, cls)

    class CoinJoinRequest(protobuf.MessageType):
        fee_rate: "int"
        no_fee_threshold: "int"
        min_registrable_amount: "int"
        mask_public_key: "bytes | None"
        signature: "bytes | None"

        def __init__(
            self,
            *,
            fee_rate: "int",
            no_fee_threshold: "int",
            min_registrable_amount: "int",
            mask_public_key: "bytes | None" = None,
            signature: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CoinJoinRequest"]:
            return isinstance(msg, cls)

    class TxRequestDetailsType(protobuf.MessageType):
        request_index: "int | None"
        tx_hash: "bytes | None"
        extra_data_len: "int | None"
        extra_data_offset: "int | None"

        def __init__(
            self,
            *,
            request_index: "int | None" = None,
            tx_hash: "bytes | None" = None,
            extra_data_len: "int | None" = None,
            extra_data_offset: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxRequestDetailsType"]:
            return isinstance(msg, cls)

    class TxRequestSerializedType(protobuf.MessageType):
        signature_index: "int | None"
        signature: "bytes | None"
        serialized_tx: "bytes | None"

        def __init__(
            self,
            *,
            signature_index: "int | None" = None,
            signature: "bytes | None" = None,
            serialized_tx: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxRequestSerializedType"]:
            return isinstance(msg, cls)

    class PaymentRequestMemo(protobuf.MessageType):
        text_memo: "TextMemo | None"
        refund_memo: "RefundMemo | None"
        coin_purchase_memo: "CoinPurchaseMemo | None"

        def __init__(
            self,
            *,
            text_memo: "TextMemo | None" = None,
            refund_memo: "RefundMemo | None" = None,
            coin_purchase_memo: "CoinPurchaseMemo | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PaymentRequestMemo"]:
            return isinstance(msg, cls)

    class TextMemo(protobuf.MessageType):
        text: "str"

        def __init__(
            self,
            *,
            text: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TextMemo"]:
            return isinstance(msg, cls)

    class RefundMemo(protobuf.MessageType):
        address: "str"
        mac: "bytes"

        def __init__(
            self,
            *,
            address: "str",
            mac: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RefundMemo"]:
            return isinstance(msg, cls)

    class CoinPurchaseMemo(protobuf.MessageType):
        coin_type: "int"
        amount: "str"
        address: "str"
        mac: "bytes"

        def __init__(
            self,
            *,
            coin_type: "int",
            amount: "str",
            address: "str",
            mac: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CoinPurchaseMemo"]:
            return isinstance(msg, cls)

    class TxAckInputWrapper(protobuf.MessageType):
        input: "TxInput"

        def __init__(
            self,
            *,
            input: "TxInput",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckInputWrapper"]:
            return isinstance(msg, cls)

    class TxAckOutputWrapper(protobuf.MessageType):
        output: "TxOutput"

        def __init__(
            self,
            *,
            output: "TxOutput",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckOutputWrapper"]:
            return isinstance(msg, cls)

    class TxAckPrevInputWrapper(protobuf.MessageType):
        input: "PrevInput"

        def __init__(
            self,
            *,
            input: "PrevInput",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevInputWrapper"]:
            return isinstance(msg, cls)

    class TxAckPrevOutputWrapper(protobuf.MessageType):
        output: "PrevOutput"

        def __init__(
            self,
            *,
            output: "PrevOutput",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevOutputWrapper"]:
            return isinstance(msg, cls)

    class TxAckPrevExtraDataWrapper(protobuf.MessageType):
        extra_data_chunk: "bytes"

        def __init__(
            self,
            *,
            extra_data_chunk: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TxAckPrevExtraDataWrapper"]:
            return isinstance(msg, cls)

    class CardanoBlockchainPointerType(protobuf.MessageType):
        block_index: "int"
        tx_index: "int"
        certificate_index: "int"

        def __init__(
            self,
            *,
            block_index: "int",
            tx_index: "int",
            certificate_index: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoBlockchainPointerType"]:
            return isinstance(msg, cls)

    class CardanoNativeScript(protobuf.MessageType):
        type: "CardanoNativeScriptType"
        scripts: "list[CardanoNativeScript]"
        key_hash: "bytes | None"
        key_path: "list[int]"
        required_signatures_count: "int | None"
        invalid_before: "int | None"
        invalid_hereafter: "int | None"

        def __init__(
            self,
            *,
            type: "CardanoNativeScriptType",
            scripts: "list[CardanoNativeScript] | None" = None,
            key_path: "list[int] | None" = None,
            key_hash: "bytes | None" = None,
            required_signatures_count: "int | None" = None,
            invalid_before: "int | None" = None,
            invalid_hereafter: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoNativeScript"]:
            return isinstance(msg, cls)

    class CardanoGetNativeScriptHash(protobuf.MessageType):
        script: "CardanoNativeScript"
        display_format: "CardanoNativeScriptHashDisplayFormat"
        derivation_type: "CardanoDerivationType"

        def __init__(
            self,
            *,
            script: "CardanoNativeScript",
            display_format: "CardanoNativeScriptHashDisplayFormat",
            derivation_type: "CardanoDerivationType",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoGetNativeScriptHash"]:
            return isinstance(msg, cls)

    class CardanoNativeScriptHash(protobuf.MessageType):
        script_hash: "bytes"

        def __init__(
            self,
            *,
            script_hash: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoNativeScriptHash"]:
            return isinstance(msg, cls)

    class CardanoAddressParametersType(protobuf.MessageType):
        address_type: "CardanoAddressType"
        address_n: "list[int]"
        address_n_staking: "list[int]"
        staking_key_hash: "bytes | None"
        certificate_pointer: "CardanoBlockchainPointerType | None"
        script_payment_hash: "bytes | None"
        script_staking_hash: "bytes | None"

        def __init__(
            self,
            *,
            address_type: "CardanoAddressType",
            address_n: "list[int] | None" = None,
            address_n_staking: "list[int] | None" = None,
            staking_key_hash: "bytes | None" = None,
            certificate_pointer: "CardanoBlockchainPointerType | None" = None,
            script_payment_hash: "bytes | None" = None,
            script_staking_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoAddressParametersType"]:
            return isinstance(msg, cls)

    class CardanoGetAddress(protobuf.MessageType):
        show_display: "bool"
        protocol_magic: "int"
        network_id: "int"
        address_parameters: "CardanoAddressParametersType"
        derivation_type: "CardanoDerivationType"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            protocol_magic: "int",
            network_id: "int",
            address_parameters: "CardanoAddressParametersType",
            derivation_type: "CardanoDerivationType",
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoGetAddress"]:
            return isinstance(msg, cls)

    class CardanoAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoAddress"]:
            return isinstance(msg, cls)

    class CardanoGetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        derivation_type: "CardanoDerivationType"

        def __init__(
            self,
            *,
            derivation_type: "CardanoDerivationType",
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoGetPublicKey"]:
            return isinstance(msg, cls)

    class CardanoPublicKey(protobuf.MessageType):
        xpub: "str"
        node: "HDNodeType"

        def __init__(
            self,
            *,
            xpub: "str",
            node: "HDNodeType",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoPublicKey"]:
            return isinstance(msg, cls)

    class CardanoSignTxInit(protobuf.MessageType):
        signing_mode: "CardanoTxSigningMode"
        protocol_magic: "int"
        network_id: "int"
        inputs_count: "int"
        outputs_count: "int"
        fee: "int"
        ttl: "int | None"
        certificates_count: "int"
        withdrawals_count: "int"
        has_auxiliary_data: "bool"
        validity_interval_start: "int | None"
        witness_requests_count: "int"
        minting_asset_groups_count: "int"
        derivation_type: "CardanoDerivationType"
        include_network_id: "bool"
        script_data_hash: "bytes | None"
        collateral_inputs_count: "int"
        required_signers_count: "int"
        has_collateral_return: "bool"
        total_collateral: "int | None"
        reference_inputs_count: "int"
        chunkify: "bool | None"
        tag_cbor_sets: "bool"

        def __init__(
            self,
            *,
            signing_mode: "CardanoTxSigningMode",
            protocol_magic: "int",
            network_id: "int",
            inputs_count: "int",
            outputs_count: "int",
            fee: "int",
            certificates_count: "int",
            withdrawals_count: "int",
            has_auxiliary_data: "bool",
            witness_requests_count: "int",
            minting_asset_groups_count: "int",
            derivation_type: "CardanoDerivationType",
            collateral_inputs_count: "int",
            required_signers_count: "int",
            ttl: "int | None" = None,
            validity_interval_start: "int | None" = None,
            include_network_id: "bool | None" = None,
            script_data_hash: "bytes | None" = None,
            has_collateral_return: "bool | None" = None,
            total_collateral: "int | None" = None,
            reference_inputs_count: "int | None" = None,
            chunkify: "bool | None" = None,
            tag_cbor_sets: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoSignTxInit"]:
            return isinstance(msg, cls)

    class CardanoTxInput(protobuf.MessageType):
        prev_hash: "bytes"
        prev_index: "int"

        def __init__(
            self,
            *,
            prev_hash: "bytes",
            prev_index: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxInput"]:
            return isinstance(msg, cls)

    class CardanoTxOutput(protobuf.MessageType):
        address: "str | None"
        address_parameters: "CardanoAddressParametersType | None"
        amount: "int"
        asset_groups_count: "int"
        datum_hash: "bytes | None"
        format: "CardanoTxOutputSerializationFormat"
        inline_datum_size: "int"
        reference_script_size: "int"

        def __init__(
            self,
            *,
            amount: "int",
            asset_groups_count: "int",
            address: "str | None" = None,
            address_parameters: "CardanoAddressParametersType | None" = None,
            datum_hash: "bytes | None" = None,
            format: "CardanoTxOutputSerializationFormat | None" = None,
            inline_datum_size: "int | None" = None,
            reference_script_size: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxOutput"]:
            return isinstance(msg, cls)

    class CardanoAssetGroup(protobuf.MessageType):
        policy_id: "bytes"
        tokens_count: "int"

        def __init__(
            self,
            *,
            policy_id: "bytes",
            tokens_count: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoAssetGroup"]:
            return isinstance(msg, cls)

    class CardanoToken(protobuf.MessageType):
        asset_name_bytes: "bytes"
        amount: "int | None"
        mint_amount: "int | None"

        def __init__(
            self,
            *,
            asset_name_bytes: "bytes",
            amount: "int | None" = None,
            mint_amount: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoToken"]:
            return isinstance(msg, cls)

    class CardanoTxInlineDatumChunk(protobuf.MessageType):
        data: "bytes"

        def __init__(
            self,
            *,
            data: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxInlineDatumChunk"]:
            return isinstance(msg, cls)

    class CardanoTxReferenceScriptChunk(protobuf.MessageType):
        data: "bytes"

        def __init__(
            self,
            *,
            data: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxReferenceScriptChunk"]:
            return isinstance(msg, cls)

    class CardanoPoolOwner(protobuf.MessageType):
        staking_key_path: "list[int]"
        staking_key_hash: "bytes | None"

        def __init__(
            self,
            *,
            staking_key_path: "list[int] | None" = None,
            staking_key_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoPoolOwner"]:
            return isinstance(msg, cls)

    class CardanoPoolRelayParameters(protobuf.MessageType):
        type: "CardanoPoolRelayType"
        ipv4_address: "bytes | None"
        ipv6_address: "bytes | None"
        host_name: "str | None"
        port: "int | None"

        def __init__(
            self,
            *,
            type: "CardanoPoolRelayType",
            ipv4_address: "bytes | None" = None,
            ipv6_address: "bytes | None" = None,
            host_name: "str | None" = None,
            port: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoPoolRelayParameters"]:
            return isinstance(msg, cls)

    class CardanoPoolMetadataType(protobuf.MessageType):
        url: "str"
        hash: "bytes"

        def __init__(
            self,
            *,
            url: "str",
            hash: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoPoolMetadataType"]:
            return isinstance(msg, cls)

    class CardanoPoolParametersType(protobuf.MessageType):
        pool_id: "bytes"
        vrf_key_hash: "bytes"
        pledge: "int"
        cost: "int"
        margin_numerator: "int"
        margin_denominator: "int"
        reward_account: "str"
        metadata: "CardanoPoolMetadataType | None"
        owners_count: "int"
        relays_count: "int"

        def __init__(
            self,
            *,
            pool_id: "bytes",
            vrf_key_hash: "bytes",
            pledge: "int",
            cost: "int",
            margin_numerator: "int",
            margin_denominator: "int",
            reward_account: "str",
            owners_count: "int",
            relays_count: "int",
            metadata: "CardanoPoolMetadataType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoPoolParametersType"]:
            return isinstance(msg, cls)

    class CardanoDRep(protobuf.MessageType):
        type: "CardanoDRepType"
        key_hash: "bytes | None"
        script_hash: "bytes | None"

        def __init__(
            self,
            *,
            type: "CardanoDRepType",
            key_hash: "bytes | None" = None,
            script_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoDRep"]:
            return isinstance(msg, cls)

    class CardanoTxCertificate(protobuf.MessageType):
        type: "CardanoCertificateType"
        path: "list[int]"
        pool: "bytes | None"
        pool_parameters: "CardanoPoolParametersType | None"
        script_hash: "bytes | None"
        key_hash: "bytes | None"
        deposit: "int | None"
        drep: "CardanoDRep | None"

        def __init__(
            self,
            *,
            type: "CardanoCertificateType",
            path: "list[int] | None" = None,
            pool: "bytes | None" = None,
            pool_parameters: "CardanoPoolParametersType | None" = None,
            script_hash: "bytes | None" = None,
            key_hash: "bytes | None" = None,
            deposit: "int | None" = None,
            drep: "CardanoDRep | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxCertificate"]:
            return isinstance(msg, cls)

    class CardanoTxWithdrawal(protobuf.MessageType):
        path: "list[int]"
        amount: "int"
        script_hash: "bytes | None"
        key_hash: "bytes | None"

        def __init__(
            self,
            *,
            amount: "int",
            path: "list[int] | None" = None,
            script_hash: "bytes | None" = None,
            key_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxWithdrawal"]:
            return isinstance(msg, cls)

    class CardanoCVoteRegistrationDelegation(protobuf.MessageType):
        vote_public_key: "bytes"
        weight: "int"

        def __init__(
            self,
            *,
            vote_public_key: "bytes",
            weight: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoCVoteRegistrationDelegation"]:
            return isinstance(msg, cls)

    class CardanoCVoteRegistrationParametersType(protobuf.MessageType):
        vote_public_key: "bytes | None"
        staking_path: "list[int]"
        payment_address_parameters: "CardanoAddressParametersType | None"
        nonce: "int"
        format: "CardanoCVoteRegistrationFormat"
        delegations: "list[CardanoCVoteRegistrationDelegation]"
        voting_purpose: "int | None"
        payment_address: "str | None"

        def __init__(
            self,
            *,
            nonce: "int",
            staking_path: "list[int] | None" = None,
            delegations: "list[CardanoCVoteRegistrationDelegation] | None" = None,
            vote_public_key: "bytes | None" = None,
            payment_address_parameters: "CardanoAddressParametersType | None" = None,
            format: "CardanoCVoteRegistrationFormat | None" = None,
            voting_purpose: "int | None" = None,
            payment_address: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoCVoteRegistrationParametersType"]:
            return isinstance(msg, cls)

    class CardanoTxAuxiliaryData(protobuf.MessageType):
        cvote_registration_parameters: "CardanoCVoteRegistrationParametersType | None"
        hash: "bytes | None"

        def __init__(
            self,
            *,
            cvote_registration_parameters: "CardanoCVoteRegistrationParametersType | None" = None,
            hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxAuxiliaryData"]:
            return isinstance(msg, cls)

    class CardanoTxMint(protobuf.MessageType):
        asset_groups_count: "int"

        def __init__(
            self,
            *,
            asset_groups_count: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxMint"]:
            return isinstance(msg, cls)

    class CardanoTxCollateralInput(protobuf.MessageType):
        prev_hash: "bytes"
        prev_index: "int"

        def __init__(
            self,
            *,
            prev_hash: "bytes",
            prev_index: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxCollateralInput"]:
            return isinstance(msg, cls)

    class CardanoTxRequiredSigner(protobuf.MessageType):
        key_hash: "bytes | None"
        key_path: "list[int]"

        def __init__(
            self,
            *,
            key_path: "list[int] | None" = None,
            key_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxRequiredSigner"]:
            return isinstance(msg, cls)

    class CardanoTxReferenceInput(protobuf.MessageType):
        prev_hash: "bytes"
        prev_index: "int"

        def __init__(
            self,
            *,
            prev_hash: "bytes",
            prev_index: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxReferenceInput"]:
            return isinstance(msg, cls)

    class CardanoTxItemAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxItemAck"]:
            return isinstance(msg, cls)

    class CardanoTxAuxiliaryDataSupplement(protobuf.MessageType):
        type: "CardanoTxAuxiliaryDataSupplementType"
        auxiliary_data_hash: "bytes | None"
        cvote_registration_signature: "bytes | None"

        def __init__(
            self,
            *,
            type: "CardanoTxAuxiliaryDataSupplementType",
            auxiliary_data_hash: "bytes | None" = None,
            cvote_registration_signature: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxAuxiliaryDataSupplement"]:
            return isinstance(msg, cls)

    class CardanoTxWitnessRequest(protobuf.MessageType):
        path: "list[int]"

        def __init__(
            self,
            *,
            path: "list[int] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxWitnessRequest"]:
            return isinstance(msg, cls)

    class CardanoTxWitnessResponse(protobuf.MessageType):
        type: "CardanoTxWitnessType"
        pub_key: "bytes"
        signature: "bytes"
        chain_code: "bytes | None"

        def __init__(
            self,
            *,
            type: "CardanoTxWitnessType",
            pub_key: "bytes",
            signature: "bytes",
            chain_code: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxWitnessResponse"]:
            return isinstance(msg, cls)

    class CardanoTxHostAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxHostAck"]:
            return isinstance(msg, cls)

    class CardanoTxBodyHash(protobuf.MessageType):
        tx_hash: "bytes"

        def __init__(
            self,
            *,
            tx_hash: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoTxBodyHash"]:
            return isinstance(msg, cls)

    class CardanoSignTxFinished(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CardanoSignTxFinished"]:
            return isinstance(msg, cls)

    class CipherKeyValue(protobuf.MessageType):
        address_n: "list[int]"
        key: "str"
        value: "bytes"
        encrypt: "bool | None"
        ask_on_encrypt: "bool | None"
        ask_on_decrypt: "bool | None"
        iv: "bytes | None"

        def __init__(
            self,
            *,
            key: "str",
            value: "bytes",
            address_n: "list[int] | None" = None,
            encrypt: "bool | None" = None,
            ask_on_encrypt: "bool | None" = None,
            ask_on_decrypt: "bool | None" = None,
            iv: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CipherKeyValue"]:
            return isinstance(msg, cls)

    class CipheredKeyValue(protobuf.MessageType):
        value: "bytes"

        def __init__(
            self,
            *,
            value: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CipheredKeyValue"]:
            return isinstance(msg, cls)

    class IdentityType(protobuf.MessageType):
        proto: "str | None"
        user: "str | None"
        host: "str | None"
        port: "str | None"
        path: "str | None"
        index: "int"

        def __init__(
            self,
            *,
            proto: "str | None" = None,
            user: "str | None" = None,
            host: "str | None" = None,
            port: "str | None" = None,
            path: "str | None" = None,
            index: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["IdentityType"]:
            return isinstance(msg, cls)

    class SignIdentity(protobuf.MessageType):
        identity: "IdentityType"
        challenge_hidden: "bytes"
        challenge_visual: "str"
        ecdsa_curve_name: "str | None"

        def __init__(
            self,
            *,
            identity: "IdentityType",
            challenge_hidden: "bytes | None" = None,
            challenge_visual: "str | None" = None,
            ecdsa_curve_name: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SignIdentity"]:
            return isinstance(msg, cls)

    class SignedIdentity(protobuf.MessageType):
        address: "str | None"
        public_key: "bytes"
        signature: "bytes"

        def __init__(
            self,
            *,
            public_key: "bytes",
            signature: "bytes",
            address: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SignedIdentity"]:
            return isinstance(msg, cls)

    class GetECDHSessionKey(protobuf.MessageType):
        identity: "IdentityType"
        peer_public_key: "bytes"
        ecdsa_curve_name: "str | None"

        def __init__(
            self,
            *,
            identity: "IdentityType",
            peer_public_key: "bytes",
            ecdsa_curve_name: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetECDHSessionKey"]:
            return isinstance(msg, cls)

    class ECDHSessionKey(protobuf.MessageType):
        session_key: "bytes"
        public_key: "bytes | None"

        def __init__(
            self,
            *,
            session_key: "bytes",
            public_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ECDHSessionKey"]:
            return isinstance(msg, cls)

    class Initialize(protobuf.MessageType):
        session_id: "bytes | None"
        derive_cardano: "bool | None"

        def __init__(
            self,
            *,
            session_id: "bytes | None" = None,
            derive_cardano: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Initialize"]:
            return isinstance(msg, cls)

    class GetFeatures(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetFeatures"]:
            return isinstance(msg, cls)

    class Features(protobuf.MessageType):
        vendor: "str | None"
        major_version: "int"
        minor_version: "int"
        patch_version: "int"
        bootloader_mode: "bool | None"
        device_id: "str | None"
        pin_protection: "bool | None"
        passphrase_protection: "bool | None"
        language: "str | None"
        label: "str | None"
        initialized: "bool | None"
        revision: "bytes | None"
        bootloader_hash: "bytes | None"
        imported: "bool | None"
        unlocked: "bool | None"
        firmware_present: "bool | None"
        backup_availability: "BackupAvailability | None"
        flags: "int | None"
        model: "str | None"
        fw_major: "int | None"
        fw_minor: "int | None"
        fw_patch: "int | None"
        fw_vendor: "str | None"
        unfinished_backup: "bool | None"
        no_backup: "bool | None"
        recovery_status: "RecoveryStatus | None"
        capabilities: "list[Capability]"
        backup_type: "BackupType | None"
        sd_card_present: "bool | None"
        sd_protection: "bool | None"
        wipe_code_protection: "bool | None"
        session_id: "bytes | None"
        passphrase_always_on_device: "bool | None"
        safety_checks: "SafetyCheckLevel | None"
        auto_lock_delay_ms: "int | None"
        display_rotation: "DisplayRotation | None"
        experimental_features: "bool | None"
        busy: "bool | None"
        homescreen_format: "HomescreenFormat | None"
        hide_passphrase_from_host: "bool | None"
        internal_model: "str | None"
        unit_color: "int | None"
        unit_btconly: "bool | None"
        homescreen_width: "int | None"
        homescreen_height: "int | None"
        bootloader_locked: "bool | None"
        language_version_matches: "bool"
        unit_packaging: "int | None"
        haptic_feedback: "bool | None"
        recovery_type: "RecoveryType | None"
        optiga_sec: "int | None"

        def __init__(
            self,
            *,
            major_version: "int",
            minor_version: "int",
            patch_version: "int",
            capabilities: "list[Capability] | None" = None,
            vendor: "str | None" = None,
            bootloader_mode: "bool | None" = None,
            device_id: "str | None" = None,
            pin_protection: "bool | None" = None,
            passphrase_protection: "bool | None" = None,
            language: "str | None" = None,
            label: "str | None" = None,
            initialized: "bool | None" = None,
            revision: "bytes | None" = None,
            bootloader_hash: "bytes | None" = None,
            imported: "bool | None" = None,
            unlocked: "bool | None" = None,
            firmware_present: "bool | None" = None,
            backup_availability: "BackupAvailability | None" = None,
            flags: "int | None" = None,
            model: "str | None" = None,
            fw_major: "int | None" = None,
            fw_minor: "int | None" = None,
            fw_patch: "int | None" = None,
            fw_vendor: "str | None" = None,
            unfinished_backup: "bool | None" = None,
            no_backup: "bool | None" = None,
            recovery_status: "RecoveryStatus | None" = None,
            backup_type: "BackupType | None" = None,
            sd_card_present: "bool | None" = None,
            sd_protection: "bool | None" = None,
            wipe_code_protection: "bool | None" = None,
            session_id: "bytes | None" = None,
            passphrase_always_on_device: "bool | None" = None,
            safety_checks: "SafetyCheckLevel | None" = None,
            auto_lock_delay_ms: "int | None" = None,
            display_rotation: "DisplayRotation | None" = None,
            experimental_features: "bool | None" = None,
            busy: "bool | None" = None,
            homescreen_format: "HomescreenFormat | None" = None,
            hide_passphrase_from_host: "bool | None" = None,
            internal_model: "str | None" = None,
            unit_color: "int | None" = None,
            unit_btconly: "bool | None" = None,
            homescreen_width: "int | None" = None,
            homescreen_height: "int | None" = None,
            bootloader_locked: "bool | None" = None,
            language_version_matches: "bool | None" = None,
            unit_packaging: "int | None" = None,
            haptic_feedback: "bool | None" = None,
            recovery_type: "RecoveryType | None" = None,
            optiga_sec: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Features"]:
            return isinstance(msg, cls)

    class LockDevice(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["LockDevice"]:
            return isinstance(msg, cls)

    class SetBusy(protobuf.MessageType):
        expiry_ms: "int | None"

        def __init__(
            self,
            *,
            expiry_ms: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SetBusy"]:
            return isinstance(msg, cls)

    class EndSession(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EndSession"]:
            return isinstance(msg, cls)

    class ApplySettings(protobuf.MessageType):
        label: "str | None"
        use_passphrase: "bool | None"
        homescreen: "bytes | None"
        auto_lock_delay_ms: "int | None"
        display_rotation: "DisplayRotation | None"
        passphrase_always_on_device: "bool | None"
        safety_checks: "SafetyCheckLevel | None"
        experimental_features: "bool | None"
        hide_passphrase_from_host: "bool | None"
        haptic_feedback: "bool | None"

        def __init__(
            self,
            *,
            label: "str | None" = None,
            use_passphrase: "bool | None" = None,
            homescreen: "bytes | None" = None,
            auto_lock_delay_ms: "int | None" = None,
            display_rotation: "DisplayRotation | None" = None,
            passphrase_always_on_device: "bool | None" = None,
            safety_checks: "SafetyCheckLevel | None" = None,
            experimental_features: "bool | None" = None,
            hide_passphrase_from_host: "bool | None" = None,
            haptic_feedback: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ApplySettings"]:
            return isinstance(msg, cls)

    class ChangeLanguage(protobuf.MessageType):
        data_length: "int"
        show_display: "bool | None"

        def __init__(
            self,
            *,
            data_length: "int",
            show_display: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ChangeLanguage"]:
            return isinstance(msg, cls)

    class TranslationDataRequest(protobuf.MessageType):
        data_length: "int"
        data_offset: "int"

        def __init__(
            self,
            *,
            data_length: "int",
            data_offset: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TranslationDataRequest"]:
            return isinstance(msg, cls)

    class TranslationDataAck(protobuf.MessageType):
        data_chunk: "bytes"

        def __init__(
            self,
            *,
            data_chunk: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TranslationDataAck"]:
            return isinstance(msg, cls)

    class ApplyFlags(protobuf.MessageType):
        flags: "int"

        def __init__(
            self,
            *,
            flags: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ApplyFlags"]:
            return isinstance(msg, cls)

    class ChangePin(protobuf.MessageType):
        remove: "bool | None"

        def __init__(
            self,
            *,
            remove: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ChangePin"]:
            return isinstance(msg, cls)

    class ChangeWipeCode(protobuf.MessageType):
        remove: "bool | None"

        def __init__(
            self,
            *,
            remove: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ChangeWipeCode"]:
            return isinstance(msg, cls)

    class SdProtect(protobuf.MessageType):
        operation: "SdProtectOperationType"

        def __init__(
            self,
            *,
            operation: "SdProtectOperationType",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SdProtect"]:
            return isinstance(msg, cls)

    class Ping(protobuf.MessageType):
        message: "str"
        button_protection: "bool | None"

        def __init__(
            self,
            *,
            message: "str | None" = None,
            button_protection: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Ping"]:
            return isinstance(msg, cls)

    class Cancel(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Cancel"]:
            return isinstance(msg, cls)

    class GetEntropy(protobuf.MessageType):
        size: "int"

        def __init__(
            self,
            *,
            size: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetEntropy"]:
            return isinstance(msg, cls)

    class Entropy(protobuf.MessageType):
        entropy: "bytes"

        def __init__(
            self,
            *,
            entropy: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Entropy"]:
            return isinstance(msg, cls)

    class GetFirmwareHash(protobuf.MessageType):
        challenge: "bytes | None"

        def __init__(
            self,
            *,
            challenge: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetFirmwareHash"]:
            return isinstance(msg, cls)

    class FirmwareHash(protobuf.MessageType):
        hash: "bytes"

        def __init__(
            self,
            *,
            hash: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["FirmwareHash"]:
            return isinstance(msg, cls)

    class AuthenticateDevice(protobuf.MessageType):
        challenge: "bytes"

        def __init__(
            self,
            *,
            challenge: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["AuthenticateDevice"]:
            return isinstance(msg, cls)

    class AuthenticityProof(protobuf.MessageType):
        certificates: "list[bytes]"
        signature: "bytes"

        def __init__(
            self,
            *,
            signature: "bytes",
            certificates: "list[bytes] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["AuthenticityProof"]:
            return isinstance(msg, cls)

    class WipeDevice(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WipeDevice"]:
            return isinstance(msg, cls)

    class LoadDevice(protobuf.MessageType):
        mnemonics: "list[str]"
        pin: "str | None"
        passphrase_protection: "bool | None"
        label: "str | None"
        skip_checksum: "bool | None"
        u2f_counter: "int | None"
        needs_backup: "bool | None"
        no_backup: "bool | None"

        def __init__(
            self,
            *,
            mnemonics: "list[str] | None" = None,
            pin: "str | None" = None,
            passphrase_protection: "bool | None" = None,
            label: "str | None" = None,
            skip_checksum: "bool | None" = None,
            u2f_counter: "int | None" = None,
            needs_backup: "bool | None" = None,
            no_backup: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["LoadDevice"]:
            return isinstance(msg, cls)

    class ResetDevice(protobuf.MessageType):
        strength: "int"
        passphrase_protection: "bool | None"
        pin_protection: "bool | None"
        label: "str | None"
        u2f_counter: "int | None"
        skip_backup: "bool | None"
        no_backup: "bool | None"
        backup_type: "BackupType"

        def __init__(
            self,
            *,
            strength: "int | None" = None,
            passphrase_protection: "bool | None" = None,
            pin_protection: "bool | None" = None,
            label: "str | None" = None,
            u2f_counter: "int | None" = None,
            skip_backup: "bool | None" = None,
            no_backup: "bool | None" = None,
            backup_type: "BackupType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ResetDevice"]:
            return isinstance(msg, cls)

    class BackupDevice(protobuf.MessageType):
        group_threshold: "int | None"
        groups: "list[Slip39Group]"

        def __init__(
            self,
            *,
            groups: "list[Slip39Group] | None" = None,
            group_threshold: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["BackupDevice"]:
            return isinstance(msg, cls)

    class EntropyRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EntropyRequest"]:
            return isinstance(msg, cls)

    class EntropyAck(protobuf.MessageType):
        entropy: "bytes"

        def __init__(
            self,
            *,
            entropy: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EntropyAck"]:
            return isinstance(msg, cls)

    class RecoveryDevice(protobuf.MessageType):
        word_count: "int | None"
        passphrase_protection: "bool | None"
        pin_protection: "bool | None"
        label: "str | None"
        enforce_wordlist: "bool | None"
        input_method: "RecoveryDeviceInputMethod | None"
        u2f_counter: "int | None"
        type: "RecoveryType"

        def __init__(
            self,
            *,
            word_count: "int | None" = None,
            passphrase_protection: "bool | None" = None,
            pin_protection: "bool | None" = None,
            label: "str | None" = None,
            enforce_wordlist: "bool | None" = None,
            input_method: "RecoveryDeviceInputMethod | None" = None,
            u2f_counter: "int | None" = None,
            type: "RecoveryType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RecoveryDevice"]:
            return isinstance(msg, cls)

    class WordRequest(protobuf.MessageType):
        type: "WordRequestType"

        def __init__(
            self,
            *,
            type: "WordRequestType",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WordRequest"]:
            return isinstance(msg, cls)

    class WordAck(protobuf.MessageType):
        word: "str"

        def __init__(
            self,
            *,
            word: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WordAck"]:
            return isinstance(msg, cls)

    class SetU2FCounter(protobuf.MessageType):
        u2f_counter: "int"

        def __init__(
            self,
            *,
            u2f_counter: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SetU2FCounter"]:
            return isinstance(msg, cls)

    class GetNextU2FCounter(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetNextU2FCounter"]:
            return isinstance(msg, cls)

    class NextU2FCounter(protobuf.MessageType):
        u2f_counter: "int"

        def __init__(
            self,
            *,
            u2f_counter: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NextU2FCounter"]:
            return isinstance(msg, cls)

    class DoPreauthorized(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DoPreauthorized"]:
            return isinstance(msg, cls)

    class PreauthorizedRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["PreauthorizedRequest"]:
            return isinstance(msg, cls)

    class CancelAuthorization(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["CancelAuthorization"]:
            return isinstance(msg, cls)

    class RebootToBootloader(protobuf.MessageType):
        boot_command: "BootCommand"
        firmware_header: "bytes | None"
        language_data_length: "int"

        def __init__(
            self,
            *,
            boot_command: "BootCommand | None" = None,
            firmware_header: "bytes | None" = None,
            language_data_length: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RebootToBootloader"]:
            return isinstance(msg, cls)

    class GetNonce(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["GetNonce"]:
            return isinstance(msg, cls)

    class Nonce(protobuf.MessageType):
        nonce: "bytes"

        def __init__(
            self,
            *,
            nonce: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Nonce"]:
            return isinstance(msg, cls)

    class UnlockPath(protobuf.MessageType):
        address_n: "list[int]"
        mac: "bytes | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            mac: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["UnlockPath"]:
            return isinstance(msg, cls)

    class UnlockedPathRequest(protobuf.MessageType):
        mac: "bytes | None"

        def __init__(
            self,
            *,
            mac: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["UnlockedPathRequest"]:
            return isinstance(msg, cls)

    class ShowDeviceTutorial(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ShowDeviceTutorial"]:
            return isinstance(msg, cls)

    class UnlockBootloader(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["UnlockBootloader"]:
            return isinstance(msg, cls)

    class SetBrightness(protobuf.MessageType):
        value: "int | None"

        def __init__(
            self,
            *,
            value: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SetBrightness"]:
            return isinstance(msg, cls)

    class Slip39Group(protobuf.MessageType):
        member_threshold: "int"
        member_count: "int"

        def __init__(
            self,
            *,
            member_threshold: "int",
            member_count: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["Slip39Group"]:
            return isinstance(msg, cls)

    class DebugLinkDecision(protobuf.MessageType):
        button: "DebugButton | None"
        swipe: "DebugSwipeDirection | None"
        input: "str | None"
        x: "int | None"
        y: "int | None"
        hold_ms: "int | None"
        physical_button: "DebugPhysicalButton | None"

        def __init__(
            self,
            *,
            button: "DebugButton | None" = None,
            swipe: "DebugSwipeDirection | None" = None,
            input: "str | None" = None,
            x: "int | None" = None,
            y: "int | None" = None,
            hold_ms: "int | None" = None,
            physical_button: "DebugPhysicalButton | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkDecision"]:
            return isinstance(msg, cls)

    class DebugLinkReseedRandom(protobuf.MessageType):
        value: "int | None"

        def __init__(
            self,
            *,
            value: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkReseedRandom"]:
            return isinstance(msg, cls)

    class DebugLinkRecordScreen(protobuf.MessageType):
        target_directory: "str | None"
        refresh_index: "int"

        def __init__(
            self,
            *,
            target_directory: "str | None" = None,
            refresh_index: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkRecordScreen"]:
            return isinstance(msg, cls)

    class DebugLinkGetState(protobuf.MessageType):
        wait_layout: "DebugWaitType"

        def __init__(
            self,
            *,
            wait_layout: "DebugWaitType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkGetState"]:
            return isinstance(msg, cls)

    class DebugLinkState(protobuf.MessageType):
        layout: "bytes | None"
        pin: "str | None"
        matrix: "str | None"
        mnemonic_secret: "bytes | None"
        node: "HDNodeType | None"
        passphrase_protection: "bool | None"
        reset_word: "str | None"
        reset_entropy: "bytes | None"
        recovery_fake_word: "str | None"
        recovery_word_pos: "int | None"
        reset_word_pos: "int | None"
        mnemonic_type: "BackupType | None"
        tokens: "list[str]"

        def __init__(
            self,
            *,
            tokens: "list[str] | None" = None,
            layout: "bytes | None" = None,
            pin: "str | None" = None,
            matrix: "str | None" = None,
            mnemonic_secret: "bytes | None" = None,
            node: "HDNodeType | None" = None,
            passphrase_protection: "bool | None" = None,
            reset_word: "str | None" = None,
            reset_entropy: "bytes | None" = None,
            recovery_fake_word: "str | None" = None,
            recovery_word_pos: "int | None" = None,
            reset_word_pos: "int | None" = None,
            mnemonic_type: "BackupType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkState"]:
            return isinstance(msg, cls)

    class DebugLinkStop(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkStop"]:
            return isinstance(msg, cls)

    class DebugLinkLog(protobuf.MessageType):
        level: "int | None"
        bucket: "str | None"
        text: "str | None"

        def __init__(
            self,
            *,
            level: "int | None" = None,
            bucket: "str | None" = None,
            text: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkLog"]:
            return isinstance(msg, cls)

    class DebugLinkMemoryRead(protobuf.MessageType):
        address: "int | None"
        length: "int | None"

        def __init__(
            self,
            *,
            address: "int | None" = None,
            length: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkMemoryRead"]:
            return isinstance(msg, cls)

    class DebugLinkMemory(protobuf.MessageType):
        memory: "bytes | None"

        def __init__(
            self,
            *,
            memory: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkMemory"]:
            return isinstance(msg, cls)

    class DebugLinkMemoryWrite(protobuf.MessageType):
        address: "int | None"
        memory: "bytes | None"
        flash: "bool | None"

        def __init__(
            self,
            *,
            address: "int | None" = None,
            memory: "bytes | None" = None,
            flash: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkMemoryWrite"]:
            return isinstance(msg, cls)

    class DebugLinkFlashErase(protobuf.MessageType):
        sector: "int | None"

        def __init__(
            self,
            *,
            sector: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkFlashErase"]:
            return isinstance(msg, cls)

    class DebugLinkEraseSdCard(protobuf.MessageType):
        format: "bool | None"

        def __init__(
            self,
            *,
            format: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkEraseSdCard"]:
            return isinstance(msg, cls)

    class DebugLinkOptigaSetSecMax(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugLinkOptigaSetSecMax"]:
            return isinstance(msg, cls)

    class EosGetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosGetPublicKey"]:
            return isinstance(msg, cls)

    class EosPublicKey(protobuf.MessageType):
        wif_public_key: "str"
        raw_public_key: "bytes"

        def __init__(
            self,
            *,
            wif_public_key: "str",
            raw_public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosPublicKey"]:
            return isinstance(msg, cls)

    class EosSignTx(protobuf.MessageType):
        address_n: "list[int]"
        chain_id: "bytes"
        header: "EosTxHeader"
        num_actions: "int"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            chain_id: "bytes",
            header: "EosTxHeader",
            num_actions: "int",
            address_n: "list[int] | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosSignTx"]:
            return isinstance(msg, cls)

    class EosTxActionRequest(protobuf.MessageType):
        data_size: "int | None"

        def __init__(
            self,
            *,
            data_size: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosTxActionRequest"]:
            return isinstance(msg, cls)

    class EosTxActionAck(protobuf.MessageType):
        common: "EosActionCommon"
        transfer: "EosActionTransfer | None"
        delegate: "EosActionDelegate | None"
        undelegate: "EosActionUndelegate | None"
        refund: "EosActionRefund | None"
        buy_ram: "EosActionBuyRam | None"
        buy_ram_bytes: "EosActionBuyRamBytes | None"
        sell_ram: "EosActionSellRam | None"
        vote_producer: "EosActionVoteProducer | None"
        update_auth: "EosActionUpdateAuth | None"
        delete_auth: "EosActionDeleteAuth | None"
        link_auth: "EosActionLinkAuth | None"
        unlink_auth: "EosActionUnlinkAuth | None"
        new_account: "EosActionNewAccount | None"
        unknown: "EosActionUnknown | None"

        def __init__(
            self,
            *,
            common: "EosActionCommon",
            transfer: "EosActionTransfer | None" = None,
            delegate: "EosActionDelegate | None" = None,
            undelegate: "EosActionUndelegate | None" = None,
            refund: "EosActionRefund | None" = None,
            buy_ram: "EosActionBuyRam | None" = None,
            buy_ram_bytes: "EosActionBuyRamBytes | None" = None,
            sell_ram: "EosActionSellRam | None" = None,
            vote_producer: "EosActionVoteProducer | None" = None,
            update_auth: "EosActionUpdateAuth | None" = None,
            delete_auth: "EosActionDeleteAuth | None" = None,
            link_auth: "EosActionLinkAuth | None" = None,
            unlink_auth: "EosActionUnlinkAuth | None" = None,
            new_account: "EosActionNewAccount | None" = None,
            unknown: "EosActionUnknown | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosTxActionAck"]:
            return isinstance(msg, cls)

    class EosSignedTx(protobuf.MessageType):
        signature: "str"

        def __init__(
            self,
            *,
            signature: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosSignedTx"]:
            return isinstance(msg, cls)

    class EosTxHeader(protobuf.MessageType):
        expiration: "int"
        ref_block_num: "int"
        ref_block_prefix: "int"
        max_net_usage_words: "int"
        max_cpu_usage_ms: "int"
        delay_sec: "int"

        def __init__(
            self,
            *,
            expiration: "int",
            ref_block_num: "int",
            ref_block_prefix: "int",
            max_net_usage_words: "int",
            max_cpu_usage_ms: "int",
            delay_sec: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosTxHeader"]:
            return isinstance(msg, cls)

    class EosAsset(protobuf.MessageType):
        amount: "int"
        symbol: "int"

        def __init__(
            self,
            *,
            amount: "int",
            symbol: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosAsset"]:
            return isinstance(msg, cls)

    class EosPermissionLevel(protobuf.MessageType):
        actor: "int"
        permission: "int"

        def __init__(
            self,
            *,
            actor: "int",
            permission: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosPermissionLevel"]:
            return isinstance(msg, cls)

    class EosAuthorizationKey(protobuf.MessageType):
        type: "int"
        key: "bytes | None"
        address_n: "list[int]"
        weight: "int"

        def __init__(
            self,
            *,
            type: "int",
            weight: "int",
            address_n: "list[int] | None" = None,
            key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosAuthorizationKey"]:
            return isinstance(msg, cls)

    class EosAuthorizationAccount(protobuf.MessageType):
        account: "EosPermissionLevel"
        weight: "int"

        def __init__(
            self,
            *,
            account: "EosPermissionLevel",
            weight: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosAuthorizationAccount"]:
            return isinstance(msg, cls)

    class EosAuthorizationWait(protobuf.MessageType):
        wait_sec: "int"
        weight: "int"

        def __init__(
            self,
            *,
            wait_sec: "int",
            weight: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosAuthorizationWait"]:
            return isinstance(msg, cls)

    class EosAuthorization(protobuf.MessageType):
        threshold: "int"
        keys: "list[EosAuthorizationKey]"
        accounts: "list[EosAuthorizationAccount]"
        waits: "list[EosAuthorizationWait]"

        def __init__(
            self,
            *,
            threshold: "int",
            keys: "list[EosAuthorizationKey] | None" = None,
            accounts: "list[EosAuthorizationAccount] | None" = None,
            waits: "list[EosAuthorizationWait] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosAuthorization"]:
            return isinstance(msg, cls)

    class EosActionCommon(protobuf.MessageType):
        account: "int"
        name: "int"
        authorization: "list[EosPermissionLevel]"

        def __init__(
            self,
            *,
            account: "int",
            name: "int",
            authorization: "list[EosPermissionLevel] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionCommon"]:
            return isinstance(msg, cls)

    class EosActionTransfer(protobuf.MessageType):
        sender: "int"
        receiver: "int"
        quantity: "EosAsset"
        memo: "str"

        def __init__(
            self,
            *,
            sender: "int",
            receiver: "int",
            quantity: "EosAsset",
            memo: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionTransfer"]:
            return isinstance(msg, cls)

    class EosActionDelegate(protobuf.MessageType):
        sender: "int"
        receiver: "int"
        net_quantity: "EosAsset"
        cpu_quantity: "EosAsset"
        transfer: "bool"

        def __init__(
            self,
            *,
            sender: "int",
            receiver: "int",
            net_quantity: "EosAsset",
            cpu_quantity: "EosAsset",
            transfer: "bool",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionDelegate"]:
            return isinstance(msg, cls)

    class EosActionUndelegate(protobuf.MessageType):
        sender: "int"
        receiver: "int"
        net_quantity: "EosAsset"
        cpu_quantity: "EosAsset"

        def __init__(
            self,
            *,
            sender: "int",
            receiver: "int",
            net_quantity: "EosAsset",
            cpu_quantity: "EosAsset",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionUndelegate"]:
            return isinstance(msg, cls)

    class EosActionRefund(protobuf.MessageType):
        owner: "int"

        def __init__(
            self,
            *,
            owner: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionRefund"]:
            return isinstance(msg, cls)

    class EosActionBuyRam(protobuf.MessageType):
        payer: "int"
        receiver: "int"
        quantity: "EosAsset"

        def __init__(
            self,
            *,
            payer: "int",
            receiver: "int",
            quantity: "EosAsset",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionBuyRam"]:
            return isinstance(msg, cls)

    class EosActionBuyRamBytes(protobuf.MessageType):
        payer: "int"
        receiver: "int"
        bytes: "int"

        def __init__(
            self,
            *,
            payer: "int",
            receiver: "int",
            bytes: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionBuyRamBytes"]:
            return isinstance(msg, cls)

    class EosActionSellRam(protobuf.MessageType):
        account: "int"
        bytes: "int"

        def __init__(
            self,
            *,
            account: "int",
            bytes: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionSellRam"]:
            return isinstance(msg, cls)

    class EosActionVoteProducer(protobuf.MessageType):
        voter: "int"
        proxy: "int"
        producers: "list[int]"

        def __init__(
            self,
            *,
            voter: "int",
            proxy: "int",
            producers: "list[int] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionVoteProducer"]:
            return isinstance(msg, cls)

    class EosActionUpdateAuth(protobuf.MessageType):
        account: "int"
        permission: "int"
        parent: "int"
        auth: "EosAuthorization"

        def __init__(
            self,
            *,
            account: "int",
            permission: "int",
            parent: "int",
            auth: "EosAuthorization",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionUpdateAuth"]:
            return isinstance(msg, cls)

    class EosActionDeleteAuth(protobuf.MessageType):
        account: "int"
        permission: "int"

        def __init__(
            self,
            *,
            account: "int",
            permission: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionDeleteAuth"]:
            return isinstance(msg, cls)

    class EosActionLinkAuth(protobuf.MessageType):
        account: "int"
        code: "int"
        type: "int"
        requirement: "int"

        def __init__(
            self,
            *,
            account: "int",
            code: "int",
            type: "int",
            requirement: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionLinkAuth"]:
            return isinstance(msg, cls)

    class EosActionUnlinkAuth(protobuf.MessageType):
        account: "int"
        code: "int"
        type: "int"

        def __init__(
            self,
            *,
            account: "int",
            code: "int",
            type: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionUnlinkAuth"]:
            return isinstance(msg, cls)

    class EosActionNewAccount(protobuf.MessageType):
        creator: "int"
        name: "int"
        owner: "EosAuthorization"
        active: "EosAuthorization"

        def __init__(
            self,
            *,
            creator: "int",
            name: "int",
            owner: "EosAuthorization",
            active: "EosAuthorization",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionNewAccount"]:
            return isinstance(msg, cls)

    class EosActionUnknown(protobuf.MessageType):
        data_size: "int"
        data_chunk: "bytes"

        def __init__(
            self,
            *,
            data_size: "int",
            data_chunk: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EosActionUnknown"]:
            return isinstance(msg, cls)

    class EthereumNetworkInfo(protobuf.MessageType):
        chain_id: "int"
        symbol: "str"
        slip44: "int"
        name: "str"

        def __init__(
            self,
            *,
            chain_id: "int",
            symbol: "str",
            slip44: "int",
            name: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumNetworkInfo"]:
            return isinstance(msg, cls)

    class EthereumTokenInfo(protobuf.MessageType):
        address: "bytes"
        chain_id: "int"
        symbol: "str"
        decimals: "int"
        name: "str"

        def __init__(
            self,
            *,
            address: "bytes",
            chain_id: "int",
            symbol: "str",
            decimals: "int",
            name: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTokenInfo"]:
            return isinstance(msg, cls)

    class EthereumDefinitions(protobuf.MessageType):
        encoded_network: "bytes | None"
        encoded_token: "bytes | None"

        def __init__(
            self,
            *,
            encoded_network: "bytes | None" = None,
            encoded_token: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumDefinitions"]:
            return isinstance(msg, cls)

    class EthereumSignTypedData(protobuf.MessageType):
        address_n: "list[int]"
        primary_type: "str"
        metamask_v4_compat: "bool"
        definitions: "EthereumDefinitions | None"

        def __init__(
            self,
            *,
            primary_type: "str",
            address_n: "list[int] | None" = None,
            metamask_v4_compat: "bool | None" = None,
            definitions: "EthereumDefinitions | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumSignTypedData"]:
            return isinstance(msg, cls)

    class EthereumTypedDataStructRequest(protobuf.MessageType):
        name: "str"

        def __init__(
            self,
            *,
            name: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTypedDataStructRequest"]:
            return isinstance(msg, cls)

    class EthereumTypedDataStructAck(protobuf.MessageType):
        members: "list[EthereumStructMember]"

        def __init__(
            self,
            *,
            members: "list[EthereumStructMember] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTypedDataStructAck"]:
            return isinstance(msg, cls)

    class EthereumTypedDataValueRequest(protobuf.MessageType):
        member_path: "list[int]"

        def __init__(
            self,
            *,
            member_path: "list[int] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTypedDataValueRequest"]:
            return isinstance(msg, cls)

    class EthereumTypedDataValueAck(protobuf.MessageType):
        value: "bytes"

        def __init__(
            self,
            *,
            value: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTypedDataValueAck"]:
            return isinstance(msg, cls)

    class EthereumStructMember(protobuf.MessageType):
        type: "EthereumFieldType"
        name: "str"

        def __init__(
            self,
            *,
            type: "EthereumFieldType",
            name: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumStructMember"]:
            return isinstance(msg, cls)

    class EthereumFieldType(protobuf.MessageType):
        data_type: "EthereumDataType"
        size: "int | None"
        entry_type: "EthereumFieldType | None"
        struct_name: "str | None"

        def __init__(
            self,
            *,
            data_type: "EthereumDataType",
            size: "int | None" = None,
            entry_type: "EthereumFieldType | None" = None,
            struct_name: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumFieldType"]:
            return isinstance(msg, cls)

    class EthereumGetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumGetPublicKey"]:
            return isinstance(msg, cls)

    class EthereumPublicKey(protobuf.MessageType):
        node: "HDNodeType"
        xpub: "str"

        def __init__(
            self,
            *,
            node: "HDNodeType",
            xpub: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumPublicKey"]:
            return isinstance(msg, cls)

    class EthereumGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        encoded_network: "bytes | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            encoded_network: "bytes | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumGetAddress"]:
            return isinstance(msg, cls)

    class EthereumAddress(protobuf.MessageType):
        address: "str | None"

        def __init__(
            self,
            *,
            address: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumAddress"]:
            return isinstance(msg, cls)

    class EthereumSignTx(protobuf.MessageType):
        address_n: "list[int]"
        nonce: "bytes"
        gas_price: "bytes"
        gas_limit: "bytes"
        to: "str"
        value: "bytes"
        data_initial_chunk: "bytes"
        data_length: "int"
        chain_id: "int"
        tx_type: "int | None"
        definitions: "EthereumDefinitions | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            gas_price: "bytes",
            gas_limit: "bytes",
            chain_id: "int",
            address_n: "list[int] | None" = None,
            nonce: "bytes | None" = None,
            to: "str | None" = None,
            value: "bytes | None" = None,
            data_initial_chunk: "bytes | None" = None,
            data_length: "int | None" = None,
            tx_type: "int | None" = None,
            definitions: "EthereumDefinitions | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumSignTx"]:
            return isinstance(msg, cls)

    class EthereumSignTxEIP1559(protobuf.MessageType):
        address_n: "list[int]"
        nonce: "bytes"
        max_gas_fee: "bytes"
        max_priority_fee: "bytes"
        gas_limit: "bytes"
        to: "str"
        value: "bytes"
        data_initial_chunk: "bytes"
        data_length: "int"
        chain_id: "int"
        access_list: "list[EthereumAccessList]"
        definitions: "EthereumDefinitions | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            nonce: "bytes",
            max_gas_fee: "bytes",
            max_priority_fee: "bytes",
            gas_limit: "bytes",
            value: "bytes",
            data_length: "int",
            chain_id: "int",
            address_n: "list[int] | None" = None,
            access_list: "list[EthereumAccessList] | None" = None,
            to: "str | None" = None,
            data_initial_chunk: "bytes | None" = None,
            definitions: "EthereumDefinitions | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumSignTxEIP1559"]:
            return isinstance(msg, cls)

    class EthereumTxRequest(protobuf.MessageType):
        data_length: "int | None"
        signature_v: "int | None"
        signature_r: "bytes | None"
        signature_s: "bytes | None"

        def __init__(
            self,
            *,
            data_length: "int | None" = None,
            signature_v: "int | None" = None,
            signature_r: "bytes | None" = None,
            signature_s: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTxRequest"]:
            return isinstance(msg, cls)

    class EthereumTxAck(protobuf.MessageType):
        data_chunk: "bytes"

        def __init__(
            self,
            *,
            data_chunk: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTxAck"]:
            return isinstance(msg, cls)

    class EthereumSignMessage(protobuf.MessageType):
        address_n: "list[int]"
        message: "bytes"
        encoded_network: "bytes | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            message: "bytes",
            address_n: "list[int] | None" = None,
            encoded_network: "bytes | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumSignMessage"]:
            return isinstance(msg, cls)

    class EthereumMessageSignature(protobuf.MessageType):
        signature: "bytes"
        address: "str"

        def __init__(
            self,
            *,
            signature: "bytes",
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumMessageSignature"]:
            return isinstance(msg, cls)

    class EthereumVerifyMessage(protobuf.MessageType):
        signature: "bytes"
        message: "bytes"
        address: "str"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            signature: "bytes",
            message: "bytes",
            address: "str",
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumVerifyMessage"]:
            return isinstance(msg, cls)

    class EthereumSignTypedHash(protobuf.MessageType):
        address_n: "list[int]"
        domain_separator_hash: "bytes"
        message_hash: "bytes | None"
        encoded_network: "bytes | None"

        def __init__(
            self,
            *,
            domain_separator_hash: "bytes",
            address_n: "list[int] | None" = None,
            message_hash: "bytes | None" = None,
            encoded_network: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumSignTypedHash"]:
            return isinstance(msg, cls)

    class EthereumTypedDataSignature(protobuf.MessageType):
        signature: "bytes"
        address: "str"

        def __init__(
            self,
            *,
            signature: "bytes",
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumTypedDataSignature"]:
            return isinstance(msg, cls)

    class EthereumAccessList(protobuf.MessageType):
        address: "str"
        storage_keys: "list[bytes]"

        def __init__(
            self,
            *,
            address: "str",
            storage_keys: "list[bytes] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["EthereumAccessList"]:
            return isinstance(msg, cls)

    class MoneroTransactionSourceEntry(protobuf.MessageType):
        outputs: "list[MoneroOutputEntry]"
        real_output: "int | None"
        real_out_tx_key: "bytes | None"
        real_out_additional_tx_keys: "list[bytes]"
        real_output_in_tx_index: "int | None"
        amount: "int | None"
        rct: "bool | None"
        mask: "bytes | None"
        multisig_kLRki: "MoneroMultisigKLRki | None"
        subaddr_minor: "int | None"

        def __init__(
            self,
            *,
            outputs: "list[MoneroOutputEntry] | None" = None,
            real_out_additional_tx_keys: "list[bytes] | None" = None,
            real_output: "int | None" = None,
            real_out_tx_key: "bytes | None" = None,
            real_output_in_tx_index: "int | None" = None,
            amount: "int | None" = None,
            rct: "bool | None" = None,
            mask: "bytes | None" = None,
            multisig_kLRki: "MoneroMultisigKLRki | None" = None,
            subaddr_minor: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSourceEntry"]:
            return isinstance(msg, cls)

    class MoneroTransactionDestinationEntry(protobuf.MessageType):
        amount: "int | None"
        addr: "MoneroAccountPublicAddress | None"
        is_subaddress: "bool | None"
        original: "bytes | None"
        is_integrated: "bool | None"

        def __init__(
            self,
            *,
            amount: "int | None" = None,
            addr: "MoneroAccountPublicAddress | None" = None,
            is_subaddress: "bool | None" = None,
            original: "bytes | None" = None,
            is_integrated: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionDestinationEntry"]:
            return isinstance(msg, cls)

    class MoneroTransactionRsigData(protobuf.MessageType):
        rsig_type: "int | None"
        offload_type: "int | None"
        grouping: "list[int]"
        mask: "bytes | None"
        rsig: "bytes | None"
        rsig_parts: "list[bytes]"
        bp_version: "int | None"

        def __init__(
            self,
            *,
            grouping: "list[int] | None" = None,
            rsig_parts: "list[bytes] | None" = None,
            rsig_type: "int | None" = None,
            offload_type: "int | None" = None,
            mask: "bytes | None" = None,
            rsig: "bytes | None" = None,
            bp_version: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionRsigData"]:
            return isinstance(msg, cls)

    class MoneroGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        network_type: "MoneroNetworkType"
        account: "int | None"
        minor: "int | None"
        payment_id: "bytes | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            network_type: "MoneroNetworkType | None" = None,
            account: "int | None" = None,
            minor: "int | None" = None,
            payment_id: "bytes | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroGetAddress"]:
            return isinstance(msg, cls)

    class MoneroAddress(protobuf.MessageType):
        address: "bytes | None"

        def __init__(
            self,
            *,
            address: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroAddress"]:
            return isinstance(msg, cls)

    class MoneroGetWatchKey(protobuf.MessageType):
        address_n: "list[int]"
        network_type: "MoneroNetworkType"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            network_type: "MoneroNetworkType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroGetWatchKey"]:
            return isinstance(msg, cls)

    class MoneroWatchKey(protobuf.MessageType):
        watch_key: "bytes | None"
        address: "bytes | None"

        def __init__(
            self,
            *,
            watch_key: "bytes | None" = None,
            address: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroWatchKey"]:
            return isinstance(msg, cls)

    class MoneroTransactionInitRequest(protobuf.MessageType):
        version: "int | None"
        address_n: "list[int]"
        network_type: "MoneroNetworkType"
        tsx_data: "MoneroTransactionData | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            version: "int | None" = None,
            network_type: "MoneroNetworkType | None" = None,
            tsx_data: "MoneroTransactionData | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionInitRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionInitAck(protobuf.MessageType):
        hmacs: "list[bytes]"
        rsig_data: "MoneroTransactionRsigData | None"

        def __init__(
            self,
            *,
            hmacs: "list[bytes] | None" = None,
            rsig_data: "MoneroTransactionRsigData | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionInitAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionSetInputRequest(protobuf.MessageType):
        src_entr: "MoneroTransactionSourceEntry | None"

        def __init__(
            self,
            *,
            src_entr: "MoneroTransactionSourceEntry | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSetInputRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionSetInputAck(protobuf.MessageType):
        vini: "bytes | None"
        vini_hmac: "bytes | None"
        pseudo_out: "bytes | None"
        pseudo_out_hmac: "bytes | None"
        pseudo_out_alpha: "bytes | None"
        spend_key: "bytes | None"

        def __init__(
            self,
            *,
            vini: "bytes | None" = None,
            vini_hmac: "bytes | None" = None,
            pseudo_out: "bytes | None" = None,
            pseudo_out_hmac: "bytes | None" = None,
            pseudo_out_alpha: "bytes | None" = None,
            spend_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSetInputAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionInputViniRequest(protobuf.MessageType):
        src_entr: "MoneroTransactionSourceEntry | None"
        vini: "bytes | None"
        vini_hmac: "bytes | None"
        pseudo_out: "bytes | None"
        pseudo_out_hmac: "bytes | None"
        orig_idx: "int | None"

        def __init__(
            self,
            *,
            src_entr: "MoneroTransactionSourceEntry | None" = None,
            vini: "bytes | None" = None,
            vini_hmac: "bytes | None" = None,
            pseudo_out: "bytes | None" = None,
            pseudo_out_hmac: "bytes | None" = None,
            orig_idx: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionInputViniRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionInputViniAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionInputViniAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionAllInputsSetRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionAllInputsSetRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionAllInputsSetAck(protobuf.MessageType):
        rsig_data: "MoneroTransactionRsigData | None"

        def __init__(
            self,
            *,
            rsig_data: "MoneroTransactionRsigData | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionAllInputsSetAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionSetOutputRequest(protobuf.MessageType):
        dst_entr: "MoneroTransactionDestinationEntry | None"
        dst_entr_hmac: "bytes | None"
        rsig_data: "MoneroTransactionRsigData | None"
        is_offloaded_bp: "bool | None"

        def __init__(
            self,
            *,
            dst_entr: "MoneroTransactionDestinationEntry | None" = None,
            dst_entr_hmac: "bytes | None" = None,
            rsig_data: "MoneroTransactionRsigData | None" = None,
            is_offloaded_bp: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSetOutputRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionSetOutputAck(protobuf.MessageType):
        tx_out: "bytes | None"
        vouti_hmac: "bytes | None"
        rsig_data: "MoneroTransactionRsigData | None"
        out_pk: "bytes | None"
        ecdh_info: "bytes | None"

        def __init__(
            self,
            *,
            tx_out: "bytes | None" = None,
            vouti_hmac: "bytes | None" = None,
            rsig_data: "MoneroTransactionRsigData | None" = None,
            out_pk: "bytes | None" = None,
            ecdh_info: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSetOutputAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionAllOutSetRequest(protobuf.MessageType):
        rsig_data: "MoneroTransactionRsigData | None"

        def __init__(
            self,
            *,
            rsig_data: "MoneroTransactionRsigData | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionAllOutSetRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionAllOutSetAck(protobuf.MessageType):
        extra: "bytes | None"
        tx_prefix_hash: "bytes | None"
        rv: "MoneroRingCtSig | None"
        full_message_hash: "bytes | None"

        def __init__(
            self,
            *,
            extra: "bytes | None" = None,
            tx_prefix_hash: "bytes | None" = None,
            rv: "MoneroRingCtSig | None" = None,
            full_message_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionAllOutSetAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionSignInputRequest(protobuf.MessageType):
        src_entr: "MoneroTransactionSourceEntry | None"
        vini: "bytes | None"
        vini_hmac: "bytes | None"
        pseudo_out: "bytes | None"
        pseudo_out_hmac: "bytes | None"
        pseudo_out_alpha: "bytes | None"
        spend_key: "bytes | None"
        orig_idx: "int | None"

        def __init__(
            self,
            *,
            src_entr: "MoneroTransactionSourceEntry | None" = None,
            vini: "bytes | None" = None,
            vini_hmac: "bytes | None" = None,
            pseudo_out: "bytes | None" = None,
            pseudo_out_hmac: "bytes | None" = None,
            pseudo_out_alpha: "bytes | None" = None,
            spend_key: "bytes | None" = None,
            orig_idx: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSignInputRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionSignInputAck(protobuf.MessageType):
        signature: "bytes | None"
        pseudo_out: "bytes | None"

        def __init__(
            self,
            *,
            signature: "bytes | None" = None,
            pseudo_out: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionSignInputAck"]:
            return isinstance(msg, cls)

    class MoneroTransactionFinalRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionFinalRequest"]:
            return isinstance(msg, cls)

    class MoneroTransactionFinalAck(protobuf.MessageType):
        cout_key: "bytes | None"
        salt: "bytes | None"
        rand_mult: "bytes | None"
        tx_enc_keys: "bytes | None"
        opening_key: "bytes | None"

        def __init__(
            self,
            *,
            cout_key: "bytes | None" = None,
            salt: "bytes | None" = None,
            rand_mult: "bytes | None" = None,
            tx_enc_keys: "bytes | None" = None,
            opening_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionFinalAck"]:
            return isinstance(msg, cls)

    class MoneroKeyImageExportInitRequest(protobuf.MessageType):
        num: "int"
        hash: "bytes"
        address_n: "list[int]"
        network_type: "MoneroNetworkType"
        subs: "list[MoneroSubAddressIndicesList]"

        def __init__(
            self,
            *,
            num: "int",
            hash: "bytes",
            address_n: "list[int] | None" = None,
            subs: "list[MoneroSubAddressIndicesList] | None" = None,
            network_type: "MoneroNetworkType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroKeyImageExportInitRequest"]:
            return isinstance(msg, cls)

    class MoneroKeyImageExportInitAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroKeyImageExportInitAck"]:
            return isinstance(msg, cls)

    class MoneroKeyImageSyncStepRequest(protobuf.MessageType):
        tdis: "list[MoneroTransferDetails]"

        def __init__(
            self,
            *,
            tdis: "list[MoneroTransferDetails] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroKeyImageSyncStepRequest"]:
            return isinstance(msg, cls)

    class MoneroKeyImageSyncStepAck(protobuf.MessageType):
        kis: "list[MoneroExportedKeyImage]"

        def __init__(
            self,
            *,
            kis: "list[MoneroExportedKeyImage] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroKeyImageSyncStepAck"]:
            return isinstance(msg, cls)

    class MoneroKeyImageSyncFinalRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroKeyImageSyncFinalRequest"]:
            return isinstance(msg, cls)

    class MoneroKeyImageSyncFinalAck(protobuf.MessageType):
        enc_key: "bytes | None"

        def __init__(
            self,
            *,
            enc_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroKeyImageSyncFinalAck"]:
            return isinstance(msg, cls)

    class MoneroGetTxKeyRequest(protobuf.MessageType):
        address_n: "list[int]"
        network_type: "MoneroNetworkType"
        salt1: "bytes"
        salt2: "bytes"
        tx_enc_keys: "bytes"
        tx_prefix_hash: "bytes"
        reason: "int | None"
        view_public_key: "bytes | None"

        def __init__(
            self,
            *,
            salt1: "bytes",
            salt2: "bytes",
            tx_enc_keys: "bytes",
            tx_prefix_hash: "bytes",
            address_n: "list[int] | None" = None,
            network_type: "MoneroNetworkType | None" = None,
            reason: "int | None" = None,
            view_public_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroGetTxKeyRequest"]:
            return isinstance(msg, cls)

    class MoneroGetTxKeyAck(protobuf.MessageType):
        salt: "bytes | None"
        tx_keys: "bytes | None"
        tx_derivations: "bytes | None"

        def __init__(
            self,
            *,
            salt: "bytes | None" = None,
            tx_keys: "bytes | None" = None,
            tx_derivations: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroGetTxKeyAck"]:
            return isinstance(msg, cls)

    class MoneroLiveRefreshStartRequest(protobuf.MessageType):
        address_n: "list[int]"
        network_type: "MoneroNetworkType"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            network_type: "MoneroNetworkType | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroLiveRefreshStartRequest"]:
            return isinstance(msg, cls)

    class MoneroLiveRefreshStartAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroLiveRefreshStartAck"]:
            return isinstance(msg, cls)

    class MoneroLiveRefreshStepRequest(protobuf.MessageType):
        out_key: "bytes"
        recv_deriv: "bytes"
        real_out_idx: "int"
        sub_addr_major: "int"
        sub_addr_minor: "int"

        def __init__(
            self,
            *,
            out_key: "bytes",
            recv_deriv: "bytes",
            real_out_idx: "int",
            sub_addr_major: "int",
            sub_addr_minor: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroLiveRefreshStepRequest"]:
            return isinstance(msg, cls)

    class MoneroLiveRefreshStepAck(protobuf.MessageType):
        salt: "bytes | None"
        key_image: "bytes | None"

        def __init__(
            self,
            *,
            salt: "bytes | None" = None,
            key_image: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroLiveRefreshStepAck"]:
            return isinstance(msg, cls)

    class MoneroLiveRefreshFinalRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroLiveRefreshFinalRequest"]:
            return isinstance(msg, cls)

    class MoneroLiveRefreshFinalAck(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroLiveRefreshFinalAck"]:
            return isinstance(msg, cls)

    class DebugMoneroDiagRequest(protobuf.MessageType):
        ins: "int | None"
        p1: "int | None"
        p2: "int | None"
        pd: "list[int]"
        data1: "bytes | None"
        data2: "bytes | None"

        def __init__(
            self,
            *,
            pd: "list[int] | None" = None,
            ins: "int | None" = None,
            p1: "int | None" = None,
            p2: "int | None" = None,
            data1: "bytes | None" = None,
            data2: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugMoneroDiagRequest"]:
            return isinstance(msg, cls)

    class DebugMoneroDiagAck(protobuf.MessageType):
        ins: "int | None"
        p1: "int | None"
        p2: "int | None"
        pd: "list[int]"
        data1: "bytes | None"
        data2: "bytes | None"

        def __init__(
            self,
            *,
            pd: "list[int] | None" = None,
            ins: "int | None" = None,
            p1: "int | None" = None,
            p2: "int | None" = None,
            data1: "bytes | None" = None,
            data2: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["DebugMoneroDiagAck"]:
            return isinstance(msg, cls)

    class MoneroOutputEntry(protobuf.MessageType):
        idx: "int | None"
        key: "MoneroRctKeyPublic | None"

        def __init__(
            self,
            *,
            idx: "int | None" = None,
            key: "MoneroRctKeyPublic | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroOutputEntry"]:
            return isinstance(msg, cls)

    class MoneroMultisigKLRki(protobuf.MessageType):
        K: "bytes | None"
        L: "bytes | None"
        R: "bytes | None"
        ki: "bytes | None"

        def __init__(
            self,
            *,
            K: "bytes | None" = None,
            L: "bytes | None" = None,
            R: "bytes | None" = None,
            ki: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroMultisigKLRki"]:
            return isinstance(msg, cls)

    class MoneroRctKeyPublic(protobuf.MessageType):
        dest: "bytes"
        commitment: "bytes"

        def __init__(
            self,
            *,
            dest: "bytes",
            commitment: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroRctKeyPublic"]:
            return isinstance(msg, cls)

    class MoneroAccountPublicAddress(protobuf.MessageType):
        spend_public_key: "bytes | None"
        view_public_key: "bytes | None"

        def __init__(
            self,
            *,
            spend_public_key: "bytes | None" = None,
            view_public_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroAccountPublicAddress"]:
            return isinstance(msg, cls)

    class MoneroTransactionData(protobuf.MessageType):
        version: "int | None"
        payment_id: "bytes | None"
        unlock_time: "int | None"
        outputs: "list[MoneroTransactionDestinationEntry]"
        change_dts: "MoneroTransactionDestinationEntry | None"
        num_inputs: "int | None"
        mixin: "int | None"
        fee: "int | None"
        account: "int | None"
        minor_indices: "list[int]"
        rsig_data: "MoneroTransactionRsigData | None"
        integrated_indices: "list[int]"
        client_version: "int | None"
        hard_fork: "int | None"
        monero_version: "bytes | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            outputs: "list[MoneroTransactionDestinationEntry] | None" = None,
            minor_indices: "list[int] | None" = None,
            integrated_indices: "list[int] | None" = None,
            version: "int | None" = None,
            payment_id: "bytes | None" = None,
            unlock_time: "int | None" = None,
            change_dts: "MoneroTransactionDestinationEntry | None" = None,
            num_inputs: "int | None" = None,
            mixin: "int | None" = None,
            fee: "int | None" = None,
            account: "int | None" = None,
            rsig_data: "MoneroTransactionRsigData | None" = None,
            client_version: "int | None" = None,
            hard_fork: "int | None" = None,
            monero_version: "bytes | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransactionData"]:
            return isinstance(msg, cls)

    class MoneroRingCtSig(protobuf.MessageType):
        txn_fee: "int | None"
        message: "bytes | None"
        rv_type: "int | None"

        def __init__(
            self,
            *,
            txn_fee: "int | None" = None,
            message: "bytes | None" = None,
            rv_type: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroRingCtSig"]:
            return isinstance(msg, cls)

    class MoneroSubAddressIndicesList(protobuf.MessageType):
        account: "int"
        minor_indices: "list[int]"

        def __init__(
            self,
            *,
            account: "int",
            minor_indices: "list[int] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroSubAddressIndicesList"]:
            return isinstance(msg, cls)

    class MoneroTransferDetails(protobuf.MessageType):
        out_key: "bytes"
        tx_pub_key: "bytes"
        additional_tx_pub_keys: "list[bytes]"
        internal_output_index: "int"
        sub_addr_major: "int | None"
        sub_addr_minor: "int | None"

        def __init__(
            self,
            *,
            out_key: "bytes",
            tx_pub_key: "bytes",
            internal_output_index: "int",
            additional_tx_pub_keys: "list[bytes] | None" = None,
            sub_addr_major: "int | None" = None,
            sub_addr_minor: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroTransferDetails"]:
            return isinstance(msg, cls)

    class MoneroExportedKeyImage(protobuf.MessageType):
        iv: "bytes | None"
        blob: "bytes | None"

        def __init__(
            self,
            *,
            iv: "bytes | None" = None,
            blob: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["MoneroExportedKeyImage"]:
            return isinstance(msg, cls)

    class NEMGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        network: "int"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            network: "int | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMGetAddress"]:
            return isinstance(msg, cls)

    class NEMAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMAddress"]:
            return isinstance(msg, cls)

    class NEMSignTx(protobuf.MessageType):
        transaction: "NEMTransactionCommon"
        multisig: "NEMTransactionCommon | None"
        transfer: "NEMTransfer | None"
        cosigning: "bool | None"
        provision_namespace: "NEMProvisionNamespace | None"
        mosaic_creation: "NEMMosaicCreation | None"
        supply_change: "NEMMosaicSupplyChange | None"
        aggregate_modification: "NEMAggregateModification | None"
        importance_transfer: "NEMImportanceTransfer | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            transaction: "NEMTransactionCommon",
            multisig: "NEMTransactionCommon | None" = None,
            transfer: "NEMTransfer | None" = None,
            cosigning: "bool | None" = None,
            provision_namespace: "NEMProvisionNamespace | None" = None,
            mosaic_creation: "NEMMosaicCreation | None" = None,
            supply_change: "NEMMosaicSupplyChange | None" = None,
            aggregate_modification: "NEMAggregateModification | None" = None,
            importance_transfer: "NEMImportanceTransfer | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMSignTx"]:
            return isinstance(msg, cls)

    class NEMSignedTx(protobuf.MessageType):
        data: "bytes"
        signature: "bytes"

        def __init__(
            self,
            *,
            data: "bytes",
            signature: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMSignedTx"]:
            return isinstance(msg, cls)

    class NEMDecryptMessage(protobuf.MessageType):
        address_n: "list[int]"
        network: "int | None"
        public_key: "bytes | None"
        payload: "bytes | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            network: "int | None" = None,
            public_key: "bytes | None" = None,
            payload: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMDecryptMessage"]:
            return isinstance(msg, cls)

    class NEMDecryptedMessage(protobuf.MessageType):
        payload: "bytes"

        def __init__(
            self,
            *,
            payload: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMDecryptedMessage"]:
            return isinstance(msg, cls)

    class NEMTransactionCommon(protobuf.MessageType):
        address_n: "list[int]"
        network: "int"
        timestamp: "int"
        fee: "int"
        deadline: "int"
        signer: "bytes | None"

        def __init__(
            self,
            *,
            timestamp: "int",
            fee: "int",
            deadline: "int",
            address_n: "list[int] | None" = None,
            network: "int | None" = None,
            signer: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMTransactionCommon"]:
            return isinstance(msg, cls)

    class NEMTransfer(protobuf.MessageType):
        recipient: "str"
        amount: "int"
        payload: "bytes | None"
        public_key: "bytes | None"
        mosaics: "list[NEMMosaic]"

        def __init__(
            self,
            *,
            recipient: "str",
            amount: "int",
            mosaics: "list[NEMMosaic] | None" = None,
            payload: "bytes | None" = None,
            public_key: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMTransfer"]:
            return isinstance(msg, cls)

    class NEMProvisionNamespace(protobuf.MessageType):
        namespace: "str"
        parent: "str | None"
        sink: "str"
        fee: "int"

        def __init__(
            self,
            *,
            namespace: "str",
            sink: "str",
            fee: "int",
            parent: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMProvisionNamespace"]:
            return isinstance(msg, cls)

    class NEMMosaicCreation(protobuf.MessageType):
        definition: "NEMMosaicDefinition"
        sink: "str"
        fee: "int"

        def __init__(
            self,
            *,
            definition: "NEMMosaicDefinition",
            sink: "str",
            fee: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMMosaicCreation"]:
            return isinstance(msg, cls)

    class NEMMosaicSupplyChange(protobuf.MessageType):
        namespace: "str"
        mosaic: "str"
        type: "NEMSupplyChangeType"
        delta: "int"

        def __init__(
            self,
            *,
            namespace: "str",
            mosaic: "str",
            type: "NEMSupplyChangeType",
            delta: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMMosaicSupplyChange"]:
            return isinstance(msg, cls)

    class NEMAggregateModification(protobuf.MessageType):
        modifications: "list[NEMCosignatoryModification]"
        relative_change: "int | None"

        def __init__(
            self,
            *,
            modifications: "list[NEMCosignatoryModification] | None" = None,
            relative_change: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMAggregateModification"]:
            return isinstance(msg, cls)

    class NEMImportanceTransfer(protobuf.MessageType):
        mode: "NEMImportanceTransferMode"
        public_key: "bytes"

        def __init__(
            self,
            *,
            mode: "NEMImportanceTransferMode",
            public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMImportanceTransfer"]:
            return isinstance(msg, cls)

    class NEMMosaic(protobuf.MessageType):
        namespace: "str"
        mosaic: "str"
        quantity: "int"

        def __init__(
            self,
            *,
            namespace: "str",
            mosaic: "str",
            quantity: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMMosaic"]:
            return isinstance(msg, cls)

    class NEMMosaicDefinition(protobuf.MessageType):
        name: "str | None"
        ticker: "str | None"
        namespace: "str"
        mosaic: "str"
        divisibility: "int | None"
        levy: "NEMMosaicLevy | None"
        fee: "int | None"
        levy_address: "str | None"
        levy_namespace: "str | None"
        levy_mosaic: "str | None"
        supply: "int | None"
        mutable_supply: "bool | None"
        transferable: "bool | None"
        description: "str"
        networks: "list[int]"

        def __init__(
            self,
            *,
            namespace: "str",
            mosaic: "str",
            description: "str",
            networks: "list[int] | None" = None,
            name: "str | None" = None,
            ticker: "str | None" = None,
            divisibility: "int | None" = None,
            levy: "NEMMosaicLevy | None" = None,
            fee: "int | None" = None,
            levy_address: "str | None" = None,
            levy_namespace: "str | None" = None,
            levy_mosaic: "str | None" = None,
            supply: "int | None" = None,
            mutable_supply: "bool | None" = None,
            transferable: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMMosaicDefinition"]:
            return isinstance(msg, cls)

    class NEMCosignatoryModification(protobuf.MessageType):
        type: "NEMModificationType"
        public_key: "bytes"

        def __init__(
            self,
            *,
            type: "NEMModificationType",
            public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["NEMCosignatoryModification"]:
            return isinstance(msg, cls)

    class RippleGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RippleGetAddress"]:
            return isinstance(msg, cls)

    class RippleAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RippleAddress"]:
            return isinstance(msg, cls)

    class RippleSignTx(protobuf.MessageType):
        address_n: "list[int]"
        fee: "int"
        flags: "int"
        sequence: "int"
        last_ledger_sequence: "int | None"
        payment: "RipplePayment"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            fee: "int",
            sequence: "int",
            payment: "RipplePayment",
            address_n: "list[int] | None" = None,
            flags: "int | None" = None,
            last_ledger_sequence: "int | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RippleSignTx"]:
            return isinstance(msg, cls)

    class RippleSignedTx(protobuf.MessageType):
        signature: "bytes"
        serialized_tx: "bytes"

        def __init__(
            self,
            *,
            signature: "bytes",
            serialized_tx: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RippleSignedTx"]:
            return isinstance(msg, cls)

    class RipplePayment(protobuf.MessageType):
        amount: "int"
        destination: "str"
        destination_tag: "int | None"

        def __init__(
            self,
            *,
            amount: "int",
            destination: "str",
            destination_tag: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["RipplePayment"]:
            return isinstance(msg, cls)

    class SolanaGetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaGetPublicKey"]:
            return isinstance(msg, cls)

    class SolanaPublicKey(protobuf.MessageType):
        public_key: "bytes"

        def __init__(
            self,
            *,
            public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaPublicKey"]:
            return isinstance(msg, cls)

    class SolanaGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaGetAddress"]:
            return isinstance(msg, cls)

    class SolanaAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaAddress"]:
            return isinstance(msg, cls)

    class SolanaTxTokenAccountInfo(protobuf.MessageType):
        base_address: "str"
        token_program: "str"
        token_mint: "str"
        token_account: "str"

        def __init__(
            self,
            *,
            base_address: "str",
            token_program: "str",
            token_mint: "str",
            token_account: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaTxTokenAccountInfo"]:
            return isinstance(msg, cls)

    class SolanaTxAdditionalInfo(protobuf.MessageType):
        token_accounts_infos: "list[SolanaTxTokenAccountInfo]"

        def __init__(
            self,
            *,
            token_accounts_infos: "list[SolanaTxTokenAccountInfo] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaTxAdditionalInfo"]:
            return isinstance(msg, cls)

    class SolanaSignTx(protobuf.MessageType):
        address_n: "list[int]"
        serialized_tx: "bytes"
        additional_info: "SolanaTxAdditionalInfo | None"

        def __init__(
            self,
            *,
            serialized_tx: "bytes",
            address_n: "list[int] | None" = None,
            additional_info: "SolanaTxAdditionalInfo | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaSignTx"]:
            return isinstance(msg, cls)

    class SolanaTxSignature(protobuf.MessageType):
        signature: "bytes"

        def __init__(
            self,
            *,
            signature: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["SolanaTxSignature"]:
            return isinstance(msg, cls)

    class StellarAsset(protobuf.MessageType):
        type: "StellarAssetType"
        code: "str | None"
        issuer: "str | None"

        def __init__(
            self,
            *,
            type: "StellarAssetType",
            code: "str | None" = None,
            issuer: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarAsset"]:
            return isinstance(msg, cls)

    class StellarGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarGetAddress"]:
            return isinstance(msg, cls)

    class StellarAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarAddress"]:
            return isinstance(msg, cls)

    class StellarSignTx(protobuf.MessageType):
        address_n: "list[int]"
        network_passphrase: "str"
        source_account: "str"
        fee: "int"
        sequence_number: "int"
        timebounds_start: "int"
        timebounds_end: "int"
        memo_type: "StellarMemoType"
        memo_text: "str | None"
        memo_id: "int | None"
        memo_hash: "bytes | None"
        num_operations: "int"

        def __init__(
            self,
            *,
            network_passphrase: "str",
            source_account: "str",
            fee: "int",
            sequence_number: "int",
            timebounds_start: "int",
            timebounds_end: "int",
            memo_type: "StellarMemoType",
            num_operations: "int",
            address_n: "list[int] | None" = None,
            memo_text: "str | None" = None,
            memo_id: "int | None" = None,
            memo_hash: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarSignTx"]:
            return isinstance(msg, cls)

    class StellarTxOpRequest(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarTxOpRequest"]:
            return isinstance(msg, cls)

    class StellarPaymentOp(protobuf.MessageType):
        source_account: "str | None"
        destination_account: "str"
        asset: "StellarAsset"
        amount: "int"

        def __init__(
            self,
            *,
            destination_account: "str",
            asset: "StellarAsset",
            amount: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarPaymentOp"]:
            return isinstance(msg, cls)

    class StellarCreateAccountOp(protobuf.MessageType):
        source_account: "str | None"
        new_account: "str"
        starting_balance: "int"

        def __init__(
            self,
            *,
            new_account: "str",
            starting_balance: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarCreateAccountOp"]:
            return isinstance(msg, cls)

    class StellarPathPaymentStrictReceiveOp(protobuf.MessageType):
        source_account: "str | None"
        send_asset: "StellarAsset"
        send_max: "int"
        destination_account: "str"
        destination_asset: "StellarAsset"
        destination_amount: "int"
        paths: "list[StellarAsset]"

        def __init__(
            self,
            *,
            send_asset: "StellarAsset",
            send_max: "int",
            destination_account: "str",
            destination_asset: "StellarAsset",
            destination_amount: "int",
            paths: "list[StellarAsset] | None" = None,
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarPathPaymentStrictReceiveOp"]:
            return isinstance(msg, cls)

    class StellarPathPaymentStrictSendOp(protobuf.MessageType):
        source_account: "str | None"
        send_asset: "StellarAsset"
        send_amount: "int"
        destination_account: "str"
        destination_asset: "StellarAsset"
        destination_min: "int"
        paths: "list[StellarAsset]"

        def __init__(
            self,
            *,
            send_asset: "StellarAsset",
            send_amount: "int",
            destination_account: "str",
            destination_asset: "StellarAsset",
            destination_min: "int",
            paths: "list[StellarAsset] | None" = None,
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarPathPaymentStrictSendOp"]:
            return isinstance(msg, cls)

    class StellarManageSellOfferOp(protobuf.MessageType):
        source_account: "str | None"
        selling_asset: "StellarAsset"
        buying_asset: "StellarAsset"
        amount: "int"
        price_n: "int"
        price_d: "int"
        offer_id: "int"

        def __init__(
            self,
            *,
            selling_asset: "StellarAsset",
            buying_asset: "StellarAsset",
            amount: "int",
            price_n: "int",
            price_d: "int",
            offer_id: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarManageSellOfferOp"]:
            return isinstance(msg, cls)

    class StellarManageBuyOfferOp(protobuf.MessageType):
        source_account: "str | None"
        selling_asset: "StellarAsset"
        buying_asset: "StellarAsset"
        amount: "int"
        price_n: "int"
        price_d: "int"
        offer_id: "int"

        def __init__(
            self,
            *,
            selling_asset: "StellarAsset",
            buying_asset: "StellarAsset",
            amount: "int",
            price_n: "int",
            price_d: "int",
            offer_id: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarManageBuyOfferOp"]:
            return isinstance(msg, cls)

    class StellarCreatePassiveSellOfferOp(protobuf.MessageType):
        source_account: "str | None"
        selling_asset: "StellarAsset"
        buying_asset: "StellarAsset"
        amount: "int"
        price_n: "int"
        price_d: "int"

        def __init__(
            self,
            *,
            selling_asset: "StellarAsset",
            buying_asset: "StellarAsset",
            amount: "int",
            price_n: "int",
            price_d: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarCreatePassiveSellOfferOp"]:
            return isinstance(msg, cls)

    class StellarSetOptionsOp(protobuf.MessageType):
        source_account: "str | None"
        inflation_destination_account: "str | None"
        clear_flags: "int | None"
        set_flags: "int | None"
        master_weight: "int | None"
        low_threshold: "int | None"
        medium_threshold: "int | None"
        high_threshold: "int | None"
        home_domain: "str | None"
        signer_type: "StellarSignerType | None"
        signer_key: "bytes | None"
        signer_weight: "int | None"

        def __init__(
            self,
            *,
            source_account: "str | None" = None,
            inflation_destination_account: "str | None" = None,
            clear_flags: "int | None" = None,
            set_flags: "int | None" = None,
            master_weight: "int | None" = None,
            low_threshold: "int | None" = None,
            medium_threshold: "int | None" = None,
            high_threshold: "int | None" = None,
            home_domain: "str | None" = None,
            signer_type: "StellarSignerType | None" = None,
            signer_key: "bytes | None" = None,
            signer_weight: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarSetOptionsOp"]:
            return isinstance(msg, cls)

    class StellarChangeTrustOp(protobuf.MessageType):
        source_account: "str | None"
        asset: "StellarAsset"
        limit: "int"

        def __init__(
            self,
            *,
            asset: "StellarAsset",
            limit: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarChangeTrustOp"]:
            return isinstance(msg, cls)

    class StellarAllowTrustOp(protobuf.MessageType):
        source_account: "str | None"
        trusted_account: "str"
        asset_type: "StellarAssetType"
        asset_code: "str | None"
        is_authorized: "bool"

        def __init__(
            self,
            *,
            trusted_account: "str",
            asset_type: "StellarAssetType",
            is_authorized: "bool",
            source_account: "str | None" = None,
            asset_code: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarAllowTrustOp"]:
            return isinstance(msg, cls)

    class StellarAccountMergeOp(protobuf.MessageType):
        source_account: "str | None"
        destination_account: "str"

        def __init__(
            self,
            *,
            destination_account: "str",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarAccountMergeOp"]:
            return isinstance(msg, cls)

    class StellarManageDataOp(protobuf.MessageType):
        source_account: "str | None"
        key: "str"
        value: "bytes | None"

        def __init__(
            self,
            *,
            key: "str",
            source_account: "str | None" = None,
            value: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarManageDataOp"]:
            return isinstance(msg, cls)

    class StellarBumpSequenceOp(protobuf.MessageType):
        source_account: "str | None"
        bump_to: "int"

        def __init__(
            self,
            *,
            bump_to: "int",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarBumpSequenceOp"]:
            return isinstance(msg, cls)

    class StellarClaimClaimableBalanceOp(protobuf.MessageType):
        source_account: "str | None"
        balance_id: "bytes"

        def __init__(
            self,
            *,
            balance_id: "bytes",
            source_account: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarClaimClaimableBalanceOp"]:
            return isinstance(msg, cls)

    class StellarSignedTx(protobuf.MessageType):
        public_key: "bytes"
        signature: "bytes"

        def __init__(
            self,
            *,
            public_key: "bytes",
            signature: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["StellarSignedTx"]:
            return isinstance(msg, cls)

    class TezosGetAddress(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosGetAddress"]:
            return isinstance(msg, cls)

    class TezosAddress(protobuf.MessageType):
        address: "str"

        def __init__(
            self,
            *,
            address: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosAddress"]:
            return isinstance(msg, cls)

    class TezosGetPublicKey(protobuf.MessageType):
        address_n: "list[int]"
        show_display: "bool | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            address_n: "list[int] | None" = None,
            show_display: "bool | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosGetPublicKey"]:
            return isinstance(msg, cls)

    class TezosPublicKey(protobuf.MessageType):
        public_key: "str"

        def __init__(
            self,
            *,
            public_key: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosPublicKey"]:
            return isinstance(msg, cls)

    class TezosSignTx(protobuf.MessageType):
        address_n: "list[int]"
        branch: "bytes"
        reveal: "TezosRevealOp | None"
        transaction: "TezosTransactionOp | None"
        origination: "TezosOriginationOp | None"
        delegation: "TezosDelegationOp | None"
        proposal: "TezosProposalOp | None"
        ballot: "TezosBallotOp | None"
        chunkify: "bool | None"

        def __init__(
            self,
            *,
            branch: "bytes",
            address_n: "list[int] | None" = None,
            reveal: "TezosRevealOp | None" = None,
            transaction: "TezosTransactionOp | None" = None,
            origination: "TezosOriginationOp | None" = None,
            delegation: "TezosDelegationOp | None" = None,
            proposal: "TezosProposalOp | None" = None,
            ballot: "TezosBallotOp | None" = None,
            chunkify: "bool | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosSignTx"]:
            return isinstance(msg, cls)

    class TezosSignedTx(protobuf.MessageType):
        signature: "str"
        sig_op_contents: "bytes"
        operation_hash: "str"

        def __init__(
            self,
            *,
            signature: "str",
            sig_op_contents: "bytes",
            operation_hash: "str",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosSignedTx"]:
            return isinstance(msg, cls)

    class TezosContractID(protobuf.MessageType):
        tag: "TezosContractType"
        hash: "bytes"

        def __init__(
            self,
            *,
            tag: "TezosContractType",
            hash: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosContractID"]:
            return isinstance(msg, cls)

    class TezosRevealOp(protobuf.MessageType):
        source: "bytes"
        fee: "int"
        counter: "int"
        gas_limit: "int"
        storage_limit: "int"
        public_key: "bytes"

        def __init__(
            self,
            *,
            source: "bytes",
            fee: "int",
            counter: "int",
            gas_limit: "int",
            storage_limit: "int",
            public_key: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosRevealOp"]:
            return isinstance(msg, cls)

    class TezosTransactionOp(protobuf.MessageType):
        source: "bytes"
        fee: "int"
        counter: "int"
        gas_limit: "int"
        storage_limit: "int"
        amount: "int"
        destination: "TezosContractID"
        parameters: "bytes | None"
        parameters_manager: "TezosParametersManager | None"

        def __init__(
            self,
            *,
            source: "bytes",
            fee: "int",
            counter: "int",
            gas_limit: "int",
            storage_limit: "int",
            amount: "int",
            destination: "TezosContractID",
            parameters: "bytes | None" = None,
            parameters_manager: "TezosParametersManager | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosTransactionOp"]:
            return isinstance(msg, cls)

    class TezosOriginationOp(protobuf.MessageType):
        source: "bytes"
        fee: "int"
        counter: "int"
        gas_limit: "int"
        storage_limit: "int"
        manager_pubkey: "bytes | None"
        balance: "int"
        spendable: "bool | None"
        delegatable: "bool | None"
        delegate: "bytes | None"
        script: "bytes"

        def __init__(
            self,
            *,
            source: "bytes",
            fee: "int",
            counter: "int",
            gas_limit: "int",
            storage_limit: "int",
            balance: "int",
            script: "bytes",
            manager_pubkey: "bytes | None" = None,
            spendable: "bool | None" = None,
            delegatable: "bool | None" = None,
            delegate: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosOriginationOp"]:
            return isinstance(msg, cls)

    class TezosDelegationOp(protobuf.MessageType):
        source: "bytes"
        fee: "int"
        counter: "int"
        gas_limit: "int"
        storage_limit: "int"
        delegate: "bytes"

        def __init__(
            self,
            *,
            source: "bytes",
            fee: "int",
            counter: "int",
            gas_limit: "int",
            storage_limit: "int",
            delegate: "bytes",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosDelegationOp"]:
            return isinstance(msg, cls)

    class TezosProposalOp(protobuf.MessageType):
        source: "bytes"
        period: "int"
        proposals: "list[bytes]"

        def __init__(
            self,
            *,
            source: "bytes",
            period: "int",
            proposals: "list[bytes] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosProposalOp"]:
            return isinstance(msg, cls)

    class TezosBallotOp(protobuf.MessageType):
        source: "bytes"
        period: "int"
        proposal: "bytes"
        ballot: "TezosBallotType"

        def __init__(
            self,
            *,
            source: "bytes",
            period: "int",
            proposal: "bytes",
            ballot: "TezosBallotType",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosBallotOp"]:
            return isinstance(msg, cls)

    class TezosParametersManager(protobuf.MessageType):
        set_delegate: "bytes | None"
        cancel_delegate: "bool | None"
        transfer: "TezosManagerTransfer | None"

        def __init__(
            self,
            *,
            set_delegate: "bytes | None" = None,
            cancel_delegate: "bool | None" = None,
            transfer: "TezosManagerTransfer | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosParametersManager"]:
            return isinstance(msg, cls)

    class TezosManagerTransfer(protobuf.MessageType):
        destination: "TezosContractID"
        amount: "int"

        def __init__(
            self,
            *,
            destination: "TezosContractID",
            amount: "int",
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["TezosManagerTransfer"]:
            return isinstance(msg, cls)

    class ThpCredentialMetadata(protobuf.MessageType):
        host_name: "str | None"

        def __init__(
            self,
            *,
            host_name: "str | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ThpCredentialMetadata"]:
            return isinstance(msg, cls)

    class ThpPairingCredential(protobuf.MessageType):
        cred_metadata: "ThpCredentialMetadata | None"
        mac: "bytes | None"

        def __init__(
            self,
            *,
            cred_metadata: "ThpCredentialMetadata | None" = None,
            mac: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ThpPairingCredential"]:
            return isinstance(msg, cls)

    class ThpAuthenticatedCredentialData(protobuf.MessageType):
        host_static_pubkey: "bytes | None"
        cred_metadata: "ThpCredentialMetadata | None"

        def __init__(
            self,
            *,
            host_static_pubkey: "bytes | None" = None,
            cred_metadata: "ThpCredentialMetadata | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["ThpAuthenticatedCredentialData"]:
            return isinstance(msg, cls)

    class WebAuthnListResidentCredentials(protobuf.MessageType):

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WebAuthnListResidentCredentials"]:
            return isinstance(msg, cls)

    class WebAuthnAddResidentCredential(protobuf.MessageType):
        credential_id: "bytes | None"

        def __init__(
            self,
            *,
            credential_id: "bytes | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WebAuthnAddResidentCredential"]:
            return isinstance(msg, cls)

    class WebAuthnRemoveResidentCredential(protobuf.MessageType):
        index: "int | None"

        def __init__(
            self,
            *,
            index: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WebAuthnRemoveResidentCredential"]:
            return isinstance(msg, cls)

    class WebAuthnCredentials(protobuf.MessageType):
        credentials: "list[WebAuthnCredential]"

        def __init__(
            self,
            *,
            credentials: "list[WebAuthnCredential] | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WebAuthnCredentials"]:
            return isinstance(msg, cls)

    class WebAuthnCredential(protobuf.MessageType):
        index: "int | None"
        id: "bytes | None"
        rp_id: "str | None"
        rp_name: "str | None"
        user_id: "bytes | None"
        user_name: "str | None"
        user_display_name: "str | None"
        creation_time: "int | None"
        hmac_secret: "bool | None"
        use_sign_count: "bool | None"
        algorithm: "int | None"
        curve: "int | None"

        def __init__(
            self,
            *,
            index: "int | None" = None,
            id: "bytes | None" = None,
            rp_id: "str | None" = None,
            rp_name: "str | None" = None,
            user_id: "bytes | None" = None,
            user_name: "str | None" = None,
            user_display_name: "str | None" = None,
            creation_time: "int | None" = None,
            hmac_secret: "bool | None" = None,
            use_sign_count: "bool | None" = None,
            algorithm: "int | None" = None,
            curve: "int | None" = None,
        ) -> None:
            pass

        @classmethod
        def is_type_of(cls, msg: Any) -> TypeGuard["WebAuthnCredential"]:
            return isinstance(msg, cls)
