/*
 * This file is part of the Trezor project, https://trezor.io/
 *
 * Copyright (c) SatoshiLabs
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TREZORHAL_NPM1300_DEFS_H
#define TREZORHAL_NPM1300_DEFS_H

// I2C address of the NPM1300 on the I2C bus.
#define NPM1300_I2C_ADDRESS 0x6B

// Event and interrupt registers

#define NPM1300_TASKSWRESET 0x0001
#define NPM1300_EVENTSADCSET 0x0002
#define NPM1300_EVENTSADCCLR 0x0003
#define NPM1300_INTENEVENTSADCSET 0x0004
#define NPM1300_INTENEVENTSADCCLR 0x0005
#define NPM1300_EVENTSBCHARGER0SET 0x0006
#define NPM1300_EVENTSBCHARGER0CLR 0x0007
#define NPM1300_INTENEVENTSBCHARGER0SET 0x0008
#define NPM1300_INTENEVENTSBCHARGER0CLR 0x0009
#define NPM1300_EVENTSBCHARGER1SET 0x000A
#define NPM1300_EVENTSBCHARGER1CLR 0x000B
#define NPM1300_INTENEVENTSBCHARGER1SET 0x000C
#define NPM1300_INTENEVENTSBCHARGER1CLR 0x000D
#define NPM1300_EVENTSBCHARGER2SET 0x000E
#define NPM1300_EVENTSBCHARGER2CLR 0x000F
#define NPM1300_INTENEVENTSBCHARGER2SET 0x0010
#define NPM1300_INTENEVENTSBCHARGER2CLR 0x0011
#define NPM1300_EVENTSSHPHLDSET 0x0012
#define NPM1300_EVENTSSHPHLDCLR 0x0013
#define NPM1300_INTENEVENTSSHPHLDSET 0x0014
#define NPM1300_INTENEVENTSSHPHLDCLR 0x0015
#define NPM1300_EVENTSVBUSIN0SET 0x0016
#define NPM1300_EVENTSVBUSIN0CLR 0x0017
#define NPM1300_INTENEVENTSVBUSIN0SET 0x0018
#define NPM1300_INTENEVENTSVBUSIN0CLR 0x0019
#define NPM1300_EVENTSVBUSIN1SET 0x001A
#define NPM1300_EVENTSVBUSIN1CLR 0x001B
#define NPM1300_INTENEVENTSVBUSIN1SET 0x001C
#define NPM1300_INTENEVENTSVBUSIN1CLR 0x001D
#define NPM1300_EVENTSGPIOSET 0x0022
#define NPM1300_EVENTSGPIOCLR 0x0023
#define NPM1300_INTENEVENTSGPIOSET 0x0024
#define NPM1300_INTENEVENTSGPIOCLR 0x0025

// SYSREG registers

#define NPM1300_TASKUPDATEILIMSW 0x0200
#define NPM1300_VBUSINILIM0 0x0201
#define NPM1300_VBUSINILIMSTARTUP 0x0202
#define NPM1300_VBUSSUSPEND 0x0203
#define NPM1300_USBCDETECTSTATUS 0x0205
#define NPM1300_VBUSINSTATUS 0x0207

// Charger registers

#define NPM1300_TASKRELEASEERR 0x0300
#define NPM1300_TASKCLEARCHGERR 0x0301
#define NPM1300_TASKCLEARSAFETYTIMER 0x0302
#define NPM1300_BCHGENABLESET 0x0304
#define NPM1300_BCHGENABLECLR 0x0305
#define NPM1300_BCHGDISABLESET 0x0306
#define NPM1300_BCHGDISABLECLR 0x0307
#define NPM1300_BCHGISETMSB 0x0308
#define NPM1300_BCHGISETLSB 0x0309
#define NPM1300_BCHGISETDISCHARGEMSB 0x030A
#define NPM1300_BCHGISETDISCHARGELSB 0x030B
#define NPM1300_BCHGVTERM 0x030C
#define NPM1300_BCHGVTERMR 0x030D
#define NPM1300_BCHGVTRICKLESEL 0x030E
#define NPM1300_BCHGITERMSEL 0x030F
#define NPM1300_NTCCOLD 0x0310
#define NPM1300_NTCCOLDLSB 0x0311
#define NPM1300_NTCCOOL 0x0312
#define NPM1300_NTCCOOLLSB 0x0313
#define NPM1300_NTCWARM 0x0314
#define NPM1300_NTCWARMLSB 0x0315
#define NPM1300_NTCHOT 0x0316
#define NPM1300_NTCHOTLSB 0x0317
#define NPM1300_DIETEMPSTOP 0x0318
#define NPM1300_DIETEMPSTOPLSB 0x0319
#define NPM1300_DIETEMPRESUME 0x031A
#define NPM1300_DIETEMPRESUMELSB 0x031B
#define NPM1300_BCHGILIMSTATUS 0x032D
#define NPM1300_NTCSTATUS 0x0332
#define NPM1300_DIETEMPSTATUS 0x0333
#define NPM1300_BCHGCHARGESTATUS 0x0334
#define NPM1300_BCHGERRREASON 0x0336
#define NPM1300_BCHGERRSENSOR 0x0337
#define NPM1300_BCHGCONFIG 0x033C

// Buck regulator registers

#define NPM1300_BUCK1ENASET 0x0400
#define NPM1300_BUCK1ENACLR 0x0401
#define NPM1300_BUCK2ENASET 0x0402
#define NPM1300_BUCK2ENACLR 0x0403
#define NPM1300_BUCK1PWMSET 0x0404
#define NPM1300_BUCK1PWMCLR 0x0405
#define NPM1300_BUCK2PWMSET 0x0406
#define NPM1300_BUCK2PWMCLR 0x0407
#define NPM1300_BUCK1NORMVOUT 0x0408
#define NPM1300_BUCK1RETVOUT 0x0409
#define NPM1300_BUCK2NORMVOUT 0x040A
#define NPM1300_BUCK2RETVOUT 0x040B
#define NPM1300_BUCKENCTRL 0x040C
#define NPM1300_BUCKVRETCTRL 0x040D
#define NPM1300_BUCKPWMCTRL 0x040E
#define NPM1300_BUCKSWCTRLSEL 0x040F
#define NPM1300_BUCK1VOUTSTATUS 0x0410
#define NPM1300_BUCK2VOUTSTATUS 0x0411
#define NPM1300_BUCKCTRL0 0x0415
#define NPM1300_BUCKSTATUS 0x0434

// System monitor registers

#define NPM1300_TASKVBATMEASURE 0x0500
#define NPM1300_TASKNTCMEASURE 0x0501
#define NPM1300_TASKTEMPMEASURE 0x0502
#define NPM1300_TASKVSYSMEASURE 0x0503
#define NPM1300_TASKIBATMEASURE 0x0506
#define NPM1300_TASKVBUS7MEASURE 0x0507
#define NPM1300_TASKDELAYEDVBATMEASURE 0x0508
#define NPM1300_ADCCONFIG 0x0509
#define NPM1300_ADCNTCRSEL 0x050A
#define NPM1300_ADCAUTOTIMCONF 0x050B
#define NPM1300_TASKAUTOTIMUPDATE 0x050C
#define NPM1300_ADCDELTIMCONF 0x050D
#define NPM1300_ADCIBATMEASSTATUS 0x0510
#define NPM1300_ADCVBATRESULTMSB 0x0511
#define NPM1300_ADCNTCRESULTMSB 0x0512
#define NPM1300_ADCTEMPRESULTMSB 0x0513
#define NPM1300_ADCVSYSRESULTMSB 0x0514
#define NPM1300_ADCGP0RESULTLSBS 0x0515
#define NPM1300_ADCVBAT0RESULTMSB 0x0516
#define NPM1300_ADCVBAT1RESULTMSB 0x0517
#define NPM1300_ADCVBAT2RESULTMSB 0x0518
#define NPM1300_ADCVBAT3RESULTMSB 0x0519
#define NPM1300_ADCGP1RESULTLSBS 0x051A
#define NPM1300_ADCIBATMEASEN 0x0524

// GPIO registers

#define NPM1300_GPIOMODE0 0x0600
#define NPM1300_GPIOMODE1 0x0601
#define NPM1300_GPIOMODE2 0x0602
#define NPM1300_GPIOMODE3 0x0603
#define NPM1300_GPIOMODE4 0x0604
#define NPM1300_GPIODRIVE0 0x0605
#define NPM1300_GPIODRIVE1 0x0606
#define NPM1300_GPIODRIVE2 0x0607
#define NPM1300_GPIODRIVE3 0x0608
#define NPM1300_GPIODRIVE4 0x0609
#define NPM1300_GPIOPUEN0 0x060A
#define NPM1300_GPIOPUEN1 0x060B
#define NPM1300_GPIOPUEN2 0x060C
#define NPM1300_GPIOPUEN3 0x060D
#define NPM1300_GPIOPUEN4 0x060E
#define NPM1300_GPIOPDEN0 0x060F
#define NPM1300_GPIOPDEN1 0x0610
#define NPM1300_GPIOPDEN2 0x0611
#define NPM1300_GPIOPDEN3 0x0612
#define NPM1300_GPIOPDEN4 0x0613
#define NPM1300_GPIOOPENDRAIN0 0x0614
#define NPM1300_GPIOOPENDRAIN1 0x0615
#define NPM1300_GPIOOPENDRAIN2 0x0616
#define NPM1300_GPIOOPENDRAIN3 0x0617
#define NPM1300_GPIOOPENDRAIN4 0x0618
#define NPM1300_GPIODEBOUNCE0 0x0619
#define NPM1300_GPIODEBOUNCE1 0x061A
#define NPM1300_GPIODEBOUNCE2 0x061B
#define NPM1300_GPIODEBOUNCE3 0x061C
#define NPM1300_GPIODEBOUNCE4 0x061D
#define NPM1300_GPIOSTATUS 0x061E

// Timer registers

#define NPM1300_TIMERSET 0x0700
#define NPM1300_TIMERCLR 0x0701
#define NPM1300_TIMERTARGETSTROBE 0x0703
#define NPM1300_WATCHDOGKICK 0x0704
#define NPM1300_TIMERCONFIG 0x0705
#define NPM1300_TIMERSTATUS 0x0706
#define NPM1300_TIMERHIBYTE 0x0708
#define NPM1300_TIMERMIDBYTE 0x0709
#define NPM1300_TIMERLOBYTE 0x070A

// LOADSW/LDO registers

#define NPM1300_TASKLDSW1SET 0x0800
#define NPM1300_TASKLDSW1CLR 0x0801
#define NPM1300_TASKLDSW2SET 0x0802
#define NPM1300_TASKLDSW2CLR 0x0803
#define NPM1300_LDSWSTATUS 0x0804
#define NPM1300_LDSW1GPISEL 0x0805
#define NPM1300_LDSW2GPISEL 0x0806
#define NPM1300_LDSWCONFIG 0x0807
#define NPM1300_LDSW1LDOSEL 0x0808
#define NPM1300_LDSW2LDOSEL 0x0809
#define NPM1300_LDSW1VOUTSEL 0x080C
#define NPM1300_LDSW2VOUTSEL 0x080D

// POF registers

#define NPM1300_POFCONFIG 0x0900

// LED registers

#define NPM1300_LEDDRV0MODESEL 0x0A00
#define NPM1300_LEDDRV1MODESEL 0x0A01
#define NPM1300_LEDDRV2MODESEL 0x0A02
#define NPM1300_LEDDRV0SET 0x0A03
#define NPM1300_LEDDRV0CLR 0x0A04
#define NPM1300_LEDDRV1SET 0x0A05
#define NPM1300_LEDDRV1CLR 0x0A06
#define NPM1300_LEDDRV2SET 0x0A07
#define NPM1300_LEDDRV2CLR 0x0A08

// Reset and hibernation mode registers

#define NPM1300_TASKENTERHIBERNATE 0x0B00
#define NPM1300_TASKSHPHLDCFGSTROBE 0x0B01
#define NPM1300_TASKENTERSHIPMODE 0x0B02
#define NPM1300_TASKRESETCFG 0x0B03
#define NPM1300_SHPHLDCONFIG 0x0B04
#define NPM1300_SHPHLDSTATUS 0x0B05
#define NPM1300_LPRESETCONFIG 0x0B06

// Reset and error registers

#define NPM1300_TASKCLRERRLOG 0x0E00
#define NPM1300_SCRATCH0 0x0E01
#define NPM1300_SCRATCH1 0x0E02
#define NPM1300_RSTCAUSE 0x0E03
#define NPM1300_CHARGERERRREASON 0x0E04
#define NPM1300_CHARGERERRSENSOR 0x0E05

// ------------------------------------------------------

// TASKSWRESET
#define NPM1300_TASKSWRESET_TRIGGER 0x01

// TASKUPDATEILIM
#define NPM1300_TASKUPDATEILIM_SELVBUSILIM0 1

// VBUSINILIM0
#define NPM1300_VBUSINILIM0_500MA 5  // Default

// BCHGENABLESET
#define NPM1300_BCHGENABLESET_ENABLECHG 0x01

// BCHGENABLECLR
#define NPM1300_BCHGENABLECLR_DISABLECHG 0x01

// BGCDISABLECLR
#define NPM1300_BCHGDISABLECLR_ENABLERCHRG 0x01
#define NPM1300_BCHGDISABLECLR_USENTC 0x02

// BCHGVTERM, BCHGVTERMR
#define NPM1300_BCHGVTERM_3V60 2  // Default
#define NPM1300_BCHGVTERM_3V65 3

// ADCCONFIG
#define NPM1300_ADCCONFIG_AUTOENABLE 0x01
#define NPM1300_ADCCONFIG_BURSTMODE 0x02

// ADCNTCRSEL
#define NPM1300_ADCNTCRSEL_HI_Z 0
#define NPM1300_ADCNTCRSEL_10K 1  // Default
#define NPM1300_ADCNTCRSEL_47K 2
#define NPM1300_ADCNTCRSEL_100K 3

// ADCIBATMEASEN
#define NPM1300_ADCIBATMEASEN_IBATMEASENABLE 0x01

// BCHGVTRICKLESEL
#define NPM1300_BCHGVTRICKLESEL_2V9 0  // Default
#define NPM1300_BCHGVTRICKLESEL_2V5 1

// BCHGITERMSEL
#define NPM1300_BCHGITERMSEL_SEL10 0  // Default
#define NPM1300_BCHGITERMSEL_SEL20 1

// LEDDRVxMODESEL

#define NPM1300_LEDDRVMODESEL_ERROR 0x00
#define NPM1300_LEDDRVMODESEL_CHARGING 0x01
#define NPM1300_LEDDRVMODESEL_HOST 0x02
#define NPM1300_LEDDRVMODESEL_NOTUSED 0x03

// GPIOMODEx

#define NPM1300_GPIOMODE_GPIINPUT 0x00
#define NPM1300_GPIOMODE_GPILOGIC1 0x01
#define NPM1300_GPIOMODE_GPILOGIC0 0x02
#define NPM1300_GPIOMODE_GPIEVENTRISE 0x03
#define NPM1300_GPIOMODE_GPIEVENTFALL 0x04
#define NPM1300_GPIOMODE_GPOIRQ 0x05
#define NPM1300_GPIOMODE_GPORESET 0x06
#define NPM1300_GPIOMODE_GPOPLW 0x07
#define NPM1300_GPIOMODE_GPOLOGIC1 0x08
#define NPM1300_GPIOMODE_GPOLOGIC9 0x09

#endif  // TREZORHAL_NPM1300_DEFS_H
