#[cfg(feature = "translations")]
mod address_details;
pub mod bl_confirm;
mod button;
#[cfg(feature = "translations")]
mod coinjoin_progress;
mod dialog;
mod fido;
#[rustfmt::skip]
mod fido_icons;
mod error;
mod frame;
#[cfg(feature = "micropython")]
mod homescreen;
mod keyboard;
mod loader;
#[cfg(feature = "translations")]
mod number_input;
pub mod number_input_slider;
#[cfg(feature = "translations")]
mod page;
mod progress;
mod result;
mod scroll;
mod set_brightness;
mod simple_page;
mod swipe;
mod welcome_screen;

#[cfg(feature = "translations")]
pub use address_details::AddressDetails;
pub use button::{
    Button, ButtonContent, ButtonMsg, ButtonStyle, ButtonStyleSheet, CancelConfirmMsg,
    CancelInfoConfirmMsg, IconText, SelectWordMsg,
};
#[cfg(feature = "translations")]
pub use coinjoin_progress::CoinJoinProgress;
pub use dialog::{Dialog, DialogMsg, IconDialog};
pub use error::ErrorScreen;
pub use fido::{FidoConfirm, FidoMsg};
pub use frame::{Frame, FrameMsg};
#[cfg(feature = "micropython")]
pub use homescreen::{check_homescreen_format, Homescreen, HomescreenMsg, Lockscreen};
pub use keyboard::{
    bip39::Bip39Input,
    mnemonic::{MnemonicInput, MnemonicKeyboard, MnemonicKeyboardMsg},
    passphrase::{PassphraseKeyboard, PassphraseKeyboardMsg},
    pin::{PinKeyboard, PinKeyboardMsg},
    slip39::Slip39Input,
    word_count::{SelectWordCount, SelectWordCountMsg},
};
pub use loader::{Loader, LoaderMsg, LoaderStyle, LoaderStyleSheet};
#[cfg(feature = "translations")]
pub use number_input::{NumberInputDialog, NumberInputDialogMsg};
pub use number_input_slider::NumberInputSliderDialog;
#[cfg(feature = "translations")]
pub use page::ButtonPage;
pub use progress::Progress;
pub use result::{ResultFooter, ResultScreen, ResultStyle};
pub use scroll::ScrollBar;
pub use set_brightness::SetBrightnessDialog;
pub use simple_page::SimplePage;
pub use swipe::{Swipe, SwipeDirection};
pub use welcome_screen::WelcomeScreen;

use super::theme;
