/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * File Name          : gfxmmu_lut.h
 * Description        : header file for GFX MMU Configuration Table
 ******************************************************************************
 * @attention
 *
 * Copyright (c) 2022 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */
/* USER CODE END Header */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __gfxmmu_lut_H
#define __gfxmmu_lut_H
#ifdef __cplusplus
extern "C" {
#endif
// GFX MMU Configuration Table

#define GFXMMU_FB_SIZE 733936
#define GFXMMU_LUT_FIRST 0
#define GFXMMU_LUT_LAST 479
#define GFXMMU_LUT_SIZE 480

static const uint32_t gfxmmu_lut_config[2 * GFXMMU_LUT_SIZE] = {
    0x00413601,  // GFXMMU_LUT0L
    0x003FFCA0,  // GFXMMU_LUT0H
    0x00433401,  // GFXMMU_LUT1L
    0x003FFD80,  // GFXMMU_LUT1H
    0x00453201,  // GFXMMU_LUT2L
    0x003FFEA0,  // GFXMMU_LUT2H
    0x00463101,  // GFXMMU_LUT3L
    0x003FFFF0,  // GFXMMU_LUT3H
    0x00482F01,  // GFXMMU_LUT4L
    0x00000170,  // GFXMMU_LUT4H
    0x00492E01,  // GFXMMU_LUT5L
    0x00000320,  // GFXMMU_LUT5H
    0x004A2D01,  // GFXMMU_LUT6L
    0x000004F0,  // GFXMMU_LUT6H
    0x004B2C01,  // GFXMMU_LUT7L
    0x000006E0,  // GFXMMU_LUT7H
    0x004C2B01,  // GFXMMU_LUT8L
    0x000008F0,  // GFXMMU_LUT8H
    0x004D2A01,  // GFXMMU_LUT9L
    0x00000B20,  // GFXMMU_LUT9H
    0x004D2A01,  // GFXMMU_LUT10L
    0x00000D60,  // GFXMMU_LUT10H
    0x004E2901,  // GFXMMU_LUT11L
    0x00000FB0,  // GFXMMU_LUT11H
    0x004F2801,  // GFXMMU_LUT12L
    0x00001220,  // GFXMMU_LUT12H
    0x00502701,  // GFXMMU_LUT13L
    0x000014B0,  // GFXMMU_LUT13H
    0x00502701,  // GFXMMU_LUT14L
    0x00001750,  // GFXMMU_LUT14H
    0x00512601,  // GFXMMU_LUT15L
    0x00001A00,  // GFXMMU_LUT15H
    0x00522501,  // GFXMMU_LUT16L
    0x00001CD0,  // GFXMMU_LUT16H
    0x00522501,  // GFXMMU_LUT17L
    0x00001FB0,  // GFXMMU_LUT17H
    0x00532401,  // GFXMMU_LUT18L
    0x000022A0,  // GFXMMU_LUT18H
    0x00532401,  // GFXMMU_LUT19L
    0x000025A0,  // GFXMMU_LUT19H
    0x00542301,  // GFXMMU_LUT20L
    0x000028B0,  // GFXMMU_LUT20H
    0x00552201,  // GFXMMU_LUT21L
    0x00002BE0,  // GFXMMU_LUT21H
    0x00552201,  // GFXMMU_LUT22L
    0x00002F20,  // GFXMMU_LUT22H
    0x00562101,  // GFXMMU_LUT23L
    0x00003270,  // GFXMMU_LUT23H
    0x00562101,  // GFXMMU_LUT24L
    0x000035D0,  // GFXMMU_LUT24H
    0x00572001,  // GFXMMU_LUT25L
    0x00003940,  // GFXMMU_LUT25H
    0x00572001,  // GFXMMU_LUT26L
    0x00003CC0,  // GFXMMU_LUT26H
    0x00581F01,  // GFXMMU_LUT27L
    0x00004050,  // GFXMMU_LUT27H
    0x00581F01,  // GFXMMU_LUT28L
    0x000043F0,  // GFXMMU_LUT28H
    0x00591E01,  // GFXMMU_LUT29L
    0x000047A0,  // GFXMMU_LUT29H
    0x00591E01,  // GFXMMU_LUT30L
    0x00004B60,  // GFXMMU_LUT30H
    0x00591E01,  // GFXMMU_LUT31L
    0x00004F20,  // GFXMMU_LUT31H
    0x005A1D01,  // GFXMMU_LUT32L
    0x000052F0,  // GFXMMU_LUT32H
    0x005A1D01,  // GFXMMU_LUT33L
    0x000056D0,  // GFXMMU_LUT33H
    0x005B1C01,  // GFXMMU_LUT34L
    0x00005AC0,  // GFXMMU_LUT34H
    0x005B1C01,  // GFXMMU_LUT35L
    0x00005EC0,  // GFXMMU_LUT35H
    0x005C1B01,  // GFXMMU_LUT36L
    0x000062D0,  // GFXMMU_LUT36H
    0x005C1B01,  // GFXMMU_LUT37L
    0x000066F0,  // GFXMMU_LUT37H
    0x005C1B01,  // GFXMMU_LUT38L
    0x00006B10,  // GFXMMU_LUT38H
    0x005D1A01,  // GFXMMU_LUT39L
    0x00006F40,  // GFXMMU_LUT39H
    0x005D1A01,  // GFXMMU_LUT40L
    0x00007380,  // GFXMMU_LUT40H
    0x005D1A01,  // GFXMMU_LUT41L
    0x000077C0,  // GFXMMU_LUT41H
    0x005E1901,  // GFXMMU_LUT42L
    0x00007C10,  // GFXMMU_LUT42H
    0x005E1901,  // GFXMMU_LUT43L
    0x00008070,  // GFXMMU_LUT43H
    0x005E1901,  // GFXMMU_LUT44L
    0x000084D0,  // GFXMMU_LUT44H
    0x005F1801,  // GFXMMU_LUT45L
    0x00008940,  // GFXMMU_LUT45H
    0x005F1801,  // GFXMMU_LUT46L
    0x00008DC0,  // GFXMMU_LUT46H
    0x00601801,  // GFXMMU_LUT47L
    0x00009240,  // GFXMMU_LUT47H
    0x00601701,  // GFXMMU_LUT48L
    0x000096E0,  // GFXMMU_LUT48H
    0x00601701,  // GFXMMU_LUT49L
    0x00009B80,  // GFXMMU_LUT49H
    0x00601701,  // GFXMMU_LUT50L
    0x0000A020,  // GFXMMU_LUT50H
    0x00611601,  // GFXMMU_LUT51L
    0x0000A4D0,  // GFXMMU_LUT51H
    0x00611601,  // GFXMMU_LUT52L
    0x0000A990,  // GFXMMU_LUT52H
    0x00611601,  // GFXMMU_LUT53L
    0x0000AE50,  // GFXMMU_LUT53H
    0x00621501,  // GFXMMU_LUT54L
    0x0000B320,  // GFXMMU_LUT54H
    0x00621501,  // GFXMMU_LUT55L
    0x0000B800,  // GFXMMU_LUT55H
    0x00621501,  // GFXMMU_LUT56L
    0x0000BCE0,  // GFXMMU_LUT56H
    0x00631401,  // GFXMMU_LUT57L
    0x0000C1D0,  // GFXMMU_LUT57H
    0x00631401,  // GFXMMU_LUT58L
    0x0000C6D0,  // GFXMMU_LUT58H
    0x00631401,  // GFXMMU_LUT59L
    0x0000CBD0,  // GFXMMU_LUT59H
    0x00631401,  // GFXMMU_LUT60L
    0x0000D0D0,  // GFXMMU_LUT60H
    0x00641301,  // GFXMMU_LUT61L
    0x0000D5E0,  // GFXMMU_LUT61H
    0x00641301,  // GFXMMU_LUT62L
    0x0000DB00,  // GFXMMU_LUT62H
    0x00641301,  // GFXMMU_LUT63L
    0x0000E020,  // GFXMMU_LUT63H
    0x00651201,  // GFXMMU_LUT64L
    0x0000E550,  // GFXMMU_LUT64H
    0x00651201,  // GFXMMU_LUT65L
    0x0000EA90,  // GFXMMU_LUT65H
    0x00651201,  // GFXMMU_LUT66L
    0x0000EFD0,  // GFXMMU_LUT66H
    0x00651201,  // GFXMMU_LUT67L
    0x0000F510,  // GFXMMU_LUT67H
    0x00661101,  // GFXMMU_LUT68L
    0x0000FA60,  // GFXMMU_LUT68H
    0x00661101,  // GFXMMU_LUT69L
    0x0000FFC0,  // GFXMMU_LUT69H
    0x00661101,  // GFXMMU_LUT70L
    0x00010520,  // GFXMMU_LUT70H
    0x00661101,  // GFXMMU_LUT71L
    0x00010A80,  // GFXMMU_LUT71H
    0x00671001,  // GFXMMU_LUT72L
    0x00010FF0,  // GFXMMU_LUT72H
    0x00671001,  // GFXMMU_LUT73L
    0x00011570,  // GFXMMU_LUT73H
    0x00671001,  // GFXMMU_LUT74L
    0x00011AF0,  // GFXMMU_LUT74H
    0x00671001,  // GFXMMU_LUT75L
    0x00012070,  // GFXMMU_LUT75H
    0x00680F01,  // GFXMMU_LUT76L
    0x00012600,  // GFXMMU_LUT76H
    0x00680F01,  // GFXMMU_LUT77L
    0x00012BA0,  // GFXMMU_LUT77H
    0x00680F01,  // GFXMMU_LUT78L
    0x00013140,  // GFXMMU_LUT78H
    0x00680F01,  // GFXMMU_LUT79L
    0x000136E0,  // GFXMMU_LUT79H
    0x00680F01,  // GFXMMU_LUT80L
    0x00013C80,  // GFXMMU_LUT80H
    0x00690E01,  // GFXMMU_LUT81L
    0x00014230,  // GFXMMU_LUT81H
    0x00690E01,  // GFXMMU_LUT82L
    0x000147F0,  // GFXMMU_LUT82H
    0x00690E01,  // GFXMMU_LUT83L
    0x00014DB0,  // GFXMMU_LUT83H
    0x00690E01,  // GFXMMU_LUT84L
    0x00015370,  // GFXMMU_LUT84H
    0x006A0D01,  // GFXMMU_LUT85L
    0x00015940,  // GFXMMU_LUT85H
    0x006A0D01,  // GFXMMU_LUT86L
    0x00015F20,  // GFXMMU_LUT86H
    0x006A0D01,  // GFXMMU_LUT87L
    0x00016500,  // GFXMMU_LUT87H
    0x006A0D01,  // GFXMMU_LUT88L
    0x00016AE0,  // GFXMMU_LUT88H
    0x006A0D01,  // GFXMMU_LUT89L
    0x000170C0,  // GFXMMU_LUT89H
    0x006B0C01,  // GFXMMU_LUT90L
    0x000176B0,  // GFXMMU_LUT90H
    0x006B0C01,  // GFXMMU_LUT91L
    0x00017CB0,  // GFXMMU_LUT91H
    0x006B0C01,  // GFXMMU_LUT92L
    0x000182B0,  // GFXMMU_LUT92H
    0x006B0C01,  // GFXMMU_LUT93L
    0x000188B0,  // GFXMMU_LUT93H
    0x006B0C01,  // GFXMMU_LUT94L
    0x00018EB0,  // GFXMMU_LUT94H
    0x006C0C01,  // GFXMMU_LUT95L
    0x000194B0,  // GFXMMU_LUT95H
    0x006C0B01,  // GFXMMU_LUT96L
    0x00019AD0,  // GFXMMU_LUT96H
    0x006C0B01,  // GFXMMU_LUT97L
    0x0001A0F0,  // GFXMMU_LUT97H
    0x006C0B01,  // GFXMMU_LUT98L
    0x0001A710,  // GFXMMU_LUT98H
    0x006C0B01,  // GFXMMU_LUT99L
    0x0001AD30,  // GFXMMU_LUT99H
    0x006C0B01,  // GFXMMU_LUT100L
    0x0001B350,  // GFXMMU_LUT100H
    0x006D0A01,  // GFXMMU_LUT101L
    0x0001B980,  // GFXMMU_LUT101H
    0x006D0A01,  // GFXMMU_LUT102L
    0x0001BFC0,  // GFXMMU_LUT102H
    0x006D0A01,  // GFXMMU_LUT103L
    0x0001C600,  // GFXMMU_LUT103H
    0x006D0A01,  // GFXMMU_LUT104L
    0x0001CC40,  // GFXMMU_LUT104H
    0x006D0A01,  // GFXMMU_LUT105L
    0x0001D280,  // GFXMMU_LUT105H
    0x006D0A01,  // GFXMMU_LUT106L
    0x0001D8C0,  // GFXMMU_LUT106H
    0x006E0901,  // GFXMMU_LUT107L
    0x0001DF10,  // GFXMMU_LUT107H
    0x006E0901,  // GFXMMU_LUT108L
    0x0001E570,  // GFXMMU_LUT108H
    0x006E0901,  // GFXMMU_LUT109L
    0x0001EBD0,  // GFXMMU_LUT109H
    0x006E0901,  // GFXMMU_LUT110L
    0x0001F230,  // GFXMMU_LUT110H
    0x006E0901,  // GFXMMU_LUT111L
    0x0001F890,  // GFXMMU_LUT111H
    0x006E0901,  // GFXMMU_LUT112L
    0x0001FEF0,  // GFXMMU_LUT112H
    0x006F0801,  // GFXMMU_LUT113L
    0x00020560,  // GFXMMU_LUT113H
    0x006F0801,  // GFXMMU_LUT114L
    0x00020BE0,  // GFXMMU_LUT114H
    0x006F0801,  // GFXMMU_LUT115L
    0x00021260,  // GFXMMU_LUT115H
    0x006F0801,  // GFXMMU_LUT116L
    0x000218E0,  // GFXMMU_LUT116H
    0x006F0801,  // GFXMMU_LUT117L
    0x00021F60,  // GFXMMU_LUT117H
    0x006F0801,  // GFXMMU_LUT118L
    0x000225E0,  // GFXMMU_LUT118H
    0x006F0801,  // GFXMMU_LUT119L
    0x00022C60,  // GFXMMU_LUT119H
    0x00700701,  // GFXMMU_LUT120L
    0x000232F0,  // GFXMMU_LUT120H
    0x00700701,  // GFXMMU_LUT121L
    0x00023990,  // GFXMMU_LUT121H
    0x00700701,  // GFXMMU_LUT122L
    0x00024030,  // GFXMMU_LUT122H
    0x00700701,  // GFXMMU_LUT123L
    0x000246D0,  // GFXMMU_LUT123H
    0x00700701,  // GFXMMU_LUT124L
    0x00024D70,  // GFXMMU_LUT124H
    0x00700701,  // GFXMMU_LUT125L
    0x00025410,  // GFXMMU_LUT125H
    0x00700701,  // GFXMMU_LUT126L
    0x00025AB0,  // GFXMMU_LUT126H
    0x00710601,  // GFXMMU_LUT127L
    0x00026160,  // GFXMMU_LUT127H
    0x00710601,  // GFXMMU_LUT128L
    0x00026820,  // GFXMMU_LUT128H
    0x00710601,  // GFXMMU_LUT129L
    0x00026EE0,  // GFXMMU_LUT129H
    0x00710601,  // GFXMMU_LUT130L
    0x000275A0,  // GFXMMU_LUT130H
    0x00710601,  // GFXMMU_LUT131L
    0x00027C60,  // GFXMMU_LUT131H
    0x00710601,  // GFXMMU_LUT132L
    0x00028320,  // GFXMMU_LUT132H
    0x00710601,  // GFXMMU_LUT133L
    0x000289E0,  // GFXMMU_LUT133H
    0x00710601,  // GFXMMU_LUT134L
    0x000290A0,  // GFXMMU_LUT134H
    0x00720501,  // GFXMMU_LUT135L
    0x00029770,  // GFXMMU_LUT135H
    0x00720501,  // GFXMMU_LUT136L
    0x00029E50,  // GFXMMU_LUT136H
    0x00720501,  // GFXMMU_LUT137L
    0x0002A530,  // GFXMMU_LUT137H
    0x00720501,  // GFXMMU_LUT138L
    0x0002AC10,  // GFXMMU_LUT138H
    0x00720501,  // GFXMMU_LUT139L
    0x0002B2F0,  // GFXMMU_LUT139H
    0x00720501,  // GFXMMU_LUT140L
    0x0002B9D0,  // GFXMMU_LUT140H
    0x00720501,  // GFXMMU_LUT141L
    0x0002C0B0,  // GFXMMU_LUT141H
    0x00720501,  // GFXMMU_LUT142L
    0x0002C790,  // GFXMMU_LUT142H
    0x00720501,  // GFXMMU_LUT143L
    0x0002CE70,  // GFXMMU_LUT143H
    0x00730401,  // GFXMMU_LUT144L
    0x0002D560,  // GFXMMU_LUT144H
    0x00730401,  // GFXMMU_LUT145L
    0x0002DC60,  // GFXMMU_LUT145H
    0x00730401,  // GFXMMU_LUT146L
    0x0002E360,  // GFXMMU_LUT146H
    0x00730401,  // GFXMMU_LUT147L
    0x0002EA60,  // GFXMMU_LUT147H
    0x00730401,  // GFXMMU_LUT148L
    0x0002F160,  // GFXMMU_LUT148H
    0x00730401,  // GFXMMU_LUT149L
    0x0002F860,  // GFXMMU_LUT149H
    0x00730401,  // GFXMMU_LUT150L
    0x0002FF60,  // GFXMMU_LUT150H
    0x00730401,  // GFXMMU_LUT151L
    0x00030660,  // GFXMMU_LUT151H
    0x00730401,  // GFXMMU_LUT152L
    0x00030D60,  // GFXMMU_LUT152H
    0x00740301,  // GFXMMU_LUT153L
    0x00031470,  // GFXMMU_LUT153H
    0x00740301,  // GFXMMU_LUT154L
    0x00031B90,  // GFXMMU_LUT154H
    0x00740301,  // GFXMMU_LUT155L
    0x000322B0,  // GFXMMU_LUT155H
    0x00740301,  // GFXMMU_LUT156L
    0x000329D0,  // GFXMMU_LUT156H
    0x00740301,  // GFXMMU_LUT157L
    0x000330F0,  // GFXMMU_LUT157H
    0x00740301,  // GFXMMU_LUT158L
    0x00033810,  // GFXMMU_LUT158H
    0x00740301,  // GFXMMU_LUT159L
    0x00033F30,  // GFXMMU_LUT159H
    0x00740301,  // GFXMMU_LUT160L
    0x00034650,  // GFXMMU_LUT160H
    0x00740301,  // GFXMMU_LUT161L
    0x00034D70,  // GFXMMU_LUT161H
    0x00740301,  // GFXMMU_LUT162L
    0x00035490,  // GFXMMU_LUT162H
    0x00740301,  // GFXMMU_LUT163L
    0x00035BB0,  // GFXMMU_LUT163H
    0x00740301,  // GFXMMU_LUT164L
    0x000362D0,  // GFXMMU_LUT164H
    0x00750201,  // GFXMMU_LUT165L
    0x00036A00,  // GFXMMU_LUT165H
    0x00750201,  // GFXMMU_LUT166L
    0x00037140,  // GFXMMU_LUT166H
    0x00750201,  // GFXMMU_LUT167L
    0x00037880,  // GFXMMU_LUT167H
    0x00750201,  // GFXMMU_LUT168L
    0x00037FC0,  // GFXMMU_LUT168H
    0x00750201,  // GFXMMU_LUT169L
    0x00038700,  // GFXMMU_LUT169H
    0x00750201,  // GFXMMU_LUT170L
    0x00038E40,  // GFXMMU_LUT170H
    0x00750201,  // GFXMMU_LUT171L
    0x00039580,  // GFXMMU_LUT171H
    0x00750201,  // GFXMMU_LUT172L
    0x00039CC0,  // GFXMMU_LUT172H
    0x00750201,  // GFXMMU_LUT173L
    0x0003A400,  // GFXMMU_LUT173H
    0x00750201,  // GFXMMU_LUT174L
    0x0003AB40,  // GFXMMU_LUT174H
    0x00750201,  // GFXMMU_LUT175L
    0x0003B280,  // GFXMMU_LUT175H
    0x00750201,  // GFXMMU_LUT176L
    0x0003B9C0,  // GFXMMU_LUT176H
    0x00750201,  // GFXMMU_LUT177L
    0x0003C100,  // GFXMMU_LUT177H
    0x00760101,  // GFXMMU_LUT178L
    0x0003C850,  // GFXMMU_LUT178H
    0x00760101,  // GFXMMU_LUT179L
    0x0003CFB0,  // GFXMMU_LUT179H
    0x00760101,  // GFXMMU_LUT180L
    0x0003D710,  // GFXMMU_LUT180H
    0x00760101,  // GFXMMU_LUT181L
    0x0003DE70,  // GFXMMU_LUT181H
    0x00760101,  // GFXMMU_LUT182L
    0x0003E5D0,  // GFXMMU_LUT182H
    0x00760101,  // GFXMMU_LUT183L
    0x0003ED30,  // GFXMMU_LUT183H
    0x00760101,  // GFXMMU_LUT184L
    0x0003F490,  // GFXMMU_LUT184H
    0x00760101,  // GFXMMU_LUT185L
    0x0003FBF0,  // GFXMMU_LUT185H
    0x00760101,  // GFXMMU_LUT186L
    0x00040350,  // GFXMMU_LUT186H
    0x00760101,  // GFXMMU_LUT187L
    0x00040AB0,  // GFXMMU_LUT187H
    0x00760101,  // GFXMMU_LUT188L
    0x00041210,  // GFXMMU_LUT188H
    0x00760101,  // GFXMMU_LUT189L
    0x00041970,  // GFXMMU_LUT189H
    0x00760101,  // GFXMMU_LUT190L
    0x000420D0,  // GFXMMU_LUT190H
    0x00760101,  // GFXMMU_LUT191L
    0x00042830,  // GFXMMU_LUT191H
    0x00760101,  // GFXMMU_LUT192L
    0x00042F90,  // GFXMMU_LUT192H
    0x00760101,  // GFXMMU_LUT193L
    0x000436F0,  // GFXMMU_LUT193H
    0x00760101,  // GFXMMU_LUT194L
    0x00043E50,  // GFXMMU_LUT194H
    0x00760101,  // GFXMMU_LUT195L
    0x000445B0,  // GFXMMU_LUT195H
    0x00770001,  // GFXMMU_LUT196L
    0x00044D20,  // GFXMMU_LUT196H
    0x00770001,  // GFXMMU_LUT197L
    0x000454A0,  // GFXMMU_LUT197H
    0x00770001,  // GFXMMU_LUT198L
    0x00045C20,  // GFXMMU_LUT198H
    0x00770001,  // GFXMMU_LUT199L
    0x000463A0,  // GFXMMU_LUT199H
    0x00770001,  // GFXMMU_LUT200L
    0x00046B20,  // GFXMMU_LUT200H
    0x00770001,  // GFXMMU_LUT201L
    0x000472A0,  // GFXMMU_LUT201H
    0x00770001,  // GFXMMU_LUT202L
    0x00047A20,  // GFXMMU_LUT202H
    0x00770001,  // GFXMMU_LUT203L
    0x000481A0,  // GFXMMU_LUT203H
    0x00770001,  // GFXMMU_LUT204L
    0x00048920,  // GFXMMU_LUT204H
    0x00770001,  // GFXMMU_LUT205L
    0x000490A0,  // GFXMMU_LUT205H
    0x00770001,  // GFXMMU_LUT206L
    0x00049820,  // GFXMMU_LUT206H
    0x00770001,  // GFXMMU_LUT207L
    0x00049FA0,  // GFXMMU_LUT207H
    0x00770001,  // GFXMMU_LUT208L
    0x0004A720,  // GFXMMU_LUT208H
    0x00770001,  // GFXMMU_LUT209L
    0x0004AEA0,  // GFXMMU_LUT209H
    0x00770001,  // GFXMMU_LUT210L
    0x0004B620,  // GFXMMU_LUT210H
    0x00770001,  // GFXMMU_LUT211L
    0x0004BDA0,  // GFXMMU_LUT211H
    0x00770001,  // GFXMMU_LUT212L
    0x0004C520,  // GFXMMU_LUT212H
    0x00770001,  // GFXMMU_LUT213L
    0x0004CCA0,  // GFXMMU_LUT213H
    0x00770001,  // GFXMMU_LUT214L
    0x0004D420,  // GFXMMU_LUT214H
    0x00770001,  // GFXMMU_LUT215L
    0x0004DBA0,  // GFXMMU_LUT215H
    0x00770001,  // GFXMMU_LUT216L
    0x0004E320,  // GFXMMU_LUT216H
    0x00770001,  // GFXMMU_LUT217L
    0x0004EAA0,  // GFXMMU_LUT217H
    0x00770001,  // GFXMMU_LUT218L
    0x0004F220,  // GFXMMU_LUT218H
    0x00770001,  // GFXMMU_LUT219L
    0x0004F9A0,  // GFXMMU_LUT219H
    0x00770001,  // GFXMMU_LUT220L
    0x00050120,  // GFXMMU_LUT220H
    0x00770001,  // GFXMMU_LUT221L
    0x000508A0,  // GFXMMU_LUT221H
    0x00770001,  // GFXMMU_LUT222L
    0x00051020,  // GFXMMU_LUT222H
    0x00770001,  // GFXMMU_LUT223L
    0x000517A0,  // GFXMMU_LUT223H
    0x00770001,  // GFXMMU_LUT224L
    0x00051F20,  // GFXMMU_LUT224H
    0x00770001,  // GFXMMU_LUT225L
    0x000526A0,  // GFXMMU_LUT225H
    0x00770001,  // GFXMMU_LUT226L
    0x00052E20,  // GFXMMU_LUT226H
    0x00770001,  // GFXMMU_LUT227L
    0x000535A0,  // GFXMMU_LUT227H
    0x00770001,  // GFXMMU_LUT228L
    0x00053D20,  // GFXMMU_LUT228H
    0x00770001,  // GFXMMU_LUT229L
    0x000544A0,  // GFXMMU_LUT229H
    0x00770001,  // GFXMMU_LUT230L
    0x00054C20,  // GFXMMU_LUT230H
    0x00770001,  // GFXMMU_LUT231L
    0x000553A0,  // GFXMMU_LUT231H
    0x00770001,  // GFXMMU_LUT232L
    0x00055B20,  // GFXMMU_LUT232H
    0x00770001,  // GFXMMU_LUT233L
    0x000562A0,  // GFXMMU_LUT233H
    0x00770001,  // GFXMMU_LUT234L
    0x00056A20,  // GFXMMU_LUT234H
    0x00770001,  // GFXMMU_LUT235L
    0x000571A0,  // GFXMMU_LUT235H
    0x00770001,  // GFXMMU_LUT236L
    0x00057920,  // GFXMMU_LUT236H
    0x00770001,  // GFXMMU_LUT237L
    0x000580A0,  // GFXMMU_LUT237H
    0x00770001,  // GFXMMU_LUT238L
    0x00058820,  // GFXMMU_LUT238H
    0x00770001,  // GFXMMU_LUT239L
    0x00058FA0,  // GFXMMU_LUT239H
    0x00780001,  // GFXMMU_LUT240L
    0x00059720,  // GFXMMU_LUT240H
    0x00770001,  // GFXMMU_LUT241L
    0x00059EB0,  // GFXMMU_LUT241H
    0x00770001,  // GFXMMU_LUT242L
    0x0005A630,  // GFXMMU_LUT242H
    0x00770001,  // GFXMMU_LUT243L
    0x0005ADB0,  // GFXMMU_LUT243H
    0x00770001,  // GFXMMU_LUT244L
    0x0005B530,  // GFXMMU_LUT244H
    0x00770001,  // GFXMMU_LUT245L
    0x0005BCB0,  // GFXMMU_LUT245H
    0x00770001,  // GFXMMU_LUT246L
    0x0005C430,  // GFXMMU_LUT246H
    0x00770001,  // GFXMMU_LUT247L
    0x0005CBB0,  // GFXMMU_LUT247H
    0x00770001,  // GFXMMU_LUT248L
    0x0005D330,  // GFXMMU_LUT248H
    0x00770001,  // GFXMMU_LUT249L
    0x0005DAB0,  // GFXMMU_LUT249H
    0x00770001,  // GFXMMU_LUT250L
    0x0005E230,  // GFXMMU_LUT250H
    0x00770001,  // GFXMMU_LUT251L
    0x0005E9B0,  // GFXMMU_LUT251H
    0x00770001,  // GFXMMU_LUT252L
    0x0005F130,  // GFXMMU_LUT252H
    0x00770001,  // GFXMMU_LUT253L
    0x0005F8B0,  // GFXMMU_LUT253H
    0x00770001,  // GFXMMU_LUT254L
    0x00060030,  // GFXMMU_LUT254H
    0x00770001,  // GFXMMU_LUT255L
    0x000607B0,  // GFXMMU_LUT255H
    0x00770001,  // GFXMMU_LUT256L
    0x00060F30,  // GFXMMU_LUT256H
    0x00770001,  // GFXMMU_LUT257L
    0x000616B0,  // GFXMMU_LUT257H
    0x00770001,  // GFXMMU_LUT258L
    0x00061E30,  // GFXMMU_LUT258H
    0x00770001,  // GFXMMU_LUT259L
    0x000625B0,  // GFXMMU_LUT259H
    0x00770001,  // GFXMMU_LUT260L
    0x00062D30,  // GFXMMU_LUT260H
    0x00770001,  // GFXMMU_LUT261L
    0x000634B0,  // GFXMMU_LUT261H
    0x00770001,  // GFXMMU_LUT262L
    0x00063C30,  // GFXMMU_LUT262H
    0x00770001,  // GFXMMU_LUT263L
    0x000643B0,  // GFXMMU_LUT263H
    0x00770001,  // GFXMMU_LUT264L
    0x00064B30,  // GFXMMU_LUT264H
    0x00770001,  // GFXMMU_LUT265L
    0x000652B0,  // GFXMMU_LUT265H
    0x00770001,  // GFXMMU_LUT266L
    0x00065A30,  // GFXMMU_LUT266H
    0x00770001,  // GFXMMU_LUT267L
    0x000661B0,  // GFXMMU_LUT267H
    0x00770001,  // GFXMMU_LUT268L
    0x00066930,  // GFXMMU_LUT268H
    0x00770001,  // GFXMMU_LUT269L
    0x000670B0,  // GFXMMU_LUT269H
    0x00770001,  // GFXMMU_LUT270L
    0x00067830,  // GFXMMU_LUT270H
    0x00770001,  // GFXMMU_LUT271L
    0x00067FB0,  // GFXMMU_LUT271H
    0x00770001,  // GFXMMU_LUT272L
    0x00068730,  // GFXMMU_LUT272H
    0x00770001,  // GFXMMU_LUT273L
    0x00068EB0,  // GFXMMU_LUT273H
    0x00770001,  // GFXMMU_LUT274L
    0x00069630,  // GFXMMU_LUT274H
    0x00770001,  // GFXMMU_LUT275L
    0x00069DB0,  // GFXMMU_LUT275H
    0x00770001,  // GFXMMU_LUT276L
    0x0006A530,  // GFXMMU_LUT276H
    0x00770001,  // GFXMMU_LUT277L
    0x0006ACB0,  // GFXMMU_LUT277H
    0x00770001,  // GFXMMU_LUT278L
    0x0006B430,  // GFXMMU_LUT278H
    0x00770001,  // GFXMMU_LUT279L
    0x0006BBB0,  // GFXMMU_LUT279H
    0x00770001,  // GFXMMU_LUT280L
    0x0006C330,  // GFXMMU_LUT280H
    0x00770001,  // GFXMMU_LUT281L
    0x0006CAB0,  // GFXMMU_LUT281H
    0x00770001,  // GFXMMU_LUT282L
    0x0006D230,  // GFXMMU_LUT282H
    0x00770001,  // GFXMMU_LUT283L
    0x0006D9B0,  // GFXMMU_LUT283H
    0x00770001,  // GFXMMU_LUT284L
    0x0006E130,  // GFXMMU_LUT284H
    0x00760101,  // GFXMMU_LUT285L
    0x0006E8A0,  // GFXMMU_LUT285H
    0x00760101,  // GFXMMU_LUT286L
    0x0006F000,  // GFXMMU_LUT286H
    0x00760101,  // GFXMMU_LUT287L
    0x0006F760,  // GFXMMU_LUT287H
    0x00760101,  // GFXMMU_LUT288L
    0x0006FEC0,  // GFXMMU_LUT288H
    0x00760101,  // GFXMMU_LUT289L
    0x00070620,  // GFXMMU_LUT289H
    0x00760101,  // GFXMMU_LUT290L
    0x00070D80,  // GFXMMU_LUT290H
    0x00760101,  // GFXMMU_LUT291L
    0x000714E0,  // GFXMMU_LUT291H
    0x00760101,  // GFXMMU_LUT292L
    0x00071C40,  // GFXMMU_LUT292H
    0x00760101,  // GFXMMU_LUT293L
    0x000723A0,  // GFXMMU_LUT293H
    0x00760101,  // GFXMMU_LUT294L
    0x00072B00,  // GFXMMU_LUT294H
    0x00760101,  // GFXMMU_LUT295L
    0x00073260,  // GFXMMU_LUT295H
    0x00760101,  // GFXMMU_LUT296L
    0x000739C0,  // GFXMMU_LUT296H
    0x00760101,  // GFXMMU_LUT297L
    0x00074120,  // GFXMMU_LUT297H
    0x00760101,  // GFXMMU_LUT298L
    0x00074880,  // GFXMMU_LUT298H
    0x00760101,  // GFXMMU_LUT299L
    0x00074FE0,  // GFXMMU_LUT299H
    0x00760101,  // GFXMMU_LUT300L
    0x00075740,  // GFXMMU_LUT300H
    0x00760101,  // GFXMMU_LUT301L
    0x00075EA0,  // GFXMMU_LUT301H
    0x00760101,  // GFXMMU_LUT302L
    0x00076600,  // GFXMMU_LUT302H
    0x00750201,  // GFXMMU_LUT303L
    0x00076D50,  // GFXMMU_LUT303H
    0x00750201,  // GFXMMU_LUT304L
    0x00077490,  // GFXMMU_LUT304H
    0x00750201,  // GFXMMU_LUT305L
    0x00077BD0,  // GFXMMU_LUT305H
    0x00750201,  // GFXMMU_LUT306L
    0x00078310,  // GFXMMU_LUT306H
    0x00750201,  // GFXMMU_LUT307L
    0x00078A50,  // GFXMMU_LUT307H
    0x00750201,  // GFXMMU_LUT308L
    0x00079190,  // GFXMMU_LUT308H
    0x00750201,  // GFXMMU_LUT309L
    0x000798D0,  // GFXMMU_LUT309H
    0x00750201,  // GFXMMU_LUT310L
    0x0007A010,  // GFXMMU_LUT310H
    0x00750201,  // GFXMMU_LUT311L
    0x0007A750,  // GFXMMU_LUT311H
    0x00750201,  // GFXMMU_LUT312L
    0x0007AE90,  // GFXMMU_LUT312H
    0x00750201,  // GFXMMU_LUT313L
    0x0007B5D0,  // GFXMMU_LUT313H
    0x00750201,  // GFXMMU_LUT314L
    0x0007BD10,  // GFXMMU_LUT314H
    0x00750201,  // GFXMMU_LUT315L
    0x0007C450,  // GFXMMU_LUT315H
    0x00740301,  // GFXMMU_LUT316L
    0x0007CB80,  // GFXMMU_LUT316H
    0x00740301,  // GFXMMU_LUT317L
    0x0007D2A0,  // GFXMMU_LUT317H
    0x00740301,  // GFXMMU_LUT318L
    0x0007D9C0,  // GFXMMU_LUT318H
    0x00740301,  // GFXMMU_LUT319L
    0x0007E0E0,  // GFXMMU_LUT319H
    0x00740301,  // GFXMMU_LUT320L
    0x0007E800,  // GFXMMU_LUT320H
    0x00740301,  // GFXMMU_LUT321L
    0x0007EF20,  // GFXMMU_LUT321H
    0x00740301,  // GFXMMU_LUT322L
    0x0007F640,  // GFXMMU_LUT322H
    0x00740301,  // GFXMMU_LUT323L
    0x0007FD60,  // GFXMMU_LUT323H
    0x00740301,  // GFXMMU_LUT324L
    0x00080480,  // GFXMMU_LUT324H
    0x00740301,  // GFXMMU_LUT325L
    0x00080BA0,  // GFXMMU_LUT325H
    0x00740301,  // GFXMMU_LUT326L
    0x000812C0,  // GFXMMU_LUT326H
    0x00740301,  // GFXMMU_LUT327L
    0x000819E0,  // GFXMMU_LUT327H
    0x00730401,  // GFXMMU_LUT328L
    0x000820F0,  // GFXMMU_LUT328H
    0x00730401,  // GFXMMU_LUT329L
    0x000827F0,  // GFXMMU_LUT329H
    0x00730401,  // GFXMMU_LUT330L
    0x00082EF0,  // GFXMMU_LUT330H
    0x00730401,  // GFXMMU_LUT331L
    0x000835F0,  // GFXMMU_LUT331H
    0x00730401,  // GFXMMU_LUT332L
    0x00083CF0,  // GFXMMU_LUT332H
    0x00730401,  // GFXMMU_LUT333L
    0x000843F0,  // GFXMMU_LUT333H
    0x00730401,  // GFXMMU_LUT334L
    0x00084AF0,  // GFXMMU_LUT334H
    0x00730401,  // GFXMMU_LUT335L
    0x000851F0,  // GFXMMU_LUT335H
    0x00730401,  // GFXMMU_LUT336L
    0x000858F0,  // GFXMMU_LUT336H
    0x00730401,  // GFXMMU_LUT337L
    0x00085FF0,  // GFXMMU_LUT337H
    0x00720501,  // GFXMMU_LUT338L
    0x000866E0,  // GFXMMU_LUT338H
    0x00720501,  // GFXMMU_LUT339L
    0x00086DC0,  // GFXMMU_LUT339H
    0x00720501,  // GFXMMU_LUT340L
    0x000874A0,  // GFXMMU_LUT340H
    0x00720501,  // GFXMMU_LUT341L
    0x00087B80,  // GFXMMU_LUT341H
    0x00720501,  // GFXMMU_LUT342L
    0x00088260,  // GFXMMU_LUT342H
    0x00720501,  // GFXMMU_LUT343L
    0x00088940,  // GFXMMU_LUT343H
    0x00720501,  // GFXMMU_LUT344L
    0x00089020,  // GFXMMU_LUT344H
    0x00720501,  // GFXMMU_LUT345L
    0x00089700,  // GFXMMU_LUT345H
    0x00710601,  // GFXMMU_LUT346L
    0x00089DD0,  // GFXMMU_LUT346H
    0x00710601,  // GFXMMU_LUT347L
    0x0008A490,  // GFXMMU_LUT347H
    0x00710601,  // GFXMMU_LUT348L
    0x0008AB50,  // GFXMMU_LUT348H
    0x00710601,  // GFXMMU_LUT349L
    0x0008B210,  // GFXMMU_LUT349H
    0x00710601,  // GFXMMU_LUT350L
    0x0008B8D0,  // GFXMMU_LUT350H
    0x00710601,  // GFXMMU_LUT351L
    0x0008BF90,  // GFXMMU_LUT351H
    0x00710601,  // GFXMMU_LUT352L
    0x0008C650,  // GFXMMU_LUT352H
    0x00710601,  // GFXMMU_LUT353L
    0x0008CD10,  // GFXMMU_LUT353H
    0x00700701,  // GFXMMU_LUT354L
    0x0008D3C0,  // GFXMMU_LUT354H
    0x00700701,  // GFXMMU_LUT355L
    0x0008DA60,  // GFXMMU_LUT355H
    0x00700701,  // GFXMMU_LUT356L
    0x0008E100,  // GFXMMU_LUT356H
    0x00700701,  // GFXMMU_LUT357L
    0x0008E7A0,  // GFXMMU_LUT357H
    0x00700701,  // GFXMMU_LUT358L
    0x0008EE40,  // GFXMMU_LUT358H
    0x00700701,  // GFXMMU_LUT359L
    0x0008F4E0,  // GFXMMU_LUT359H
    0x00700701,  // GFXMMU_LUT360L
    0x0008FB80,  // GFXMMU_LUT360H
    0x006F0801,  // GFXMMU_LUT361L
    0x00090210,  // GFXMMU_LUT361H
    0x006F0801,  // GFXMMU_LUT362L
    0x00090890,  // GFXMMU_LUT362H
    0x006F0801,  // GFXMMU_LUT363L
    0x00090F10,  // GFXMMU_LUT363H
    0x006F0801,  // GFXMMU_LUT364L
    0x00091590,  // GFXMMU_LUT364H
    0x006F0801,  // GFXMMU_LUT365L
    0x00091C10,  // GFXMMU_LUT365H
    0x006F0801,  // GFXMMU_LUT366L
    0x00092290,  // GFXMMU_LUT366H
    0x006F0801,  // GFXMMU_LUT367L
    0x00092910,  // GFXMMU_LUT367H
    0x006E0901,  // GFXMMU_LUT368L
    0x00092F80,  // GFXMMU_LUT368H
    0x006E0901,  // GFXMMU_LUT369L
    0x000935E0,  // GFXMMU_LUT369H
    0x006E0901,  // GFXMMU_LUT370L
    0x00093C40,  // GFXMMU_LUT370H
    0x006E0901,  // GFXMMU_LUT371L
    0x000942A0,  // GFXMMU_LUT371H
    0x006E0901,  // GFXMMU_LUT372L
    0x00094900,  // GFXMMU_LUT372H
    0x006E0901,  // GFXMMU_LUT373L
    0x00094F60,  // GFXMMU_LUT373H
    0x006D0A01,  // GFXMMU_LUT374L
    0x000955B0,  // GFXMMU_LUT374H
    0x006D0A01,  // GFXMMU_LUT375L
    0x00095BF0,  // GFXMMU_LUT375H
    0x006D0A01,  // GFXMMU_LUT376L
    0x00096230,  // GFXMMU_LUT376H
    0x006D0A01,  // GFXMMU_LUT377L
    0x00096870,  // GFXMMU_LUT377H
    0x006D0A01,  // GFXMMU_LUT378L
    0x00096EB0,  // GFXMMU_LUT378H
    0x006C0B01,  // GFXMMU_LUT379L
    0x000974E0,  // GFXMMU_LUT379H
    0x006C0B01,  // GFXMMU_LUT380L
    0x00097B00,  // GFXMMU_LUT380H
    0x006C0B01,  // GFXMMU_LUT381L
    0x00098120,  // GFXMMU_LUT381H
    0x006C0B01,  // GFXMMU_LUT382L
    0x00098740,  // GFXMMU_LUT382H
    0x006C0B01,  // GFXMMU_LUT383L
    0x00098D60,  // GFXMMU_LUT383H
    0x006C0B01,  // GFXMMU_LUT384L
    0x00099380,  // GFXMMU_LUT384H
    0x006B0C01,  // GFXMMU_LUT385L
    0x00099990,  // GFXMMU_LUT385H
    0x006B0C01,  // GFXMMU_LUT386L
    0x00099F90,  // GFXMMU_LUT386H
    0x006B0C01,  // GFXMMU_LUT387L
    0x0009A590,  // GFXMMU_LUT387H
    0x006B0C01,  // GFXMMU_LUT388L
    0x0009AB90,  // GFXMMU_LUT388H
    0x006B0C01,  // GFXMMU_LUT389L
    0x0009B190,  // GFXMMU_LUT389H
    0x006A0D01,  // GFXMMU_LUT390L
    0x0009B780,  // GFXMMU_LUT390H
    0x006A0D01,  // GFXMMU_LUT391L
    0x0009BD60,  // GFXMMU_LUT391H
    0x006A0D01,  // GFXMMU_LUT392L
    0x0009C340,  // GFXMMU_LUT392H
    0x006A0D01,  // GFXMMU_LUT393L
    0x0009C920,  // GFXMMU_LUT393H
    0x006A0D01,  // GFXMMU_LUT394L
    0x0009CF00,  // GFXMMU_LUT394H
    0x00690E01,  // GFXMMU_LUT395L
    0x0009D4D0,  // GFXMMU_LUT395H
    0x00690E01,  // GFXMMU_LUT396L
    0x0009DA90,  // GFXMMU_LUT396H
    0x00690E01,  // GFXMMU_LUT397L
    0x0009E050,  // GFXMMU_LUT397H
    0x00690E01,  // GFXMMU_LUT398L
    0x0009E610,  // GFXMMU_LUT398H
    0x00690E01,  // GFXMMU_LUT399L
    0x0009EBD0,  // GFXMMU_LUT399H
    0x00690E01,  // GFXMMU_LUT400L
    0x0009F190,  // GFXMMU_LUT400H
    0x00690E01,  // GFXMMU_LUT401L
    0x0009F750,  // GFXMMU_LUT401H
    0x00680F01,  // GFXMMU_LUT402L
    0x0009FD00,  // GFXMMU_LUT402H
    0x00680F01,  // GFXMMU_LUT403L
    0x000A02A0,  // GFXMMU_LUT403H
    0x00680F01,  // GFXMMU_LUT404L
    0x000A0840,  // GFXMMU_LUT404H
    0x00680F01,  // GFXMMU_LUT405L
    0x000A0DE0,  // GFXMMU_LUT405H
    0x00671001,  // GFXMMU_LUT406L
    0x000A1370,  // GFXMMU_LUT406H
    0x00671001,  // GFXMMU_LUT407L
    0x000A18F0,  // GFXMMU_LUT407H
    0x00671001,  // GFXMMU_LUT408L
    0x000A1E70,  // GFXMMU_LUT408H
    0x00671001,  // GFXMMU_LUT409L
    0x000A23F0,  // GFXMMU_LUT409H
    0x00661101,  // GFXMMU_LUT410L
    0x000A2960,  // GFXMMU_LUT410H
    0x00661101,  // GFXMMU_LUT411L
    0x000A2EC0,  // GFXMMU_LUT411H
    0x00661101,  // GFXMMU_LUT412L
    0x000A3420,  // GFXMMU_LUT412H
    0x00661101,  // GFXMMU_LUT413L
    0x000A3980,  // GFXMMU_LUT413H
    0x00651201,  // GFXMMU_LUT414L
    0x000A3ED0,  // GFXMMU_LUT414H
    0x00651201,  // GFXMMU_LUT415L
    0x000A4410,  // GFXMMU_LUT415H
    0x00651201,  // GFXMMU_LUT416L
    0x000A4950,  // GFXMMU_LUT416H
    0x00641301,  // GFXMMU_LUT417L
    0x000A4E80,  // GFXMMU_LUT417H
    0x00641301,  // GFXMMU_LUT418L
    0x000A53A0,  // GFXMMU_LUT418H
    0x00641301,  // GFXMMU_LUT419L
    0x000A58C0,  // GFXMMU_LUT419H
    0x00641301,  // GFXMMU_LUT420L
    0x000A5DE0,  // GFXMMU_LUT420H
    0x00631401,  // GFXMMU_LUT421L
    0x000A62F0,  // GFXMMU_LUT421H
    0x00631401,  // GFXMMU_LUT422L
    0x000A67F0,  // GFXMMU_LUT422H
    0x00631401,  // GFXMMU_LUT423L
    0x000A6CF0,  // GFXMMU_LUT423H
    0x00621501,  // GFXMMU_LUT424L
    0x000A71E0,  // GFXMMU_LUT424H
    0x00621501,  // GFXMMU_LUT425L
    0x000A76C0,  // GFXMMU_LUT425H
    0x00621501,  // GFXMMU_LUT426L
    0x000A7BA0,  // GFXMMU_LUT426H
    0x00621501,  // GFXMMU_LUT427L
    0x000A8080,  // GFXMMU_LUT427H
    0x00611601,  // GFXMMU_LUT428L
    0x000A8550,  // GFXMMU_LUT428H
    0x00611601,  // GFXMMU_LUT429L
    0x000A8A10,  // GFXMMU_LUT429H
    0x00611601,  // GFXMMU_LUT430L
    0x000A8ED0,  // GFXMMU_LUT430H
    0x00601701,  // GFXMMU_LUT431L
    0x000A9380,  // GFXMMU_LUT431H
    0x00601701,  // GFXMMU_LUT432L
    0x000A9820,  // GFXMMU_LUT432H
    0x00601701,  // GFXMMU_LUT433L
    0x000A9CC0,  // GFXMMU_LUT433H
    0x005F1801,  // GFXMMU_LUT434L
    0x000AA150,  // GFXMMU_LUT434H
    0x005F1801,  // GFXMMU_LUT435L
    0x000AA5D0,  // GFXMMU_LUT435H
    0x005F1801,  // GFXMMU_LUT436L
    0x000AAA50,  // GFXMMU_LUT436H
    0x005E1901,  // GFXMMU_LUT437L
    0x000AAEC0,  // GFXMMU_LUT437H
    0x005E1901,  // GFXMMU_LUT438L
    0x000AB320,  // GFXMMU_LUT438H
    0x005D1A01,  // GFXMMU_LUT439L
    0x000AB770,  // GFXMMU_LUT439H
    0x005D1A01,  // GFXMMU_LUT440L
    0x000ABBB0,  // GFXMMU_LUT440H
    0x005D1A01,  // GFXMMU_LUT441L
    0x000ABFF0,  // GFXMMU_LUT441H
    0x005C1B01,  // GFXMMU_LUT442L
    0x000AC420,  // GFXMMU_LUT442H
    0x005C1B01,  // GFXMMU_LUT443L
    0x000AC840,  // GFXMMU_LUT443H
    0x005B1C01,  // GFXMMU_LUT444L
    0x000ACC50,  // GFXMMU_LUT444H
    0x005B1C01,  // GFXMMU_LUT445L
    0x000AD050,  // GFXMMU_LUT445H
    0x005B1C01,  // GFXMMU_LUT446L
    0x000AD450,  // GFXMMU_LUT446H
    0x005A1D01,  // GFXMMU_LUT447L
    0x000AD840,  // GFXMMU_LUT447H
    0x005A1D01,  // GFXMMU_LUT448L
    0x000ADC20,  // GFXMMU_LUT448H
    0x00591E01,  // GFXMMU_LUT449L
    0x000ADFF0,  // GFXMMU_LUT449H
    0x00591E01,  // GFXMMU_LUT450L
    0x000AE3B0,  // GFXMMU_LUT450H
    0x00581F01,  // GFXMMU_LUT451L
    0x000AE760,  // GFXMMU_LUT451H
    0x00581F01,  // GFXMMU_LUT452L
    0x000AEB00,  // GFXMMU_LUT452H
    0x00572001,  // GFXMMU_LUT453L
    0x000AEE90,  // GFXMMU_LUT453H
    0x00572001,  // GFXMMU_LUT454L
    0x000AF210,  // GFXMMU_LUT454H
    0x00562101,  // GFXMMU_LUT455L
    0x000AF580,  // GFXMMU_LUT455H
    0x00562101,  // GFXMMU_LUT456L
    0x000AF8E0,  // GFXMMU_LUT456H
    0x00552201,  // GFXMMU_LUT457L
    0x000AFC30,  // GFXMMU_LUT457H
    0x00552201,  // GFXMMU_LUT458L
    0x000AFF70,  // GFXMMU_LUT458H
    0x00542301,  // GFXMMU_LUT459L
    0x000B02A0,  // GFXMMU_LUT459H
    0x00542301,  // GFXMMU_LUT460L
    0x000B05C0,  // GFXMMU_LUT460H
    0x00532401,  // GFXMMU_LUT461L
    0x000B08D0,  // GFXMMU_LUT461H
    0x00522501,  // GFXMMU_LUT462L
    0x000B0BC0,  // GFXMMU_LUT462H
    0x00522501,  // GFXMMU_LUT463L
    0x000B0EA0,  // GFXMMU_LUT463H
    0x00512601,  // GFXMMU_LUT464L
    0x000B1170,  // GFXMMU_LUT464H
    0x00502701,  // GFXMMU_LUT465L
    0x000B1420,  // GFXMMU_LUT465H
    0x00502701,  // GFXMMU_LUT466L
    0x000B16C0,  // GFXMMU_LUT466H
    0x004F2801,  // GFXMMU_LUT467L
    0x000B1950,  // GFXMMU_LUT467H
    0x004E2901,  // GFXMMU_LUT468L
    0x000B1BC0,  // GFXMMU_LUT468H
    0x004D2A01,  // GFXMMU_LUT469L
    0x000B1E10,  // GFXMMU_LUT469H
    0x004D2A01,  // GFXMMU_LUT470L
    0x000B2050,  // GFXMMU_LUT470H
    0x004C2B01,  // GFXMMU_LUT471L
    0x000B2280,  // GFXMMU_LUT471H
    0x004B2C01,  // GFXMMU_LUT472L
    0x000B2490,  // GFXMMU_LUT472H
    0x004A2D01,  // GFXMMU_LUT473L
    0x000B2680,  // GFXMMU_LUT473H
    0x00492E01,  // GFXMMU_LUT474L
    0x000B2850,  // GFXMMU_LUT474H
    0x00482F01,  // GFXMMU_LUT475L
    0x000B2A00,  // GFXMMU_LUT475H
    0x00463101,  // GFXMMU_LUT476L
    0x000B2B80,  // GFXMMU_LUT476H
    0x00453201,  // GFXMMU_LUT477L
    0x000B2CD0,  // GFXMMU_LUT477H
    0x00433401,  // GFXMMU_LUT478L
    0x000B2DF0,  // GFXMMU_LUT478H
    0x00413601,  // GFXMMU_LUT479L
    0x000B2ED0   // GFXMMU_LUT479H
};

#ifdef __cplusplus
}
#endif
#endif /*__ gfxmmu_lut_H */

/**
 * @}
 */

/**
 * @}
 */
