const HANASystemReplicationModes = {
  Primary: 'HANA Primary',
  Secondary: 'HANA Secondary',
};

export const isHanaSecondary = (instance) =>
  instance.systemReplication == HANASystemReplicationModes.Secondary;
export const isHanaPrimary = (instance) =>
  instance.systemReplication == HANASystemReplicationModes.Primary;

export const availableSAPSystems = [
  {
    sid: 'NWD',
    id: 'a1e80e3e152a903662f7882fb3f8a851',
    health: 'check_circle',
    attachedDatabase: {
      sid: 'HDD',
      id: 'fd44c254ccb14331e54015c720c7a1f2',
      tenant: 'HDD',
      dbAddress: '10.100.1.13',
    },
    instances: [
      {
        sid: 'NWD',
        health: 'check_circle',
        features: 'MESSAGESERVER|ENQUE',
        instanceNumber: '00',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwdev01',
        hostID: '7269ee51-5007-5849-aaa7-7c4a98b0c9ce',
      },
      {
        sid: 'NWD',
        health: 'check_circle',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '01',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwdev03',
        hostID: '9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f',
      },
      {
        sid: 'NWD',
        health: 'check_circle',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '02',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwdev04',
        hostID: '1b0e9297-97dd-55d6-9874-8efde4d84c90',
      },
      {
        sid: 'NWD',
        health: 'check_circle',
        features: 'ENQREP',
        instanceNumber: '10',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwdev02',
        hostID: 'fb2c6b8a-9915-5969-a6b7-8b5a42de1971',
      },
      {
        sid: 'HDD',
        health: 'check_circle',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Primary,
        systemReplicationStatus: 'SOK',
        clusterName: 'hana_cluster',
        clusterID: '04b8f8c21f9fd8991224478e8c4362f8',
        hostname: 'vmhdbdev01',
        hostID: '13e8c25c-3180-5a9a-95c8-51ec38e50cfc',
      },
      {
        sid: 'HDD',
        health: 'check_circle',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Secondary,
        systemReplicationStatus: 'SOK',
        clusterName: 'hana_cluster',
        clusterID: '04b8f8c21f9fd8991224478e8c4362f8',
        hostname: 'vmhdbdev02',
        hostID: '0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4',
      },
    ],
    tag: 'env3',
  },
  {
    id: '97a1e70aeff3c0685d65c4c3d32d533b',
    sid: 'NWP',
    health: 'check_circle',
    attachedDatabase: {
      sid: 'HDP',
      id: '1154f7678ac587e5f0f242830a5201f1',
      tenant: 'HDP',
      dbAddress: '10.80.1.13',
    },
    instances: [
      {
        sid: 'NWP',
        health: 'check_circle',
        features: 'MESSAGESERVER|ENQUE',
        instanceNumber: '00',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwprd01',
        hostID: '116d49bd-85e1-5e59-b820-83f66db8800c',
      },
      {
        sid: 'NWP',
        health: 'check_circle',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '01',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwprd03',
        hostID: 'a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12',
      },
      {
        sid: 'NWP',
        health: 'check_circle',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '02',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwprd04',
        hostID: '0fc07435-7ee2-54ca-b0de-fb27ffdc5deb',
      },
      {
        sid: 'NWP',
        health: 'check_circle',
        features: 'ENQREP',
        instanceNumber: '10',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwprd02',
        hostID: '4b30a6af-4b52-5bda-bccb-f2248a12c992',
      },
      {
        sid: 'HDP',
        health: 'check_circle',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Primary,
        systemReplicationStatus: 'SOK',
        clusterName: 'hana_cluster',
        clusterID: '04b8f8c21f9fd8991224478e8c4362f8',
        hostname: 'vmhdbprd01',
        hostID: '9cd46919-5f19-59aa-993e-cf3736c71053',
      },
      {
        sid: 'HDP',
        health: 'check_circle',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Secondary,
        systemReplicationStatus: 'SOK',
        clusterName: 'hana_cluster',
        clusterID: '04b8f8c21f9fd8991224478e8c4362f8',
        hostname: 'vmhdbprd02',
        hostID: 'b767b3e9-e802-587e-a442-541d093b86b9',
      },
    ],
    tag: 'env1',
  },
  {
    id: 'd01fdc69aeba7bd5133b210eb2884853',
    sid: 'NWQ',
    health: 'check_circle',
    attachedDatabase: {
      sid: 'HDQ',
      id: '9953878f07bb54cac20d5d5d7ff08af2',
      tenant: 'HDQ',
      dbAddress: 'ha-cluster.suse.de',
    },
    instances: [
      {
        sid: 'NWQ',
        health: 'check_circle',
        features: 'MESSAGESERVER|ENQUE',
        instanceNumber: '00',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwqas01',
        hostID: '25677e37-fd33-5005-896c-9275b1284534',
      },
      {
        sid: 'NWQ',
        health: 'check_circle',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '01',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwqas03',
        hostID: '098fc159-3ed6-58e7-91be-38fda8a833ea',
      },
      {
        sid: 'NWQ',
        health: 'check_circle',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '02',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwqas04',
        hostID: '81e9b629-c1e7-538f-bff1-47d3a6580522',
      },
      {
        sid: 'NWQ',
        health: 'check_circle',
        features: 'ENQREP',
        instanceNumber: '10',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwqas02',
        hostID: '3711ea88-9ccc-5b07-8f9d-042be449d72b',
      },
      {
        sid: 'HDQ',
        health: 'check_circle',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Primary,
        systemReplicationStatus: 'SOK',
        clusterName: 'hana_cluster',
        clusterID: '04b8f8c21f9fd8991224478e8c4362f8',
        hostname: 'vmhdbqas01',
        hostID: '99cf8a3a-48d6-57a4-b302-6e4482227ab6',
      },
      {
        sid: 'HDQ',
        health: 'check_circle',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Secondary,
        systemReplicationStatus: 'SOK',
        clusterName: 'hana_cluster',
        clusterID: '04b8f8c21f9fd8991224478e8c4362f8',
        hostname: 'vmhdbqas02',
        hostID: 'e0c182db-32ff-55c6-a9eb-2b82dd21bc8b',
      },
    ],
    tag: 'env2',
  },
];
