// Package api GENERATED BY THE COMMAND ABOVE; DO NOT EDIT
// This file was generated by swaggo/swag
package api

import (
	"bytes"
	"encoding/json"
	"strings"
	"text/template"

	"github.com/swaggo/swag"
)

var doc = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {
            "name": "Trento Project",
            "url": "https://www.trento-project.io",
            "email": "trento-project@suse.com"
        },
        "license": {
            "name": "Apache 2.0",
            "url": "http://www.apache.org/licenses/LICENSE-2.0.html"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/checks/catalog": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "summary": "Get the whole checks' catalog",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/web.JSONChecksGroup"
                            }
                        }
                    }
                }
            },
            "put": {
                "produces": [
                    "application/json"
                ],
                "summary": "Create/Updates the checks catalog",
                "parameters": [
                    {
                        "description": "Checks catalog",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/web.JSONCheck"
                            }
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/web.JSONCheck"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/checks/{id}/results": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "summary": "Create a checks result entry",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Resource Id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Checks result",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.JSONChecksResult"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/web.JSONChecksResult"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/checks/{id}/settings": {
            "get": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Get the check settings",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Resource id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.JSONChecksSettings"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            },
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Create the check settings",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Resource id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Checks settings",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.JSONChecksSettings"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/web.JSONChecksSettings"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/clusters/settings": {
            "get": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Retrieve Settings for all the clusters. Cluster's Selected checks and Hosts connection settings",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/models.ClusterSettings"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/clusters/{cluster_id}/results": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "summary": "Get a specific cluster's check results",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Cluster Id",
                        "name": "cluster_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object",
                            "additionalProperties": true
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/clusters/{id}/tags": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Add tag to Cluster",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Cluster id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "The tag to create",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/clusters/{id}/tags/{tag}": {
            "delete": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Delete a specific tag that belongs to a cluster",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Cluster id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Tag",
                        "name": "tag",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content",
                        "schema": {
                            "type": "object",
                            "additionalProperties": true
                        }
                    }
                }
            }
        },
        "/databases/{id}/tags": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Add tag to a HANA database",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Database id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "The tag to create",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/databases/{id}/tags/{tag}": {
            "delete": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Delete a specific tag that belongs to a HANA database",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Database id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Tag",
                        "name": "tag",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content",
                        "schema": {
                            "type": "object",
                            "additionalProperties": true
                        }
                    }
                }
            }
        },
        "/hosts/{id}/tags": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Add tag to host",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Host id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "The tag to create",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/hosts/{id}/tags/{tag}": {
            "delete": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Delete a specific tag that belongs to a host",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Host id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Tag",
                        "name": "tag",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content",
                        "schema": {
                            "type": "object",
                            "additionalProperties": true
                        }
                    }
                }
            }
        },
        "/prometheus/targets": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "summary": "Get prometheus HTTP SD targets",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/web.Targets"
                            }
                        }
                    }
                }
            }
        },
        "/sapsystems/health": {
            "get": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Retrieve SAP Systems Health Summary",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/models.SAPSystemHealthSummary"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/sapsystems/{id}/tags": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Add tag to SAPSystem",
                "parameters": [
                    {
                        "type": "string",
                        "description": "SAPSystem id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "The tag to create",
                        "name": "Body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/web.JSONTag"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/sapsystems/{id}/tags/{tag}": {
            "delete": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "Delete a specific tag that belongs to a SAPSystem",
                "parameters": [
                    {
                        "type": "string",
                        "description": "SAPSystem id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Tag",
                        "name": "tag",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content",
                        "schema": {
                            "type": "object",
                            "additionalProperties": true
                        }
                    }
                }
            }
        },
        "/tags": {
            "get": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "List all the tags in the system",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Filter by resource type",
                        "name": "resource_type",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "models.Check": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "implementation": {
                    "type": "string"
                },
                "labels": {
                    "type": "string"
                },
                "msg": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "premium": {
                    "type": "boolean"
                },
                "remediation": {
                    "type": "string"
                },
                "result": {
                    "type": "string"
                },
                "selected": {
                    "type": "boolean"
                }
            }
        },
        "models.ClusterSettings": {
            "type": "object",
            "properties": {
                "hosts": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/models.HostConnection"
                    }
                },
                "id": {
                    "type": "string"
                },
                "selected_checks": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "models.HostConnection": {
            "type": "object",
            "properties": {
                "address": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "models.SAPSystemHealthSummary": {
            "type": "object",
            "properties": {
                "clusters_health": {
                    "type": "string"
                },
                "database_health": {
                    "type": "string"
                },
                "hosts_health": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "sapsystem_health": {
                    "type": "string"
                },
                "sid": {
                    "type": "string"
                }
            }
        },
        "web.JSONCheck": {
            "type": "object",
            "required": [
                "group",
                "id",
                "name"
            ],
            "properties": {
                "description": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "implementation": {
                    "type": "string"
                },
                "labels": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "premium": {
                    "type": "boolean"
                },
                "remediation": {
                    "type": "string"
                }
            }
        },
        "web.JSONCheckResult": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "group": {
                    "type": "string"
                },
                "hosts": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/web.JSONHosts"
                    }
                },
                "id": {
                    "type": "string"
                }
            }
        },
        "web.JSONChecksGroup": {
            "type": "object",
            "properties": {
                "checks": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/models.Check"
                    }
                },
                "group": {
                    "type": "string"
                }
            }
        },
        "web.JSONChecksResult": {
            "type": "object",
            "required": [
                "checks",
                "hosts"
            ],
            "properties": {
                "checks": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/web.JSONCheckResult"
                    }
                },
                "hosts": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/web.JSONHosts"
                    }
                }
            }
        },
        "web.JSONChecksSettings": {
            "type": "object",
            "required": [
                "connection_settings",
                "selected_checks"
            ],
            "properties": {
                "connection_settings": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "hostnames": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "selected_checks": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "web.JSONHosts": {
            "type": "object",
            "properties": {
                "msg": {
                    "type": "string"
                },
                "reachable": {
                    "type": "boolean"
                },
                "result": {
                    "type": "string"
                }
            }
        },
        "web.JSONTag": {
            "type": "object",
            "required": [
                "tag"
            ],
            "properties": {
                "tag": {
                    "type": "string"
                }
            }
        },
        "web.Targets": {
            "type": "object",
            "properties": {
                "labels": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "targets": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        }
    }
}`

type swaggerInfo struct {
	Version     string
	Host        string
	BasePath    string
	Schemes     []string
	Title       string
	Description string
}

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = swaggerInfo{
	Version:     "1.0",
	Host:        "",
	BasePath:    "/api",
	Schemes:     []string{"http"},
	Title:       "Trento API",
	Description: "Trento API",
}

type s struct{}

func (s *s) ReadDoc() string {
	sInfo := SwaggerInfo
	sInfo.Description = strings.Replace(sInfo.Description, "\n", "\\n", -1)

	t, err := template.New("swagger_info").Funcs(template.FuncMap{
		"marshal": func(v interface{}) string {
			a, _ := json.Marshal(v)
			return string(a)
		},
		"escape": func(v interface{}) string {
			// escape tabs
			str := strings.Replace(v.(string), "\t", "\\t", -1)
			// replace " with \", and if that results in \\", replace that with \\\"
			str = strings.Replace(str, "\"", "\\\"", -1)
			return strings.Replace(str, "\\\\\"", "\\\\\\\"", -1)
		},
	}).Parse(doc)
	if err != nil {
		return doc
	}

	var tpl bytes.Buffer
	if err := t.Execute(&tpl, sInfo); err != nil {
		return doc
	}

	return tpl.String()
}

func init() {
	swag.Register("swagger", &s{})
}
