# How to contribute

I'm really glad you're reading this, because we need volunteer developers to help this project come to fruition.

## Submitting changes

Please send a [GitHub Pull Request to Trento](https://github.com/trento-project/trento/pull/new/main) with a clear list of what you've done (read more about [pull requests](http://help.github.com/pull-requests/)). When you send a pull request, we will love you forever if you include updates and extensions to the Golang Tests. We can always use more test coverage. Please follow our coding conventions (below) and make sure all of your commits are atomic (one feature per commit).

Always write a clear log message for your commits. One-line messages are fine for small changes, but bigger changes should look like this:

```
git commit -m "A brief summary of the commit
     
A paragraph describing what changed and its impact."
```

## Coding conventions

Start reading our code and you'll get the hang of it. We optimize for readability:

  * We indent using four spaces (soft tabs)
  * We use the [Effective Go](https://golang.org/doc/effective_go) guidelines by default
