unit GIS.Render.Tiles.OSM;

////////////////////////////////////////////////////////////////////////////////
//
// Author: Jaap Baak
// https://github.com/transportmodelling/GISlib
//
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
interface
////////////////////////////////////////////////////////////////////////////////

Uses
  SysUtils, Graphics, PngImage, GIS.Render.Tiles;

Type
  TOpenStreetMapLayer = Class(TCustomTilesLayer)
  strict protected
    Function GetTile(Level,Xindex,Yindex: Integer): TGraphic; override;
  end;

////////////////////////////////////////////////////////////////////////////////
implementation
////////////////////////////////////////////////////////////////////////////////

Function TOpenStreetMapLayer.GetTile(Level,Xindex,Yindex: Integer): TGraphic;
begin
  Result := DownloadTile<TPngImage>('http://tile.openstreetmap.org/' +
                         Level.ToString + '/' +
                         Xindex.ToString + '/'+
                         YIndex.ToString + '.png');
end;

end.
