## Resolução de conflitos e banimentos da nossa comunidade

Como parte da moderação, nosso papel é fazer com que se cumpra o **[Código de Conduta](http://bit.ly/tc-conduct-code)**, propor melhorias no documento e resolver conflitos.

Neste documento constam os processos para tratarmos os problemas referentes ao **COC**.

---

## O que fazer quando alguém quebrar o código de conduta?

Devemos intervir na hora em que o problema aparecer.

Se observarmos uma pessoa sendo racista, homofóbica ou qualquer outro tipo de preconceito em seus comentários no **Slack**, por exemplo, devemos avisar a pessoa que seu comentário foi preconceituoso.

Não devemos excluir ou chegar de maneira agressiva na pessoa que cometeu a infração. A pessoa pode não entender que seu comentário é errado e nosso papel é orientar para que a pessoa não cometa mais o mesmo erro **(nem em nossa comunidade, nem em sua vida pessoal)**.

Para isso seguiremos o processo de conversar passivamente com a pessoa de maneira a orientar ela.

> Uma maneira de aprendermos a conversar passivamente é ouvindo o episódio do Podcast da [Lambda3](https://www.lambda3.com.br) sobre comunicação não violenta.
> [Lambda3 Podcast 31 – Comunicação não violenta](https://www.lambda3.com.br/2017/02/podcast-31-comunicacao-nao-violenta/)

É comum que a pessoa entenda nosso posicionamento, entenda que errou e peça desculpas na hora.

Porém o contrário também pode acontecer.

Se a pessoa não está disposta a aprender sobre preconceitos, ela não deve fazer parte da nossa comunidade. Nosso objetivo é criar um ambiente seguro e uma pessoa que não deseja aprender é uma futura agressora em nosso meio, tornando o grupo não seguro.

Podemos identificar pessoas preconceituosas e que não desejam aprender durante a comunicação sobre seu comentário errado. A pessoa logo vai demonstrar que não liga para aquilo ou que, simplesmente, não concorda que aquilo é um preconceito apesar de toda a argumentação que você tentou com ela. Antes de tudo, convoque outras pessoas para te ajudar na argumentação, às vezes a pessoa pode só estar desinformada, com raiva pelo momento e em estado defensivo. Outras pessoas podem acabar ajudando. Se a pessoa não está disposta a aprender, devemos expulsar ela do grupo.

Caso você não consiga, não esteja em um bom dia ou não saiba como proceder, deve seguir o seguinte procedimento:

* As pessoas do `Core Team` são acionadas na thread através do `@core`
* Se você é do `Core Team`, o link da thread deve ser enviado no canal `core` avisando da infração
* Outras pessoas devem intervir e tentar ajudar na orientação com suas palavras (pois às vezes a maneira de se comunicar de outra pessoa pode ser mais efetiva em algum caso específico)

Caso a pessoa realmente não esteja disposta a aprender, deve ser expulsa da comunidade.

O banimento deve ser acordado com o `Core Team`, de acordo com os passos anteriores.

## Banimento

Caso identifiquemos que uma pessoa realmente deve ser expulsa da comunidade (passos acima), um comentário deve ser adicionado à thread onde rolou a comunicação a respeito da sua infração:

```
Conforme acordado entre o time de moderação, você `@usuario` está recebendo o banimento da nossa comunidade por infração ao código de conduta
Código de conduta: http://bit.ly/tc-conduct-code
Infração cometida: xxx
```

Onde, em **Infração cometida**, devemos adicionar onde ela quebrou o **código de conduta**.

## Permissões e projetos

Qualquer pessoa pode ser banida da nossa comunidade por quebra ao **COC**. Tanto membros quanto pessoas da organização. Isso implica em: a pessoa deve ser banida do **Slack** e de nossos projetos.

Processos:

* Desativar o usuário no **Slack**
* Analisar se o usuário faz parte dos projetos e remover o usuário de lá
