<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->
<div align="center">

[![Stargazers][stars-shield]][stars-url]
[![npm][npm-shield]][npm-url]
[![Workflow][workflow-shield]][workflow-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]

</div>
<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://github.com/tomma5o/claxed">
    <img src="images/claxed_logo.png" alt="Claxed">
  </a>
  <p align="center">
    Classes with the same style of Styled-Components 🚀
    <br />
    <a href="https://github.com/tomma5o/claxed">View Demo</a>
    ·
    <a href="https://github.com/tomma5o/claxed/issues">Report Bug</a>
    ·
    <a href="https://github.com/tomma5o/claxed/issues">Request Feature</a>
  </p>
</p>

<!-- ABOUT THE PROJECT -->

## About The Project

The idea is born while using [tailwind CSS](https://tailwindcss.com/), which is a very helpful classes framewrok that gives us all the CSS classes for sizes, colors, spacings.
However it can be messy if you have a lot of classes to type inside the component. And not to mention when you want a conditional class based on a prop 💆‍♂️

With claxed, heavily inspired by [styled-components](https://styled-components.com/), we can keep our DOM a little bit cleaner with the help of some utilities like props interpolation inside the template string.

<!-- GETTING STARTED -->

### Installation

```sh
npm install claxed
```

or

```sh
yarn add claxed
```

<!-- USAGE EXAMPLES -->

## Usage

If you know styled-components this syntax might be already familiar to you. Whatever you type within the template string will be printed in the html `class` attribute of the component. In the following example every row is a CSS class.

```js
const Button = claxed.button`
  px-3
  py-2
`;

const ButtonRed = claxed(Button)`
  ${({ border }) => border && 'border'}
  text-red-500
`;

const App = () => (
  <div>
    <Button>Click me</Button>
    <ButtonRed border>Click me</ButtonRed>
  </div>
);

// Note: All the falsy values are stripped from the output
```

## Roadmap

See the [open issues](https://github.com/tomma5o/claxed/issues) for a list of proposed features (and known issues).

<!-- CONTRIBUTING -->

## Contributing

Contributions are what make the open source community such an amazing place form where to learn, be inspired, and create. Any contributions you make are **greatly appreciated**.

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## FAQ

<details>
  <summary>Is the order in which I type classes with claxed relevant for their CSS specificity?</summary>
  <p>No. Claxed is only responsible to combine CSS classes and put the result in the html `class` attribute of the component. If you have any specificity problem you should look at how classes are defined in the CSS file</p>
</details>

<!-- LICENSE -->

## License

Distributed under the MIT License. See `LICENSE` for more information.

<!-- CONTACT -->

## Contact

Tommaso Poletti - [@Tomma5o](https://twitter.com/tomma5o)

Project Link: [https://github.com/tomma5o/claxed](https://github.com/tomma5o/claxed)

<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->

[npm-shield]: https://img.shields.io/npm/v/claxed?color=%23ff0000&logo=npm
[stars-shield]: https://img.shields.io/github/stars/tomma5o/claxed?style=social
[issues-shield]: https://img.shields.io/github/issues-raw/tomma5o/claxed
[license-shield]: https://img.shields.io/npm/l/claxed
[workflow-shield]: https://img.shields.io/github/workflow/status/tomma5o/claxed/CI

<!--URLs-->

[npm-url]: https://npmjs.com/package/claxed
[stars-url]: https://github.com/tomma5o/claxed/stargazers
[issues-url]: https://github.com/tomma5o/claxed/issues
[license-url]: https://github.com/tomma5o/claxed/blob/master/LICENSE.txt
[workflow-url]: https://github.com/tomma5o/claxed/actions/workflows/main.yml
