<p align="center">
  <img src="https://i.ibb.co/xghRGsN/New-Project.png" title="SDMarket">
</p>
<p align="center">A java-based supermarket system developed by <a href="https://www.linkedin.com/in/tomergut" target="_blank">Tomer Guttman</a> and <a href="https://www.linkedin.com/in/ohad-slutzky/" target="_blank">Ohad Slutzky</a></p>
<hr>

<p align="center">
  <img style="" src="https://i.ibb.co/kyNyN4p/customer-Dash.png" title="SDMarket">
</p>

<p align="center">
  <img src="https://i.ibb.co/ngLky0q/cart-And-Disc.png" title="SDMarket">
</p>

<p align="center">
  <img src="https://i.ibb.co/M9tgGbb/notifi.png" title="SDMarket">
</p>

<p align="center">
  <img src="https://i.ibb.co/D5xXBc2/starz.png" title="SDMarket">
</p>

# SDMarket 🏪🛒
A java based super-market system

<br>Technology stack include:<br /> `Java` `Javascript` `jQuery` `Ajax` `HTML` `Bootstrap` `CSS` `Java FX` `XML` `JSON` `Tomcat` `Servelts`


# Intro
The cost of living is a significant economic burden on more and more people in the world. One of the means to alleviate the cost of living is the ability to check and compare prices in a convenient and easy way, which allows for wise consumer purchase of any basket of products.

The development of the world and technology makes it possible to bring together sellers (Stores) and shoppers, and create a digital arena in which the consumer can, on the one hand, make quick and easy price comparisons, and on the other hand, create exposure of stores to different consumers who were previously unaware of their existence.

SDMarket allows you to set up stores that sell various items and will allow the consumer to order these items, while the system performs the ideal price comparison according to the consumer's requirements. 

## Main Features

- [x] Add stores and customers
- [x] Add new items to the zone and store that zone
- [x] Perform static/dynamic orders
- [x] Load data from an XML file
- [x] Full web-application
- [x] Users transaction system
- [x] Users notifications system for various events
- [x] Chat between the system users
- [x] Stores feedback and rating system

## Requirements
In order to deploy SDMarket you will need:
* [Apache Tomcat](http://tomcat.apache.org/)
* Java installed on your computer
    
## Deploying

1. Install Tomcat on your system
2. Fork/Clone the repository
3. Download the .war file inside of `SDMarket/Web/warfile/` named `webapp_war.war`
4. Put the war file `webapp_war.war` inside of `/Tomcat/webapps/` folder
5. Run Tomcat using the `startup.bat` in the `bin` folder.
6. Navigate to `localhost:8080` in the browser
7. Press `Manager App` 
8. Inside the applications table look for `webapp_war` link and press it
9. Welcome to SDMarket!


## Contributing

Please see our [CONTRIBUTING.md](CONTRIBUTING.md) file for details on how to contribute to SDMarket.

## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE) file for details

## Team & Credits

- Authors: <a href="mailto:tomerguttman27@gmail.com" target="_blank">Tomer Guttman</a>, <a href="mailto:ohadslu@gmail.com" target="_blank">Ohad Slutzky</a>
- Mentor: Aviad Cohen
