/*
 * Decompiled with CFR 0.152.
 */
package SDMImprovedFacade;

import SDMImprovedFacade.Order;
import SDMImprovedFacade.Store;
import SDMImprovedFacade.StoreItem;
import generatedClasses.SDMItem;
import generatedClasses.SDMSell;
import generatedClasses.SDMStore;
import generatedClasses.SuperDuperMarketDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SuperDuperMarket {
    private final Map<Integer, Store> systemStores;
    private final Map<Integer, StoreItem> systemItems;
    private Map<Integer, Order> systemDynamicOrders = null;
    private int orderID = 1;

    public SuperDuperMarket(SuperDuperMarketDescriptor inputSDM) {
        this.systemStores = inputSDM.getSDMStores().getSDMStore().stream().collect(Collectors.toMap(SDMStore::getId, Store::new));
        this.systemItems = inputSDM.getSDMItems().getSDMItem().stream().collect(Collectors.toMap(SDMItem::getId, StoreItem::new));
        this.initializeStoresItems(inputSDM);
        this.initializeAveragePriceOfItemAndAmountOfStoresSellingAnItem();
    }

    public void initializeAveragePriceOfItemAndAmountOfStoresSellingAnItem() {
        Collection<Store> storesInSystem = this.systemStores.values();
        for (StoreItem systemItem : this.systemItems.values()) {
            int amountOfStoresSellingAnItem = 0;
            double sum = 0.0;
            for (Store store : this.systemStores.values()) {
                if (!store.getItemsBeingSold().containsKey(systemItem.getId())) continue;
                ++amountOfStoresSellingAnItem;
                sum += store.getItemsBeingSold().get(systemItem.getId()).getPricePerUnit();
            }
            systemItem.setAveragePriceOfTheItem(sum / (double)amountOfStoresSellingAnItem);
            systemItem.setAmountOfStoresSellingThisItem(amountOfStoresSellingAnItem);
        }
    }

    private void initializeStoresItems(SuperDuperMarketDescriptor inputSDM) {
        Map<Integer, SDMItem> SDMItemsMap = inputSDM.getSDMItems().getSDMItem().stream().collect(Collectors.toMap(SDMItem::getId, item -> item));
        for (SDMStore currentStore : inputSDM.getSDMStores().getSDMStore()) {
            HashMap<Integer, StoreItem> storeItemsForSaleImproved = new HashMap<Integer, StoreItem>();
            Store improvedStore = this.systemStores.get(currentStore.getId());
            for (SDMSell currentItem : currentStore.getSDMPrices().getSDMSell()) {
                storeItemsForSaleImproved.put(currentItem.getItemId(), new StoreItem(SDMItemsMap.get(currentItem.getItemId()), currentItem));
            }
            improvedStore.setItemBeingSold(storeItemsForSaleImproved);
        }
    }

    public Map<Integer, Store> getSystemStores() {
        return this.systemStores;
    }

    public Map<Integer, StoreItem> getSystemItems() {
        return this.systemItems;
    }

    public void setOrderID(int orderID) {
        this.orderID = orderID;
    }

    public int getOrderID() {
        return this.orderID++;
    }

    public Map<Integer, Order> getSystemDynamicOrders() {
        return this.systemDynamicOrders;
    }

    public void addDynamicOrder(Order dynamicOrder) {
        if (this.systemDynamicOrders == null) {
            this.systemDynamicOrders = new HashMap<Integer, Order>();
        }
        this.systemDynamicOrders.put(dynamicOrder.getOrderId(), dynamicOrder);
    }
}

