/*
 * Decompiled with CFR 0.152.
 */
package SDMImprovedFacade;

import SDMImprovedFacade.StoreItem;
import generatedClasses.Location;
import java.util.HashSet;
import java.util.List;

public class Order {
    final int orderId;
    final int storeId;
    final double deliveryCost;
    final double costOfItemsInOrder;
    final double totalOrderCost;
    final String dateOrderWasMade;
    final String storeName;
    final Location orderDestination;
    private int amountOfStoresRelatedToOrder;
    final List<StoreItem> itemsInOrder;

    public Order(String dateOrderWasMade, int orderId, int storeId, double deliveryCost, String storeName, List<StoreItem> itemsInOrder, Location userLocation) {
        this.dateOrderWasMade = dateOrderWasMade;
        this.orderId = orderId;
        this.storeId = storeId;
        this.deliveryCost = deliveryCost;
        this.storeName = storeName;
        this.itemsInOrder = itemsInOrder;
        this.costOfItemsInOrder = this.calculateTotalCostOfItemsInOrder();
        this.totalOrderCost = deliveryCost + this.costOfItemsInOrder;
        this.orderDestination = userLocation;
        this.amountOfStoresRelatedToOrder = 1;
    }

    public Order(String dateOrderWasMade, Location userLocation, int orderId, Double deliveryCost, int amountOfStoresParticipating, List<StoreItem> itemsInOrder) {
        this.dateOrderWasMade = dateOrderWasMade;
        this.orderId = orderId;
        this.storeId = -1;
        this.deliveryCost = deliveryCost;
        this.storeName = String.format("Dynamic Order %d", orderId);
        this.itemsInOrder = itemsInOrder;
        this.costOfItemsInOrder = this.calculateTotalCostOfItemsInOrder();
        this.totalOrderCost = deliveryCost + this.costOfItemsInOrder;
        this.orderDestination = userLocation;
        this.amountOfStoresRelatedToOrder = amountOfStoresParticipating;
    }

    public int getNumberOfItemsInOrder() {
        HashSet itemsInOrderSet = new HashSet();
        this.itemsInOrder.forEach(item -> itemsInOrderSet.add(item.getId()));
        return itemsInOrderSet.size();
    }

    private double calculateTotalCostOfItemsInOrder() {
        return this.itemsInOrder.stream().mapToDouble(itemInOrder -> itemInOrder.getTotalItemsSold() * itemInOrder.getPricePerUnit()).sum();
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int getStoreId() {
        return this.storeId;
    }

    public double getCostOfItemsInOrder() {
        return this.costOfItemsInOrder;
    }

    public double getTotalOrderCost() {
        return this.totalOrderCost;
    }

    public double getDeliveryCost() {
        return this.deliveryCost;
    }

    public Location getOrderDestination() {
        return this.orderDestination;
    }

    public String getDateOrderWasMade() {
        return this.dateOrderWasMade;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public List<StoreItem> getItemsInOrder() {
        return this.itemsInOrder;
    }

    public int getAmountOfStoresRelated() {
        return this.amountOfStoresRelatedToOrder;
    }

    public void setAmountOfStoresRelated(int amountOfStoresRelated) {
        this.amountOfStoresRelatedToOrder = amountOfStoresRelated;
    }

    private int getTotalNumberOfItemsInOrder() {
        return this.itemsInOrder.stream().mapToInt(item -> {
            if (item.getPurchaseCategory().equals("Weight")) {
                return 1;
            }
            return (int)item.getTotalItemsSold();
        }).sum();
    }

    public String getStringWholeOrder() {
        StringBuilder stbOrder = new StringBuilder();
        this.itemsInOrder.forEach(item -> {
            stbOrder.append(item.getStringItemForPurchase());
            stbOrder.append("\t\tAmount Bought: ").append(item.getTotalItemsSold()).append("\n");
            stbOrder.append("\t\tTotal Price: ").append(item.getTotalItemsSold() * item.getPricePerUnit()).append("\n");
        });
        return stbOrder.toString();
    }

    public String toString() {
        return "\tOrder ID: " + this.orderId + "\n\t\tDate Of Order: " + this.dateOrderWasMade + "\n\t\tStore ID: " + this.storeId + "(" + this.storeName + ")\n\t\tAmount Of Item Types: " + this.getNumberOfItemsInOrder() + "\n\t\tTotal Number Of Items In Order: " + this.getTotalNumberOfItemsInOrder() + "\n\t\tTotal Cost Of Items In Order: " + String.format("%.2f", this.costOfItemsInOrder) + "\n\t\tDelivery Cost: " + String.format("%.2f", this.deliveryCost) + "\n\t\tTotal Cost Of Order: " + String.format("%.2f", this.totalOrderCost) + "\n";
    }

    public String toStringDynamicOrder() {
        return "\tOrder ID: " + this.orderId + "\n\t\tDate Of Order: " + this.dateOrderWasMade + "\n\t\tAmount Of Stores Participating In Order: " + this.amountOfStoresRelatedToOrder + "\n\t\tAmount Of Item Types: " + this.getNumberOfItemsInOrder() + "\n\t\tTotal Number Of Items In Order: " + this.getTotalNumberOfItemsInOrder() + "\n\t\tTotal Cost Of Items In Order: " + String.format("%.2f", this.costOfItemsInOrder) + "\n\t\tDelivery Cost: " + String.format("%.2f", this.deliveryCost) + "\n\t\tTotal Cost Of Order: " + String.format("%.2f", this.totalOrderCost) + "\n";
    }
}

