/*
 * Decompiled with CFR 0.152.
 */
package SDMImprovedFacade;

import SDMImprovedFacade.Order;
import SDMImprovedFacade.StoreItem;
import generatedClasses.Location;
import generatedClasses.SDMStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Store {
    private final int Id;
    private int deliveryPpk;
    private double totalOrdersRevenue = 0.0;
    private String name;
    private Location storeLocation;
    private Map<Integer, StoreItem> itemsBeingSold;
    private final List<Order> storeOrdersHistory;

    public Store(SDMStore inputStore) {
        this.Id = inputStore.getId();
        this.deliveryPpk = inputStore.getDeliveryPpk();
        this.name = inputStore.getName();
        this.storeLocation = inputStore.getLocation();
        this.storeOrdersHistory = new ArrayList<Order>();
    }

    public void setTotalOrdersRevenue(double totalOrdersRevenue) {
        this.totalOrdersRevenue = totalOrdersRevenue;
    }

    public double getTotalOrdersRevenue() {
        return this.totalOrdersRevenue;
    }

    public Map<Integer, StoreItem> getItemsBeingSold() {
        return this.itemsBeingSold;
    }

    public List<Order> getStoreOrdersHistory() {
        return this.storeOrdersHistory;
    }

    public Order getLastOrder() {
        return this.storeOrdersHistory.get(this.storeOrdersHistory.size() - 1);
    }

    public void setItemBeingSold(Map<Integer, StoreItem> itemBeingSold) {
        this.itemsBeingSold = itemBeingSold;
    }

    public int getId() {
        return this.Id;
    }

    public int getDeliveryPpk() {
        return this.deliveryPpk;
    }

    public void setDeliveryPpk(int deliveryPpk) {
        this.deliveryPpk = deliveryPpk;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(Location storeLocation) {
        this.storeLocation = storeLocation;
    }

    public void generateOrder(String orderDate, int orderId, List<StoreItem> itemsInOrder, Location userCoordinates) {
        Order order = new Order(orderDate, orderId, this.Id, this.calculateDistance(userCoordinates) * (double)this.deliveryPpk, this.name, itemsInOrder, userCoordinates);
        this.storeOrdersHistory.add(order);
        this.totalOrdersRevenue += order.getTotalOrderCost();
    }

    public double calculateDistance(Location userCoordinates) {
        int x1 = userCoordinates.getX();
        int x2 = this.storeLocation.getX();
        int y1 = userCoordinates.getY();
        int y2 = this.storeLocation.getY();
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public String displayStoreForPurchase() {
        return "- ID: " + this.Id + ", Name: " + this.name + ", PPK: " + this.deliveryPpk + "\n";
    }

    public String getStringStoreItemsShort() {
        StringBuilder storeItemsStringBuilder = new StringBuilder();
        storeItemsStringBuilder.append("-----\tStore items available\t-----\n");
        this.itemsBeingSold.values().forEach(item -> storeItemsStringBuilder.append(item.getStringItemForPurchase()));
        return storeItemsStringBuilder.toString();
    }

    public String toString() {
        StringBuilder storeInformation = new StringBuilder();
        storeInformation.append("\n<><><><><>   Store - ").append(this.Id).append("  <><><><><>\n");
        storeInformation.append("Store ID: ").append(this.Id).append("\n").append("Store Name: ").append(this.name).append("\n");
        storeInformation.append("Store PPK: ").append(this.deliveryPpk).append("\n");
        storeInformation.append("Total Orders Revenue: ").append(String.format("%.2f", this.totalOrdersRevenue)).append("\n\n");
        storeInformation.append("Store Item List: ").append(this.itemsBeingSold.size()).append(" items\n");
        storeInformation.append("\n-----  Store Items  -----\n\n");
        this.itemsBeingSold.values().forEach(item -> storeInformation.append(item.toString()));
        storeInformation.append("\n-----  Store Orders  -----\n\n");
        if (!this.storeOrdersHistory.isEmpty()) {
            this.storeOrdersHistory.forEach(order -> storeInformation.append(order.toString()));
        } else {
            storeInformation.append("\tThere are no orders that were made from this store.\n\n");
        }
        return storeInformation.toString();
    }
}

