/*
 * Decompiled with CFR 0.152.
 */
import SDMImprovedFacade.Store;
import SDMImprovedFacade.StoreItem;
import SuperMarketLogic.SuperMarketLogic;
import com.google.gson.Gson;
import generatedClasses.Location;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class ConsoleUI {
    private SuperMarketLogic SDMLogic;
    private boolean dataWasLoaded = false;

    public static void main(String[] args) {
        ConsoleUI ConsoleApp = new ConsoleUI();
        ConsoleApp.run();
    }

    private void printMenu() {
        System.out.println("\nPlease select one of the following options by entering a number:");
        System.out.println("1.Load system details from XML file.");
        System.out.println("2.Print the details of all the stores that are currently in the system.");
        System.out.println("3.Print the details of all the items that are currently in the system.");
        System.out.println("4.Perform a purchase.");
        System.out.println("5.Print orders history of the entire system.");
        System.out.println("6.Update store products.");
        System.out.println("7.Save system orders to file.");
        System.out.println("8.Load orders history");
        System.out.println("\nPress 'q' at any time to exit the system");
    }

    private boolean validateMenuUserInputChoice(String userInput) throws IllegalInputException {
        try {
            int userInputParsed = Integer.parseInt(userInput);
            return 1 <= userInputParsed && userInputParsed <= 8;
        }
        catch (NumberFormatException e) {
            if (userInput.toLowerCase().equals("q")) {
                return true;
            }
            throw new IllegalInputException("<IllegalInputException: The input you entered is not a number or 'q'>\n");
        }
    }

    private void run() {
        this.SDMLogic = new SuperMarketLogic();
        Scanner scn = new Scanner(System.in);
        StringBuilder outputMessage = new StringBuilder();
        boolean exitFlag = false;
        while (!exitFlag) {
            try {
                this.printMenu();
                String userMenuChoice = scn.nextLine().trim();
                outputMessage.setLength(0);
                if (this.validateMenuUserInputChoice(userMenuChoice)) {
                    if (userMenuChoice.equals("q")) {
                        exitFlag = true;
                        System.out.println("Thank you for using our SDMarket");
                        continue;
                    }
                    if (userMenuChoice.equals("1")) {
                        this.handleLoadDataFromXMLAction(scn, outputMessage);
                        System.out.println("\n" + outputMessage.toString() + "\n");
                        continue;
                    }
                    if (this.dataWasLoaded) {
                        this.performActionOfChoice(userMenuChoice);
                        continue;
                    }
                    System.out.println("\n<You can't perform this action without loading a system data file first>\n");
                    continue;
                }
                System.out.println("\n<Please choose one of the options available between [1 - 6] or 'q' to exit the system>\n");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void handleLoadDataFromXMLAction(Scanner scn, StringBuilder outputMessage) throws JAXBException {
        System.out.println("Please enter a path to the .xml file in order to load it.");
        this.dataWasLoaded = this.SDMLogic.loadData(scn.nextLine().trim(), outputMessage) || this.dataWasLoaded;
    }

    private void performActionOfChoice(String userMenuChoice) throws Exception {
        switch (userMenuChoice) {
            case "2": {
                this.displayStoresInformation();
                break;
            }
            case "3": {
                this.displaySystemItemsInformation();
                break;
            }
            case "4": {
                this.receiveOrderFromUser();
                break;
            }
            case "5": {
                this.displayAllStoresOrderHistory();
                break;
            }
            case "6": {
                this.updateStoreProducts();
                break;
            }
            case "7": {
                this.saveOrderHistoryToFile();
                break;
            }
            case "8": {
                this.loadOrderHistoryFromFile();
                break;
            }
            default: {
                this.printUserMenuChoiceError();
            }
        }
    }

    private void loadOrderHistoryFromFile() throws Exception {
        Gson gson = new Gson();
        StringBuilder pathToFiles = new StringBuilder();
        Scanner scanner = new Scanner(System.in);
        if (this.getAndValidatePathForLoad(pathToFiles, scanner)) {
            this.SDMLogic.loadStaticOrdersHistory(pathToFiles.toString() + "_static_orders_history.json", gson);
            this.SDMLogic.loadDynamicOrdersHistory(pathToFiles.toString() + "_dynamic_orders_history.json", gson);
            this.SDMLogic.setOrderIDAfterHistoryLoaded();
            System.out.println("\nOrders history was loaded successfully!\n");
        } else {
            System.out.println("<The file does not exist>");
        }
    }

    private boolean getAndValidatePathForLoad(StringBuilder pathToFiles, Scanner scanner) throws Exception {
        try {
            System.out.println("\nPlease enter a path to the saved file (without a file type).");
            String userPathInput = scanner.nextLine().trim();
            Path staticPath = Paths.get(userPathInput + "_static_orders_history.json", new String[0]);
            Path dynamicPath = Paths.get(userPathInput + "_dynamic_orders_history.json", new String[0]);
            pathToFiles.append(userPathInput);
            return Files.exists(staticPath, new LinkOption[0]) && Files.exists(dynamicPath, new LinkOption[0]);
        }
        catch (Exception e) {
            throw new Exception("<There was an error validating the input path>");
        }
    }

    private void saveOrderHistoryToFile() throws Exception {
        block5: {
            if (this.SDMLogic.getLastOrderID() != 1) {
                Scanner scanner = new Scanner(System.in);
                Gson gson = new Gson();
                StringBuilder pathToFileStringBuilder = new StringBuilder();
                try {
                    if (this.getAndValidatePath(pathToFileStringBuilder, scanner)) {
                        String stringPathToFile = pathToFileStringBuilder.toString();
                        this.SDMLogic.writeStaticOrdersToFile(stringPathToFile, gson);
                        this.SDMLogic.writeDynamicOrdersToFile(stringPathToFile, gson);
                        System.out.println("\nOrders history was successfully saved!");
                        break block5;
                    }
                    System.out.println("<The input path does not exist>");
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            } else {
                System.out.println("<There are no orders in the system to save>");
            }
        }
    }

    private boolean getAndValidatePath(StringBuilder pathToFileStringBuilder, Scanner scanner) throws Exception {
        try {
            System.out.println("\nPlease enter the path of the file with the file name included (without a file type).");
            String userPathInput = scanner.nextLine().trim();
            String directoryPath = userPathInput.substring(0, userPathInput.lastIndexOf(92));
            Path path = Paths.get(directoryPath, new String[0]);
            pathToFileStringBuilder.append(userPathInput);
            return Files.exists(path, new LinkOption[0]);
        }
        catch (Exception e) {
            throw new Exception("<There was an error validating the input path>");
        }
    }

    private void updateStoreProducts() {
        Scanner scn = new Scanner(System.in);
        String userInput = this.getAndValidateUpdateStoreProductInput(scn);
        this.performUpdateStoreProductsOfChoice(userInput, scn);
    }

    private void performUpdateStoreProductsOfChoice(String userInput, Scanner scn) {
        switch (userInput) {
            case "1": {
                this.updateStoreItemPrice(scn);
                break;
            }
            case "2": {
                this.addItemToStore(scn);
                break;
            }
            case "3": {
                this.removeItemFromStore(scn);
                break;
            }
            default: {
                this.printUserMenuChoiceError();
            }
        }
    }

    private void removeItemFromStore(Scanner scn) {
        Store storeOfChoice = this.printAndGetStoreOfChoice(scn);
        StoreItem itemToRemove = this.getStoreItemToRemove(scn, storeOfChoice);
        if (itemToRemove != null) {
            this.SDMLogic.removeItemFromStore(itemToRemove, storeOfChoice);
            System.out.println("The item was removed successfully!\n");
        }
    }

    private StoreItem getStoreItemToRemove(Scanner scn, Store storeOfChoice) {
        System.out.println(storeOfChoice.getStringStoreItemsShort());
        StoreItem itemToRemove = null;
        boolean isValidItemToRemove = false;
        while (!isValidItemToRemove) {
            System.out.println("Please select an item to remove");
            String userInput = scn.nextLine();
            if (this.isNumber(userInput)) {
                int userInputInteger = Integer.parseInt(userInput);
                if (storeOfChoice.getItemsBeingSold().containsKey(userInputInteger)) {
                    itemToRemove = this.SDMLogic.getItems().get(userInputInteger);
                    isValidItemToRemove = true;
                    continue;
                }
                System.out.println("<The item you chose is not sold by the store>\n");
                continue;
            }
            System.out.println("<The input is not an integer>\n");
        }
        if (storeOfChoice.getItemsBeingSold().size() <= 1) {
            System.out.println("<This is the only item this store is selling, therefore it cannot be removed>\n");
        } else {
            if (this.SDMLogic.getItems().get(itemToRemove.getId()).getAmountOfStoresSellingThisItem() > 1) {
                return itemToRemove;
            }
            System.out.println("<This store is the only one selling this item, therefore it cannot be removed>\n");
        }
        return null;
    }

    private void addItemToStore(Scanner scn) {
        Store storeOfChoice = this.printAndGetStoreOfChoice(scn);
        StoreItem itemToAdd = this.getSystemItemToAdd(scn, storeOfChoice);
        this.SDMLogic.addItemToStore(itemToAdd, storeOfChoice);
        System.out.println("The item was added successfully!\n");
    }

    private StoreItem getSystemItemToAdd(Scanner scn, Store storeOfChoice) {
        return this.getAndValidateSystemItemToAdd(scn, storeOfChoice);
    }

    private StoreItem getAndValidateSystemItemToAdd(Scanner scn, Store storeOfChoice) {
        this.displaySystemItemsInformation();
        StoreItem itemToAdd = null;
        boolean isValidItemToAdd = false;
        while (!isValidItemToAdd) {
            System.out.println("Please select an item to add");
            String userInput = scn.nextLine();
            if (this.isNumber(userInput)) {
                int userInputInteger = Integer.parseInt(userInput);
                if (this.SDMLogic.getItems().containsKey(userInputInteger)) {
                    if (!storeOfChoice.getItemsBeingSold().containsKey(userInputInteger)) {
                        isValidItemToAdd = true;
                        itemToAdd = this.SDMLogic.getItems().get(userInputInteger);
                        continue;
                    }
                    System.out.println("<The item you chose already exists in this store>\n");
                    continue;
                }
                System.out.println("<The ID you chose does not belong to an existing item>\n");
                continue;
            }
            System.out.println("<The input is not an integer>\n");
        }
        return itemToAdd;
    }

    private void updateStoreItemPrice(Scanner scn) {
        Store storeOfChoice = this.printAndGetStoreOfChoice(scn);
        StoreItem itemToUpdate = this.getItemToUpdate(scn, storeOfChoice);
        this.updateItemPrice(scn, itemToUpdate, storeOfChoice.getId());
        this.SDMLogic.updateAllStoresItemsAveragePricesAndAmountOfStoresSellingAnItem();
        System.out.println("The price was updated successfully!\n");
    }

    private void updateItemPrice(Scanner scn, StoreItem itemToUpdate, int storeOfChoiceId) {
        double newPrice = this.getAndValidatePrice(scn);
        this.SDMLogic.updatePriceOfAnItem(storeOfChoiceId, itemToUpdate.getId(), newPrice);
    }

    private double getAndValidatePrice(Scanner scn) {
        boolean isValidPrice = false;
        double priceOfChoice = 0.0;
        while (!isValidPrice) {
            System.out.println("Please enter the new price of the item");
            String userInput = scn.nextLine();
            if (this.isDouble(userInput)) {
                isValidPrice = true;
                priceOfChoice = Double.parseDouble(userInput);
                continue;
            }
            System.out.println("<The input you entered is not a number>");
        }
        return priceOfChoice;
    }

    private StoreItem getItemToUpdate(Scanner scn, Store storeOfChoice) {
        return this.getAndValidateItemById(scn, storeOfChoice);
    }

    private StoreItem getAndValidateItemById(Scanner scn, Store storeOfChoice) {
        boolean isValidItemId = false;
        StoreItem chosenItem = null;
        this.printStoreItemsForUpdate(storeOfChoice);
        while (!isValidItemId) {
            System.out.println("Please choose an item by it's id");
            String userInput = scn.nextLine().trim();
            if (this.isNumber(userInput)) {
                if (storeOfChoice.getItemsBeingSold().containsKey(Integer.parseInt(userInput))) {
                    chosenItem = storeOfChoice.getItemsBeingSold().get(Integer.parseInt(userInput));
                    isValidItemId = true;
                    continue;
                }
                System.out.println("<The ID you entered does not exist in the current store>\n");
                continue;
            }
            System.out.println("<The input you entered is not an integer>\n");
        }
        return chosenItem;
    }

    private void printStoreItemsForUpdate(Store storeOfChoice) {
        StringBuilder allStoreItems = new StringBuilder();
        storeOfChoice.getItemsBeingSold().values().forEach(item -> allStoreItems.append(item.getStringItemForPurchase()));
        System.out.println(allStoreItems.toString());
    }

    private Store printAndGetStoreOfChoice(Scanner scn) {
        StringBuilder allStoresToChooseFrom = new StringBuilder();
        allStoresToChooseFrom.append("\n-----\tStores to choose from\t-----\n");
        this.SDMLogic.getStores().values().forEach(store -> allStoresToChooseFrom.append(store.displayStoreForPurchase()));
        System.out.println(allStoresToChooseFrom.toString());
        return this.getStoreOfChoiceByID(scn);
    }

    private String getAndValidateUpdateStoreProductInput(Scanner scn) {
        String userInput = null;
        boolean isValidInput = false;
        while (!isValidInput) {
            this.printStoreUpdateMenu();
            userInput = scn.nextLine().trim();
            if (this.isNumber(userInput)) {
                int integerUserInput = Integer.parseInt(userInput);
                if (1 <= integerUserInput && integerUserInput <= 3) {
                    isValidInput = true;
                    continue;
                }
                System.out.println("<Please enter a number between [1-3]>\n");
                continue;
            }
            System.out.println("<The input is not a number>\n");
        }
        return userInput;
    }

    private void printStoreUpdateMenu() {
        System.out.println("\tPlease choose one of the following options:");
        System.out.println("\t\t1.Update item price.");
        System.out.println("\t\t2.Add item to store.");
        System.out.println("\t\t3.Remove item from store.\n");
    }

    private void printUserMenuChoiceError() {
        System.out.println("<Something went terribly weird inside of the switch case in the [performActionOfChoice] method>");
    }

    private void receiveOrderFromUser() {
        String userPurchaseMethod = this.receiveUserPurchaseMethod();
        this.redirectToRelevantPurchaseMethod(userPurchaseMethod);
    }

    private String receiveUserPurchaseMethod() {
        Scanner scn = new Scanner(System.in);
        boolean isValidPurchaseMethod = false;
        String userInput = null;
        this.printPurchaseMethodMenu();
        while (!isValidPurchaseMethod) {
            System.out.println("Please choose a purchase method");
            userInput = scn.nextLine().trim();
            if (this.isNumber(userInput)) {
                int userInputToInteger = Integer.parseInt(userInput);
                if (1 == userInputToInteger || userInputToInteger == 2) {
                    isValidPurchaseMethod = true;
                    continue;
                }
                System.out.println("<The number you entered is not a valid purchase choice>\n");
                continue;
            }
            System.out.println("<The input you entered is not an integer>\n");
        }
        return userInput;
    }

    private void printPurchaseMethodMenu() {
        System.out.println("\n1.Static purchase - choose and buy from a specific store");
        System.out.println("2.Dynamic purchase - choose the items and the system will find the cheapest shopping cart");
    }

    private void redirectToRelevantPurchaseMethod(String userPurchaseMethod) {
        switch (userPurchaseMethod) {
            case "1": {
                this.performStaticPurchase();
                break;
            }
            case "2": {
                this.performDynamicPurchase();
                break;
            }
            default: {
                this.printUserMenuChoiceError();
            }
        }
    }

    private void performDynamicPurchase() {
        Scanner sc = new Scanner(System.in);
        AtomicReference<Double> sumOfDeliveryCost = new AtomicReference<Double>(0.0);
        String userDateInput = this.getDateFromUserAndValidate(sc);
        Location userLocationInput = this.getLocationFromUserAndValidate(sc);
        Map<Integer, Double> itemsToOrderWithAmount = this.getAllItemsOfOrderDynamically(sc);
        if (!itemsToOrderWithAmount.isEmpty()) {
            Map<Integer, Store> cheapestStoresForEachProduct = this.SDMLogic.getCheapestStoresPerProductMap(itemsToOrderWithAmount);
            List<StoreItem> itemsToOrder = this.SDMLogic.createListOfOrderedItemsByCheapestPrice(itemsToOrderWithAmount, cheapestStoresForEachProduct);
            this.displayDynamicLastOrder(itemsToOrder);
            if (this.isOrderApproved(sc)) {
                Map<Integer, List<StoreItem>> itemsListForEachStore = this.SDMLogic.generateItemsListForEachStore(itemsToOrder, cheapestStoresForEachProduct);
                int orderIDForAllOrdersIncluded = this.SDMLogic.getLastOrderID();
                itemsListForEachStore.forEach((storeID, listOfItems) -> {
                    this.SDMLogic.updateStoreAndSystemItemAmountInformationAccordingToNewOrder((List<StoreItem>)listOfItems, this.SDMLogic.getStores().get(storeID));
                    sumOfDeliveryCost.set((Double)sumOfDeliveryCost.get() + this.SDMLogic.updateStoreRevenue((List<StoreItem>)listOfItems, this.SDMLogic.getStores().get(storeID), userLocationInput, userDateInput, orderIDForAllOrdersIncluded));
                });
                this.SDMLogic.generateDynamicOrderAndRecord(itemsToOrder, sumOfDeliveryCost.get(), userDateInput, userLocationInput, itemsListForEachStore.size(), orderIDForAllOrdersIncluded);
                System.out.println("\nThe order was successfully made!");
            } else {
                System.out.println("\nThe order was cancelled!\n");
            }
        } else {
            System.out.println("\nThe order was cancelled!\n");
        }
    }

    private void displayDynamicLastOrder(List<StoreItem> itemsToOrder) {
        System.out.println(this.SDMLogic.getStringOfDynamicLastOrder(itemsToOrder));
    }

    private Map<Integer, Double> getAllItemsOfOrderDynamically(Scanner sc) {
        boolean orderIsFinished = false;
        HashMap<Integer, Double> orderItems = new HashMap<Integer, Double>();
        this.displaySystemItemsInformation();
        while (!orderIsFinished) {
            try {
                System.out.println("Please choose an item by it's ID. PRESS 'q' TO FINISH THE ORDER");
                String userInput = sc.nextLine().trim();
                if (!this.validateItemIdToOrder(userInput)) continue;
                if (userInput.equals("q")) {
                    orderIsFinished = true;
                    continue;
                }
                int inputParsedToInteger = Integer.parseInt(userInput);
                double amountOfTheItem = this.getAmountOfItem(sc, this.SDMLogic.getItems().get(inputParsedToInteger));
                if (orderItems.containsKey(inputParsedToInteger)) {
                    orderItems.put(inputParsedToInteger, (Double)orderItems.get(inputParsedToInteger) + amountOfTheItem);
                    continue;
                }
                orderItems.put(inputParsedToInteger, amountOfTheItem);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return orderItems;
    }

    private boolean validateItemIdToOrder(String userInput) {
        return userInput.toLowerCase().equals("q") || this.isNumber(userInput) && this.SDMLogic.getItems().containsKey(Integer.parseInt(userInput));
    }

    private void performStaticPurchase() {
        Scanner sc = new Scanner(System.in);
        this.displayShortPresentationOfSystemStores();
        Store storeToOrderFrom = this.getStoreOfChoiceByID(sc);
        String userDateInput = this.getDateFromUserAndValidate(sc);
        Location userLocationInput = this.getLocationFromUserAndValidate(sc);
        this.displayAllSystemItemsForPurchaseByStore(storeToOrderFrom);
        List<StoreItem> orderItems = this.getAllItemsOfOrder(sc, storeToOrderFrom);
        if (orderItems.size() > 0) {
            this.displayLastOrder(orderItems, storeToOrderFrom, userLocationInput);
            if (this.isOrderApproved(sc)) {
                this.SDMLogic.updateStoreAndSystemItemAmountInformationAccordingToNewOrder(orderItems, storeToOrderFrom);
                this.SDMLogic.generateOrderForStore(storeToOrderFrom, userDateInput, this.SDMLogic.getLastOrderID(), orderItems, userLocationInput);
                System.out.println("\nThe order was successfully made!");
            } else {
                System.out.println("\nThe order was cancelled!\n");
            }
        } else {
            System.out.println("\nThe order was cancelled!\n");
        }
    }

    private void displayLastOrder(List<StoreItem> orderItems, Store storeToOrderFrom, Location userLocationInput) {
        double distanceFromUser = this.SDMLogic.calculateDistanceFromUser(storeToOrderFrom, userLocationInput);
        int ppk = this.SDMLogic.getStorePpk(storeToOrderFrom);
        String lastOrderString = this.SDMLogic.getStringOfStaticLastOrder(orderItems, distanceFromUser, ppk);
        System.out.println(lastOrderString);
    }

    private boolean isOrderApproved(Scanner sc) {
        boolean isInputValid = false;
        boolean acceptOrder = false;
        while (!isInputValid) {
            System.out.println("Do you approve the order? Please answer by typing 'Y' / 'N'");
            String userInput = sc.nextLine().trim().toUpperCase();
            if (userInput.equals("Y")) {
                isInputValid = true;
                acceptOrder = true;
                continue;
            }
            if (userInput.equals("N")) {
                isInputValid = true;
                continue;
            }
            System.out.println("Please enter 'Y' or 'N'");
        }
        return acceptOrder;
    }

    private List<StoreItem> getAllItemsOfOrder(Scanner sc, Store storeToOrderFrom) {
        boolean orderIsFinished = false;
        ArrayList<StoreItem> orderItems = new ArrayList<StoreItem>();
        while (!orderIsFinished) {
            try {
                System.out.println("Please choose an item by it's ID. PRESS 'q' TO FINISH THE ORDER");
                String userInput = sc.nextLine();
                if (!this.validateOrderInput(storeToOrderFrom.getItemsBeingSold(), userInput)) continue;
                if (userInput.equals("q")) {
                    orderIsFinished = true;
                    continue;
                }
                orderItems.add(this.handleAmountForOneItem(sc, Integer.parseInt(userInput), storeToOrderFrom));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return orderItems;
    }

    private StoreItem handleAmountForOneItem(Scanner sc, int userInput, Store storeToOrderFrom) {
        StoreItem sItem = storeToOrderFrom.getItemsBeingSold().get(userInput);
        StoreItem item = new StoreItem(sItem);
        item.setTotalItemsSold(this.getAmountOfItem(sc, item));
        return item;
    }

    private double getAmountOfItem(Scanner sc, StoreItem itemToBuy) {
        double doubleUserInput = 0.0;
        boolean isInputValid = false;
        while (!isInputValid) {
            System.out.format("How much %s would you like to order?\n", itemToBuy.getName());
            String userInput = sc.nextLine();
            if (itemToBuy.getPurchaseCategory().equals("Quantity")) {
                if (this.isNumber(userInput)) {
                    doubleUserInput = Integer.parseInt(userInput);
                    if (!(doubleUserInput >= 1.0)) continue;
                    isInputValid = true;
                    continue;
                }
                System.out.println("<The input you entered is not an integer>");
                continue;
            }
            if (this.isDouble(userInput)) {
                doubleUserInput = Double.parseDouble(userInput);
                if (!(doubleUserInput > 0.0)) continue;
                isInputValid = true;
                continue;
            }
            System.out.println("<The input you entered is not a number>");
        }
        return doubleUserInput;
    }

    private boolean isDouble(String userInput) {
        try {
            Double.parseDouble(userInput);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean validateOrderInput(Map<Integer, StoreItem> itemsBeingSold, String userInput) throws Exception {
        try {
            if (userInput.equals("q")) {
                return true;
            }
            if (this.isNumber(userInput)) {
                if (itemsBeingSold.containsKey(Integer.parseInt(userInput))) {
                    return true;
                }
                throw new IllegalInputException("<The item ID you entered is not sold by the store>");
            }
        }
        catch (NumberFormatException e) {
            throw new Exception("<The input was not 'q', nor a number>");
        }
        return false;
    }

    private boolean isNumber(String inputString) {
        try {
            Integer.parseInt(inputString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void displayAllSystemItemsForPurchaseByStore(Store storeToOrderFrom) {
        System.out.println("-----\tItems Available\t-----\n");
        this.SDMLogic.getItems().values().forEach(itemInSystem -> {
            if (storeToOrderFrom.getItemsBeingSold().containsKey(itemInSystem.getId())) {
                System.out.println(storeToOrderFrom.getItemsBeingSold().get(itemInSystem.getId()).getStringItemForPurchase());
            } else {
                System.out.println(itemInSystem.getStringItemForPurchaseWithNotSoldProperty());
            }
        });
    }

    private Store getStoreOfChoiceByID(Scanner sc) {
        while (true) {
            try {
                while (true) {
                    System.out.println("Please choose a store using it's ID");
                    String userStoreIDInput = sc.nextLine();
                    if (this.SDMLogic.isValidStoreChoice(userStoreIDInput)) {
                        return this.SDMLogic.getStores().get(Integer.parseInt(userStoreIDInput));
                    }
                    System.out.println("<The input you entered wasn't an existing store's ID>\n");
                }
            }
            catch (NumberFormatException e) {
                System.out.println("<The input you entered wasn't a number>\n");
                continue;
            }
            break;
        }
    }

    private Location getLocationFromUserAndValidate(Scanner sc) {
        int x = 0;
        int y = 0;
        boolean isLocationValid = false;
        String regex = "\\((-?\\d+)\\,(-?\\d+)\\)";
        Pattern pattern = Pattern.compile("\\((-?\\d+)\\,(-?\\d+)\\)");
        while (!isLocationValid) {
            System.out.println("Please enter your location in the following format (x,y) where 1 <= x,y <= 50\n");
            String userLocationInput = sc.nextLine().trim();
            Matcher matcher = pattern.matcher(userLocationInput);
            if (!matcher.matches()) continue;
            int indexOfSeparation = userLocationInput.indexOf(",");
            String xString = userLocationInput.substring(1, indexOfSeparation);
            String yString = userLocationInput.substring(indexOfSeparation + 1, userLocationInput.length() - 1);
            x = Integer.parseInt(xString);
            if (this.SDMLogic.validateLocationBorders(x, y = Integer.parseInt(yString))) {
                if (this.validateLocationAgainstAllStores(x, y)) {
                    isLocationValid = true;
                    continue;
                }
                System.out.println("<Your location cannot be the same as a an existing store's location>");
                continue;
            }
            System.out.println("<Please enter x,y values that meet with the requirements 1 <= x,y <= 50>");
        }
        Location outLocation = new Location();
        outLocation.setX(x);
        outLocation.setY(y);
        return outLocation;
    }

    private boolean validateLocationAgainstAllStores(int x, int y) {
        return this.SDMLogic.checkUserLocationAgainstAllStoresLocations(x, y);
    }

    private void displayShortPresentationOfSystemStores() {
        System.out.println("-----\tStores Available\t-----\n");
        this.SDMLogic.getStores().forEach((integer, store) -> System.out.println(store.displayStoreForPurchase()));
    }

    private String getDateFromUserAndValidate(Scanner scanner) {
        String regexString = "^((0[1-9])|([12][0-9])|(3[01]))/([0]?[1-9]|1[012])-([0-1]?[0-9]|2?[0-3]):([0-5]\\d)$";
        Pattern regex = Pattern.compile(regexString);
        System.out.println("Please enter the delivery date in the following format - dd/mm-hh:mm");
        String userDateInput = scanner.nextLine().trim();
        Matcher match = regex.matcher(userDateInput);
        while (!match.matches()) {
            System.out.println("Wrong format. Please use the following format -> dd/mm-hh:mm");
            userDateInput = scanner.nextLine().trim();
            match = regex.matcher(userDateInput);
        }
        return userDateInput;
    }

    private void displayAllStoresOrderHistory() {
        String allStoresOrdersString = "\n-----\tSystem Static Order History\t-----\n" + this.SDMLogic.getStringOfAllStaticSystemOrders() + "\n-----\tSystem Dynamic Order History\t-----\n" + this.SDMLogic.getStringOfAllDynamicSystemOrders();
        System.out.println(allStoresOrdersString);
    }

    private void displayStoresInformation() {
        Map<Integer, Store> systemStores = this.SDMLogic.getStores();
        systemStores.forEach((id, store) -> System.out.println(store.toString()));
    }

    private void displaySystemItemsInformation() {
        System.out.println("-----\tSystem Items\t-----\n");
        Map<Integer, StoreItem> systemStores = this.SDMLogic.getItems();
        systemStores.forEach((id, item) -> System.out.println(item.getStringItemForAllSystemItemsDisplay()));
    }

    private class IllegalInputException
    extends Exception {
        public IllegalInputException(String message) {
            super(message);
        }
    }
}

