<?php

namespace TomatoPHP\FilamentNotes\Filament\Pages;

use TomatoPHP\FilamentNotes\Filament\Resources\NoteResource\Pages\ManageNotes;
use TomatoPHP\FilamentTypes\Pages\BaseTypePage;
use TomatoPHP\FilamentTypes\Services\Contracts\Type;

class NotesGroups extends BaseTypePage
{
    public function getTitle(): string
    {
        return trans('filament-notes::messages.pages.groups');
    }

    public function getType(): string
    {
        return "groups";
    }

    public function getFor(): string
    {
        return "notes";
    }

    public function getBackUrl()
    {
        return ManageNotes::getUrl(); // TODO: Change the autogenerated stub
    }

    public function getTypes(): array
    {
        return [
            Type::make('todo')
                ->name([
                    "ar" => "مهام",
                    "en" => "TODO"
                ])
                ->color('#1461e3')
                ->icon('heroicon-o-list-bullet'),
            Type::make('ideas')
                ->name([
                    "ar" => "أفكار",
                    "en" => "Ideas"
                ])
                ->color('#13e0da')
                ->icon('heroicon-o-sparkles'),
            Type::make('saved')
                ->name([
                    "ar" => "محفوظ",
                    "en" => "Saved"
                ])
                ->color('#29a82e')
                ->icon('heroicon-o-arrow-down-on-square'),
        ];
    }
}
