module.exports = {
  siteUrl: `https://toddbirchard.com`, // Site domain. Do not include a trailing slash!
  siteRss: `https://toddbirchard.com/rss.xml`,
  siteMap: `https://toddbirchard.com/sitemap.xml`,
  siteAdminUrl: `https://toddbirchard.app`,

  // Post confit=g
  postsPerPage: 8,

  // Metadata
  siteTitleMeta: `Todd Birchard: Engineering, Product, Technology.`,
  shortTitle: `Todd Birchard`,
  siteDescriptionMeta: `Giant reptile giving technology a good name. Occasional tangents of mass destruction. Made in Silicon Alley.`,
  categories: [`software`, `engineering`, `data`, `data science`, `data engineering`],
  siteCopyright: `©2021 Todd Birchard: Engineering, Product, Technology.`,
  backgroundColor: `#f8f8f8`,
  themeColor: `#b15d5d`,

  // Image Config
  images: {
    siteIcon: `favicon.png`,
    mobileLogo: `/images/logo@2x.png`,
    buyMeACoffee: `/images/buymeacoffee.svg`,
    shareImage: `cover.jpg`,
    shareImageWidth: 1000,
    shareImageHeight: 523,
  },

  // Creator information
  creator: {
    name: `Todd Birchard`,
    twitter: `@toddrbirchard`,
  },

  // Site social media
  links: {
    twitter: `https://twitter.com/hackersslackers`,
    buyMeACoffee: `https://buymeacoff.ee/hackersslackers`,
    githubOrg: `https://github.com/hackersandslackers/`,
  },

}
