// Generated by jextract

package com.github.tjake.jlama.tensor.operations.cnative;

import java.lang.invoke.*;
import java.lang.foreign.*;
import java.nio.ByteOrder;
import java.util.*;
import java.util.function.*;
import java.util.stream.*;

import static java.lang.foreign.ValueLayout.*;
import static java.lang.foreign.MemoryLayout.PathElement.*;

public class NativeSimd {

    NativeSimd() {
        // Should not be called directly
    }

    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");

    static void traceDowncall(String name, Object... args) {
         String traceArgs = Arrays.stream(args)
                       .map(Object::toString)
                       .collect(Collectors.joining(", "));
         System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol)
            .orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        } catch (ReflectiveOperationException ex) {
            throw new AssertionError(ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        return switch (layout) {
            case PaddingLayout p -> p;
            case ValueLayout v -> v.withByteAlignment(align);
            case GroupLayout g -> {
                MemoryLayout[] alignedMembers = g.memberLayouts().stream()
                        .map(m -> align(m, align)).toArray(MemoryLayout[]::new);
                yield g instanceof StructLayout ?
                        MemoryLayout.structLayout(alignedMembers) : MemoryLayout.unionLayout(alignedMembers);
            }
            case SequenceLayout s -> MemoryLayout.sequenceLayout(s.elementCount(), align(s.elementLayout(), align));
        };
    }

    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup()
            .or(Linker.nativeLinker().defaultLookup());

    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS
            .withTargetLayout(MemoryLayout.sequenceLayout(java.lang.Long.MAX_VALUE, JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int HAS_F16C = (int)2L;
    /**
     * {@snippet lang=c :
     * #define HAS_F16C 2
     * }
     */
    public static int HAS_F16C() {
        return HAS_F16C;
    }
    private static final int HAS_AVX2 = (int)4L;
    /**
     * {@snippet lang=c :
     * #define HAS_AVX2 4
     * }
     */
    public static int HAS_AVX2() {
        return HAS_AVX2;
    }
    private static final int IS_M_SERIES_MAC = (int)8L;
    /**
     * {@snippet lang=c :
     * #define IS_M_SERIES_MAC 8
     * }
     */
    public static int IS_M_SERIES_MAC() {
        return IS_M_SERIES_MAC;
    }
    private static final int Q8_BLOCK_SIZE = (int)32L;
    /**
     * {@snippet lang=c :
     * #define Q8_BLOCK_SIZE 32
     * }
     */
    public static int Q8_BLOCK_SIZE() {
        return Q8_BLOCK_SIZE;
    }
    private static final int Q4_BLOCK_SIZE = (int)32L;
    /**
     * {@snippet lang=c :
     * #define Q4_BLOCK_SIZE 32
     * }
     */
    public static int Q4_BLOCK_SIZE() {
        return Q4_BLOCK_SIZE;
    }

    private static class gemm_q8_q4 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_q8_q4");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_q8_q4(int flags, const float *restrict af, const char *restrict a, int aoffset, const float *restrict bf, const char *restrict b, int boffset, float *restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_q8_q4$descriptor() {
        return gemm_q8_q4.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_q8_q4(int flags, const float *restrict af, const char *restrict a, int aoffset, const float *restrict bf, const char *restrict b, int boffset, float *restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static MethodHandle gemm_q8_q4$handle() {
        return gemm_q8_q4.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_q8_q4(int flags, const float *restrict af, const char *restrict a, int aoffset, const float *restrict bf, const char *restrict b, int boffset, float *restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static MemorySegment gemm_q8_q4$address() {
        return gemm_q8_q4.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_q8_q4(int flags, const float *restrict af, const char *restrict a, int aoffset, const float *restrict bf, const char *restrict b, int boffset, float *restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static void gemm_q8_q4(int flags, MemorySegment af, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc) {
        var mh$ = gemm_q8_q4.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_q8_q4", flags, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_q8_q4_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_q8_q4_batch");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_q8_q4_batch(int flags, int batch_num, const float *restrict af, const char *restrict a, int aoffset, const float **restrict bf, const char **restrict b, int boffset, float **restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_q8_q4_batch$descriptor() {
        return gemm_q8_q4_batch.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_q8_q4_batch(int flags, int batch_num, const float *restrict af, const char *restrict a, int aoffset, const float **restrict bf, const char **restrict b, int boffset, float **restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static MethodHandle gemm_q8_q4_batch$handle() {
        return gemm_q8_q4_batch.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_q8_q4_batch(int flags, int batch_num, const float *restrict af, const char *restrict a, int aoffset, const float **restrict bf, const char **restrict b, int boffset, float **restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static MemorySegment gemm_q8_q4_batch$address() {
        return gemm_q8_q4_batch.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_q8_q4_batch(int flags, int batch_num, const float *restrict af, const char *restrict a, int aoffset, const float **restrict bf, const char **restrict b, int boffset, float **restrict r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc)
     * }
     */
    public static void gemm_q8_q4_batch(int flags, int batch_num, MemorySegment af, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc) {
        var mh$ = gemm_q8_q4_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_q8_q4_batch", flags, batch_num, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, batch_num, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_f32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_f32(int flags, const float *a, int aoffset, const float *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_f32$descriptor() {
        return gemm_f32.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_f32(int flags, const float *a, int aoffset, const float *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MethodHandle gemm_f32$handle() {
        return gemm_f32.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_f32(int flags, const float *a, int aoffset, const float *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MemorySegment gemm_f32$address() {
        return gemm_f32.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_f32(int flags, const float *a, int aoffset, const float *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static void gemm_f32(int flags, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        var mh$ = gemm_f32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_f32", flags, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_f32_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_batch");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_f32_batch(int flags, int batch_num, const float *a, int aoffset, const float **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_f32_batch$descriptor() {
        return gemm_f32_batch.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_f32_batch(int flags, int batch_num, const float *a, int aoffset, const float **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MethodHandle gemm_f32_batch$handle() {
        return gemm_f32_batch.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_f32_batch(int flags, int batch_num, const float *a, int aoffset, const float **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MemorySegment gemm_f32_batch$address() {
        return gemm_f32_batch.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_f32_batch(int flags, int batch_num, const float *a, int aoffset, const float **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static void gemm_f32_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        var mh$ = gemm_f32_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_f32_batch", flags, batch_num, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_f32_q4 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_q4");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_f32_q4(int flags, const float *a, int aoffset, const float *bf, const char *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_f32_q4$descriptor() {
        return gemm_f32_q4.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_f32_q4(int flags, const float *a, int aoffset, const float *bf, const char *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static MethodHandle gemm_f32_q4$handle() {
        return gemm_f32_q4.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_f32_q4(int flags, const float *a, int aoffset, const float *bf, const char *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static MemorySegment gemm_f32_q4$address() {
        return gemm_f32_q4.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_f32_q4(int flags, const float *a, int aoffset, const float *bf, const char *b, int boffset, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static void gemm_f32_q4(int flags, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc) {
        var mh$ = gemm_f32_q4.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_f32_q4", flags, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_f32_q4_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_q4_batch");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_f32_q4_batch(int flags, int batch_num, const float *a, int aoffset, const float **bf, const char **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_f32_q4_batch$descriptor() {
        return gemm_f32_q4_batch.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_f32_q4_batch(int flags, int batch_num, const float *a, int aoffset, const float **bf, const char **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static MethodHandle gemm_f32_q4_batch$handle() {
        return gemm_f32_q4_batch.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_f32_q4_batch(int flags, int batch_num, const float *a, int aoffset, const float **bf, const char **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static MemorySegment gemm_f32_q4_batch$address() {
        return gemm_f32_q4_batch.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_f32_q4_batch(int flags, int batch_num, const float *a, int aoffset, const float **bf, const char **b, int boffset, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc)
     * }
     */
    public static void gemm_f32_q4_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc) {
        var mh$ = gemm_f32_q4_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_f32_q4_batch", flags, batch_num, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_bf16 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_bf16");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_bf16(int flags, const short *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_bf16$descriptor() {
        return gemm_bf16.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_bf16(int flags, const short *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MethodHandle gemm_bf16$handle() {
        return gemm_bf16.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_bf16(int flags, const short *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MemorySegment gemm_bf16$address() {
        return gemm_bf16.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_bf16(int flags, const short *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static void gemm_bf16(int flags, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        var mh$ = gemm_bf16.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_bf16", flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_bf16_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_bf16_batch");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_bf16_batch(int flags, int batch_num, const short *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_bf16_batch$descriptor() {
        return gemm_bf16_batch.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_bf16_batch(int flags, int batch_num, const short *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MethodHandle gemm_bf16_batch$handle() {
        return gemm_bf16_batch.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_bf16_batch(int flags, int batch_num, const short *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MemorySegment gemm_bf16_batch$address() {
        return gemm_bf16_batch.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_bf16_batch(int flags, int batch_num, const short *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static void gemm_bf16_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        var mh$ = gemm_bf16_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_bf16_batch", flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_f32_bf16 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_bf16");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_f32_bf16(int flags, const float *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_f32_bf16$descriptor() {
        return gemm_f32_bf16.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_f32_bf16(int flags, const float *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MethodHandle gemm_f32_bf16$handle() {
        return gemm_f32_bf16.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_f32_bf16(int flags, const float *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MemorySegment gemm_f32_bf16$address() {
        return gemm_f32_bf16.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_f32_bf16(int flags, const float *a, int aoffset, const short *b, int boffset, short *cr, float *r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static void gemm_f32_bf16(int flags, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        var mh$ = gemm_f32_bf16.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_f32_bf16", flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_f32_bf16_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_POINTER,
            NativeSimd.C_POINTER,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT,
            NativeSimd.C_INT
        );

        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_bf16_batch");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * void gemm_f32_bf16_batch(int flags, int batch_num, const float *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static FunctionDescriptor gemm_f32_bf16_batch$descriptor() {
        return gemm_f32_bf16_batch.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * void gemm_f32_bf16_batch(int flags, int batch_num, const float *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MethodHandle gemm_f32_bf16_batch$handle() {
        return gemm_f32_bf16_batch.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * void gemm_f32_bf16_batch(int flags, int batch_num, const float *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static MemorySegment gemm_f32_bf16_batch$address() {
        return gemm_f32_bf16_batch.ADDR;
    }

    /**
     * {@snippet lang=c :
     * void gemm_f32_bf16_batch(int flags, int batch_num, const float *a, int aoffset, const short **b, int boffset, short **cr, float **r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc)
     * }
     */
    public static void gemm_f32_bf16_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        var mh$ = gemm_f32_bf16_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("gemm_f32_bf16_batch", flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }
}

