# Contributing to Pubmed Parser

First of all, thanks for considering contributing to Pubmed Parser (`pubmed_parser`) 👍. We really appreciate your great help and support!

`pubmed_parser` is an open source Python project, maintained by reseachers who want to support and make analysis of biomedical text and metadata easy. We would like to accelerate how you get biomedical text data fast and, therefore, ease the effort in data cleaning process.

## How you can contribute?

There are several ways you can contribute to this project. Please see below

### Share the repository ❤️

If you use `pubmed_parser` and think it is useful. Please feel free to share and tag us on Twitter [`@titipat_a`](https://twitter.com/titipat_a), [`@daniel_akuna`](https://twitter.com/daniel_akuna), and [`@KordingLab`](https://twitter.com/KordingLab).

If you are using `pubmed_parser` on a paper you are writing, consider [citing it](https://github.com/titipata/pubmed_parser#citation).

### Report a bug 🐛

We use GitHub issues to track bugs, questions, and feature requests. Before reporting a bug, we suggest you to do [a quick search](https://github.com/titipata/pubmed_parser/issues) to see if your issue has already been reported. If your issue has already been reported, please comment on the existing issue.

Otherwise, open [a new GitHub issue](https://github.com/titipata/pubmed_parser/issues). It would be great if you can make the issue as clear as possible. That can be done by

* Provide a clear title and description of your issue.
* Provide a source code on how to reproduce your and software version you use e.g. Python version, OS version.
* Provide a source of data that you parse using `pubmed_parser`, can be URL or URL to data repository. This can also be a name of the file from MEDLINE or PubMed (a link to `ftp` of the dataset and file name).
* Include some explanation of what you think might be an issue (new data version, obsolete chunk of code).

For questions and feature requests, please frame it as narrow as possible so that we can discuss within the domain of your suggestions.

### Propose a feature 💡

Have an idea for a `pubmed_parser` feature? Take a look at the [repository](https://github.com/titipata/pubmed_parser) and [issue page](https://github.com/titipata/pubmed_parser/issues) to see if it isn't included or suggested yet. If not, suggest your idea as an issue on GitHub. While we can't promise to implement your idea, it helps to:

* Explain in detail how it would work. - provide source of data and features that you want us to add
* Keep the scope as narrow as possible. - narrow scope makes it more feasible for us to complete your idea

See below if you want to contribute code for your idea as well.

### Contribute code and documentation 📝

If you have been using `pubmed_parser` and see any errors that can be fixed, you are welcome to report an [issue](https://github.com/titipata/pubmed_parser/issues), comment if the issue already exists, or contribute if you know where the bug occurs. We currently have documentation for each function directly in the source code. You can contribute directly there.

### Ask a private question

If you have a very specific research question which may not be directly related to the repository, you can email us for a private question. Although, we do **not** suggest you to email the maintainers directly. We encourage you to frame your question so that it can be asked directly on GitHub issue if possible.

## Development guidelines

We follow the [GitHub flow](https://guides.github.com/introduction/flow/) for development.

1. Fork [`pubmed_parser` repository](https://github.com/titipata/pubmed_parser) and clone to your computer. To learn more about this process, see [this guide](https://guides.github.com/activities/forking/).
2. If you have forked and cloned the project before and it has been a while since you worked on it, [pull changes from the original repo](https://help.github.com/articles/merging-an-upstream-repository-into-your-fork/) to your clone by using `git pull upstream master`.
3. Make your changes using your preferred text editor:
   * Edit source code and test on the dataset.
   * Edit documentation of functions that are not clear or incomplete.
4. Commit and push your changes
5. Submit a [pull request](https://github.com/titipata/pubmed_parser/pulls) with your description.

In your pull request, you can tag issue numbers relating to your pull request so that we can use it as a reference in the future. You can also give a short description on your pull request e.g. what is the improvement (code or documentation)? what error did you fix? etc.

If you see inactivity in your pull request, please re-tag core maintainers so that they can take a look closely to your pull requests again. Core maintainers might be really busy at the time you make the pull request.
