(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
                         -****************+.
               .-=++*+::*###############*-
           :=+##*+=-::*##**############=
        .=*#*=:    .+#*=+############+.
       =##+.      +#+-=############*-:
     :*#+.      =+-.=#############- =#*.
    -##-      -=..+#############*:.  ---.
   -##:     .: .+################= :+#*-:.
  .##-        :==========*#####= :*#*- -#*
  =##                   -####*:-*#*-   .##:
  +#+                  -###*--*#*-      *#=
  *#+                 +###==*#*:        *#=
  +#*                *##+=*#*-          ##-
  :##.             .*##*##*:           -##.
   +#*            -#####*:             *#=
    *#+          =####+:             .*#+
     +#*.       +###+.              :##=
      -##+.    *##+:              :+#*:
        =*#+..*#+:             .-*#*-
          :-:#+::.        .:-=*##+:
           -+..+*###****####*+-.
          :.      ..:::::..
        ____                   _
       / ___| _ __   __ _ _ __| | __
       \___ \| '_ \ / _` | '__| |/ /
        ___) | |_) | (_| | |  |   <
       |____/| .__/ \__,_|_|  |_|\_\
             |_|   Game Toolkit

Copyright  2024-present tinyBigGAMES LLC
         All Rights Reserved.

Website: https://tinybiggames.com
Email  : support@tinybiggames.com

See LICENSE for license information
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)

unit UZipFile01;

interface

uses
  System.SysUtils,
  SGT.Deps,
  SGT.Deps.Ext,
  SGT.OGL,
  SGT.Core,
  SGT.Lua,
  SGT.LuaDebugger,
  UCommon;

procedure Demo();

implementation

// This procedure is used as a callback during the zip file building process to show progress.
// ASender: Pointer to the object that initiated the zip file build.
// AFilename: Name of the file currently being added to the zip archive.
// AProgress: Integer indicating the current progress percentage of the file being added.
// ANewFile: Boolean indicating whether a new file is being added (true) or not (false).
procedure ZipFile_BuildProgress(const ASender: Pointer; const AFilename: string; const AProgress: Integer; const ANewFile: Boolean);
begin
  // If a new file is being added, print a new line.
  if ANewFile then
    Console.PrintLn('');

  // Print the progress of the current file being added, showing the filename and progress percentage.
  // The progress is shown in dark green text.
  Console.Print(Console.CR + 'Adding %s(%d%s)...', [ExtractFileName(string(AFilename)), AProgress, '%'], Console.FG_DARKGREEN);
end;

// This procedure demonstrates the usage of the TZipFile.Build method to create a zip file.
// The procedure also uses the Console object to print messages and set the console window title.
procedure Demo();
begin
  // Set the title of the console window to indicate the demo for the ZipFile functionality.
  Console.SetTitle('SGT: ZipFile #01');

  // Print a message indicating that the zip file build process is starting.
  Console.PrintLn(Console.CRLF + Console.CRLF + 'Build zip file "%s"...', [CZipFilename]);

  // Attempt to build the zip file.
  // 'CZipFilename' is the name of the zip file to be created.
  // 'res' is the directory to be zipped.
  // The progress of the build is shown using the 'ZipFile_BuildProgress' procedure.
  // If the build succeeds, a success message is printed in cyan text.
  // If the build fails, a failure message is printed in red text.
  if TZipFile.Build(CZipFilename, 'res', nil, ZipFile_BuildProgress) then
    Console.PrintLn(Console.CRLF + Console.CRLF + 'Success!', Console.FG_CYAN)
  else
    Console.PrintLn(Console.CRLF + Console.CRLF + 'Failed!', Console.FG_RED);
end;

end.
