(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
                         -****************+.
               .-=++*+::*###############*-
           :=+##*+=-::*##**############=
        .=*#*=:    .+#*=+############+.
       =##+.      +#+-=############*-:
     :*#+.      =+-.=#############- =#*.
    -##-      -=..+#############*:.  ---.
   -##:     .: .+################= :+#*-:.
  .##-        :==========*#####= :*#*- -#*
  =##                   -####*:-*#*-   .##:
  +#+                  -###*--*#*-      *#=
  *#+                 +###==*#*:        *#=
  +#*                *##+=*#*-          ##-
  :##.             .*##*##*:           -##.
   +#*            -#####*:             *#=
    *#+          =####+:             .*#+
     +#*.       +###+.              :##=
      -##+.    *##+:              :+#*:
        =*#+..*#+:             .-*#*-
          :-:#+::.        .:-=*##+:
           -+..+*###****####*+-.
          :.      ..:::::..
        ____                   _
       / ___| _ __   __ _ _ __| | __
       \___ \| '_ \ / _` | '__| |/ /
        ___) | |_) | (_| | |  |   <
       |____/| .__/ \__,_|_|  |_|\_\
             |_|   Game Toolkit

Copyright  2024-present tinyBigGAMES LLC
         All Rights Reserved.

Website: https://tinybiggames.com
Email  : support@tinybiggames.com

See LICENSE for license information
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)

unit UCommon;

interface

uses
  SysUtils,
  SGT.Core,
  SGT.Deps.Ext;

const
  CZipFilename = 'Data.zip';  // Filename for the ZIP file containing resources.

  // Cloud database connection details.
  CDbURL = 'https://sparkgametoolkit.com/clouddb/SGT-Examples';  // URL of the cloud database.
  CDbApiKey = 'c91c8b1561fc4890a216e2a550c2e5de';                // API key for accessing the cloud database.
  CDbName = 'testbed';                                           // Name of the database.
  CDbTable = 'game1';                                            // Name of the table in the database.

type
  TDemo = procedure();  // TDemo is a procedure type used to define demo procedures.

procedure Run(const ADemo: TDemo);  // Declares the Run procedure.

implementation

// The 'Run' procedure initializes the library, runs a demo procedure, and handles cleanup.
// It is designed to execute a demo procedure safely, ensuring that the library is properly initialized and cleaned up.
procedure Run(const ADemo: TDemo);
begin
  // Print the project name or identifier with a cyan color.
  Console.Print(SGT_PROJECT, Console.FG_CYAN);

  // Attempt to initialize the library. If it fails, print an error message and exit.
  if not InitLib() then
  begin
    Console.Println('Fatal Error: Failed to initialize library.', Console.FG_RED);
    Console.PrintLn('');
    Console.Pause();
    Exit;
  end;

  try
    // Run the demo procedure provided as a parameter.
    ADemo();

    // Pause the console after the demo runs to allow the user to view the output.
    Console.Pause();
  finally
    // Ensure that the library is properly cleaned up, even if an error occurs during the demo.
    QuitLib();
  end;
end;


end.
