![Spark Game Toolkit Logo](media/SGT.png)

[![Chat on Discord](https://img.shields.io/discord/754884471324672040?style=for-the-badge)](https://discord.gg/tPWjMwK) [![Twitter Follow](https://img.shields.io/twitter/follow/tinyBigGAMES?style=for-the-badge)](https://twitter.com/tinyBigGAMES) 

**Spark Game Toolkit™ (SGT)** is a powerful and flexible 2D game development library designed to streamline the creation of engaging games and multimedia applications using the [Delphi](https://www.embarcadero.com/products/delphi) (Object Pascal) programming language. Whether you're a seasoned developer or just getting started, SGT offers a robust set of tools to bring your ideas to life on Windows platforms.

## Table of Contents
- [Features](#features)
- [Getting Started](#getting-started)
- [Installation](#installation)
- [Usage](#usage)
- [Modules](#modules)
- [Examples](#examples)
- [Contributing](#contributing)
- [License](#license)
- [Links](#links)
- [Contact](#contact)

## Features

- **Develop for Win64**: Build games effortlessly for Windows platforms using Object Pascal.
- **Modular Design**: Utilize only the components you need, keeping your project lightweight.
- **High-Performance 2D Rendering**: Experience efficient and smooth graphics rendering.
- **Seamless Audio Integration**: Easily incorporate music and sound effects.
- **Comprehensive Input Handling**: Support for keyboard, mouse, and gamepad controls.
- **Advanced Resource Management**: Efficiently manage textures, fonts, and other assets.
- **Built-In Physics & Collision Detection**: Simplify game mechanics with ready-to-use systems.
- **Entity-Component System**: Implement flexible and reusable game objects.
- **Config File Management**: Streamline game settings with an intuitive file system.
- **Utility Functions**: Leverage a variety of helper functions for common game development tasks.
- **Flexible IO Operations**: Handle memory, file, and ZipFile IO seamlessly.
- **And more...**


## Getting Started

To get started with Spark Game Toolkit, you'll need to have a basic understanding of Pascal programming and game development concepts.

### Prerequisites

- [Delphi 12.1 CE](https://www.embarcadero.com/products/delphi/starter) or higher.
- GPU that supports OpenGL 2.1 or higher
- Basic knowledge of 2D game development concepts

## Installation

1. **Clone or Download**: 
   - Clone the repository or download the latest version of Spark Game Toolkit from the [GitHub repo](https://github.com/tinyBigGAMES/SparkGameToolkit/archive/refs/heads/main.zip).

2. **Extract Files**: 
   - Extract the downloaded archive to your desired project directory.

3. **Install Prerequisites**:
   - Ensure you have [Delphi 12.1 CE](https://www.embarcadero.com/products/delphi/starter) or higher installed on your system.
   - If you're planning to use GenAI examples, download the [gemma-2-2b-it](https://huggingface.co/bartowski/gemma-2-2b-it-abliterated-GGUF/resolve/main/gemma-2-2b-it-abliterated-Q8_0.gguf?download=true) large language model (LLM) and place it in the folder `C:\LLM\gguf`.

4. **Open Project**:
   - Load the `Spark Game Toolkit.groupproj` project group file located in the `src` folder.

5. **Run Example Projects**:
   - Reference the example projects to see how to use the features of the toolkit.
   - Ensure to compile and run `ZipFile01` example first to create the `Data.zip` used by other examples.



## Usage

Here's a basic example of how to use Spark Game Toolkit to create a simple window and draw a shape:

```Pascal
uses
  System.SysUtils,
  SGT.Core;

var
  LWindow: TWindow;
  LFont: TFont;
  LPos: TPoint;
begin
  // Initialize a new window with the title "SGT: Window #01"
  LWindow := TWindow.Init('SGT: Window #01');

  // Load the default font with size 10
  LFont := TFont.LoadDefault(LWindow, 10);

  // Main game loop
  while not LWindow.ShouldClose() do
  begin
    LWindow.StartFrame();

      // Close the window if ESC key is pressed
      if LWindow.GetKey(KEY_ESCAPE, isWasPressed) then
        LWindow.SetShouldClose(True);

      // Begin drawing on the window
      LWindow.StartDrawing();

        // Clear the screen with a dark slate brown color
        LWindow.Clear(DARKSLATEBROWN);

        // Draw FPS and Quit text on the screen
        LPos := Math.Point(3, 3);
        LFont.DrawText(LWindow, LPos.X, LPos.Y, 0, WHITE, haLeft, 'fps %d',
          [FrameLimitTimer.FrameRate()]);
        LFont.DrawText(LWindow, LPos.X, LPos.Y, 0, GREEN, haLeft, Utils.HudTextItem('Quit', 'ESC'),
          [FrameLimitTimer.FrameRate()]);

      // End drawing
      LWindow.EndDrawing();

    LWindow.EndFrame();
  end;

  // Free resources
  LFont.Free();
  LWindow.Free();
end.  
```

## Modules

Spark Game Toolkit consists of several modules, each focusing on specific aspects of game development:

- **Window**: Create and manage game windows.
- **Audio**: Play music and sound effects.
- **Texture**: Load and manipulate 2D images.
- **Font**: Render text using TrueType fonts.
- **Video**: Play video files within your game.
- **Camera**: Implement 2D camera systems.
- **Polygon**: Create and manipulate 2D polygons.
- **Starfield**: Generate parallax starfield effects.
- **Sprite**: Manage sprite sheets and animations.
- **Entity**: Create and manage game objects.
- **ConfigFile**: Handle game configuration files.

## Examples

The Spark Game Toolkit comes with various example projects demonstrating different features of the library. You can find these examples in the `examples` directory of the SDK.

## Contributing

Contributions are vital to the Spark Game Toolkit's evolution. Whether you're fixing bugs, adding new features, or improving documentation, your help is greatly appreciated. Here's how you can contribute:

1. Fork the repository on GitHub.
2. Create a new branch for your feature or bug fix.
3. Make your changes, ensuring they adhere to the project's coding standards.
4. Commit your changes with clear, descriptive messages.
5. Push your changes to your fork.
6. Submit a pull request with a detailed description of your changes.

Pull requests are welcome and encouraged. They are an excellent way to propose new features, fix bugs, or improve documentation.

If you find the Spark Game Toolkit beneficial for your projects, please consider:

- Starring the repository on GitHub to show your support.
- Sharing your experience with others in the game development community.
- Providing feedback or reporting issues to help improve the toolkit.

Your support and engagement play a crucial role in the growth and improvement of this open-source project. Thank you for contributing to the Spark Game Toolkit!

## License

Spark Game Toolkit is released under the BSD 3-Clause License:

```
BSD 3-Clause License

Copyright (c) 2024-present, tinyBigGAMES LLC
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```

This license allows you to use, modify, and distribute the software, provided you include the copyright notice, conditions, and disclaimer. For more details, please refer to the `LICENSE` file included with the SDK.

## Links
- [Homepage](https://sparkgametoolkit.com)
- [Facebook Group](https://www.facebook.com/groups/sparkgametoolkit)
- [X/Twitter](https://X.com/tinyBigGAMES)
- [YouTube](https://youtube.com/tinyBigGAMES)
- [Learn Delphi](https://learndelphi.org/)

## Contact
For support, feature requests, or general inquiries, please use the following resources:

- **Website**: [https://sparkgametoolkit.com](https://sparkgametoolkit.com)
- **GitHub Issues**: [Report issues or suggest features](https://github.com/tinyBigGAMES/SparkGameToolkit/issues)
- **Facebook Group**: [Join the community](https://www.facebook.com/groups/sparkgametoolkit)

---

Copyright © 2024-present tinyBigGAMES™ LLC. All Rights Reserved.