![JetZip](media/jetzip.png)  
[![Chat on Discord](https://img.shields.io/discord/754884471324672040?style=for-the-badge)](https://discord.gg/tPWjMwK)
[![Follow on Bluesky](https://img.shields.io/badge/Bluesky-tinyBigGAMES-blue?style=for-the-badge&logo=bluesky)](https://bsky.app/profile/tinybiggames.com)

### Advanced ZIP Archive Support for Delphi with JetZip 🚀

#### Overview 🌟
Introducing **JetZip**, a single-class solution for seamless ZIP archive handling in Delphi. Designed for **professional Delphi developers**, JetZip combines simplicity, power, and efficiency to provide everything you need for managing ZIP files in your applications or games. With features like **password encryption**, **file I/O within archives**, and a **minimal footprint**, JetZip empowers you to deliver high-performance, secure, and maintainable projects.

#### Key Features ✨

1. **Single-Class Implementation: `TJetZip`** 🛠️
   - Everything you need is encapsulated in one class, making integration quick and easy.
   - Clean, maintainable, and lightweight—ideal for professional projects.

2. **Fast and Easy ZIP Archive Support** ⚡
   - Simplified API for creating, reading, and writing ZIP archives.
   - Optimized for high performance, even with large or complex files.

3. **Password Encryption** 🔒
   - Protect sensitive data with integrated password support.
   - Ensure compliance with security standards while maintaining ease of use.

4. **Comprehensive File I/O Operations** 📂
   - Perform operations directly within ZIP archives:
     - **Read**: Access compressed files without extracting them.
     - **Seek**: Navigate files with precision.
     - **EOF and POS**: Manage file streams efficiently.
   - Work with ZIP files as if they were regular files.

5. **Minimalistic Design** 🪶
   - Encapsulated in a **single unit**, keeping the library lightweight and easy to deploy.
   - Small memory footprint ensures minimal impact on your application's performance.

6. **Powered by Minizip in Zlib** 🛡️
   - Built on the trusted **Minizip** library from **Zlib** for industry-standard ZIP support.
   - Combines proven reliability with modern features.

#### Why Use ZIP Files in Your Applications or Games? 🎮

- **Resource Organization** 📦:
  - Consolidate multiple assets (e.g., images, sounds, configs) into a single archive.
  - Simplify file management and reduce directory clutter.

- **Performance Boost** 🚀:
  - Compress files to save storage space and improve loading times.
  - Minimize disk I/O for better runtime performance.

- **Data Security** 🔐:
  - Combine encryption with compression to secure critical resources.
  - Protect sensitive user data and application assets.

- **Streamlined Updates** 🔄:
  - Simplify patching and updates by bundling resources into modular ZIP files.
  - Ideal for games and applications with dynamic content.

#### Use Cases 🎯

- **Game Development** 🎮:
  - Store assets like textures, music, and levels in a single encrypted ZIP for efficient access.
- **Application Deployment** 🛠️:
  - Manage configuration files, logs, and user data in compressed archives for easier updates.
- **Enterprise Solutions** 🏢:
  - Distribute sensitive documents or resources securely within password-protected ZIP files.

#### Why JetZip? 💡

JetZip is the ultimate solution for Delphi developers who need professional-grade ZIP archive management. Whether you're building applications, games, or enterprise solutions, JetZip` offers:

- ✅ Simplicity: A single-class implementation for easy integration.  
- ✅ Security: Password encryption for peace of mind.  
- ✅ Performance: Optimized handling for smooth operation, even with large archives.

### Contributing

Contributions to **Callisto** are highly encouraged. Please feel free to submit issues, suggest new features, or create pull requests to expand the capabilities and robustness of the scripting engine.

### License

**Callisto** is distributed under the 🆓 **BSD-3-Clause License**, allowing for redistribution and use in both source and binary forms, with or without modification, under specific conditions. See the [LICENSE](https://github.com/tinyBigGAMES/JetZip?tab=BSD-3-Clause-1-ov-file#BSD-3-Clause-1-ov-file) file for more details.

### Support

- <a href="https://github.com/tinyBigGAMES/JetZip/issues" target="_blank">Issues</a>
- <a href="https://github.com/tinyBigGAMES/JetZip/discussions" target="_blank">Discussions</a>
- <a href="https://learndelphi.org/" target="_blank">Learn Delphi</a>

---
Embrace the future of file handling with JetZip! 🌟

<p align="center">
<img src="media/delphi.png" alt="Delphi">
</p>
<h5 align="center">

Made with :heart: in Delphi
</h5>

