import { Field } from '@toolkit/forms'
import { InputFieldType } from '@toolkit/fields/plugins/wrap-field-with-meta'

export interface FieldPlugin<ExtraFieldProps = {}, InputProps = {}> {
  __type: 'field'
  name: string
  Component: React.FC<InputFieldType<ExtraFieldProps, InputProps>>
  type?: string
  validate?(
    value: any,
    allValues: any,
    meta: any,
    field: Field
  ): string | object | undefined
  parse?: (value: any, name: string, field: Field) => any
  format?: (value: any, name: string, field: Field) => any
  defaultValue?: any
}

export type { InputFieldType } from '../fields/plugins/wrap-field-with-meta'
