# tinacms-cli

## 1.7.0

### Minor Changes

- [#5357](https://github.com/tinacms/tinacms/pull/5357) [`0ed5b0f`](https://github.com/tinacms/tinacms/commit/0ed5b0f5c24140befb425526b3d31c79b9071df4) Thanks [@brookjeynes-ssw](https://github.com/brookjeynes-ssw)! - Adds the patch version into the graphql errors when building a project.

### Patch Changes

- [#5354](https://github.com/tinacms/tinacms/pull/5354) [`4daaaf7`](https://github.com/tinacms/tinacms/commit/4daaaf72cb93f30988a78a88b28a0d80f4f96d5b) Thanks [@brookjeynes-ssw](https://github.com/brookjeynes-ssw)! - chore: added additional logging to graphql diff errors to display reason and a possible faq if a relevant one is found.

- Updated dependencies [[`b54b303`](https://github.com/tinacms/tinacms/commit/b54b303a8290528230dc83d8fb1b7535df7199f6), [`c45ac5d`](https://github.com/tinacms/tinacms/commit/c45ac5d9c7219593cde63e0cc6fbf945480884f7), [`0345852`](https://github.com/tinacms/tinacms/commit/0345852e3a7568b61a1417cd037715ab0d0dca01)]:
  - tinacms@2.5.2
  - @tinacms/schema-tools@1.6.9
  - @tinacms/app@2.1.14
  - @tinacms/graphql@1.5.9
  - @tinacms/search@1.0.36

## 1.6.13

### Patch Changes

- [#5350](https://github.com/tinacms/tinacms/pull/5350) [`7339bd1`](https://github.com/tinacms/tinacms/commit/7339bd1e1b020085048fef4880b0ce0771698dbb) Thanks [@kldavis4](https://github.com/kldavis4)! - Add detailed logging of version and indexing information on schema errors

- Updated dependencies [[`bbfd415`](https://github.com/tinacms/tinacms/commit/bbfd415762a8b2c62b7653b497b94d67aaa8501a), [`83a25cf`](https://github.com/tinacms/tinacms/commit/83a25cf61b736e1867d37bee37f7514d349e4427)]:
  - tinacms@2.5.1
  - @tinacms/app@2.1.13

## 1.6.12

### Patch Changes

- [#5276](https://github.com/tinacms/tinacms/pull/5276) [`f90ef4d`](https://github.com/tinacms/tinacms/commit/f90ef4d92ae7b21c8c610d14af9510354a3969c6) Thanks [@Ben0189](https://github.com/Ben0189)! - Updates minor and patch dependencies

- [#5248](https://github.com/tinacms/tinacms/pull/5248) [`97d38ab`](https://github.com/tinacms/tinacms/commit/97d38abd3db198d3b8bff70d5fe481d8215b4e06) Thanks [@kldavis4](https://github.com/kldavis4)! - Adds additional validation of the local tina schema and the remote version to prevent inconsistent behavior when changes are not committed to the remote GitHub repository. Related issue: https://github.com/tinacms/tinacms/issues/5221

- Updated dependencies [[`f90ef4d`](https://github.com/tinacms/tinacms/commit/f90ef4d92ae7b21c8c610d14af9510354a3969c6), [`ac2003f`](https://github.com/tinacms/tinacms/commit/ac2003f87381de36c417d69fdb59485dc96f334a), [`03bb823`](https://github.com/tinacms/tinacms/commit/03bb8237df87dab9da503818b839d44209263a48), [`60fb710`](https://github.com/tinacms/tinacms/commit/60fb710addd539860eb7ba39196e02f3bb5f08c1), [`f3aa146`](https://github.com/tinacms/tinacms/commit/f3aa1465423101520bd05939249228c8d8b2a0df)]:
  - @tinacms/app@2.1.12
  - @tinacms/graphql@1.5.8
  - @tinacms/metrics@1.0.8
  - @tinacms/schema-tools@1.6.8
  - @tinacms/search@1.0.35
  - tinacms@2.5.0

## 1.6.11

### Patch Changes

- [#5228](https://github.com/tinacms/tinacms/pull/5228) [`9bb408f`](https://github.com/tinacms/tinacms/commit/9bb408f1c45ecb1fd8e39faac652c4b342f74967) Thanks [@JackDevAU](https://github.com/JackDevAU)! - 🐛 fix r.join error when building pages

- [#5225](https://github.com/tinacms/tinacms/pull/5225) [`0daf0b6`](https://github.com/tinacms/tinacms/commit/0daf0b687b36614a1fdf904b1d5125e4c63e81a9) Thanks [@JackDevAU](https://github.com/JackDevAU)! - ⬆️ Addresses peer dependency issues and applies necessary updates

- Updated dependencies [[`9bb408f`](https://github.com/tinacms/tinacms/commit/9bb408f1c45ecb1fd8e39faac652c4b342f74967), [`bbf2f81`](https://github.com/tinacms/tinacms/commit/bbf2f81143eb400faf8aa4dff33b8a58fa5059c8), [`bc59a81`](https://github.com/tinacms/tinacms/commit/bc59a819e1e68e48de027c4fac72551ca109185d), [`0daf0b6`](https://github.com/tinacms/tinacms/commit/0daf0b687b36614a1fdf904b1d5125e4c63e81a9)]:
  - tinacms@2.4.0
  - @tinacms/graphql@1.5.7
  - @tinacms/schema-tools@1.6.7
  - @tinacms/app@2.1.11
  - @tinacms/search@1.0.34

## 1.6.10

### Patch Changes

- [#4825](https://github.com/tinacms/tinacms/pull/4825) [`ecea7ac`](https://github.com/tinacms/tinacms/commit/ecea7ac5e1c087954eaaf873df3a563ca08f3e47) Thanks [@JackDevAU](https://github.com/JackDevAU)! - ✨ Add Mermaid Support to Rich Text Field (Plate)
  🐛 Fix tooltip rendering behind TinaCMS app

- [#5004](https://github.com/tinacms/tinacms/pull/5004) [`74014ed`](https://github.com/tinacms/tinacms/commit/74014ed2df67e96e1a5fb2950e973528322671a3) Thanks [@Ben0189](https://github.com/Ben0189)! - Fix toolbar floating icon show up in different screen size

- Updated dependencies [[`c5dad82`](https://github.com/tinacms/tinacms/commit/c5dad82a3f1fc4f7686f1503a7894dfacffa8c36), [`ecea7ac`](https://github.com/tinacms/tinacms/commit/ecea7ac5e1c087954eaaf873df3a563ca08f3e47), [`eb519f2`](https://github.com/tinacms/tinacms/commit/eb519f27a4c0fe1b05c361db2c1fe2337e6c4e12), [`74014ed`](https://github.com/tinacms/tinacms/commit/74014ed2df67e96e1a5fb2950e973528322671a3), [`00f6525`](https://github.com/tinacms/tinacms/commit/00f6525871c7c6bd40091424337df72c7bfcf783)]:
  - tinacms@2.3.0
  - @tinacms/schema-tools@1.6.6
  - @tinacms/app@2.1.10
  - @tinacms/graphql@1.5.6
  - @tinacms/metrics@1.0.7
  - @tinacms/search@1.0.33

## 1.6.9

### Patch Changes

- Updated dependencies [[`31513bb`](https://github.com/tinacms/tinacms/commit/31513bb473cd1d349a3711ef7c5075cf9d03f121), [`3b2aba8`](https://github.com/tinacms/tinacms/commit/3b2aba80ac14a512592f67a04f9e1792667db9dd)]:
  - tinacms@2.2.9
  - @tinacms/schema-tools@1.6.5
  - @tinacms/app@2.1.9
  - @tinacms/graphql@1.5.5
  - @tinacms/search@1.0.32

## 1.6.8

### Patch Changes

- [#4843](https://github.com/tinacms/tinacms/pull/4843) [`4753c9b`](https://github.com/tinacms/tinacms/commit/4753c9b53854d19212229f985bc445b2794fad9a) Thanks [@JackDevAU](https://github.com/JackDevAU)! - ⬆️ Update Minor & Patch Dependencies Versions

- Updated dependencies [[`4753c9b`](https://github.com/tinacms/tinacms/commit/4753c9b53854d19212229f985bc445b2794fad9a)]:
  - tinacms@2.2.8
  - @tinacms/app@2.1.8
  - @tinacms/graphql@1.5.4
  - @tinacms/metrics@1.0.7
  - @tinacms/schema-tools@1.6.4
  - @tinacms/search@1.0.31

## 1.6.7

### Patch Changes

- Updated dependencies [[`113f4db`](https://github.com/tinacms/tinacms/commit/113f4db4b5d5b7d4b95d612eca56f815f41b4f8c), [`f0994c8`](https://github.com/tinacms/tinacms/commit/f0994c8f49122cd9d784bf47171715c529d2528f)]:
  - tinacms@2.2.7
  - @tinacms/app@2.1.7

## 1.6.6

### Patch Changes

- [#4803](https://github.com/tinacms/tinacms/pull/4803) [`a6a7735`](https://github.com/tinacms/tinacms/commit/a6a77351b97589c60de69445a9eb2ea57beb4343) Thanks [@kldavis4](https://github.com/kldavis4)! - Fix module not found `tinacms/dist/cache` error at runtime due to broken webpack bundling

- [#4804](https://github.com/tinacms/tinacms/pull/4804) [`d08053e`](https://github.com/tinacms/tinacms/commit/d08053e758b6910afa8ab8952a40984921cccbc4) Thanks [@dependabot](https://github.com/apps/dependabot)! - ⬆️ Updates Typescript to v5.5, @types/node to v22.x, next.js to latest version 14.x, and removes node-fetch

- Updated dependencies [[`b64b046`](https://github.com/tinacms/tinacms/commit/b64b046dc67ae948513057f855b156ce0cf250d8), [`6cd3596`](https://github.com/tinacms/tinacms/commit/6cd35967ab0d34851be44199bc9821b128fcfc75), [`96bdcb7`](https://github.com/tinacms/tinacms/commit/96bdcb79b30e96056c7b19614be260a6c3ef00da), [`a6a7735`](https://github.com/tinacms/tinacms/commit/a6a77351b97589c60de69445a9eb2ea57beb4343), [`d08053e`](https://github.com/tinacms/tinacms/commit/d08053e758b6910afa8ab8952a40984921cccbc4)]:
  - tinacms@2.2.6
  - @tinacms/schema-tools@1.6.3
  - @tinacms/app@2.1.6
  - @tinacms/graphql@1.5.3
  - @tinacms/metrics@1.0.6
  - @tinacms/search@1.0.30

## 1.6.5

### Patch Changes

- Updated dependencies [cf1530d]
- Updated dependencies [2762994]
- Updated dependencies [ba5f7a3]
  - tinacms@2.2.5
  - @tinacms/search@1.0.29
  - @tinacms/app@2.1.5

## 1.6.4

### Patch Changes

- a0ec2a5: Fix init bug causing invalid tina config
- e24fe0b: Fix cacheDir path generation on Windows to avoid unescaped characters breaking esbuild
- Updated dependencies [75cf194]
- Updated dependencies [198c280]
  - tinacms@2.2.4
  - @tinacms/app@2.1.4

## 1.6.3

### Patch Changes

- Updated dependencies [367faed]
  - tinacms@2.2.3
  - @tinacms/app@2.1.3

## 1.6.2

### Patch Changes

- acf8430: Add rollup option to ignore "MODULE_LEVEL_DIRECTIVE"
- 110f1ce: Fix tina-lock.json to not include search configuration, including search indexer token
- 27bfe84: CLI - Adds client caching and cli flag to disable: --no-client-build-cache
- Updated dependencies [6ccda6c]
- Updated dependencies [33eaa81]
- Updated dependencies [f088b97]
- Updated dependencies [f59d67b]
- Updated dependencies [daeeebf]
- Updated dependencies [27bfe84]
  - tinacms@2.2.2
  - @tinacms/schema-tools@1.6.2
  - @tinacms/graphql@1.5.2
  - @tinacms/app@2.1.2
  - @tinacms/search@1.0.28
  - @tinacms/metrics@1.0.5

## 1.6.1

### Patch Changes

- Updated dependencies [ae03e8e]
- Updated dependencies [4c9f221]
  - @tinacms/schema-tools@1.6.1
  - tinacms@2.2.1
  - @tinacms/graphql@1.5.1
  - @tinacms/search@1.0.27
  - @tinacms/app@2.1.1

## 1.6.0

### Minor Changes

- 324950a: Updates Plate Editor to latest version 36.

  - Upgrades all remaining packages `Typescript` to version `^5`
  - Adds Shadcn/ui styles/colours to our `tinatailwind` config (`packages/@tinacms/cli/src/next/vite/tailwind.ts`)
  - Replaces some `lodash` deps with either the specific function i.e. `lodash.set` or implements them in a utility file
  - Updates and removes old version of plate (`plate-headless`) for latest version `^36`
  - Starts removing and cleaning up some of the old Plate code.

### Patch Changes

- Updated dependencies [324950a]
- Updated dependencies [f378f11]
- Updated dependencies [ceb0c07]
  - @tinacms/schema-tools@1.6.0
  - @tinacms/graphql@1.5.0
  - @tinacms/app@2.1.0
  - tinacms@2.2.0
  - @tinacms/search@1.0.26
  - @tinacms/metrics@1.0.5

## 1.5.53

### Patch Changes

- d9b23fc: Improve reference field selector
- Updated dependencies [c6e9afb]
- Updated dependencies [d9b23fc]
- Updated dependencies [613e9c5]
- Updated dependencies [1c69338]
- Updated dependencies [a1a767d]
  - tinacms@2.1.1
  - @tinacms/app@2.0.3
  - @tinacms/graphql@1.4.40
  - @tinacms/search@1.0.25

## 1.5.52

### Patch Changes

- Updated dependencies [4128128]
  - @tinacms/app@2.0.2

## 1.5.51

### Patch Changes

- Updated dependencies [cb83dc2]
- Updated dependencies [1b3584c]
  - tinacms@2.1.0
  - @tinacms/schema-tools@1.5.0
  - @tinacms/app@2.0.1
  - @tinacms/graphql@1.4.39
  - @tinacms/search@1.0.24

## 1.5.50

### Patch Changes

- f567fc8: More React 18 upgrades and fixes
- e58b951: update vulnerable packages so npm audit does not complain
- 9076d09: update next js version from 12 to 14 in tinacms packages
- Updated dependencies [f567fc8]
- Updated dependencies [957fa26]
- Updated dependencies [e58b951]
- Updated dependencies [957fa26]
- Updated dependencies [9076d09]
  - @tinacms/app@2.0.0
  - @tinacms/graphql@1.4.38
  - @tinacms/schema-tools@1.4.19
  - tinacms@2.0.0
  - @tinacms/metrics@1.0.5
  - @tinacms/search@1.0.23

## 1.5.49

### Patch Changes

- Updated dependencies [2940594]
- Updated dependencies [82ab066]
  - @tinacms/app@1.2.45
  - @tinacms/metrics@1.0.4
  - tinacms@1.6.7

## 1.5.48

### Patch Changes

- Updated dependencies [a9b461c]
- Updated dependencies [3034430]
- Updated dependencies [171f5a5]
- Updated dependencies [fd216f3]
- Updated dependencies [d004af2]
- Updated dependencies [20f972a]
- Updated dependencies [2a36b65]
- Updated dependencies [f26b40d]
  - @tinacms/app@1.2.44
  - tinacms@1.6.6
  - @tinacms/schema-tools@1.4.18
  - @tinacms/graphql@1.4.37
  - @tinacms/search@1.0.22

## 1.5.47

### Patch Changes

- 0503072: update ts, remove rimraf, fix types
- 0ba0e59: Fix remix visual editing error
- dc632f3: cli - fix broken link to do with client variables not being configured properly. (Link to https://tina.io/docs/tina-cloud/overview/)
- 1104006: Update tailwind to v3.4.4 + fix media manager height overflow on mobile screens
- dffa355: Remove yarn for pnpm
- Updated dependencies [76c1a2e]
- Updated dependencies [04f0bf3]
- Updated dependencies [0503072]
- Updated dependencies [1104006]
- Updated dependencies [dffa355]
  - @tinacms/graphql@1.4.36
  - tinacms@1.6.5
  - @tinacms/metrics@1.0.3
  - @tinacms/schema-tools@1.4.17
  - @tinacms/search@1.0.21
  - @tinacms/app@1.2.43

## 1.5.46

### Patch Changes

- Updated dependencies [2e3393ef5]
  - @tinacms/schema-tools@1.4.16
  - @tinacms/graphql@1.4.35
  - tinacms@1.6.4
  - @tinacms/search@1.0.20
  - @tinacms/datalayer@1.2.35
  - @tinacms/app@1.2.42
  - @tinacms/metrics@1.0.2

## 1.5.45

### Patch Changes

- Updated dependencies [66f7e2074]
- Updated dependencies [b3ad50a62]
  - tinacms@1.6.3
  - @tinacms/app@1.2.41
  - @tinacms/graphql@1.4.34
  - @tinacms/datalayer@1.2.34
  - @tinacms/search@1.0.19

## 1.5.44

### Patch Changes

- Updated dependencies [141e78c04]
  - tinacms@1.6.2
  - @tinacms/app@1.2.40

## 1.5.43

### Patch Changes

- 216cfff0c: Add fetch options to generated client
- ee135ef03: Feat: add support for preview indexing and overriding upstream branch in separate content repo builds
- Updated dependencies [216cfff0c]
  - tinacms@1.6.1
  - @tinacms/app@1.2.39

## 1.5.42

### Patch Changes

- de271d65a: Update CLI build command to support separate content repo schema synchronization
- Updated dependencies [c8ceba4d8]
  - tinacms@1.6.0
  - @tinacms/app@1.2.38

## 1.5.41

### Patch Changes

- Updated dependencies [04704e3dc]
  - tinacms@1.5.30
  - @tinacms/app@1.2.37

## 1.5.40

### Patch Changes

- Updated dependencies [67e7a2d82]
  - @tinacms/graphql@1.4.33
  - @tinacms/datalayer@1.2.33
  - @tinacms/search@1.0.18
  - tinacms@1.5.29
  - @tinacms/app@1.2.36

## 1.5.39

### Patch Changes

- 0639228c9: Add mongodb to deps when using the mongo adapter

## 1.5.38

### Patch Changes

- Updated dependencies [1e5c94f05]
  - @tinacms/graphql@1.4.32
  - @tinacms/datalayer@1.2.32
  - @tinacms/search@1.0.17
  - tinacms@1.5.28
  - @tinacms/app@1.2.35

## 1.5.37

### Patch Changes

- Updated dependencies [4202c1028]
- Updated dependencies [7779cdbf6]
- Updated dependencies [64f8fa038]
- Updated dependencies [548fe6d96]
- Updated dependencies [031ce05c2]
- Updated dependencies [50b20f809]
  - tinacms@1.5.27
  - @tinacms/graphql@1.4.31
  - @tinacms/schema-tools@1.4.15
  - @tinacms/app@1.2.34
  - @tinacms/datalayer@1.2.31
  - @tinacms/search@1.0.16

## 1.5.36

### Patch Changes

- Updated dependencies [9e1a22a53]
  - tinacms@1.5.26
  - @tinacms/app@1.2.33

## 1.5.35

### Patch Changes

- Updated dependencies [476b9dfbe]
  - @tinacms/graphql@1.4.30
  - @tinacms/datalayer@1.2.30
  - @tinacms/search@1.0.15
  - tinacms@1.5.25
  - @tinacms/app@1.2.32

## 1.5.34

### Patch Changes

- 39ce3a5ac: Fix the name of the read only token in the init process

## 1.5.33

### Patch Changes

- a65ca13f2: ## TinaCMS Self hosted Updates

  ### Changes in the database file

  #### Deprecations and Additions

  - **Deprecated**: `onPut`, `onDelete`, and `level` arguments in `createDatabase`.
  - **Added**: `databaseAdapter` to replace `level`.
  - **Added**: `gitProvider` to substitute `onPut` and `onDelete`.
  - **New Package**: `tinacms-gitprovider-github`, exporting the `GitHubProvider` class.
  - **Interface Addition**: `gitProvider` added to `@tinacms/graphql`.
  - **Addition**: Generated database client.

  #### Updated `database.ts` Example

  ```typescript
  import { createDatabase, createLocalDatabase } from '@tinacms/datalayer'
  import { MongodbLevel } from 'mongodb-level'
  import { GitHubProvider } from 'tinacms-gitprovider-github'

  const isLocal = process.env.TINA_PUBLIC_IS_LOCAL === 'true'

  export default isLocal
    ? createLocalDatabase()
    : createDatabase({
        gitProvider: new GitHubProvider({
          branch: process.env.GITHUB_BRANCH,
          owner: process.env.GITHUB_OWNER,
          repo: process.env.GITHUB_REPO,
          token: process.env.GITHUB_PERSONAL_ACCESS_TOKEN,
        }),
        databaseAdapter: new MongodbLevel<string, Record<string, any>>({
          collectionName: 'tinacms',
          dbName: 'tinacms',
          mongoUri: process.env.MONGODB_URI,
        }),
        namespace: process.env.GITHUB_BRANCH,
      })
  ```

  ### Migrating `database.ts`

  #### a. Replacing `onPut` and `onDelete` with `gitProvider`

  - **GitHubProvider Usage**: Replace `onPut` and `onDelete` with `gitProvider`, using the provided `GitHubProvider` for GitHub.

  ```typescript
  const gitProvider = new GitHubProvider({
    branch: process.env.GITHUB_BRANCH,
    owner: process.env.GITHUB_OWNER,
    repo: process.env.GITHUB_REPO,
    token: process.env.GITHUB_PERSONAL_ACCESS_TOKEN,
  })
  ```

  - **Custom Git Provider**: Implement the `GitProvider` interface for different git providers.

  If you are not using Github as your git provider, you can implement the `GitProvider` interface to use your own git provider.

  ```typescript
  class CustomGitProvider implements GitProvider
      async onPut(key: string, value: string)
          // ...

      async onDelete(key: string)
          // ...


  const gitProvider = new CustomGitProvider();
  ```

  #### b. Renaming `level` to `databaseAdapter`

  - **Renaming in Code**: Change `level` to `databaseAdapter` for clarity.

  ```diff
  createDatabase({
  -    level: new MongodbLevel<string, Record<string, any>>(...),
  +    databaseAdapter: new MongodbLevel<string, Record<string, any>>(...),
  })
  ```

  #### c. `createLocalDatabase` Function

  - **Usage**: Implement a local database with the `createLocalDatabase` function.

  ```typescript
  import { createLocalDatabase } from '@tinacms/datalayer'
  createLocalDatabase(port)
  ```

  #### d. Consolidated Example

  - **Updated `database.{ts,js}` File**:

  ```typescript
  import { createDatabase, createLocalDatabase, GitHubProvider } from '@tinacms/datalayer';
  import { MongodbLevel } from 'mongodb-level';
  const isLocal = process.env.TINA_PUBLIC_IS_LOCAL === 'true';
  export default isLocal
    ? createLocalDatabase()
    : createDatabase({
        gitProvider: new GitHubProvider(...),
        databaseAdapter: new MongodbLevel<string, Record<string, any>>(...),
      });
  ```

  ### Summary of Authentication Updates in Config

  #### a. AuthProvider and AbstractAuthProvider

  - **New**: `authProvider` in `defineConfig`.
  - **Class**: `AbstractAuthProvider` for extending new auth providers.
  - **Clerk Auth Provider**: New provider added.
  - **Renaming**: `admin.auth` to `admin.authHooks`.
  - **Deprecation**: `admin.auth`.

  #### b. Auth Provider in Internal Client and Config

  - **Transition**: From auth functions to `authProvider` class.

  #### c. Migration for Authentication

  - **Previous API**:

  ```javascript
  defineConfig({
    admin: {
      auth: {
        login() {},
        logout() {},
        //...
      },
    },
    //...
  })
  ```

  - **New API**:

  ```javascript
  import { AbstractAuthProvider } from 'tinacms'
  class CustomAuthProvider extends AbstractAuthProvider {
    login() {}
    logout() {}
    //...
  }
  defineConfig({
    authProvider: new CustomAuthProvider(),
    //...
  })
  ```

  ### TinaCMS Self Hosted backend updates

  - **New:** TinaNodeBackend is exported from `@tinacms/datalayer`. This is used to host the TinaCMS backend in a single function.
  - **New:** `LocalBackendAuthProvider` is exported from `@tinacms/datalayer`. This is used to host the TinaCMS backend locally.

  - **New:** `AuthJsBackendAuthProvider` is exported from `tinacms-authjs`. This is used to host the TinaCMS backend with AuthJS.

  ### Migrating the TinaCMS backend

  Now, instead of hosting the in /tina/api/gql.ts file, the entire TinaCMS backend (including auth) will be hosted in a single backend function.

  `/api/tina/[...routes].{ts,js}`

  ```typescript
  import { TinaNodeBackend, LocalBackendAuthProvider } from '@tinacms/datalayer'

  import { TinaAuthJSOptions, AuthJsBackendAuthProvider } from 'tinacms-authjs'

  import databaseClient from '../../../tina/__generated__/databaseClient'

  const isLocal = process.env.TINA_PUBLIC_IS_LOCAL === 'true'

  const handler = TinaNodeBackend({
    authProvider: isLocal
      ? LocalBackendAuthProvider()
      : AuthJsBackendAuthProvider({
          authOptions: TinaAuthJSOptions({
            databaseClient: databaseClient,
            secret: process.env.NEXTAUTH_SECRET,
          }),
        }),
    databaseClient,
  })

  export default (req, res) => {
    // Modify the request here if you need to
    return handler(req, res)
  }
  ```

  These changes are put in place to make self hosted TinaCMS easier to use and more flexible.

  Please [check out the docs](https://tina.io/docs/self-hosted/overview) for more information on self hosted TinaCMS.

- Updated dependencies [a65ca13f2]
  - @tinacms/schema-tools@1.4.14
  - @tinacms/datalayer@1.2.29
  - @tinacms/graphql@1.4.29
  - tinacms@1.5.24
  - @tinacms/search@1.0.14
  - @tinacms/metrics@1.0.2
  - @tinacms/app@1.2.31

## 1.5.32

### Patch Changes

- 7eb8dca1d: Log the output location of the SPA html file
- a937aabf0: Add support for build.basePath to be an environment variable
- Updated dependencies [131b4dc55]
- Updated dependencies [93bfc804a]
- Updated dependencies [1fc2c4a99]
- Updated dependencies [693cf5bd6]
- Updated dependencies [afd1c7c97]
- Updated dependencies [a937aabf0]
- Updated dependencies [8b8a6c96b]
- Updated dependencies [661239b2a]
- Updated dependencies [630ab9436]
  - tinacms@1.5.23
  - @tinacms/app@1.2.30
  - @tinacms/graphql@1.4.28
  - @tinacms/datalayer@1.2.28
  - @tinacms/search@1.0.13

## 1.5.31

### Patch Changes

- a58c5b12f: Update dev & build commands to log and exit on indexing errors
- Updated dependencies [b6fbab887]
- Updated dependencies [939147364]
- Updated dependencies [857414612]
- Updated dependencies [4ae43fdde]
- Updated dependencies [a58c5b12f]
- Updated dependencies [6861b5e01]
- Updated dependencies [aec44a7dc]
  - tinacms@1.5.22
  - @tinacms/search@1.0.12
  - @tinacms/graphql@1.4.27
  - @tinacms/schema-tools@1.4.13
  - @tinacms/app@1.2.29
  - @tinacms/datalayer@1.2.27

## 1.5.30

### Patch Changes

- cb9871921: fix: add tina-lock file to external content directories when localContentPath is set
- 0ec28c6ae: Update message to use defineSchema when frags is too large
- 3b214ec6b: Fixes issue when an existing database contains sha metadata for partial reindexing and the sha is missing from the repository
- Updated dependencies [177002715]
- Updated dependencies [c244d963a]
- Updated dependencies [e69a3ef81]
- Updated dependencies [c925786ef]
- Updated dependencies [841456237]
- Updated dependencies [3b214ec6b]
- Updated dependencies [9f01550dd]
- Updated dependencies [8bd85b15e]
  - tinacms@1.5.21
  - @tinacms/graphql@1.4.26
  - @tinacms/app@1.2.28
  - @tinacms/datalayer@1.2.26
  - @tinacms/search@1.0.11

## 1.5.29

### Patch Changes

- Updated dependencies [7e4de0b2a]
- Updated dependencies [099bf5646]
- Updated dependencies [1144af060]
- Updated dependencies [c92de7b1d]
  - @tinacms/schema-tools@1.4.12
  - tinacms@1.5.20
  - @tinacms/app@1.2.27
  - @tinacms/graphql@1.4.25
  - @tinacms/search@1.0.10
  - @tinacms/datalayer@1.2.25

## 1.5.28

### Patch Changes

- Updated dependencies [1563ce5b2]
- Updated dependencies [e83ba8855]
  - @tinacms/schema-tools@1.4.11
  - tinacms@1.5.19
  - @tinacms/graphql@1.4.24
  - @tinacms/search@1.0.9
  - @tinacms/app@1.2.26
  - @tinacms/datalayer@1.2.24

## 1.5.27

### Patch Changes

- 193d98dfa: Adds ability to specify branch name in the request for the autogenerated client
- ad22e0950: Consolidate tailwind usage
- 8db979b9f: Add support for "static" setting in Tina media, which preprocesses the available media files and disables uploads and deletions of media from the CMS.
- 121bd9fc4: Absorb @tinacms/toolkit into tinacms

  fix: Use clean page-sizes on media manager (to make pagination more obvious)

  Fix issue with uploading media in a folder with tina cloud

- Updated dependencies [9c27087fb]
- Updated dependencies [65d0a701f]
- Updated dependencies [133e97d5b]
- Updated dependencies [f02b4368b]
- Updated dependencies [37cf8bd40]
- Updated dependencies [ad22e0950]
- Updated dependencies [8db979b9f]
- Updated dependencies [7991e097e]
- Updated dependencies [30c7eac58]
- Updated dependencies [121bd9fc4]
  - tinacms@1.5.18
  - @tinacms/schema-tools@1.4.10
  - @tinacms/app@1.2.25
  - @tinacms/graphql@1.4.23
  - @tinacms/search@1.0.8
  - @tinacms/datalayer@1.2.23
  - @tinacms/metrics@1.0.2

## 1.5.26

### Patch Changes

- Updated dependencies [0d8a19632]
- Updated dependencies [bc812441b]
  - @tinacms/graphql@1.4.22
  - @tinacms/schema-tools@1.4.9
  - @tinacms/datalayer@1.2.22
  - @tinacms/search@1.0.7
  - @tinacms/app@1.2.24
  - @tinacms/metrics@1.0.2

## 1.5.25

### Patch Changes

- 94f353822: Fix to log errors in spinner
- Updated dependencies [ad6a166a6]
- Updated dependencies [94f353822]
  - @tinacms/search@1.0.6
  - @tinacms/graphql@1.4.21
  - @tinacms/app@1.2.23
  - @tinacms/datalayer@1.2.21

## 1.5.24

### Patch Changes

- Updated dependencies [019920a35]
  - @tinacms/schema-tools@1.4.8
  - @tinacms/graphql@1.4.20
  - @tinacms/search@1.0.5
  - @tinacms/datalayer@1.2.20
  - @tinacms/app@1.2.22

## 1.5.23

### Patch Changes

- @tinacms/app@1.2.21

## 1.5.22

### Patch Changes

- 495108725: Add optional partialReindex flag to build command
- Updated dependencies [495108725]
  - @tinacms/graphql@1.4.19
  - @tinacms/app@1.2.20
  - @tinacms/datalayer@1.2.19
  - @tinacms/search@1.0.4

## 1.5.21

### Patch Changes

- ca1298975: Fix issue where external React depenedencies we're being dynamically required
  - @tinacms/app@1.2.19

## 1.5.20

### Patch Changes

- 62e4ce3f1: Fix the indexing status error message to suggest Reindex instead of Reset Repository cache
- fe13b4ed9: Fix search index tokenizer regex to not treat underscores as token separators
- 4d2c913f8: Ensure schema changes are picked up by the Vite dev server so we don't get schema mismatch errors during local dev
- 0bf700512: Change the way the Tina config file is built, so dependencies with Tailwind classes are picked up automatically
- cc9d065b8: Fix issue where react and react-dom werent provided by the CLI
- Updated dependencies [fe13b4ed9]
- Updated dependencies [e5e29ed58]
- Updated dependencies [812df6ace]
- Updated dependencies [1176d569a]
  - @tinacms/schema-tools@1.4.7
  - @tinacms/search@1.0.3
  - @tinacms/graphql@1.4.18
  - @tinacms/app@1.2.18
  - @tinacms/datalayer@1.2.18

## 1.5.19

### Patch Changes

- 1751f2fd3: Update tailwind.ts
- Updated dependencies [ee9acb5e5]
- Updated dependencies [a94e123b6]
  - @tinacms/search@1.0.2
  - @tinacms/schema-tools@1.4.6
  - @tinacms/graphql@1.4.17
  - @tinacms/app@1.2.17
  - @tinacms/datalayer@1.2.17

## 1.5.18

### Patch Changes

- c385b5615: Initial implementation of search functionality
- 1c78bafc2: Fix local search indexing to properly update the index on filesystem changes
- Updated dependencies [c385b5615]
- Updated dependencies [1c78bafc2]
  - @tinacms/schema-tools@1.4.5
  - @tinacms/graphql@1.4.16
  - @tinacms/search@1.0.1
  - @tinacms/datalayer@1.2.16
  - @tinacms/app@1.2.16

## 1.5.17

### Patch Changes

- e2e8bd01d: Fix issue where images with spaces in their names wouldn't upload properly
- e2e8bd01d: Show uncaught errors from the CLI

## 1.5.16

### Patch Changes

- @tinacms/app@1.2.15

## 1.5.15

### Patch Changes

- 9f4136c10: Index the content before a build when self hosting.
- a94bf721b: Catch condition where remote schema does not exist to avoid "Invalid or incomplete introspection error" being thrown during build checks
- Updated dependencies [a94bf721b]
- Updated dependencies [52b1762e2]
- Updated dependencies [16b0c8073]
  - @tinacms/graphql@1.4.15
  - @tinacms/app@1.2.14
  - @tinacms/datalayer@1.2.15

## 1.5.14

### Patch Changes

- Updated dependencies [e731ab0c5]
  - @tinacms/graphql@1.4.14
  - @tinacms/datalayer@1.2.14

## 1.5.13

### Patch Changes

- 5a6018916: Add support for "quick editing". By adding the `[data-tina-field]` attribute to your elements, editors can click to see the
  correct form and field focused in the sidebar.

  This work closely resembles the ["Active Feild Indicator"](https://tina-io-git-quick-edit-tinacms.vercel.app/docs/editing/active-field-indicator/) feature.
  Which will be phased in out place of this in the future. Note that the attribute name is different, `[data-tinafield]` is the value
  for the "Active Field Indicator" while `[data-tina-field]` is the new attribute.

  The `tinaField` helper function should now only be used with the `[data-tina-field]` attibute.

  Adds experimental support for Vercel previews, the `useVisualEditing` hook from `@tinacms/vercel-previews` can be used
  to activate edit mode and listen for Vercel edit events.

- Updated dependencies [ca74add40]
- Updated dependencies [0f5557d23]
- Updated dependencies [ff4c1e0f4]
- Updated dependencies [6fefa56b0]
- Updated dependencies [7f95c1ce5]
  - @tinacms/graphql@1.4.13
  - @tinacms/app@1.2.13
  - @tinacms/datalayer@1.2.13

## 1.5.12

### Patch Changes

- 31c160cdf: Placeholder view for when assets fail to load
- b2a38b56f: Add back local build option that allows the user to build their site with the filesystem.
- beb179279: Add support for sites deployed to sub-paths. To enabled, provide the sub-path at config.build.basePath:

  ```ts
    ...
    build: {
      outputFolder: 'admin',
      publicFolder: 'public',
      basePath: 'my-site', // site is served at my-domain.com/my-site
    },
    ...
  ```

- Updated dependencies [31c160cdf]
- Updated dependencies [beb179279]
  - @tinacms/app@1.2.12
  - @tinacms/schema-tools@1.4.4
  - @tinacms/graphql@1.4.12
  - @tinacms/datalayer@1.2.12

## 1.5.11

### Patch Changes

- 83b19fb8d: Update the bridge interface to remove properties that are no longer needed.
- Updated dependencies [83b19fb8d]
- Updated dependencies [1c7998b7e]
  - @tinacms/graphql@1.4.11
  - @tinacms/app@1.2.11
  - @tinacms/datalayer@1.2.11

## 1.5.10

### Patch Changes

- Updated dependencies [a402c8010]
  - @tinacms/graphql@1.4.10
  - @tinacms/datalayer@1.2.10
  - @tinacms/app@1.2.10

## 1.5.9

### Patch Changes

- Updated dependencies [89dcad9d9]
- Updated dependencies [a0eb72ce0]
  - @tinacms/graphql@1.4.9
  - @tinacms/app@1.2.9
  - @tinacms/datalayer@1.2.9

## 1.5.8

### Patch Changes

- 5cb73050e: fix issue where migration would error if a user selected no to migrating templates
- 012ed53bf: Fix regression where `build.host` was not passed correctly
- Updated dependencies [eba7e5e5e]
  - @tinacms/app@1.2.8

## 1.5.7

### Patch Changes

- eeedcfd30: Adds folder support in the admin. See [this PR](https://github.com/tinacms/tinacms/pull/3750) for more info and a demo.
- 1de2c09ff: skip some checks durring build if the user is using self hosted
- f11408108: Skip schema diff check when we have conflicting version of GraphQL
- 0b0255a50: Increase body parser limit
- Updated dependencies [f14f59a96]
- Updated dependencies [eeedcfd30]
- Updated dependencies [7d4be0e51]
  - @tinacms/schema-tools@1.4.3
  - @tinacms/graphql@1.4.8
  - @tinacms/app@1.2.7
  - @tinacms/datalayer@1.2.8

## 1.5.6

### Patch Changes

- 65d53d5b9: Handle frontmatter format in forestry migration
- e7e11c624: Fix issue with windows paths not getting converted in config-manager
- Updated dependencies [65d53d5b9]
- Updated dependencies [40d15644f]
- Updated dependencies [a6786cc73]
  - @tinacms/graphql@1.4.7
  - @tinacms/datalayer@1.2.7
  - @tinacms/app@1.2.6

## 1.5.5

### Patch Changes

- 75d5ed359: Add html tag back into rich-text response
- Updated dependencies [75d5ed359]
  - @tinacms/graphql@1.4.6
  - @tinacms/app@1.2.5
  - @tinacms/datalayer@1.2.6

## 1.5.4

### Patch Changes

- 9f9cc4799: better forestry template migration
- 8f3767410: better matching on forestry pages
- Updated dependencies [67c7a48b8]
  - @tinacms/graphql@1.4.5
  - @tinacms/app@1.2.4
  - @tinacms/datalayer@1.2.5

## 1.5.3

### Patch Changes

- Updated dependencies [ae3abe927]
  - @tinacms/graphql@1.4.4
  - @tinacms/datalayer@1.2.4

## 1.5.2

### Patch Changes

- 40d908a79: Update error messages in Forestry migration
- 02a555c39: Handle block aliases on forestry migration
- 9216a5bda: Allow svg imports
- Updated dependencies [40d908a79]
- Updated dependencies [02a555c39]
  - @tinacms/graphql@1.4.3
  - @tinacms/app@1.2.3
  - @tinacms/datalayer@1.2.3

## 1.5.1

### Patch Changes

- 691d2eb3f: Add support for the `tinacms codemod move-tina-folder` command. This command moves the Tina folder from `.tina` to `tina`, and creates a lock file, which allows the entire `tina/__generated__` folder to be gitignored.
- bb9f0047f: Add `skip.client = true` to the Tina config for Forestry migrations by default.
- a70204500: feat: Configurable template key on blocks
- Updated dependencies [af5c32eae]
- Updated dependencies [1f9f83718]
- Updated dependencies [a70204500]
  - @tinacms/graphql@1.4.2
  - @tinacms/schema-tools@1.4.2
  - @tinacms/app@1.2.2
  - @tinacms/datalayer@1.2.2

## 1.5.0

### Minor Changes

- bbae12b95: Changes Tailwind config to also search for class names within user's config and related custom components

### Patch Changes

- 5f0139437: Add option for specifying datalayer port
- 5fcef561d: - Pin vite version
  - Adds react plugin so that we no longer get a 404 on react /@react-refresh
  - Adds transform ts and tsx files in build as well as dev
- 8fc99059f: Fix main export field for @tinacms/app
- 9a8074889: Consolidate payload transform logic
- e37f64b7f: feat: Skip blocks import, since it has some issues
  feat: Handle image gallery import
  feat: Handle a nested forestry directory through --forestryPath arg
- c48326846: Move --skipSDK into config property: `client.skip = true`
- Updated dependencies [e9514656c]
- Updated dependencies [5fcef561d]
- Updated dependencies [8fc99059f]
- Updated dependencies [9a8074889]
- Updated dependencies [c48326846]
- Updated dependencies [13b809ff5]
  - @tinacms/graphql@1.4.1
  - @tinacms/app@1.2.1
  - @tinacms/schema-tools@1.4.1
  - @tinacms/datalayer@1.2.1

## 1.4.0

### Minor Changes

- 76c984bcc: Use new API endpoint in content api reqests
- 202cd714d: Internal updates to the CLI

### Patch Changes

- 74742cb1c: Add warnings for deprecated CLI commands
- 81a2d3125: Ensure tina directory is specified on Database with new Tina config folder
- 48011a9ab: Fix issue where process.platform wasn't defined for external package. Fix issue where jsx-dev-runtime wasn't provided as an ES module from Vite in dev mode
- 5809796cf: Adds match property to collection
- 54dd7aabb: Move branch check to a seperate check.
- a18474c3b: Fix console warning about prettier parser not being provided
- 3a1edd50d: Bundle the MDX package with its dependencies so we can avoid awkward import issues related to the remark ecosystem modules
- a37648c5c: Only stop dev process when config is invalid at the start of the command
- Updated dependencies [76c984bcc]
- Updated dependencies [5809796cf]
- Updated dependencies [e3b58c03e]
- Updated dependencies [54aac9017]
- Updated dependencies [0553035f5]
- Updated dependencies [202cd714d]
- Updated dependencies [3a1edd50d]
  - @tinacms/schema-tools@1.4.0
  - @tinacms/datalayer@1.2.0
  - @tinacms/graphql@1.4.0
  - @tinacms/app@1.2.0
  - @tinacms/metrics@1.0.2

## 1.3.3

### Patch Changes

- Updated dependencies [d1cf65999]
  - @tinacms/schema-tools@1.3.4
  - @tinacms/app@1.1.2
  - @tinacms/graphql@1.3.5
  - @tinacms/datalayer@1.1.6

## 1.3.2

### Patch Changes

- Updated dependencies [b095d06a9]
  - @tinacms/graphql@1.3.4
  - @tinacms/app@1.1.2
  - @tinacms/datalayer@1.1.5
  - @tinacms/metrics@1.0.2
  - @tinacms/schema-tools@1.3.3

## 1.3.1

### Patch Changes

- 591c6e95c: Wait for DB before checking schema.

## 1.3.0

### Minor Changes

- d9962edc2: rm previewSrc from images

### Patch Changes

- 2df7b56e4: feat: import invalid forestry field names
- Updated dependencies [0a5297800]
- Updated dependencies [9c277e179]
- Updated dependencies [7a3e86ba1]
- Updated dependencies [f831dcf4f]
- Updated dependencies [5427d03c6]
- Updated dependencies [353899de1]
- Updated dependencies [01b858e41]
  - @tinacms/graphql@1.3.3
  - @tinacms/schema-tools@1.3.3
  - @tinacms/app@1.1.2
  - @tinacms/datalayer@1.1.4
  - @tinacms/metrics@1.0.2

## 1.2.2

### Patch Changes

- c97ffc20d: Add schema checks to ensure the local and server schema are the same.
- Updated dependencies [aa0250979]
- Updated dependencies [892b4e39e]
- Updated dependencies [3b1fe23ef]
- Updated dependencies [c97ffc20d]
  - @tinacms/graphql@1.3.2
  - @tinacms/schema-tools@1.3.2
  - @tinacms/app@1.1.1
  - @tinacms/datalayer@1.1.3

## 1.2.1

### Patch Changes

- Updated dependencies [3bbb621cd]
  - @tinacms/graphql@1.3.1
  - @tinacms/datalayer@1.1.2

## 1.2.0

### Minor Changes

- 169147490: When markdown files fail to parse, fallback to the non-MDX parser

### Patch Changes

- Updated dependencies [a8457798a]
- Updated dependencies [94b8bb6e0]
- Updated dependencies [169147490]
- Updated dependencies [e15d82c2e]
- Updated dependencies [e732906b6]
  - @tinacms/graphql@1.3.0
  - @tinacms/app@1.1.0
  - @tinacms/schema-tools@1.3.1
  - @tinacms/datalayer@1.1.1

## 1.1.0

### Minor Changes

- efd56e769: Replace Store with AbstractLevel in Database. Update CLI to allow user to configure Database.

### Patch Changes

- efd56e769: Remove license headers
- Updated dependencies [efd56e769]
- Updated dependencies [efd56e769]
- Updated dependencies [50f86caed]
  - @tinacms/app@1.0.7
  - @tinacms/datalayer@1.1.0
  - @tinacms/graphql@1.2.0
  - @tinacms/metrics@1.0.2
  - @tinacms/schema-tools@1.3.0

## 1.0.9

### Patch Changes

- Updated dependencies [61f8c0e50]
  - @tinacms/app@1.0.6

## 1.0.8

### Patch Changes

- 55f7953eb: Small cli styling change on public assets in init
  - @tinacms/app@1.0.5

## 1.0.7

### Patch Changes

- 849dc0bb7: Adds more features to the forestry migration tool
- 23942cfcb: Add support for --rootPath argument in CLI commands
- e7c404bcf: Support remote path configuration for separate content repos

  Tina now supports serving content from a separate Git repo.

  ### Local development workflow

  To enable this during local development, point
  this config at the root of the content repo.

  > NOTE: Relative paths are fine to use here, but make sure it's relative to the `.tina/config` file

  ```ts
  localContentPath: process.env.REMOTE_ROOT_PATH // eg. '../../my-content-repo'
  ```

  ### Production workflow

  For production, your config should use the `clientId`, `branch`, and `token` values that are associated with your _content repo_.

- 82b22d6f7: fix: don't try and show spinners in CI logs
- d6301e7fb: Use the db status endpoint to validate credentials so that slow indexing does not cause builds to fail during indexing
- Updated dependencies [84fe97ca7]
- Updated dependencies [c5a603c75]
- Updated dependencies [23942cfcb]
- Updated dependencies [e7c404bcf]
- Updated dependencies [e8776aa59]
- Updated dependencies [e938b9d91]
- Updated dependencies [b7b05d03f]
- Updated dependencies [4533d5d66]
- Updated dependencies [31dacc176]
  - @tinacms/schema-tools@1.2.1
  - @tinacms/app@1.0.5
  - @tinacms/datalayer@1.0.1
  - @tinacms/graphql@1.1.0

## 1.0.6

### Patch Changes

- Updated dependencies [7d41435df]
- Updated dependencies [3165f397d]
- Updated dependencies [b2952a298]
  - @tinacms/graphql@1.0.5
  - @tinacms/schema-tools@1.2.0
  - @tinacms/app@1.0.4
  - @tinacms/datalayer@1.0.0
  - @tinacms/metrics@1.0.1

## 1.0.5

### Patch Changes

- 4ebc44068: Add a migration tool for forestry users
- Updated dependencies [7554ea362]
- Updated dependencies [1a75e8c13]
- Updated dependencies [4ebc44068]
  - @tinacms/schema-tools@1.1.0
  - @tinacms/app@1.0.4
  - @tinacms/metrics@1.0.1
  - @tinacms/graphql@1.0.4

## 1.0.4

### Patch Changes

- e0f71d4bd: Update the error message to include context from the server
- Updated dependencies [66ed1452b]
- Updated dependencies [7495f032b]
- Updated dependencies [de37c9eff]
  - @tinacms/app@1.0.3
  - @tinacms/schema-tools@1.0.3
  - @tinacms/graphql@1.0.3

## 1.0.3

### Patch Changes

- Updated dependencies [f13878798]
- Updated dependencies [c62d2bad4]
  - @tinacms/app@1.0.2

## 1.0.2

### Patch Changes

- c91bc0fc9: Tweak CLI styling for create-tina-app, tinacms dev, and tinacms init
- Updated dependencies [38438bad6]
- Updated dependencies [c91bc0fc9]
- Updated dependencies [78b9668b1]
- Updated dependencies [0b2164645]
- Updated dependencies [7c1425a82]
- Updated dependencies [c1ac4bf10]
- Updated dependencies [9d4943a82]
  - @tinacms/app@1.0.1
  - @tinacms/schema-tools@1.0.2
  - @tinacms/graphql@1.0.2

## 1.0.1

### Patch Changes

- Updated dependencies [08e02ec21]
- Updated dependencies [94a5da311]
  - @tinacms/schema-tools@1.0.1
  - @tinacms/graphql@1.0.1
  - @tinacms/app@1.0.0

## 1.0.0

### Major Changes

- 958d10c82: Tina 1.0 Release

  Make sure you have updated to th "iframe" path: https://tina.io/blog/upgrading-to-iframe/

### Patch Changes

- Updated dependencies [958d10c82]
  - @tinacms/app@1.0.0
  - @tinacms/datalayer@1.0.0
  - @tinacms/graphql@1.0.0
  - @tinacms/metrics@1.0.0
  - @tinacms/schema-tools@1.0.0

## 0.62.3

### Patch Changes

- Updated dependencies [f4dcf3e27]
- Updated dependencies [a5d6722c7]
- Updated dependencies [231dcab2e]
  - @tinacms/app@0.0.28
  - @tinacms/schema-tools@0.2.2
  - @tinacms/graphql@0.63.20

## 0.62.2

### Patch Changes

- 41a0e946c: Don't compile client since we have all info needed to create client.
- Updated dependencies [d58401231]
- Updated dependencies [3370cefd8]
- Updated dependencies [6c93834a2]
- Updated dependencies [e720590e1]
  - @tinacms/app@0.0.27
  - @tinacms/schema-tools@0.2.1
  - @tinacms/graphql@0.63.19

## 0.62.1

### Patch Changes

- a4de4fa6e: Fix typo in !

## 0.62.0

### Minor Changes

- 0fb26ac91: Updated to use new init for iframe way of editing.

### Patch Changes

- 2a03abe66: Remove console.log
- 4b1e773ae: Fix issue caused by removing client and types file
- Updated dependencies [fd7e4f636]
- Updated dependencies [f7d3cf532]
- Updated dependencies [774abcf9c]
- Updated dependencies [245a65dfe]
  - @tinacms/app@0.0.26
  - @tinacms/schema-tools@0.2.0
  - @tinacms/graphql@0.63.18

## 0.61.27

### Patch Changes

- Updated dependencies [6d06e18a3]
  - @tinacms/app@0.0.25

## 0.61.26

### Patch Changes

- 194123d26: Update error message
- 97f0b6472: Add raw editor support for static mode. Use `~` for preview path.
- 660dc62fb: Show a deperecated notification for old schema file usage
  - @tinacms/app@0.0.24
  - @tinacms/graphql@0.63.17

## 0.61.25

### Patch Changes

- ec73f1ea6: Check config.ts/config.tsx additionally for usingTs
- Updated dependencies [15f7c18ef]
- Updated dependencies [c4f9607ce]
  - @tinacms/app@0.0.24
  - @tinacms/schema-tools@0.1.9
  - @tinacms/graphql@0.63.16

## 0.61.24

### Patch Changes

- 009fe3180: Reorganize @tinacms/app so that it runs a local install in the working directory to ensure consistent dependencies
- 03aa3e09e: Remove the use of ESM package, which allowed CJS scripts to run as ES modules. This was initially used for yarn pnp support but is no longer necessary.
- Updated dependencies [009fe3180]
- Updated dependencies [2f6a3596d]
  - @tinacms/app@0.0.23
  - @tinacms/datalayer@0.2.4
  - @tinacms/graphql@0.63.15
  - @tinacms/metrics@0.0.3
  - @tinacms/schema-tools@0.1.8

## 0.61.23

### Patch Changes

- 2422e505d: Removed styled-components as a dependency in tinacms.
  Removed deprecated react-toolbar in @tinacms/toolkit.
- Updated dependencies [2422e505d]
  - @tinacms/app@0.0.22
  - @tinacms/graphql@0.63.15
  - @tinacms/datalayer@0.2.4
  - @tinacms/metrics@0.0.3
  - @tinacms/schema-tools@0.1.8

## 0.61.22

### Patch Changes

- Updated dependencies [005e1d699]
- Updated dependencies [ce6c1ccfb]
  - @tinacms/schema-tools@0.1.8
  - @tinacms/graphql@0.63.14
  - @tinacms/app@0.0.21

## 0.61.21

### Patch Changes

- 97225d5f0: Exit tinacms init when there's an error with dependency install
- fce51ddd8: Remove extra space in tina init console.log
- Updated dependencies [b1a357f60]
  - @tinacms/schema-tools@0.1.7
  - @tinacms/app@0.0.20
  - @tinacms/graphql@0.63.13

## 0.61.20

### Patch Changes

- Updated dependencies [c6e3bd321]
  - @tinacms/schema-tools@0.1.6
  - @tinacms/app@0.0.19
  - @tinacms/graphql@0.63.12

## 0.61.19

### Patch Changes

- 802381abd: Fix an issue where npm init didn't get awaited during init
  - @tinacms/app@0.0.18

## 0.61.18

### Patch Changes

- Updated dependencies [183249b11]
- Updated dependencies [8060d0949]
  - @tinacms/schema-tools@0.1.5
  - @tinacms/app@0.0.17
  - @tinacms/graphql@0.63.11

## 0.61.17

### Patch Changes

- @tinacms/app@0.0.16

## 0.61.16

### Patch Changes

- a4a829734: Remove styled-components from static install
  - @tinacms/app@0.0.15

## 0.61.15

### Patch Changes

- @tinacms/app@0.0.14

## 0.61.14

### Patch Changes

- f581f263d: Add --static option for `tina init`
- c06b6a2f0: fix: Don't run subprocess if main process fails with occupied port
- 47f99085d: Do not require a schema file when a config is provided.
- 64c40e6fc: change hardcoded content api url to be dynamic
- 2444cf047: - Makes cli checks the error message clearer
  - Adds a "Spinner" to the messages to make it cleaner
  - Does a GQL request to check the clientID, token, branch are all valid.
- f3439ea35: Replace loading message and hide forms while loading.
- 48032e2ba: Use tinaio url config override in the client
- 4efe31214: Include error message in file failed upload model
- Updated dependencies [f581f263d]
- Updated dependencies [e5da05a8c]
- Updated dependencies [0513ae416]
- Updated dependencies [7ae1b0697]
- Updated dependencies [f3439ea35]
- Updated dependencies [48032e2ba]
- Updated dependencies [6e137ea85]
  - @tinacms/schema-tools@0.1.4
  - @tinacms/app@0.0.13
  - @tinacms/datalayer@0.2.4
  - @tinacms/graphql@0.63.10

## 0.61.13

### Patch Changes

- 9183157c4: This allows us to use a leaner `define` function for the standalone config. Right now we're balancing a lot on the `defineSchema/defineConfig` types and have a few overlapping things like `client`, which accepts both an optional object with `referenceDepth` config as well as the autogenerated http client.

  One thing it does that's a bit different is it uses the `apiUrl` from the client generation function and sends it through as a global constant to the Vite app, this avoids the need for the generated `client`.

- 4adf12619: Add support for experimental iframe mode
- Updated dependencies [9183157c4]
- Updated dependencies [4adf12619]
- Updated dependencies [f8b89379c]
  - @tinacms/app@0.0.12
  - @tinacms/schema-tools@0.1.3
  - @tinacms/graphql@0.63.9

## 0.61.12

### Patch Changes

- Updated dependencies [87369d34c]
  - @tinacms/graphql@0.63.8

## 0.61.11

### Patch Changes

- Updated dependencies [777b1e08a]
  - @tinacms/schema-tools@0.1.2
  - @tinacms/graphql@0.63.7
  - @tinacms/app@0.0.11

## 0.61.10

### Patch Changes

- 75b9a1b56: enhancement: Don't build client on tinacms audit
- 10cce31b7: fix: surface errors from type-gen
- 9e5da3103: Add router to default schema
- 098102a89: fix: exit with error with tina schema build fails
- Updated dependencies [75b9a1b56]
- Updated dependencies [59ff1bb10]
- Updated dependencies [232ae6d52]
- Updated dependencies [fd4d8c8ff]
- Updated dependencies [9e5da3103]
  - @tinacms/graphql@0.63.6
  - @tinacms/schema-tools@0.1.1
  - @tinacms/app@0.0.10

## 0.61.9

### Patch Changes

- 2b60a7bd8: Improve audit so that it doesn't throw errors during the file list process. Also adds support for `--verbose` argument during `audit`.
- Updated dependencies [2b60a7bd8]
  - @tinacms/graphql@0.63.5
  - @tinacms/app@0.0.9

## 0.61.8

### Patch Changes

- b1f141e66: Fixes an issue where JSX inside the tina schema would break compilation for users using a later version of esbuild.
  - @tinacms/app@0.0.8

## 0.61.7

### Patch Changes

- Updated dependencies [1fc0e339e]
  - @tinacms/datalayer@0.2.3
  - @tinacms/graphql@0.63.4

## 0.61.6

### Patch Changes

- Updated dependencies [b369d7238]
  - @tinacms/graphql@0.63.3
  - @tinacms/app@0.0.7

## 0.61.5

### Patch Changes

- @tinacms/graphql@0.63.2

## 0.61.4

### Patch Changes

- @tinacms/app@0.0.6
- @tinacms/datalayer@0.2.2
- @tinacms/graphql@0.63.1
- @tinacms/metrics@0.0.3
- @tinacms/schema-tools@0.1.0

## 0.61.3

### Patch Changes

- Updated dependencies [067c49efd]
- Updated dependencies [9ba09bd0c]
  - @tinacms/graphql@0.63.1
  - @tinacms/app@0.0.5

## 0.61.2

### Patch Changes

- 8183b638c: ## Adds a new "Static" build option.

  This new option will build tina into a static `index.html` file. This will allow someone to use tina without having react as a dependency.

  ### How to update

  1.  Add a `.tina/config.{js,ts,tsx,jsx}` with the default export of define config.

  ```ts
  // .tina/config.ts
  import schema from './schema'

  export default defineConfig({
    schema: schema,
    //.. Everything from define config in `schema.ts`
    //.. Everything from `schema.config`
  })
  ```

  2. Add Build config

  ```
  .tina/config.ts

  export default defineConfig({
     build: {
       outputFolder: "admin",
       publicFolder: "public",
    },
    //... other config
  })
  ```

  3. Go to `http://localhost:3000/admin/index.html` and view the admin

- Updated dependencies [7b0dda55e]
- Updated dependencies [8183b638c]
  - @tinacms/graphql@0.63.0
  - @tinacms/schema-tools@0.1.0
  - @tinacms/app@0.0.4
  - @tinacms/datalayer@0.2.2
  - @tinacms/metrics@0.0.3

## 0.61.1

### Patch Changes

- 531347748: Update to use mkdirp to fix issue on windows
- Updated dependencies [028e10686]
- Updated dependencies [e27f5cce7]
  - @tinacms/graphql@0.62.1

## 0.61.0

### Minor Changes

- 870a32f18: This PR adds the new generated client, a new build command and introduces a new path of working with tina.

  # How to upgrade

  ## Updates to schema.ts

  Instead of passing an ApiURL, now the clientId, branch and read only token (NEW) will all be configured in the schema. The local url will be used if the --local flag is passed.

  This will require a change to the schema and the scripts.

  ```diff
  // .tina/schema.ts

  + import { client } from "./__generated__/client";

  // ...

  const schema = defineSchema({
  +    config: {
  +        branch: "main",
  +        clientId: "***",
  +        token: "***",
      },
      collections: [
          // ...
      ]
  })

  // ...
  - const branch = process.env.NEXT_PUBLIC_VERCEL_GIT_COMMIT_REF
  - const clientId = 'YOUR-CLIENT-ID-HERE'
  - const apiURL =
  -   process.env.NODE_ENV == 'development'
  -     ? 'http://localhost:4001/graphql'
  -    : `https://content.tinajs.io/content/${clientId}/github/${branch}`
  export const tinaConfig = defineConfig({
  +  client,
  -  apiURl,
    schema,
    // ...
  })

  export default schema
  ```

  The token must be a wildcard token (`*`) and can be generated from the tina dashboard. [Read more hear](https://tina.io/docs/graphql/read-only-tokens/)

  ## Updates to scripts in package.json

  We now recommend separating the graphQL server into two separate processes (two separate terminals in development). The scripts should look like this:

  ```json
  {
    "scripts": {
      "dev": "tinacms build --local && next dev",
      "dev-server": "tinacms server:start",
      "build": "tinacms build && next build"
      // ... Other Scripts
    }
  }
  ```

  When developing, in the first terminal run `yarn dev-server` and then `yarn dev` in the second.

  The old `-c` subcommand can still be used. This will start the dev server and next dev process in the same terminal.

  ```json
  {
    "scripts": {
      "dev": "tinacms server:start \"tinacms build --local && next dev\"",
      "dev-server": "tinacms server:start",
      "build": "tinacms build && next build"
      // ... Other Scripts
    }
  }
  ```

  ## Updates to generated files

  We now recommend ignoring most of the generated files. This is because `client.ts` and `types.ts` will be generated in CI with `tinacms build`

  To remove them from your repository, run `git rm --cached .tina/__generated__/*` and then `yarn tinacms build` to update the generated files that need to stay.

### Patch Changes

- 98f82cef7: Updates the init command to use the new client
- ae06f4a96: Fixed audit cmd to use datalayer
- 4360ef284: Minor bug fixes with tina init command in the CLI
- 3ac1fb8e4: Generate types and client based on the file type of the schema
- cf7df9859: Throw an error message when the client is not setup properly in production
- f68b045b9: Example page accounts for apps that use the src dir
- 637793dc0: Always reset the generated folder
- 8dab8d4ce: fix bug where tina init would error because there is no generated folder
- Updated dependencies [870a32f18]
- Updated dependencies [dcbc57c86]
- Updated dependencies [ae06f4a96]
- Updated dependencies [660247b6b]
- Updated dependencies [a7dcb8d44]
  - @tinacms/graphql@0.62.0
  - @tinacms/schema-tools@0.0.9
  - @tinacms/datalayer@0.2.2

## 0.60.28

### Patch Changes

- Updated dependencies [0b5a8e6e7]
  - @tinacms/graphql@0.61.3

## 0.60.27

### Patch Changes

- 8e893a027: Fixed issue where having a src and pages dir would cause an issue
- Updated dependencies [cf0f531a1]
- Updated dependencies [b0dfc6205]
  - @tinacms/datalayer@0.2.1
  - @tinacms/schema-tools@0.0.8
  - @tinacms/graphql@0.61.2

## 0.60.26

### Patch Changes

- b5b0dfd66: chore: migrate from fs.rmdir -> fs.rm
- 7d87eb6b7: Add `loadCustomStore` to top schema config
- 7038745f6: Fixed issue where server would start before the generated file was made.
- Updated dependencies [b5b0dfd66]
- Updated dependencies [7d87eb6b7]
- Updated dependencies [67e291e56]
- Updated dependencies [ae23e9ad6]
  - @tinacms/graphql@0.61.1
  - @tinacms/schema-tools@0.0.7

## 0.60.25

### Patch Changes

- 0bc18072e: Fixed issue where too many saves at one time would cause server to crash

## 0.60.24

### Patch Changes

- 2ef5a1f33: Use media config from the schema in the local media server
- 2ef5a1f33: Uses new `schema.config` when resolving media/asset urls
- b348f8b6b: Experimental isomorphic git bridge implementation
- b46e9a481: Fixed issue where child process would start before parent
- fb73fb355: Renames syncFolder to a mediaRoot when configuring Repo-Based Media
- 7b77fe1b5: Add a default TinaMediaStore for repo-based media
- 3e4b3ea7e: media manage uses relieve dir paths
- 99a13024d: Enables paging for local media manager
- Updated dependencies [2ef5a1f33]
- Updated dependencies [2ef5a1f33]
- Updated dependencies [b348f8b6b]
- Updated dependencies [fb73fb355]
- Updated dependencies [4daf15b36]
  - @tinacms/graphql@0.61.0
  - @tinacms/datalayer@0.2.0
  - @tinacms/schema-tools@0.0.6
  - @tinacms/metrics@0.0.3

## 0.60.23

### Patch Changes

- Updated dependencies [3325cd226]
  - @tinacms/graphql@0.60.8

## 0.60.22

### Patch Changes

- b1a4290e6: Use media config from the schema in the local media server
- 1955b8842: Uses new `schema.config` when resolving media/asset urls
- Updated dependencies [f6cb634c2]
- Updated dependencies [b1a4290e6]
- Updated dependencies [1955b8842]
- Updated dependencies [8b81c3cf3]
  - @tinacms/graphql@0.60.7
  - @tinacms/schema-tools@0.0.5
  - @tinacms/datalayer@0.1.1
  - @tinacms/metrics@0.0.3

## 0.60.21

### Patch Changes

- Updated dependencies [e2aafcd93]
- Updated dependencies [a20fed8b7]
  - @tinacms/graphql@0.60.6

## 0.60.20

### Patch Changes

- f71f55ac3: Fixd issue where --dev caused a breaking change
- Updated dependencies [57f09bdd7]
  - @tinacms/graphql@0.60.5

## 0.60.19

### Patch Changes

- d103b27ad: Fix issue where new collections would not be added when CLI restarts
- e06dbb3ca: Adds `waitForDB` cmd to cli
- Updated dependencies [d103b27ad]
  - @tinacms/graphql@0.60.4

## 0.60.18

### Patch Changes

- 79d112d79: Update cli to accept tinaCloudMediaStore flag and add to metadata during schema compilation
- 91d6e6758: revert platform aware paths in schema introduced in https://github.com/tinacms/tinacms/commit/558cc4368cd2a4b6e87dfb82bbfbb6f569f8a6f8
- b1240328d: Adds local server routes for handling media
- 91d6e6758: Fix issues with experimentalData on windows related to path separator inconsistency and interference with the .tina/**generated** folder
- Updated dependencies [79d112d79]
- Updated dependencies [3f46c6706]
- Updated dependencies [db9168578]
- Updated dependencies [91d6e6758]
  - @tinacms/graphql@0.60.3

## 0.60.17

### Patch Changes

- 08cdb672a: Adds `useRelativeMedia` support to local graphql client
- 646cad8da: Adds support for using the generated client on the frontend
- f857616f6: Rename sdk to queries
- Updated dependencies [08cdb672a]
- Updated dependencies [fdbfe9a16]
- Updated dependencies [6e2ed31a2]
  - @tinacms/graphql@0.60.2
  - @tinacms/schema-tools@0.0.4

## 0.60.16

### Patch Changes

- 7372f90ca: Adds a new client that can be used on the backend and frontend.
- Updated dependencies [3b11ff6ad]
  - @tinacms/graphql@0.60.1

## 0.60.15

### Patch Changes

- ceb826916: Fix issue where \_app override from tina init was improperly formatted

## 0.60.14

### Patch Changes

- Updated dependencies [6a6f137ae]
  - @tinacms/graphql@0.60.0

## 0.60.13

### Patch Changes

- 9d28ea29e: hide some existing start:server logging behind --verbose flag. format some messages to make them easier to read

## 0.60.12

### Patch Changes

- ef450a53a: - Update tinacms CLI to support schemaFileType option (default 'ts') to allow user to specify the schema file type
  - Update telemetry module to optionally check NO_TELEMETRY environment variable for disabling telemetry
- 81b729c24: Update formatting of cli init outputs
- 558cc4368: Make schema init platform-aware and refactor database put requests
- Updated dependencies [4da32454b]
- Updated dependencies [921709a7e]
- Updated dependencies [ef450a53a]
- Updated dependencies [a2906d6fe]
- Updated dependencies [558cc4368]
- Updated dependencies [06666d39f]
- Updated dependencies [3e2d9e43a]
  - @tinacms/graphql@0.59.11
  - @tinacms/schema-tools@0.0.3
  - @tinacms/metrics@0.0.3
  - @tinacms/datalayer@0.1.1

## 0.60.11

### Patch Changes

- Updated dependencies [cf33bcec1]
  - @tinacms/graphql@0.59.10

## 0.60.10

### Patch Changes

- 6154d12b8: Check for appropriate versions of react and react-dom before initializing with tinacms init
- 8c23d69a2: Adds an MDX example when you run @tinacms/cli init
- abf25c673: The schema can now to used on the frontend (optional for now but will be the main path moving forward).

  ### How to migrate.

  If you gone though the `tinacms init` process there should be a file called `.tina/components/TinaProvider`. In that file you can import the schema from `schema.ts` and add it to the TinaCMS wrapper component.

  ```tsx
  import TinaCMS from 'tinacms'
  import schema, { tinaConfig } from '../schema.ts'

  // Importing the TinaProvider directly into your page will cause Tina to be added to the production bundle.
  // Instead, import the tina/provider/index default export to have it dynamially imported in edit-moode
  /**
   *
   * @private Do not import this directly, please import the dynamic provider instead
   */
  const TinaProvider = ({ children }) => {
    return (
      <TinaCMS {...tinaConfig} schema={schema}>
        {children}
      </TinaCMS>
    )
  }

  export default TinaProvider
  ```

- Updated dependencies [8b3be903f]
- Updated dependencies [82174ff50]
- Updated dependencies [a87e1e6fa]
- Updated dependencies [abf25c673]
- Updated dependencies [591640db0]
- Updated dependencies [e8b0de1f7]
- Updated dependencies [b01f2e382]
  - @tinacms/datalayer@0.1.0
  - @tinacms/graphql@0.59.9

## 0.60.9

### Patch Changes

- 048538625: fix: return cms on cmsCallback codegen (to fix broken typing)
- Updated dependencies [e7b27ba3b]
- Updated dependencies [11d55f441]
  - @tinacms/graphql@0.59.8

## 0.60.8

### Patch Changes

- 919f5cb6c: use standard next script names

## 0.60.7

### Patch Changes

- 9e436f145: Update CLI to use defineConfig
- 851e4be73: Update tina init to use the new way of laying out tina config
- cc99e4309: update admin file path to /pages/admin.js to support the hash router
  - @tinacms/datalayer@0.0.2
  - @tinacms/graphql@0.59.7
  - @tinacms/metrics@0.0.2

## 0.60.6

### Patch Changes

- 98622111d: Use [esbuild](https://esbuild.github.io/) to build the schema instead of typescript.

  This allows the user to

  - use non typescript files like JS, JSX, TS
  - Import from outside of the tina folder

  The downside

  - Now type errors will still pass (The schema will compile) and one will get an error at runtime instead of compile time

- Updated dependencies [c730fa1dd]
- Updated dependencies [cd0f6f022]
  - @tinacms/graphql@0.59.7

## 0.60.5

### Patch Changes

- 399fbf4fa: Fix an issue where builds weren't happening during CI, this is only an issue for the experimental data layer

## 0.60.4

### Patch Changes

- a05546eb4: Added basic open source telemetry

  See [this discussion](https://github.com/tinacms/tinacms/discussions/2451) for more information and how to opt out.

- Updated dependencies [8bf0ac832]
- Updated dependencies [a05546eb4]
  - @tinacms/metrics@0.0.2
  - @tinacms/datalayer@0.0.2
  - @tinacms/graphql@0.59.6

## 0.60.3

### Patch Changes

- 43b40cc8b: Implement useTina in CLI init
- b399c734c: Fixes support for collection.templates in graphql
- Updated dependencies [b399c734c]
  - @tinacms/datalayer@0.0.2
  - @tinacms/graphql@0.59.6

## 0.60.2

### Patch Changes

- d17de356a: Update CLI to use apiUrl
- a67b0c1d7: Dont reinstantiate bridge and store

## 0.60.1

### Patch Changes

- Updated dependencies [8ad8f03fd]
- Updated dependencies [04b7988d5]
- Updated dependencies [e3c41f69d]
- Updated dependencies [f5390e841]
- Updated dependencies [32082e0b3]
  - @tinacms/graphql@0.59.5
  - @tinacms/datalayer@0.0.1

## 0.60.0

### Minor Changes

- 35884152b: Adds and audit command that checks files for errors.

### Patch Changes

- 083aa8ec6: Rebuild database every save while in local mode
- Updated dependencies [b66aefde1]
- Updated dependencies [35884152b]
- Updated dependencies [4948beec6]
  - @tinacms/graphql@0.59.4

## 0.59.0

### Minor Changes

- 70da62fe8: deprecated the use of `getStaticPropsForTina`

### Patch Changes

- 80732bd97: Create a @tinacms/datalayer package which houses the logic for data management for the GraphQL API. This simplifies the @tinacms/graphql package and allows for a clearer separation.
- Updated dependencies [34cd3a44a]
- Updated dependencies [b006a5ab9]
- Updated dependencies [a324b9c37]
- Updated dependencies [80732bd97]
- Updated dependencies [0bec208e2]
- Updated dependencies [5c070a83f]
  - @tinacms/graphql@0.59.3
  - @tinacms/datalayer@0.0.1

## 0.58.5

### Patch Changes

- Updated dependencies [212685fc3]
  - @tinacms/graphql@0.59.2

## 0.58.4

### Patch Changes

- 118524507: Fixed typo in admin link
- Updated dependencies [f46c6f987]
  - @tinacms/graphql@0.59.1

## 0.58.3

### Patch Changes

- Updated dependencies [bd4e1f802]
- Updated dependencies [62bea7019]
  - @tinacms/graphql@0.59.0

## 0.58.2

### Patch Changes

- Updated dependencies [fffce3af8]
  - @tinacms/graphql@0.58.2

## 0.58.1

### Patch Changes

- Updated dependencies [4700d7ae4]
  - @tinacms/graphql@0.58.1

## 0.58.0

### Minor Changes

- fa7a0419f: Adds experimental support for a data layer between file-based content and the GraphQL API. This allows documents to be indexed so the CMS can behave more like a traditional CMS, with the ability enforce foreign reference constraints and filtering/pagination capabilities.
- 8c14f29ef: Updated cli to include a new option, `--noSDK`. When this flag is present it will not generate the SDK.

### Patch Changes

- 9c5f888a3: Modifies `tinacms init` for `TinaAdmin`-ready page
- Updated dependencies [eb5fbfac7]
- Updated dependencies [fa7a0419f]
- Updated dependencies [47d126029]
  - @tinacms/graphql@0.58.0

## 0.57.2

### Patch Changes

- edb2f4011: Trim path property on collections during compilation
- Updated dependencies [edb2f4011]
  - @tinacms/graphql@0.57.2

## 0.57.1

### Patch Changes

- 50710e1d0: Add no-check for Typescript-generated file
- c78d981e6: Reset entire **generated** folder on re-compile
- Updated dependencies [60729f60c]
  - @tinacms/graphql@0.57.1

## 0.57.0

### Minor Changes

- d1ed404ba: Add support for auto-generated SDK for type-safe data fetching

### Patch Changes

- 138ceb8c4: Clean up dependencies
- Updated dependencies [138ceb8c4]
- Updated dependencies [577d6a5ad]
- Updated dependencies [ed277e3bd]
- Updated dependencies [d1ed404ba]
  - @tinacms/graphql@0.57.0

## 0.56.5

### Patch Changes

- 33ebe7a41: updated cli generated files
- Updated dependencies [4b7795612]
  - @tinacms/graphql@0.56.1

## 0.56.4

### Patch Changes

- b99baebf1: Add rich-text editor based on mdx, bump React dependency requirement to 16.14
- Updated dependencies [891623c7c]
- Updated dependencies [b99baebf1]
  - @tinacms/graphql@0.56.0

## 0.56.3

### Patch Changes

- 7c389cb0f: Remove Forestry reference in CLI hint

## 0.56.2

### Patch Changes

- Updated dependencies [9ecb392ca]
  - @tinacms/graphql@0.55.2

## 0.56.1

### Patch Changes

- Updated dependencies [ff4446c8e]
- Updated dependencies [667c33e2a]
  - @tinacms/graphql@0.55.1

## 0.56.0

### Minor Changes

- f3bddeb4a: Added new warning messages for list UI that we do not support by default
- 455a44359: Add noWatch option to server:start command. When this option is used, the config is not regenerated on file changes.

### Patch Changes

- Updated dependencies [2908f8176]
- Updated dependencies [5d83643b2]
- Updated dependencies [f3bddeb4a]
  - @tinacms/graphql@0.55.0

## 0.55.2

### Patch Changes

- e6e727697: feat: add simpler err message
- 9b27192fe: Build packages with new scripting, which includes preliminary support for ES modules.
- Updated dependencies [9b27192fe]
  - @tinacms/graphql@0.54.3

## 0.55.1

### Patch Changes

- d94fec611: Improve exported types for defineSchema
- Updated dependencies [d94fec611]
  - @tinacms/graphql@0.54.2

## 0.55.0

### Minor Changes

- f4f652dae: Updated regex for CSS in tina init CLI

## 0.54.2

### Patch Changes

- Updated dependencies [4de977f63]
  - @tinacms/graphql@0.54.1

## 0.54.1

### Patch Changes

- Updated dependencies [7663e0f7f]
  - @tinacms/graphql@0.54.0

## 0.54.0

### Minor Changes

- 069c63b73: Tina init command now adds exit-admin path

### Patch Changes

- Updated dependencies [b4f5e973f]
  - @tinacms/graphql@0.53.0

## 0.53.3

### Patch Changes

- Updated dependencies [b4bbdda86]
  - @tinacms/graphql@0.52.2

## 0.53.2

### Patch Changes

- Updated dependencies [b05c91c6]
  - @tinacms/graphql@0.52.1

## 0.53.1

### Patch Changes

- 7d2307321: Fixed the new line character in the @tinacms/cli init command
- Updated dependencies [aa4507697]
  - @tinacms/graphql@0.52.0

## 0.53.0

### Minor Changes

- 35d6f5e7: Added better error handleing for childProcess

## 0.52.2

### Patch Changes

- Updated dependencies [589c7806]
  - @tinacms/graphql@0.51.1

## 0.52.1

### Patch Changes

- c66b7eef: added regex to add css files to generated file
- Updated dependencies [5a934f6b]
- Updated dependencies [271a72d7]
  - @tinacms/graphql@0.51.0

## 0.52.0

### Minor Changes

- d6dd2886: Added styles to generated files from CLI

### Patch Changes

- 853330c1: Fix issue where NEXT_PUBLIC_EDIT_BRANCH was actually NEXT_PUBLIC_EDIT_BRACH in generated file

## 0.51.1

### Patch Changes

- Updated dependencies [0970961f]
  - @tinacms/graphql@0.50.2

## 0.51.0

### Minor Changes

- 25e0be67: update generated files in CLI

## 0.50.1

### Patch Changes

- Updated dependencies [65b3e3a3]
  - @tinacms/graphql@0.50.1

## 0.50.0

### Minor Changes

- 7f3c8c1a: # 🔧 Changes coming to TinaCMS ⚙️

  👋 You may have noticed we've been hard at-work lately building out a more opinionated approach to TinaCMS. To that end, we've settled around a few key points we'd like to announce. To see the work in progress, check out the [main](https://github.com/tinacms/tinacms/tree/main) branch, which will become the primary branch soon.

  ## Consolidating @tinacms packages in to @tinacms/toolkit

  By nature, Tina relies heavily on React context, and the dependency mismatches from over-modularizing our toolkit has led to many bugs related to missing context. To fix this, we'll be consolidating nearly every package in the @tinacms scope to a single package called `@tinacms/toolkit`

  We'll also be rolling out esm support as it's now much easier to address build improvements

  ## A more focused tinacms package

  The `tinacms` package now comes baked-in with APIs for working with the TinaCMS GraphQL API. Because `@tinacms/toolkit` now encompasses everything you'd need to build your own CMS integration, we're repurposing the `tinacms` package to more accurately reflect the "batteries-included" approach.

  If you haven't been introduced, the GraphQL API is a Git-backed CMS which we'll be leaning into more in the future. With a generous free tier and direct syncing with Github its something we're really excited to push forward. Sign up for free here
  Note: tinacms still exports the same APIs, but we'll gradually start moving the backend-agnostic tools to @tinacms/toolkit.

  ## Consolidating the tina-graphql-gateway repo

  The tina-graphql-gateway repo will be absorbed into this one. If you've been working with our GraphQL APIs you'll need to follow our migration guide.

  ## Moving from Lerna to Yarn PNP

  We've had success with Yarn 2 and PNP in other monorepos, if you're a contributor you'll notice some updates to the DX, which should hopefully result in a smoother experience.

  ## FAQ

  ### What about other backends?

  The `@tinacms/toolkit` isn't going anywhere. And if you're using packages like `react-tinacms-strapi` or r`eact-tinacms-github` with success, that won't change much, they'll just be powered by `@tinacms/toolkit` under the hood.

  ### Do I need to do anything?

  We'll be bumping all packages to `0.50.0` to reflect the changes. If you're using @tincams scoped packages those won't receive the upgrade. Unscoped packages like `react-tinacms-editor` will be upgraded, and should be bumped to 0.50.0 as well.
  When we move to `1.0.0` we'll be pushing internal APIs to `@tinacms/toolkit`, so that's the long-term location of

  ### Will you continue to patch older versions?

  We'll continue to make security patches, however major bug fixes will likely not see any updates. Keep in mind that `@tinacms/toolkit` will continue to be developed.

### Patch Changes

- Updated dependencies [7f3c8c1a]
  - @tinacms/graphql@0.1.0

## 0.4.0

### Minor Changes

- 7351d92f: # Define schema changes

  We're going to be leaning on a more _primitive_ concept of how types are defined with Tina, and in doing so will be introducing some breaking changes to the way schemas are defined. Read the detailed [RFC discussion](https://github.com/tinacms/rfcs/pull/18) for more on this topic, specifically the [latter portions](https://github.com/tinacms/rfcs/pull/18#issuecomment-805400313) of the discussion.

  ## Collections now accept a `fields` _or_ `templates` property

  You can now provide `fields` instead of `templates` for your collection, doing so will result in a more straightforward schema definition:

  ```js
  {
    collections: [
      {
        name: 'post',
        label: 'Post',
        path: 'content/posts',
        fields: [
          {
            name: 'title',
            label: 'Title',
            type: 'string', // read on below to learn more about _type_ changes
          },
        ],
        // defining `fields` and `templates` would result in a compilation error
      },
    ]
  }
  ```

  **Why?**

  Previously, a collection could define multiple templates, the ambiguity introduced with this feature meant that your documents needed a `_template` field on them so we'd know which one they belonged to. It also mean having to disambiguate your queries in graphql:

  ```graphql
  getPostDocument(relativePage: $relativePath) {
    data {
      ...on Article_Doc_Data {
        title
      }
    }
  }
  ```

  Going forward, if you use `fields` on a collection, you can omit the `_template` key and simplify your query:

  ```graphql
  getPostDocument(relativePage: $relativePath) {
    data {
      title
    }
  }
  ```

  ## `type` changes

  Types will look a little bit different, and are meant to reflect the lowest form of the shape they can represent. Moving forward, the `ui` field will represent the UI portion of what you might expect. For a blog post "description" field, you'd define it like this:

  ```js
  {
    type: "string",
    label: "Description",
    name: "description",
  }
  ```

  By default `string` will use the `text` field, but you can change that by specifying the `component`:

  ```js
  {
    type: "string",
    label: "Description",
    name: "description",
    ui: {
      component: "textarea"
    }
  }
  ```

  For the most part, the UI properties are added to the field and adhere to the existing capabilities of Tina's core [field plugins](https://tina.io/docs/fields/). But there's nothing stopping you from providing your own components -- just be sure to register those with the CMS object on the frontend:

  ```js
  {
    type: "string",
    label: "Description",
    name: "description",
    ui: {
      component: "myMapField"
      someAdditionalMapConfig: 'some-value'
    }
  }
  ```

  [Register](https://tina.io/docs/fields/custom-fields/#registering-the-plugin) your `myMapField` with Tina:

  ```js
  cms.fields.add({
    name: 'myMapField',
    Component: MapPicker,
  })
  ```

  ### One important gotcha

  Every property in the `defineSchema` API must be serlializable. Meaning functions will not work. For example, there's no way to define a `validate` or `parse` function at this level. However, you can either use the [formify](https://tina.io/docs/tina-cloud/client/#formify) API to get access to the Tina form, or provide your own logic by specifying a plugin of your choice:

  ```js
  {
    type: "string",
    label: "Description",
    name: "description",
    ui: {
      component: "myText"
    }
  }
  ```

  And then when you register the plugin, provide your custom logic here:

  ```js
  import { TextFieldPlugin } from 'tinacms'

  // ...

  cms.fields.add({
    ...TextFieldPlugin, // spread existing text plugin
    name: 'myText',
    validate: (value) => {
      someValidationLogic(value)
    },
  })
  ```

  **Why?**

  The reality is that under the hood this has made no difference to the backend, so we're removing it as a point of friction. Instead, `type` is the true definition of the field's _shape_, while `ui` can be used for customizing the look and behavior of the field's UI.

  ## Defensive coding in Tina

  When working with GraphQL, there are 2 reasons a property may not be present.

  1. The data is not a required property. That is to say, if I have a blog post document, and "category" is an optional field, we'll need to make sure we factor that into how we render our page:

  ```tsx
  const MyPage = (props) => {
    return (
      <>
        <h2>{props.getPostDocument.data.title}</h2>
        <MyCategoryComponent>
          {props.getPostDocument.data?.category}
        </MyCategoryComponent>
      </>
    )
  }
  ```

  2. The query did not ask for that field:

  ```graphql
  {
    getPostDocument {
      data {
        title
      }
    }
  }
  ```

  But with Tina, there's a 3rd scenario: the document may be in an invalid state. Meaning, we could mark the field as `required` _and_ query for the appropriate field, and _still_ not have the expected shape of data. Due to the contextual nature of Tina, it's very common to be in an intermediate state, where your data is incomplete simply because you're still working on it. Most APIs would throw an error when a document is in an invalid state. Or, more likely, you couldn't even request it.

  ## Undefined list fields will return `null`

  Previously an listable field which wasn't defined in the document was treated as an emptry array. So for example:

  ```md
  ---
  title: 'Hello, World'
  categories:
    - sports
    - movies
  ---
  ```

  The responsee would be `categories: ['sports', 'movies']`. If you omit the items, but kept the empty array:

  ```md
  ---
  title: 'Hello, World'
  categories: []
  ---
  ```

  The responsee would be `categories: []`. If you omit the field entirely:

  ```md
  ---
  title: 'Hello, World'
  ---
  ```

  The response will be `categories: null`. Previously this would have been `[]`, which was incorrect.

  ## For a listable item which is `required: true` you _must_ provide a `ui.defaultItem` property

  ### Why?

  It's possible for Tina's editing capabilities to introduce an invalid state during edits to list items. Imagine the scenario where you are iterating through an array of objects, and each object has a categories array on it we'd like to render:

  ```tsx
  const MyPage = (props) => {
    return props.blocks.map((block) => {
      return (
        <>
          <h2>{block.categories.split(',')}</h2>
        </>
      )
    })
  }
  ```

  For a new item, `categories` will be null, so we'll get an error. This only happens when you're editing your page with Tina, so it's not a production-facing issue.

  ## Every `type` can be a list

  Previously, we had a `list` field, which allowed you to supply a `field` property. Instead, _every_ primitive type can be represented as a list:

  ```js
  {
    type: "string",
    label: "Categories",
    name: "categories",
    list: true
  }
  ```

  Additionally, enumerable lists and selects are inferred from the `options` property. The following example is represented by a `select` field:

  ```js
  {
    type: "string",
    label: "Categories",
    name: "categories",
    options: ["fitness", "movies", "music"]
  }
  ```

  While this, is a `checkbox` field

  ```js
  {
    type: "string",
    label: "Categories",
    name: "categories"
    list: true,
    options: ["fitness", "movies", "music"]
  }
  ```

  > Note we may introduce an `enum` type, but haven't discussed it thoroughly

  ## Introducing the `object` type

  Tina currently represents the concept of an _object_ in two ways: a `group` (and `group-list`), which is a uniform collection of fields; and `blocks`, which is a polymporphic collection. Moving forward, we'll be introducing a more comporehensive type, which envelopes the behavior of both `group` and `blocks`, and since _every_ field can be a `list`, this also makes `group-list` redundant.

  > Note: we've previously assumed that `blocks` usage would _always_ be as an array. We'll be keeping that assumption with the `blocks` type for compatibility, but `object` will allow for non-array polymorphic objects.

  ### Defining an `object` type

  An `object` type takes either a `fields` _or_ `templates` property (just like the `collections` definition). If you supply `fields`, you'll end up with what is essentially a `group` item. And if you say `list: true`, you'll have what used to be a `group-list` definition.

  Likewise, if you supply a `templates` field and `list: true`, you'll get the same API as `blocks`. However you can also say `list: false` (or omit it entirely), and you'll have a polymorphic object which is _not_ an array.

  This is identical to the current `blocks` definition:

  ```js
  {
    type: "object",
    label: "Page Sections",
    name: "pageSections",
    list: true,
    templates: [{
      label: "Hero",
      name: "hero",
      fields: [{
        label: "Title",
        name: "title",
        type: "string"
      }]
    }]
  }
  ```

  And here is one for `group`:

  ```js
  {
    type: "object",
    label: "Hero",
    name: "hero",
    fields: [{
      label: "Title",
      name: "title",
      type: "string"
    }]
  }
  ```

  ## `dataJSON` field

  You can now request `dataJSON` for the entire data object as a single query key. This is great for more tedius queries like theme files where including each item in the result is cumbersome.

  > Note there is no typescript help for this feature for now

  ```graphql
  getThemeDocument(relativePath: $relativePath) {
    dataJSON
  }
  ```

  ```json
  {
    "getThemeDocument": {
      "dataJSON": {
        "every": "field",
        "in": {
          "the": "document"
        },
        "is": "returned"
      }
    }
  }
  ```

  ## Lists queries will now adhere to the GraphQL connection spec

  [Read the spec](https://relay.dev/graphql/connections.htm)

  Previously, lists would return a simple array of items:

  ```graphql
  {
    getPostsList {
      id
    }
  }
  ```

  Which would result in:

  ```json
  {
    "data": {
      "getPostsList": [
        {
          "id": "content/posts/voteForPedro.md"
        }
      ]
    }
  }
  ```

  In the new API, you'll need to step through `edges` & `nodes`:

  ```graphql
  {
    getPostsList {
      edges {
        node {
          id
        }
      }
    }
  }
  ```

  ```json
  {
    "data": {
      "getPostsList": {
        "edges": [
          {
            "node": {
              "id": "content/posts/voteForPedro.md"
            }
          }
        ]
      }
    }
  }
  ```

  **Why?**

  The GraphQL connection spec opens up a more future-proof structure, allowing us to put more information in to the _connection_ itself like how many results have been returned, and how to request the next page of data.

  Read [a detailed explanation](https://graphql.org/learn/pagination/) of how the connection spec provides a richer set of capabilities.

  > Note: sorting and filtering is still not supported for list queries.

  ## `_body` is no longer included by default

  There is instead an `isBody` boolean which can be added to any `string` field

  **Why?**

  Since markdown files sort of have an implicit "body" to them, we were automatically populating a field which represented the body of your markdown file. This wasn't that useful, and kind of annoying. Instead, just attach `isBody` to the field which you want to represent your markdown "body":

  ```js
  {
    collections: [{
      name: "post",
      label: "Post",
      path: "content/posts",
      fields: [
        {
          name: "title",
          label: "Title",
          type: "string"
        }
        {
          name: "myBody",
          label: "My Body",
          type: "string",
          component: 'textarea',
          isBody: true
        }
      ]
    }]
  }
  ```

  This would result in a form field called `My Body` getting saved to the body of your markdown file (if you're using markdown):

  ```md
  ---
  title: Hello, World!
  ---

  This is the body of the file, it's edited through the "My Body" field in your form.
  ```

  ## References now point to more than one collection.

  Instead of a `collection` property, you must now define a `collections` field, which is an array:

  ```js
  {
    type: "reference",
    label: "Author",
    name: "author",
    collections: ["author"]
  }
  ```

  ```graphql
  {
    getPostDocument(relativePath: "hello.md") {
      data {
        title
        author {
          ...on Author_Document {
            name
          }
          ...on Post_Document {
            title
          }
        }
      }
    }
  ```

  ## Other breaking changes

  ### The `template` field on polymorphic objects (formerly _blocks_) is now `_template`

  **Old API:**

  ```md
  ---
  ---

  myBlocks:

  - template: hero
    title: Hello

  ---
  ```

  **New API:**

  ```md
  ---
  ---

  myBlocks:

  - \_template: hero
    title: Hello

  ---
  ```

  ### `data` `__typename` values have changed

  They now include the proper namespace to prevent naming collisions and no longer require `_Doc_Data` suffix. All generated `__typename` properties are going to be slightly different. We weren't fully namespacing fields so it wasn't possible to guarantee that no collisions would occur. The pain felt here will likely be most seen when querying and filtering through blocks. This ensures the stability of this type in the future

  ```graphql
  {
    getPageDocument(relativePath: "home.md") {
      data {
        title
        myBlocks {
          ...on Page_Hero_Data {  # previously this would have been Hero_Data
            # ...
          }
        }
      }
    }
  ```

- 33e27538: Init command now adds admin.tsx file to the users pages folder
- 8c8fc2ad: Init script now checks for file extention.

### Patch Changes

- 5cd5ce76: - Improve types for ui field
  - Marks system fields as required so the user has a guarantee that they'll be there
  - Return null for listable fields which are null or undefined
  - Handle null values for reference fields better
- Updated dependencies [fdb7724b]
- Updated dependencies [d42e2bcf]
- Updated dependencies [5cd5ce76]
- Updated dependencies [8c425440]
- Updated dependencies [7351d92f]
  - tina-graphql@0.2.0
  - tina-graphql-helpers@0.1.2

## 0.3.1

### Patch Changes

- ebe77b21: added iframe to tina init generate page

## 0.3.0

### Minor Changes

- fa3967b3: tina-gql init command now updates the users package.json with tina-dev scripts and adds a \_app.js files into the users project

## 0.2.60

### Patch Changes

- c21bda17: Allow single command arguments to be passed in the sub command for the server:start command
- Updated dependencies [348ef1e5]
  - tina-graphql@0.1.25

## 0.2.58

### Patch Changes

- Updated dependencies [b36de960]
  - tina-graphql@0.1.24

## 0.2.57

### Patch Changes

- Bump packages to reflect new changest capabilities
- Updated dependencies [undefined]
  - tina-graphql@0.1.23
  - tina-graphql-helpers@0.1.1

## 0.2.56

### Patch Changes

- Updated dependencies [undefined]
  - tina-graphql-helpers@0.1.0
  - tina-graphql@0.1.22

## 0.2.55

### Patch Changes

- Updated dependencies [undefined]
  - tina-graphql@0.1.21
