[![GitHub license](https://img.shields.io/github/license/tinacms/tinacms?color=blue)](https://github.com/tinacms/tinacms/blob/main/LICENSE)
[![npm version](https://img.shields.io/npm/v/tinacms.svg?style=flat)](https://www.npmjs.com/package/tinacms)
[![Build, Test, Lint for Main](https://github.com/tinacms/tinacms/actions/workflows/main.yml/badge.svg?branch=main&event=push)](https://github.com/tinacms/tinacms/actions/workflows/main.yml)

# [![TINA CMS](https://res.cloudinary.com/forestry-demo/image/upload/c_scale,w_400/v1694189357/tina-brand-assets/logos/png/Logo_Full_-_Default.png 'Visit tinacms.org')](https://tina.io)

[![Tina Demo](https://res.cloudinary.com/forestry-demo/video/upload/du_16,w_700,e_loop/tina-io/new-homepage/homepage-demo-2.gif)](https://tina.io/)

Tina is a headless content management system with support for **Markdown**, MDX, JSON, YAML, and more.

It comes with a GraphQL API:

- Query your Markdown content like this 👉 `post.author.firstName`
- Supports statically generated and server side rendered pages
- Supports references between documents

Tina offers a live preview (optional and opt-in) that makes editing Markdown files very intuitive for less-technical people.

## Getting Started

Test a TinaCMS starter site locally

```
npx create-tina-app@latest
```

Or try a [demo site](https://app.tina.io/quickstart) on Tina Cloud.

## Documentation

Visit [Tina's documentation](https://tina.io/docs/) to learn more.

## Questions?

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?url=https%3A%2F%2Ftinacms.org&text=I%20just%20checked%20out%20@tinacms%20on%20GitHub%20and%20it%20is%20sweet%21&hashtags=TinaCMS%2Cjamstack%2Cheadlesscms)
[![Forum](https://shields.io/github/discussions/tinacms/tinacms)](https://github.com/tinacms/tinacms/discussions)

Visit the [GitHub Discussions](https://github.com/tinacms/tinacms/discussions) or our [Community Discord](https://discord.com/invite/zumN63Ybpf) to ask questions, or look us up on on Twitter at [@tinacms](https://twitter.com/tinacms).

## 🧑‍🎓 Earn a Tina Badge

Go the extra mile and earn a Tina Dev Badge 🦙: [Earn a Tina Credly badge](./_docs/dev-badge.md)
<!-- ## Changelog

Check the [CHANGELOG](./CHANGELOG.md) for the latest updates to TinaCMS.  -->

## Vision

To be the world-leading CMS with Git support that developers love.

## Tech Stack

See
https://tina.io/docs/introduction/faq/#what-is-tinas-tech-stack

## Roadmap

Our development priorities can be read on our [Public Roadmap](https://tina.io/roadmap/).

## Contributing

Please see our [./CONTRIBUTING.md](https://github.com/tinacms/tinacms/blob/main/CONTRIBUTING.md)

### Maintainers

- Kelly Davis ([@kldavis](https://github.com/kldavis4))
- Jeff See ([@jeffsee55](https://github.com/jeffsee55))
- Matt Wicks ([@wicksipedia](https://github.com/wicksipedia))
- Jack Pettit ([@JackDevAU](https://github.com/JackDevAU))
- Jord Gui ([@Jord-Gui](https://github.com/Jord-Gui))
- Nick Curran ([@ncn-ssw](https://github.com/ncn-ssw))
- Brook Jeynes ([@brookjeynes-ssw](https://github.com/brookjeynes-ssw))
- Ben Neoh ([@Ben0189](https://github.com/Ben0189))
- Warwick Leahy ([@leahy268](https://github.com/leahy268))
- Seth Daily ([@sethdaily ](https://github.com/sethdaily))
- Josh Berman ([@joshbermanssw](https://github.com/joshbermanssw))
- Scott Gallant ([@scottgallant](https://github.com/scottgallant))
- Adam Cogan ([@adamcogan](https://github.com/adamcogan))

View our awesome SSW devs at [ssw.com.au/people](https://www.ssw.com.au/people/?skill=%F0%9F%A6%99-TinaCMS).

![](https://res.cloudinary.com/forestry-demo/image/upload/h_85/v1573167387/Favicon.png)
