# Timescale Vector Cookbook
A collection of recipes and sample application starter kits to build with LLMs using PostgreSQL and Timescale Vector.

Learn more about Timescale Vector, PostgreSQL++ for AI applications: [timescale.com/ai](https://www.timescale.com/ai)

Sign up for a [free cloud PostgreSQL database](https://console.cloud.timescale.com/signup?utm_campaign=vectorlaunch&utm_source=github&utm_medium=direct) to use to work thru the examples in this repo. You'll get 90 days free by signing up with the link above.

## Timescale Vector Resources
Timescale Vector enables you to power AI applications using PostgreSQL to store vector, relational and time-series data. It enhances pgvector with faster search, higher recall, and more efficient time-based filtering.
- [Overview and Performance Benchmarks](https://www.timescale.com/blog/how-we-made-postgresql-the-best-vector-database/?utm_campaign=vectorlaunch&utm_source=github&utm_medium=direct)
- [Timescale Vector LangChain Integration](https://python.langchain.com/docs/integrations/vectorstores/timescalevector)
- [Timescale Vector LlamaIndex Integration](https://gpt-index.readthedocs.io/en/stable/examples/vector_stores/Timescalevector.html)
- [Timescale Vector Python Client Library](https://github.com/timescale/python-vector)
- [Timescale Vector Python Tutorial](https://github.com/timescale/python-vector/blob/main/nbs/tsv_python_getting_started_tutorial.ipynb)

## Sample Applications
- [TSV Time Machine](https://github.com/timescale/vector-cookbook/tree/main/tsv_timemachine): Chat with git the commit history of any repo. Stack: LlamaIndex, Streamlit, Timescale Vector (PostgreSQL), Python. [Live demo](https://pg-timemachine.streamlit.app/TimeMachine_Demo)

## PGVector Resources
- [Create, store and query OpenAI embeddings with PostgreSQL and pgvector](https://github.com/timescale/vector-cookbook/tree/main/openai_pgvector_helloworld)
- [Nearest Neighbor Indexes: What Are ivfflat Indexes in pgvector and How Do They Work](https://www.timescale.com/blog/nearest-neighbor-indexes-what-are-ivfflat-indexes-in-pgvector-and-how-do-they-work/)
- [Introduction to LangChain for LLM applications using pgvector as a vectorstore](https://github.com/timescale/vector-cookbook/tree/main/intro_langchain_pgvector)

Note: If you need to setup Python, pyenv and Jupyter on your Mac, follow [this handy tutorial](https://www.timescale.com/blog/jupyter-notebook-tutorial-setup-python-and-jupyter-notebooks-macos/).
