<h1 align="center">
    <img src="./public/favicon.svg"/>
    GITBOX
</h1>

## Preview

![Home](/public/preview/demo_version5.png)

## Proccess
![Project](/public//preview/demo_project.png)
## Features
+ [chart](https://vuejsprojects.com/vue-morris)

## Exploring
+ Developing **VueJs 3** framwork in **ViteJs** module with **TypeScript** option.
+ **Composition API** for [hook](https://vuejs.org/guide/essentials/lifecycle.html) in Vue3
+ Get acquainted with **[REST API GITHUB](https://docs.github.com/en/rest)**
+ Using [axios](https://www.npmjs.com) HTTP Client library and **fetch()** method to fetch data links with support of [Postman](https://www.postman.com).
+ Transporting data between components by [event bus](https://v3.vuejs.org/guide/migration/events-api.html#overview)  library in Javascript.
+ The template uses Vue 3 `<script setup>` SFCs, check out the [script setup docs](https://v3.vuejs.org/api/sfc-script-setup.html#sfc-script-setup) to learn more.

## Setup project

Setup dependencies
```script
npm install
```
Enviroment variables
```bash
 # create .env.<mode>
VITE_API_USERNAME=<your_username>
```
Compiles and hot-reloads for development
```script
npm run dev
```
Compiles and minifies for production
```script
npm run build
```
Lints and fixes files
```script
npm run lint
```

## Type Support For `.vue` Imports in TS

* Since TypeScript cannot handle type information for `.vue` imports, they are shimmed to be a generic Vue component type by default. In most cases this is fine if you don't really care about component prop types outside of templates. However, if you wish to get actual prop types in `.vue` imports (for example to get props validation when using manual `h(...)` calls), you can enable Volar's `.vue` type support plugin by running `Volar: Switch TS Plugin on/off` from VSCode command palette.

## 🤝 Join with me
+ #### Code together in the development to build perfect products.
+ #### You can give a **star**/**fork**/**comment discuss**/**make issues**/**create Pull-Request** about source code to develop this me project. It can save it on release history.
+ #### Any problem, should contact me via [email](mailto:ititiu19228@student.hcmiu.edu.vn).
+ #### Following **ECL-2.0 LICENSE** about @Copyright of [@thuongtruong1009](https://github.com/thuongtruong1009), 2021.

## 🔧 Tools and references
+ Recommended IDE setup: [Visual Studio Code](https://code.visualstudio.com/) + [Volar](https://marketplace.visualstudio.com/items?itemName=johnsoncodehk.volar).
+ Extension: Vetur, Prettier, ESLint...
+ Get started at [ViteJs](https://vitejs.dev/).
+ Learning front-end full course at [front-end course](https://github.com/thuongtruong1009/fontend-master).

### ❤️ Support me
[![MOMO](https://img.shields.io/badge/-MOMO-red?style=for-the-badge&labelColor=pink&logo=MOMO&logoColor=black)](https://nhantien.momo.vn/0917085937)
<a href="https://www.paypal.me/thuongtruong1009">
  <img height="25" marginTop="10" src="https://quyetdao.com/wp-content/uploads/2019/04/paypal-logo.png">
</a>
<a href='https://ko-fi.com/thuongtruong1009' target='_blank'><img height='25' style='border:0px;height:28px;color:blue' src='https://az743702.vo.msecnd.net/cdn/kofi3.png?v=0' border='0' alt='Buy Me a Coffee at ko-fi.com' />