# Contributing Guidelines
First of all, thank you for considering contributing to this project! Any sort of contributions are very welcome and help the project grow. Before starting, please read the following guidelines.

## Contributing
You can contribute in many ways, such as, but not limited to:

### Reporting Issues
If you find any bugs, have an idea for a feature or just overall suggestions on how to improve this project, feel free to create an [issue](https://github.com/thiagomvas/TMath/issues) and I'll make sure to read it!

### Code Contributions
If you'd like to introduce new features or fix something yourself, you can do so by:
1. **Fork the repository.** Fork this project to your Github Account, after that you can clone it to your machine using ``git clone <project-url>``
2. **Create a branch.** - Since we use the Github Flow, features being worked on have their own branch, to do this, simply run
```bash
   git checkout -b <feature-or-fix-name>
```
3. **Make any changes you'd like.** Please do make sure any changes are documented, prefferably with proper XML comments explaining what your implementation does.
4. **Test your changes.** Make sure your changes work properly and don't cause any issues. Adding a NUnit test for your function also helps.
5. **After you're done, create a pull request**. After you pushed your commits to your awesome feature branch, create a pull request for me to review your code, if everything looks good then your awesome feature is now part of this codebase!

# Thank you!
Any contribution you make, no matter how big or small, means a lot to me and knowing you've shown interest in the project gives me more motivation to work on it!
