<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li class="active">Preface :: The Hard Way Is Easier</li>
</ol>

## Preface pt. ii

# The Hard Way Is Easier

> "The hardest part about gaining any new idea is sweeping out the false idea occupying that niche.  As long as that niche is occupied, evidence and proof and logical demonstration get nowhere.  But once the niche is emptied of the wrong idea that has been filling it---once you can honestly say, 'I don't know,' then it becomes possible to get at the truth."
> <footer>Robert A. Heinlein, <em>The Cat Who Walks Through Walls</em></footer>

Whatever you think you know about programming, forget it.  Lisp is different from other programming languages.

If you're coming to Lisp as an experienced developer, it is only fair to tell you up-front that your experience will hold you back.  It will make you feel bored when the material isn't "challenging you".  It will make you skip over sections you think you already understand.  It will tell you reading the code examples once is enough to learn it, that it's okay to copy-and-paste.  *But this experience is a lie*. If you slack off now, you'll only be making things harder for yourself later.

No matter who you are or what your background is, if you stick to the steps of learning *The Hard Way*, you'll see that it is actually easier in the long run.  You'll have to work hard, but you'll learn what you need to learn the first time, and you won't forget it.

Learning the hard way means following these five steps every day until you've completed this book:

1. Forget everything you know
2. Work through each exercise from beginning to end
3. Type in each example *exactly*
4. Make the code run
5. Reflect on what you've seen

And that's all.

Depending on your level of self-discipline, you may have a more difficult time sticking to these steps than some---but this isn't a contest.  Don't worry about how long it takes you to work through an exercise, don't panic if you have to miss a day, and don't compare yourself to others.  If you do your best to apply these steps every day, you will develop the self-discipline required to see this book through to the end.

An important theme of this book is also on the skills necessary for programming in general, while using Lisp to reinforce them.  These skills are: reading and writing, attention to detail, spotting differences, and mathematics.  Thus, once you finish this book, you won't just be a Lisp Hacker, you'll be ready to tackle other programming languages too---and in the process you might just discover that learning a new skill is more fun than any hobby, game, movie, or tv show.

### Reading and Writing

Programming, much like human language, involves the intentional use of a specific set of language-dependent characters that have *meaning*, some of which you might not be used to typing. Programming is significantly more exact than human languages---if you have trouble reading, writing, or typing, you will struggle writing code.

Take the time to read over the code examples carefully, and double-check your work once you have typed it.  This will save you from many stress headaches along the way.

### Attention to Detail

More than any other skill, what separates a professional from an amateur in every field and trade is attention to detail.  In programming, this is especially obvious; it makes the difference between sluggish, buggy software that regularly crashes and leads to hair-loss in its users, and a refined, user-friendly, indispensable tool.

By manually typing each exercise *exactly* as you work through this book, you will be training your brain to focus on the subtle details of what you are doing, while you are doing it.

### Spotting Differences

The natural extension to the first two skills is the ability to spot differences.  With careful reading, typing, and attention to detail, you will also be training your brain to highlight subtle differences for you, so that when you make a mistake, you notice, and can correct it immediately.

Naturally, this skill will also help you more quickly spot and correct bugs in other people's code that you have to upgrade and maintain.

### Mathematics

Remember in high school, there was always at least one classmate that would demand to know when, in life, any of you would ever need to know half the stuff they taught you?  You may have even been that student.  If so, you may be disappointed to know that many problem domains a professional programmer has to deal with on a daily basis require nearly the entire high school and university level math curricula.  I'm not talking about highly specialized fields either, like Quantum Computing; Currency, Stock, and Commodity exchange; or Cryptography---junior game, mobile, and web developers need math too.  As <a href="http://zedshaw.com/archive/programmers-need-to-learn-statistics-or-i-will-kill-them-all/" target="_blank">Zed Shaw argued</a> in an excellent, albeit *angry rant* essay, at the very least you should know Statistics.  But Algebra, Geometry, Trigonometry, Calculus, Lambda Calculus---and of course, Algorithms---are extremely useful tools that will help you reason about and abstract your code at a whole new level.

If the very idea of math makes your heart skip a beat, your hands shake, and your brow drip with sweat, just remember the infamous words inscribed on the cover of the Hitchhiker's Guide to the Galaxy: DON'T PANIC. You *don't have to be a math-whiz* to learn programming *or* Lisp, and this book assumes little to no familiarity with math above the grade-school level. You can learn the math you need along the way, when you need it---and you will probably understand it better this time because you'll see its practical value.  Just remember that math is your friend---even when it's not essential, formal quantitative reasoning, analysis, and deductive reasoning will give you an edge over other developers, and help you write better software.  Oh right, and *make sure you know where your towel is*.

### No Copy-and-Paste

If you copy-and-paste the code from the exercises into the Lisp REPL instead of typing them out yourself, you might as well not do them at all.  As both teacher and student for the duration of this book, you have to force yourself to type in every example.  No matter how easy or self-evident a code example appears to be, you have to stop yourself from cheating.

The point of these exercises is to train your hands, your eyes, your brain, and your mind how to read, write, see, think, and dream code.  When you cheat here, you're only cheating yourself.

<ul class="pager">
  <li class="previous"><a href="/book/preface/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/preface-part-three/">Next &raquo;</a><li>
</ul>
