<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li class="active">Preface :: Who Is This Book For?</li>
</ol>

## Preface pt. iii

# Who Is This Book For?

> "Do not handicap your children by making their lives easy."
> <footer>Robert A. Heinlein, <em>Time Enough for Love</em></footer>

Programming books can be tedious, and usually come in only one of two bland flavours---so basic an introduction you know less about the language after reading the book, or so dense a tome it is not useful outside an ivy-league university's computer science program.  *The Hard Way* is different.

You don't have to know anything about programming or computer science to learn Lisp with this book, but I'm not going to talk down to you either.  I'm going to assume that you know that learning any new skill is hard for everyone, and that you need to work hard in order to succeed.

Sometimes, you might not understand what I'm talking about, so I also expect you to take advantage of all the free research tools available on the internet---search engines, dictionaries, thesauri, encyclopedias, reference works, academic papers, programming blogs, and more.  Any time you feel completely boggled, you should turn to these.  I will be as casual as possible in my presentation, but sometimes it makes more sense to be formal.

That being said, Lispers of all experience levels should benefit from this book.  We'll be exploring the language through real, immediately useful source code examples, and dissecting the language down to its core.  Later on in the book, we'll also be covering a wide variety of advanced, relevant practical applications using a selection of the most popular and powerful libraries from the Lisp community.

So in summary, this book is for you if:

* You know nothing about programming, but want to learn
* You tried to learn Lisp before, but other books made it seem too hard or not useful
* You are an experienced programmer considering a move to Lisp
* You are already a Lisper, but want to take your code to the next level, or
* You simply haven't seen what all the fuss is about when it comes to Lisp---but you keep hearing how amazing Lisp is, so here you are reading another book about it

### Practice and Persistence

To learn any new skill, you have to take the time, while applying the five rules of learning the hard way.  You'll have good days and bad, times when you feel inspired and everything makes perfect sense, and times when you would rather just veg-out in front of the TV because you feel completely brain-dead already.  Keep in mind that to maintain a skill, the rule of thumb is to spend *at least* two hours a day practicing.  To improve an existing skill or learn a new one, it may require a lot more commitment from you.

Once again, don't let yourself be disheartened if some days you can't seem to make sense of the exercises and material.  Learning any new skill takes a considerable shift in the way you think, as well as effort.  Also, don't let yourself get disheartened if you feel like you're not progressing fast enough---there's no timeline for the exercises, you're not competing with anyone else for the top grade.  You should take the time you need to complete each exercise at your own pace, so that you actually learn the material that the exercise covers.

The best advice I can offer for when you hit the wall is to stick to the five steps of the Hard Way, no matter what.  Force yourself to work through the next exercise, even if it makes no sense.  You might just wake up the next day and suddenly get it---or you may need to repeat it a few times.  Persistence pays off, and if you stick with this methodology no matter what challenges you face, you will triumph.

### Attitude and Intelligence

Some of you will think I'm joking when I say, "forget everything you know."  I assure you, I'm not.  Lisp is different than other languages---it's not imperative, procedural, object-oriented, or functional; it's *multi-paradigm*.  You need to be willing to set your ego aside and remember that everyone has more to learn than they have yet learned or ever can be learned.  Yes, Lisp is *that* different from other languages, even from other multi-paradigm programming languages.  If you take this to heart, you will discover that there is always something new to discover.

From a technical perspective, intelligence is more of an attitude problem than a measure of ability.  When you think you are smart, you tend to think you already know everything and have all the answers.  This makes learning new skills an uphill battle.  You might not be guaranteed to fail at everything new when you already think you know everything, but you will find yourself easily discouraged by "boredom" as new knowledge is beaten away by your ever-swelling ego.

Recognizing your own ignorance up-front allows you to learn without self-sabotage.  It is the wisdom of the ancients, every great artist's secret weapon, and an indispensable tool to a programmer.  And since The Lisp Way is so fundamentally different from other approaches to programming, this minor attitude adjustment will help you see Lisp without the blinders of previous experience.

### The End-Goal

The end-goal of teaching Lisp is to somehow convey the concept of 'grokking' Lisp to new students of the language.  The main challenge with this task, in my humble opinion, is that not enough emphasis has been placed on first forgetting everything you know, and second on the core syntax of Lisp where the symmetry with the human mind and the fractal cosmology model of the universe are most obvious.  While other books on Lisp leave the matter of grokking open, hoping that by the end the reader will just grok grokking for themselves, in this book, grokking is a first-class citizen of your Lisp education.  It's that important.

Lisp is, at its heart, a very mystical language which blurs the line between programming and magic.  It is so inspired that, as one of my blog readers suggested, it seems more as though it was created by the ancient Egyptian god of writing and magic, Thoth, and handed down to John McCarthy in revelation.  Several notable Lispers have even described that moment of their sudden awakening to understanding of Lisp as a religious experience, a suffusion of blue inspiring deep spiritual sentiments and a tendency towards prophesy.

This is where the term 'grokking' comes into the picture.  It was coined by speculative/science fiction author Robert A. Heinlein in his novel, Stranger in a Strange Land, to describe the experience of knowing something so deeply that you become a part of it as much as it becomes a part of you.  In short, Grokking is gnosis for the transhuman age.  So being that learning Lisp shares so much in common with mystical initiation, using the initiatory techniques of Occult orders in teaching Lisp makes a lot of sense.  This is why the Hard Way is the road to the Lisp Way, and why even experienced Lisp, Scheme, Clojure, Haskell, and OCaml programmers will benefit as greatly from this book as an absolute beginner.

<ul class="pager">
  <li class="previous"><a href="/book/preface-part-two/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/introduction/">Next &raquo;</a><li>
</ul>
