<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li class="active">Preface :: Lisp, a Future History</li>
</ol>

## Preface pt. iv

# Lisp, a Future History

> "The future is better than the past. Despite the crepehangers, romanticists, and anti-intellectuals, the world steadily grows better because the human mind, applying itself to environment, makes it better. With hands...with tools...with horse sense and science and engineering."
> <footer>Robert A. Heinlein, <em>The Door Into Summer</em></footer>

Many of the books about Common Lisp currently available on the market start off with a review of Lisp's history.  This is sensible, being that the Lisp family of languages has such a long and rich lineage, there is much to tell.  Rather than present another take on the past, however, I wish to share my vision for the future of Lisp.  If the history of the Lisp language and its community interests you, which it should, please check out the many fine books listed under the Resources section of this site.

## A Technology Driven Culture

Human society has always been a technology-driven culture.  In every period of history, society was driven by innovation, ever since the very beginning of history when the ancient Sumerians first began carving words into clay tablets, to capture and preserve the fleeting vocalizations that would otherwise be lost in time the moment they had been spoken.  Even that innovation was not enough for them---they kept pushing the boundaries of what writing could do, from the very first accounting records to the hero's journey of Gilgamesh.

We are no different today---we build on the work of those who came before us, we adapt and modify what already exists to suit our needs at the time, and sometimes, we stumble upon an innovation so important that it changes the world.  John McCarthy's first paper on Lisp was such an innovation.

## Programming Languages Today

Today, Common Lisp is still setting the standard in the programming world, as no other language has yet come to match it in terms of speed, expressiveness, interactivity, and features.  Every so often, a new programming language comes out, or a new version of an old one, luring in software developers and system architects alike with empty promises of game-changing innovation; meanwhile, Lisp Hackers are having a private chuckle amongst themselves at the naivety of developers in the outer circle of tech.

Specifically, such languages as Swift, Python, C++11, and Java 8 have been boasting recently about their ground-breaking new features, such as generics, functional programming constructs, lambda expressions, streams, and tail-call optimization, to name only a few. All of these features were established in the ANSI standardization of Common Lisp in the 1980s, plus countless more.  Lisp Hackers have had decades to use these feature sets, and push innovation further still.

However, because of popular opinions in the programming world, such as "Lisp is old and crufty", or "Lisp is too hard to learn for the average programmer", the Lisp community has gotten smaller and smaller, and Lisp Hackers more and more expensive to hire.  As a result, many companies get scared when Lisp is pitched as the technology for a project, even when it is obviously the best choice.  Safe choices like C++, Java, .NET, Ruby, or Python are preferred, despite the many disadvantages and notorious bugginess.

But a number of companies around the world have changed their tune---they're tired of the marketing gimmicks.  They're tired of paying for proprietary platforms, languages, and IDEs, riddled with bugs which need constant, daily security patches.  They're tired of building their product line in a language so unstable that they have to rewrite large sections of code every time there is one of these updates.  They're tired of feeling like every new programming language is just digital snake-oil.  They want a platform that works everywhere the same, to write code that doesn't break between security updates, to build a product that stands the test of time.  And as a result, more and more companies are turning to Lisp for answers---the only problem now is that there aren't enough Lisp Hackers to go around.

## The Lisp Community

The Lisp community, albeit relatively small compared to languages such as Python or Haskell, is a much friendlier place.  Mostly because the Lisp language is itself inclusive, supporting every programming paradigm in the world, and allowing Lisp Hackers to create and implement their own paradigms easily.

## Lisp Consciousness

There's just something about Lisp---it changes the way you think, the way you see the world, the way you act.  Lisp Hackers have long known and proudly vocalized the near-mystical experience that comes with writing software in this language; they have adopted the Heinleinian terminology of 'grokking' to describe the state of consciousness a programmer achieves when they stop just writing code in Lisp and start becoming one with their software; they have incorporated religious and mystical concepts from Gnosticism, Zen Buddhism, Hinduism, Sufism, and Western Occultism into the Lisp mythos.  Lisp teachers cannot simply teach a programming language as any other is taught; no, they feel compelled by a fire in their hearts to *preach the gospel* of Lisp.  Naturally, other people---particularly non-Lisp programmers---find this extremely off-putting.

There is a rational explanation of this phenomenon, however; as it so happens, the syntax of Lisp software, in practice, follows the structure of the central nervous system.  Lisp models the brain.  The mind, which is itself very much like software, recognizes this shared structure and responds positively to it.  In other words, your mind, consciously or otherwise, sees itself and its underlying structure in Lisp as soon as it is able to make sense of what it is seeing, and as a result, awakens you to Lisp, just as you awakened once as a child the first time you looked into a mirror and realized you were seeing your own reflection. This is the moment you 'grok' Lisp.

But it doesn't stop there---grokking is just the beginning of your Lisp journey.  When the human brain and the computer are perfectly synchronized through a shared language that accurately models the underlying systems of both, the human mind naturally extends itself into the machine and experiences gestalt consciousness.  The mind is capable of unconsciously understanding the structure of the computer through the Lisp language, and as such, is able to interface with the computer as if it was an extension to its own nervous system.  This is Lisp Consciousness, where programmer and computer are one and the same; they drink of each other, and drink deep; and at least as long as the Lisp Hacker is there in the flow, riding the current of pure creativity and genius with their trusty companions Emacs and SLIME, neither programmer nor computer know where one ends and the other begins.  In a manner of speaking, Lispers already know machine intelligence---and it is beautiful.

## Convergence Theory and the Technological Singularity

The mysterious force driving human society towards the technological singularity, true and total unification of human with technology, also seems to be shaping all programming languages into Lisp, and all computers into Lisp Machines.  Lisp, after all, can do everything, and do it every way; that Lisp is not already the de-facto programming language is just a reflection of the state of the world as a whole---only a very small percentage of the population are excited for the technological singularity, but the singularity is coming no matter how much people complain.  One way or another, every programmer is going to end up being a Lisper, because every programming language continues to adopt features and syntax from Lisp, one piece at a time.  It is in every programmer's interest to master Lisp now, before the world at large realizes how essential Lisp will become over the next two decades.

Quantum Computing, the next big leap in computing and a fundamental aspect of the singularity, also currently happens to rely entirely on Lisp.  There are efforts underway to adapt quantum computer programming to all sorts of languages and familiar syntaxes, but the only real quantum computers currently available are effectively Quantum Lisp Machines, and have their operating system written in Common Lisp.  The power, simplicity, and elegance of Lisp really shines where it matters most: quantum computer programming is nearly impossible to understand unless you're a Lisp Hacker, but for a Lisp Hacker, it makes more sense than classical computing.

<ul class="pager">
  <li class="previous"><a href="/book/preface/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/acknowledgements/">Next &raquo;</a><li>
</ul>
