<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/3-00-00-overview/">Part Three: Lisp So(u)rcery</a></li>
  <li class="active">Neuroscience and Thought-Controlled Computing</li>
</ol>

## Chapter 3.20

# Neuroscience and Thought-Controlled Computing

> "Now that he knew himself to be self he was free to grok ever closer to his brothers, merge without let. Self's integrity was and is and ever had been."
> <footer>Robert A. Heinlein, <em>Stranger in a Strange Land</em></footer>

**Note:** *the exercises in this chapter will require specialized hardware components to complete, and due to the prohibitive cost and lack of availability for some readers, it should be considered optional*.

Affordable Brain--Computer Interfaces are a relatively new thing.  They are not *new* in terms of actual technological innovation, being based on EEG systems that have existed for decades, but the application of specialized medical and scientific equipment to the average computer user as a potential replacement for the old-fashioned keyboard and mouse *is* quite novel.  Naturally, BCIs have been advertised primarily as accessibility devices and the next big thing for gaming, but their impact is far more significant than that.

The real significance of BCIs is that they enable an individual user to become consciously aware of their own brainwaves, and then manipulate them arbitrarily for computational purposes.  Depending on the sophistication of the BCI, this may simply amount to a more interactive meditative experience that allows you to track your progress towards inner peace---but some models available on the market give a very complete picture of the brain's activity to the user, and with multiple sensors, can at least in theory be manipulated like a brainwave-powered stenographic keyboard.

The one issue with available Brain--Computer Interfaces is the lack of software to make full use of the hardware.  Developer kits are available for every platform on the market, but surprisingly few developers have jumped on such an intriguing technology---given how many programmers suffer from carpal-tunnel syndrome, and other repetitive stress injuries, one would think that BCIs would be embraced more rapidly, as a more efficient and less physically damaging means to write software. Example BCI-based replacements for the keyboard and mouse interfaces already exist, however they suffer in terms of usability---once trained in the art of conscious brainwave manipulation, a number of more intuitive methodolgies exist for controlling a computer.  And we will cover them here.

In this chapter, we will review the basic concepts of Neuroscience and the various BCIs available on the market, their specifications and SDKs; we will parse the resulting brainwave data in Lisp, and attempt to structure Neural-net models to get a better understanding of what our brains are doing; and write several brainwave controlled utility applications specifically designed for improving your Lisp workflow, including a brief introduction to Emacs Lisp that will enable us to map BCI input to Emacs keyboard commands.

## Exercise 3.20.1

**An Introduction to Neuroscience**

*Note:* illustrate concepts of neuroscience with a model neural net that produces externally visible brainwaves as a software interface.

```lisp

```

## Exercise 3.20.2

**An Introduction to Thought-Controlled Computing**

*Note:* extend the previous exercise to demonstrate use of the visible brainwave interface.

```lisp

```

## Exercise 3.20.3

**Commercial Brain--Computer Interfaces**

```lisp

```

## Exercise 3.20.4

**Muse and OSC**

```lisp

```

## Exercise 3.20.5

**Emotiv EPOC SDK**

```lisp

```

## Exercise 3.20.6

**Analyzing Brainwave Data in Lisp**

```lisp

```

## Exercise 3.20.7

**Mapping Mnemonic Brainwave Patterns**

```lisp

```

## Exercise 3.20.8

**Training Your Brain to Activate BCI Sensors**

```lisp

```

## Exercise 3.20.9

**Training Your Brain's Resting State**

```lisp

```

## Project 3.20.10

**Interactive Meditation and Self-Awareness**

```lisp

```

## Exercise 3.20.11

**Mapping Brainwave Data to Text Input**

```lisp

```

## Exercise 3.20.12

**Mapping Brainwave Data to Mouse Input**

```lisp

```

## Project 3.20.13

**An Emacs Extension for Thought-Controlled Computing**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/3-19-00-space-tech/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-21-00-lispos/">Next &raquo;</a><li>
</ul>
